/* @(#) somx/phonedir.c 2.3 1/20/94 10:25:55 [5/15/94 17:59:13] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


#define phoneDir_Class_Source
#define SOMClass_Class_Source
#include <phonedir.ih>

/*
 ===============================================================================
 Operation:  addEntry
 Purpose  :  Adds a dirEntry object to the directory.
 ===============================================================================
 */

SOM_Scope long  SOMLINK addEntry(phoneDir somSelf, dirEntry entry)
{
    Environment *ev;
    long rc;

    phoneDirData *somThis = phoneDirGetData(somSelf);
    phoneDirMethodDebug("phoneDir","addEntry");

    ev = SOM_CreateLocalEnvironment();
    if (sequenceLength(_directory) < sequenceMaximum(_directory)) {
        sequenceElement(_directory, sequenceLength(_directory)) = entry;
        sequenceLength(_directory)++;
        _sompSetDirty (somSelf, ev);
        rc = 0L;
    } else
        rc = -1L;
    SOM_DestroyLocalEnvironment(ev);
    return(rc);
}

/*
 ===============================================================================
 Operation:  printDirInfo
 Purpose  :  Invokes lsEntry for each instance of direntry.
 ===============================================================================
 */

SOM_Scope void  SOMLINK printDirInfo(phoneDir somSelf)
{
    int probe;

    phoneDirData *somThis = phoneDirGetData(somSelf);
    phoneDirMethodDebug("phoneDir","printDirInfo");

    if (sequenceLength(_directory) > 0) {
       somPrintf("\n");
       somPrintf("Name                Phone\n");
       somPrintf("----------------    ----------------\n");
       for (probe = 0; probe < sequenceLength(_directory); probe++) {
          _lsEntry(sequenceElement(_directory, probe));
       }
    } else {
        somPrintf ("\nDirectory is Empty\n");
    }
}

/*
 ===============================================================================
 Operation:  getEntry
 Purpose  :  returns a pointer to the list entry with name == entryID.
             If a matching entry is not found, returns NULL.
 ===============================================================================
 */

SOM_Scope dirEntry  SOMLINK getEntry(phoneDir somSelf, string entryID)
{
    int probe;
    char *probename;

    phoneDirData *somThis = phoneDirGetData(somSelf);
    phoneDirMethodDebug("phoneDir","getEntry");

    for (probe = 0;probe < sequenceLength(_directory);probe++) {
      probename = dirEntry__get_name(sequenceElement(_directory, probe));
      if (strcmp(probename, entryID) == 0)
          return (sequenceElement(_directory, probe));
    } /* endfor */

    return (dirEntry) NULL;
}

/*
 ===============================================================================
 Operation:  dropEntry
 Purpose  :  delete an entry from the directory.
 *
 *  dropEntry removes the entry with name == entryID from the directory
 *  array, and returns a pointer to the dropped entry.
 *  If a matching entry is not found, it returns NULL.
 *  The client application must use sompDeleteObject on the returned object
 *  to delete it from the IO Group.  The client must also free the dirEntry
 *  Object returned.
 ===============================================================================
 */

SOM_Scope dirEntry  SOMLINK dropEntry(phoneDir somSelf, string entryID)
{
    int probe;
    char *probename;
    dirEntry dptr;
    Environment *ev;

    phoneDirData *somThis = phoneDirGetData(somSelf);
    phoneDirMethodDebug("phoneDir","dropEntry");

    ev = SOM_CreateLocalEnvironment();
    for (probe = 0;probe < sequenceLength(_directory);probe++) {
        probename = dirEntry__get_name(sequenceElement(_directory, probe));
        if (strcmp(probename, entryID) == 0) {
            dptr = sequenceElement(_directory, probe);
            sequenceLength(_directory)--;
            for (; probe < sequenceLength(_directory); probe++) {
                sequenceElement(_directory, probe) =
                sequenceElement(_directory, (probe + 1));
            }
            _sompSetDirty (somSelf, ev);
            SOM_DestroyLocalEnvironment(ev);
            return dptr;
        } /* endif */
    } /* endfor */

    SOM_DestroyLocalEnvironment(ev);
    return (dirEntry) NULL;
}

/*
 ===============================================================================
 Operation: somInit
 Purpose  : init instance
 ===============================================================================
*/

SOM_Scope void  SOMLINK somInit(phoneDir somSelf)
{
    phoneDirData *somThis = phoneDirGetData(somSelf);
    phoneDirMethodDebug("phoneDir","somInit");

    phoneDir_parent_SOMPPersistentObject_somInit(somSelf);

    sequenceMaximum(_directory) = MAXDIRSIZE;
    sequenceLength(_directory) = 0;
    _directory._buffer = SOMMalloc(sizeof (dirEntry *) * MAXDIRSIZE);

}

/*
 ===============================================================================
 Operation: somUninit
 Purpose  : release resources
 ===============================================================================
*/

SOM_Scope void  SOMLINK somUninit(phoneDir somSelf)
{
    phoneDirData *somThis = phoneDirGetData(somSelf);
    phoneDirMethodDebug("phoneDir","somUninit");

    if (_directory._buffer) SOMFree(_directory._buffer);
    phoneDir_parent_SOMPPersistentObject_somUninit(somSelf);
}

/*
 ===============================================================================
 Operation: sompIsDirty
 ===============================================================================
*/

SOM_Scope boolean  SOMLINK sompIsDirty(phoneDir somSelf,  Environment *ev)
{
    phoneDirData *somThis = phoneDirGetData(somSelf);
    phoneDirMethodDebug("phoneDir","sompIsDirty");

    return (_sompGetDirty(somSelf, ev));
}

