/* @(#) somx/template.c 2.3 1/20/94 10:22:41 [5/15/94 17:59:05] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


/*===========================================================================*
 *                                                                           *
 * Name: template.c                                                          *
 *                                                                           *
 * Notes: This module is the implementation of a template SOM Persistence    *
 * Framework I/O Group Manager class. It's purpose is to provide a starting  *
 * point for someone who wants to implement their own I/O Group Manager      *
 * class.                                                                    *
 *                                                                           *
 * When modifying this implementation, refer to guidelines for implementing  *
 * a new I/O Group Manager in the toolkit documentation.                     *
 *                                                                           *
 * History:                                                                  *
 * 3/2/93    : version 1                                                     *
 *                                                                           *
 *===========================================================================*/

#include <somp.h>
#include <stdlib.h>
#include <stdio.h>
#include <iogrp.h>

#define SOMPTemplate_Class_Source
#include <template.ih>

SOM_Scope void  SOMLINK sompNewMediaInterface(SOMPTemplate somSelf, Environment *ev,
                string IOInfo)
{
    SOMPTemplateData *somThis = SOMPTemplateGetData(somSelf);
    SOMPTemplateMethodDebug("SOMPTemplate","sompNewMediaInterface");

    if (_mia == NULL) {
       _mia = _sompInstantiateMediaInterface(somSelf, ev);
       _sompInitReadWrite(_mia, ev, IOInfo);
       if (ev->_major == NO_EXCEPTION) {
          _sompOpen(_mia, ev);
       } /* endif */
    } /* endif */
}

SOM_Scope SOMPMediaInterfaceAbstract  SOMLINK sompGetMediaInterface(SOMPTemplate somSelf, Environment *ev)
{
    SOMPTemplateData *somThis = SOMPTemplateGetData(somSelf);
    SOMPTemplateMethodDebug("SOMPTemplate","sompGetMediaInterface");

    return (_mia);
}

SOM_Scope void  SOMLINK sompFreeMediaInterface(SOMPTemplate somSelf, Environment *ev)
{
    SOMPTemplateData *somThis = SOMPTemplateGetData(somSelf);
    SOMPTemplateMethodDebug("SOMPTemplate","sompFreeMediaInterface");

    if (_mia) {
       _sompClose(_mia, ev);
       _somFree(_mia);
       _mia = NULL;
    } /* endif */
}

SOM_Scope SOMPMediaInterfaceAbstract  SOMLINK sompInstantiateMediaInterface(SOMPTemplate somSelf, Environment *ev)
{
    SOMPMediaInterfaceAbstract mia = NULL;
    SOMPTemplateData *somThis = SOMPTemplateGetData(somSelf);
    SOMPTemplateMethodDebug("SOMPTemplate","sompInstantiateMediaInterface");

    /* mia = <mediaInterfaceClassName>New(); */
    mia = SOMPAsciiMediaInterfaceNew(); /* sample only */
    return(mia);
}

SOM_Scope boolean SOMLINK sompWriteGroup(SOMPTemplate somSelf, Environment *ev,
                SOMPPersistentObject storeObj)
{
    SOMPIteratorHandle hit;
    SOMObject thisPo;
    SOMPIOGroup thisGroup;
    SOMPEncoderDecoderAbstract ed;

    SOMPTemplateData *somThis = SOMPTemplateGetData(somSelf);
    SOMPTemplateMethodDebug("SOMPTemplate","sompWriteGroup");

#ifdef TMP_WRITE_ALL
/* Write all objects grouped with the given object */
    thisGroup = _sompGetIOGroup(storeObj, ev);

    hit = _sompNewIterator(thisGroup, ev);

    /* Get each of the objects from the group. If it should be stored,
       then instantiate an Encoder/Decoder object and invoke its
       sompEDWrite method.                                     */
    while ( ((thisPo = _sompNextObjectInGroup(thisGroup, ev, hit))!=NULL) &&
             ev->_major == NO_EXCEPTION) {

      if (_sompIsDirty(thisPo, ev)) {
         _sompPassivate(thisPo, ev); /* Tell object to prepare to be stored. */
         /* ...
            At this point, the IO Group Mgr must
            store anything about the object necessary in order to
            find it again in the group container. You may want to
            store any of:
             - how many objects are in the group container
             - where the object is located
             - mapping between ID and the class name of the object (used
               when the object is restored).
             - the class name of the encoder/decoder used by the object
             - etc.
            ... */
         ed = _sompGetEncoderDecoder(thisPo, ev);
         /* Now, write the object data */
         if (ed) {
            _sompEDWrite(ed, ev, _sompGetMediaInterface(somSelf, ev), thisPo);
            _sompFreeEncoderDecoder(thisPo, ev);
            _sompClearState(thisPo, ev, SOMP_STATE_DIRTY);
            /* ...
               any other unique processing
               ... */
         } else {
            sompRaiseException(ev, SOMPERROR_FRAMEWORK_ERROR,
                                   SOMPERROR_ENC_DEC_NOT_FOUND);
         } /* endif */
      } /* endif */
   } /* endwhile */
   _sompFreeIterator(thisGroup, ev, hit);
   return(TRUE); /* return TRUE to indicate that we attempted to write
                    all objects in the group.                           */
#else
   /* Write only the given object. */

   /* Write the object only if it is stable and has been marked as "dirty" */
   if (_sompIsDirty(storeObj, ev)) {
      _sompPassivate(storeObj, ev); /* Tell object to prepare to be stored. */
      /* ...
         At this point, the IO Group Mgr must
         store anything about the object necessary in order to
         find it again in the group container

         ... */
      ed = _sompGetEncoderDecoder(storeObj, ev);
      if (ed) {
         /* Now, write the object data */
         _sompEDWrite(ed, ev, _sompGetMediaInterface(somSelf, ev), storeObj);
         _sompFreeEncoderDecoder(storeObj, ev);
         _sompClearState(storeObj, ev, SOMP_STATE_DIRTY);
         /* ...
            any other unique processing
            ... */
      } else {
         sompRaiseException(ev, SOMPERROR_FRAMEWORK_ERROR,
                                SOMPERROR_ENC_DEC_NOT_FOUND);
      } /* endif */
   } /* endif */
   return(FALSE); /* return FALSE to indicate that we attempted to write
                     only the given object.                              */
#endif /* TMP_WRITE_ALL */
}

SOM_Scope SOMPPersistentObject  SOMLINK sompReadGroup(SOMPTemplate somSelf, Environment *ev,
                SOMPPersistentId objectID)
{
    SOMPIOGroup newIOGroup = NULL;
    SOMClass classObj;
    SOMObject thisPo = NULL;
    string objectClassName = "ttest"; /* template test class name */

    SOMPTemplateData *somThis = SOMPTemplateGetData(somSelf);
    SOMPTemplateMethodDebug("SOMPTemplate","sompReadGroup");

    /* ...
       Restore the objectClassName from the container the
       IO Group Mgr is managing and anything else about the object
       required for your IO Group Mgr. This will depend on what
       object metadata you have stored along with your object.

       You must provide some ability to map the given objectID
       into a SOM class name.

       objectClassName = ...;

       ... */

   classObj = _somFindClass(SOMClassMgrObject,
                            SOM_IdFromString(objectClassName),
                            0, 0);
   if (classObj) { /* If SOM was able to find the class, instantiate
                      the object.                                    */
      thisPo = _somNew(classObj);
      _sompInitGivenId(thisPo, ev, objectID);
      /*
         ...

      */
      /* Indicate this object is unstable - i.e. not fully restored yet
         and that the object is not "dirty" yet.                        */
      _sompClearState(thisPo, ev, SOMP_STATE_STABLE);
      _sompSetState(thisPo, ev, SOMP_STATE_UNSTABLE);
      _sompClearState(thisPo, ev, SOMP_STATE_DIRTY);
      newIOGroup = _sompGetIOGroup(thisPo, ev);
   } else {
      sompRaiseException(ev, SOMPERROR_FRAMEWORK_ERROR,
                             SOMPERROR_IOGROUP_NEWOBJ);
   } /* endif */

   return(thisPo);
}

SOM_Scope void  SOMLINK sompReadObjectData(SOMPTemplate somSelf, Environment *ev,
                SOMPPersistentObject thisPo)
{
    SOMPEncoderDecoderAbstract ed;
    SOMPPersistentId objectID;

    SOMPTemplateData *somThis = SOMPTemplateGetData(somSelf);
    SOMPTemplateMethodDebug("SOMPTemplate","sompReadObjectData");

    /* Locate the object in the group container via its ID and
       set up the media interface in preparation for invoking the
       sompEDRead method to read the object data.

       objectID = _sompGetPersistentId(thisPo, ev);

       ...

       */

    ed = _sompGetEncoderDecoder(thisPo, ev);
    if (ed) {
       _sompEDRead(ed, ev, _sompGetMediaInterface(somSelf, ev), thisPo);
       _sompFreeEncoderDecoder(thisPo, ev);

       _sompClearState(thisPo, ev, SOMP_STATE_UNSTABLE);
       _sompSetState(thisPo, ev, SOMP_STATE_STABLE);
    } else {
       sompRaiseException(ev, SOMPERROR_FRAMEWORK_ERROR,
                              SOMPERROR_ENC_DEC_NOT_FOUND);
    } /* endif */
}

SOM_Scope void  SOMLINK sompDeleteObjectFromGroup(SOMPTemplate somSelf, Environment *ev,
                SOMPPersistentId objectID)
{
    /* SOMPTemplateData *somThis = SOMPTemplateGetData(somSelf); */
    SOMPTemplateMethodDebug("SOMPTemplate","sompDeleteObjectFromGroup");

    SOMPTemplate_parent_SOMPIOGroupMgrAbstract_sompDeleteObjectFromGroup(somSelf,ev,objectID);
}

SOM_Scope boolean  SOMLINK sompGroupExists(SOMPTemplate somSelf, Environment *ev,
                string IOInfo)
{
    SOMPTemplateData *somThis = SOMPTemplateGetData(somSelf);
    SOMPTemplateMethodDebug("SOMPTemplate","sompGroupExists");

    /* Determine whether the group given by IOInfo exists */

    return (TRUE);
}

SOM_Scope boolean  SOMLINK sompObjectInGroup(SOMPTemplate somSelf, Environment *ev,
                SOMPPersistentId objectID)
{
    SOMPTemplateData *somThis = SOMPTemplateGetData(somSelf);
    SOMPTemplateMethodDebug("SOMPTemplate","sompObjectInGroup");

    /* Determine whether the object with the given ID is exists in the
       group determined from the ID. */
    return (TRUE);
}

SOM_Scope boolean  SOMLINK sompMediaFormatOk(SOMPTemplate somSelf, Environment *ev,
                string mediaFormatName)
{
    SOMPTemplateData *somThis = SOMPTemplateGetData(somSelf);
    SOMPTemplateMethodDebug("SOMPTemplate","sompMediaFormatOk");

    return (TRUE);
}

SOM_Scope void  SOMLINK somInit(SOMPTemplate somSelf)
{
    SOMPTemplateData *somThis = SOMPTemplateGetData(somSelf);
    SOMPTemplateMethodDebug("SOMPTemplate","somInit");

    _mia = NULL; /* Initially, no media interface */
}

SOM_Scope void  SOMLINK somUninit(SOMPTemplate somSelf)
{
    Environment tev;
    SOMPTemplateData *somThis = SOMPTemplateGetData(somSelf);
    SOMPTemplateMethodDebug("SOMPTemplate","somUninit");

    _sompFreeMediaInterface(somSelf, &tev);
}
