/* @(#) somx/prftest.c 2.3 1/20/94 10:20:07 [5/15/94 17:59:07] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */

/*****************************************************************************/
/*                                                                           */
/* PROGRAM NAME: PRFTEST                                                     */
/*  SOM Persistence Framework Sample Program                                 */
/*                                                                           */
/* REVISION LEVEL: 1.0                                                       */
/*                                                                           */
/* WHAT THIS PROGRAM DOES:                                                   */
/*  This program creates several persistent objects and stores               */
/*  them via a user-built IO Group Mgr class (SOMPIni) and a user-built      */
/*  Media Interface class (SOMPIniMediaInterface) into an OS/2 .INI file.    */
/*  It displays the students stored, restores one of the student objects     */
/*  and displays it.                                                         */
/*                                                                           */
/* WHAT THIS PROGRAM DEMONSTRATES:                                           */
/*  This program demonstrates the use of subclasses of the SOM Persistence   */
/*  Framework. By specifying an object ID of "SOMPIni:os2.ini:0" this        */
/*  program instructs the Framework to instantiate an IO Group Manager       */
/*  class named "SOMPIni". This class is provided in the sompini.dll         */
/*  file as an example I/O Group Manager class.                              */
/*                                                                           */
/*  To see the implementation of the sample I/O Group Mgr class              */
/*  SOMPIni, refer to prfgm.idl and prfgm.c.                                 */
/*                                                                           */
/*  To see the implementation of the sample Media Interface class            */
/*  SOMPIniMediaInterface, refer to prf.idl and prf.c.                       */
/*                                                                           */
/*                                                                           */
/* WHAT YOU NEED TO COMPILE THIS PROGRAM:                                    */
/*  Refer to the Makefile                                                    */
/*                                                                           */
/*****************************************************************************/
#include <stdlib.h>
#include <stdio.h>

#include <somp.h>                   /* Persistence framework         */
#include <student.h>                /* Student class                 */

#define USE_SOMPINI
#ifdef USE_SOMPINI
string pidString = "SOMPIni:os2.ini:0";      /* Use user-built IO Group Mgr */
#else
string pidString = "SOMPAscii:os2.ini:0";      /* Use framework supplied  */
#endif

main(argc, argv, envp)
  int argc;
  char *argv[];
  char *envp[];
{
   Environment *ev;
   PersistentStudent s1, s2, s3, s4, s5;
   SOMPPersistentStorageMgr psm = SOMPPersistentStorageMgrNew();
   SOMPPersistentId pid = SOMPPersistentIdNew();
   long rc;

   ev = SOM_CreateLocalEnvironment();

/* Get a few persistent objects
   ---------------------------- */
   s1 = PersistentStudentNew();
   s2 = PersistentStudentNew();
   s3 = PersistentStudentNew();
   s4 = PersistentStudentNew();
   s5 = PersistentStudentNew();

/* Setup the ID.
   The ID used determines the IO Group Mgr class used to store the
   object.
   --------------------------------------------------------------- */
   _somutSetIdString(pid, ev, pidString);
   if (ev->_major != NO_EXCEPTION) {
      somPrintf("%s is not a valid ID.\n", pidString);
      exit(1);
   } /* endif */

/* Initialize the objects into the same group
   ------------------------------------------ */
   _sompInitGivenId   (s1, ev, pid);
   _sompInitNearObject(s2, ev, s1);
   _sompInitNearObject(s3, ev, s1);
   _sompInitNearObject(s4, ev, s1);
   _sompInitNearObject(s5, ev, s1);

/* Modify the objects...
   --------------------- */
   _setUpStudent(s1, ev, "123-45-6789", "Joe Blow");
   _setUpStudent(s2, ev, "123-45-6790", "John Q. Public");
   _setUpStudent(s3, ev, "123-45-6791", "John Doe");
   _setUpStudent(s4, ev, "123-45-6792", "Sally Forth");
   _setUpStudent(s5, ev, "123-45-6793", "Wendy Whiner");

/* Store the group of objects, s1 thru s5.
   Storing just the s1 object will result
   in storing all the objects initialized
   "near" (via sompInitNearObject) it.
   This behavior is determined by the
   implementor of the IO Group Manager
   class.
   -------------------------------------- */
   _sompStoreObject(psm, ev, s1);
   if (ev->_major == NO_EXCEPTION) {
      somPrintf("Stored the following objects:\n");
      _printStudentInfo(s1, ev);
      _printStudentInfo(s2, ev);
      _printStudentInfo(s3, ev);
      _printStudentInfo(s4, ev);
      _printStudentInfo(s5, ev);
   } else {
      somPrintf("Exception %s encountered.\n", exception_id(ev));
      exit(1);
   } /* endif */

   _somFree(s1); /* free this so we know we will be restoring from disk */
   _somFree(s2);
   _somFree(s3);
   _somFree(s4);
   _somFree(s5);

/* Restore the first object.
   The IO Group Mgr in this sample is built
   to return only the object requested and
   not all the objects initialized near it.
   ----------------------------------------- */
   s1 = _sompRestoreObject(psm, ev, pid);

/* Print out the student
   Note: on AIX, nothing is restored and therefore no student info
   will be printed below.
   --------------------------------------------------------------- */
   if (s1) {
      somPrintf("Restored the following objects:\n");
      _printStudentInfo(s1, ev);
   } /* endif */
}
