/* @(#) somx/sample5.c 2.3 1/20/94 10:14:45 [5/15/94 17:58:54] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */

/*
 *  Persistent Framework Example 5
 */

#include "direntry.h"        /*  Client Class Includes  */
#include "phonedir.h"
#include <somp.h>            /*  Persistence Includes   */

/* Global Declarations.
   -------------------- */
SOMPPersistentStorageMgr psm;
SOMPIdAssigner idAssigner;
static char idBuff[SOMPMAXIDSIZE]; /*  Stores system Id of persistent object */
Environment *ev;

/*
--------------------------------------------------------------------
save
Demonstrates creating and storing of a compound
persistent object - a list of phone numbers.

Demonstrated Features:
  - system-assigned persistent id.
  - all objects in a single io/group.
  - default attribute encoder/decoder.
  - object modification.
--------------------------------------------------------------------
 */

void save()
{
/* Local declarations.
   ------------------- */
   SOMPPersistentId pid;
   dirEntry name1, name2, name3;
   phoneDir mylist;
   string fp;

/* Create phone directory with three entries.
   ------------------------------------------ */
   mylist = phoneDirNew();

   name1 = dirEntryNew();
   _mkEntry  (name1, "Roger", "555-5085");
   _addEntry (mylist, name1);

   name2 = dirEntryNew();
   _mkEntry  (name2, "Hari", "555-5079");
   _addEntry (mylist, name2);

   name3 = dirEntryNew();
   _mkEntry  (name3, "Charles", "555-5571");
   _addEntry (mylist, name3);

/* Display phone directory.
   ------------------------ */
   _printDirInfo(mylist);

/* Initialize Persistent ID(s).
   ---------------------------- */
   _sompInitNextAvail (mylist, ev, idAssigner);    /* System-Assigned */
   if (ev->_major != NO_EXCEPTION) exit(-1);

   _sompInitNearObject (name1, ev, mylist);
   if (ev->_major != NO_EXCEPTION) exit(-1);

   _sompInitNearObject (name2, ev, mylist);
   if (ev->_major != NO_EXCEPTION) exit(-1);

   _sompInitNearObject (name3, ev, mylist);
   if (ev->_major != NO_EXCEPTION) exit(-1);

/* Get the object id used for storing the directory.
   ------------------------------------------------- */
   pid = _sompGetPersistentId (mylist, ev);
   fp  = _sompGetIOGroupName (pid, ev, idBuff);

/* Store the phone directory.
   -------------------------- */
   _sompStoreObject(psm, ev, mylist);
   if (ev->_major != NO_EXCEPTION) exit(-1);

/* Finished.
   --------- */
   _somFree (name1);
   _somFree (name2);
   _somFree (name3);
   _somFree (mylist);
}

/*
--------------------------------------------------------------------
modify
Restores a (previously created) persistent object, adds and
updates entries, and stores the (modified) object.
--------------------------------------------------------------------
*/
void modify()
{
/* Local declarations.
   ------------------- */
   dirEntry  newname, oldname;
   phoneDir  mylist;
   SOMPPersistentId pid;

/* Set Id of Persistent Object to be restored.
   ------------------------------------------- */
   pid = SOMPPersistentIdNew();             /*  Free before exit */
   _sompSetIOGroupName(pid, ev, idBuff);
   if (ev->_major != NO_EXCEPTION) {
      somPrintf ("Set Persistent Name failed.\n");
      exit(-1);
   }

/* Restore phone directory.
   ------------------------ */
   mylist = _sompRestoreObject (psm, ev, pid);
   if (ev->_major != NO_EXCEPTION) exit(-1);

/* Add a new entry to the directory.
   --------------------------------- */
   newname = dirEntryNew();
   _sompInitNearObject (newname, ev, mylist);
   if (ev->_major != NO_EXCEPTION) exit(-1);

   _mkEntry (newname, "Robert", "555-5158");
   _addEntry (mylist, newname);

/* Modify an existing Entry.
   ------------------------- */
   oldname = _getEntry (mylist, "Charles");
   if (oldname == (dirEntry) NULL) {
     somPrintf ("\nCould not find entry for Charles\n");
   } else {
     _mkEntry (oldname, "Charles", "555-5071");
     _sompSetDirty(oldname, ev);
   } /* endif */

/* Display the modified phone directory.
   ------------------------------------- */
   _printDirInfo(mylist);

/* Store the modified phone directory.
   ----------------------------------- */
   _sompStoreObject (psm, ev, mylist);
   if (ev->_major != NO_EXCEPTION) exit(-1);

/* Finished.
   --------- */
   _somFree (pid);
   _somFree (newname);
   _somFree (oldname);
   _somFree (mylist);
}

/*
--------------------------------------------------------------------
delete
Demonstrates deleting a persistent object from its I/O group.
--------------------------------------------------------------------
*/
void delete()
{
/* Local declarations.
   ------------------- */
   dirEntry  dropname;
   phoneDir  mylist;
   char deleteBuff[100];
   SOMPPersistentId pid, dropPid;
   string fp;

/* Set Id of Persistent Object to be restored.
   ------------------------------------------- */
   pid = SOMPPersistentIdNew();
   _sompSetIOGroupName(pid, ev, idBuff);
   if (ev->_major != NO_EXCEPTION) {
      somPrintf ("Set Persistent Name failed.\n");
      exit(-1);
   }

/* Restore phone directory.
   ------------------------ */
   mylist = _sompRestoreObject (psm, ev, pid);
   if (ev->_major != NO_EXCEPTION) exit(-1);

/* Delete one of the entries.
   -------------------------- */
   dropname = _dropEntry (mylist, "Hari");

/* Get and display the persistent id for the entry.
   ------------------------------------------------ */
   dropPid = _sompGetPersistentId (dropname, ev);

/* Delete the persistent object from the I/O group.
   ------------------------------------------------ */
   _sompDeleteObject(psm, ev, dropPid);
   if (ev->_major != NO_EXCEPTION) exit(-1);

/* Store the modified phone directory.
   ----------------------------------- */
   _sompStoreObject (psm, ev, mylist);

/* Display the directory.
   ---------------------- */
   _printDirInfo(mylist);

/* Finished.
   --------- */
   _somFree (pid);
   _somFree (mylist);
}

/*
--------------------------------------------------------------------
restore
Demonstrates restoration of a persistent object.
--------------------------------------------------------------------
*/
void restore()
{
/* Local declarations.
   ------------------- */
   phoneDir mylist;
   SOMPPersistentId pid;

/* Set Id of Persistent Object to be restored.
   ------------------------------------------- */
   pid = SOMPPersistentIdNew();             /*  Free before exit */
   _sompSetIOGroupName(pid, ev, idBuff);
   if (ev->_major != NO_EXCEPTION) {
      somPrintf ("Set Persistent Name failed.\n");
      exit(-1);
   }

/* Restore phone directory.
   ------------------------ */
   mylist = _sompRestoreObject (psm, ev, pid);
   if (ev->_major != NO_EXCEPTION) exit(-1);

/* Display the directory.
   ---------------------- */
   _printDirInfo(mylist);

/* Finished.
   --------- */
   _somFree (pid);
}

main()
{
/* Initialize the Persistence Framework.
   ------------------------------------- */
   psm = SOMPPersistentStorageMgrNew();
   idAssigner = SOMPIdAssignerNew();
   ev = somGetGlobalEnvironment();
   dirEntryNewClass(0,0);
   phoneDirNewClass(0,0);

   somPrintf("\nSave test\n");
   save();
   somPrintf("\nModify test\n");
   modify();
   somPrintf("\nDelete test\n");
   delete();
   somPrintf("\nRestore test\n");
   restore();
   _somFree (idAssigner);
   exit (0);
}

