/* @(#) somx/sample3.c 2.3 1/20/94 10:13:37 [5/15/94 17:58:50] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */

/*
 *  Persistence Framework Example Program 3
 */


#include "direntry.h"        /*  Client Class Includes */
#include "phonedir.h"
#include <somp.h>            /*  Persistence Includes   */

/* Global Declarations.
   -------------------- */
SOMPPersistentStorageMgr psm;
SOMPIdAssigner idAssigner;
static char idBuff[SOMPMAXIDSIZE]; /*  Stores system Id of persistent object */
Environment *ev;

/*
--------------------------------------------------------------------
save
Demonstrates creating and storing of a compound
persistent object - a list of phone numbers.

Demonstrated Features:
  - client-assigned persistent id.
  - all objects in a single io/group.
  - default attribute encoder/decoder.
--------------------------------------------------------------------
*/
save()
{
/* Local declarations.
   ------------------- */
   SOMPPersistentId pid;
   dirEntry name1, name2;
   phoneDir mylist;
   string fp;

   pid = SOMPPersistentIdNew();

/* Create phone directory.
   ----------------------- */
   mylist = phoneDirNew();

   _sompSetIOGroupName(pid, ev, "./phoneDir");
   if (ev->_major != NO_EXCEPTION) exit(-1);

   _sompInitGivenId (mylist, ev, pid);
   _somFree (pid);
   if (ev->_major != NO_EXCEPTION) exit(-1);

/* Get the object id used for storing the directory.
   ------------------------------------------------- */
   pid = _sompGetPersistentId (mylist, ev);
   fp  = _sompGetIOGroupName (pid, ev, idBuff);

/* Add entry 1.
   ------------ */
   name1 = dirEntryNew();
   _mkEntry  (name1, "Roger", "555-5085");
   _sompInitNearObject (name1, ev, mylist);
   if (ev->_major != NO_EXCEPTION) exit(-1);
   _addEntry (mylist, name1);

/* Add entry 2.
   ------------ */
   name2 = dirEntryNew();
   _mkEntry  (name2, "Hari", "555-5079");
   _sompInitNearObject (name2, ev, mylist);
   if (ev->_major != NO_EXCEPTION) exit(-1);
   _addEntry (mylist, name2);

/* Display phone directory.
   ------------------------ */
   _printDirInfo(mylist);

/* Store the phone directory.
   -------------------------- */
   _sompStoreObject (psm, ev, mylist);
   if (ev->_major != NO_EXCEPTION) {
      somPrintf ("\nBack from StoreObject - ERROR!\n");
   } else {
      somPrintf ("\nBack from StoreObject - Ok\n");
      somPrintf ("Group Name is %s\n", idBuff);
   }

/* Finished.
   --------- */
   _somFree (name2);
   _somFree (name1);
   _somFree (mylist);
}


/*
--------------------------------------------------------------------
restore
Demonstrates restoring a (previously created) compound
persistent object - a list of phone numbers.
--------------------------------------------------------------------
*/
restore()
{
/* Local declarations.
   ------------------- */
   SOMPPersistentId pid;
   phoneDir  mylist;

/* Set Id of Persistent Object to be restored.
   ------------------------------------------- */
   pid = SOMPPersistentIdNew();             /*  Must free before exit */
   _sompSetIOGroupName(pid, ev, idBuff);
   if (ev->_major != NO_EXCEPTION) {
      somPrintf ("Set Persistent Name failed.\n");
      exit(-1);
   }

/* Restore phone directory.
   ------------------------ */
   mylist = _sompRestoreObject (psm, ev, pid);
   if (ev->_major != NO_EXCEPTION) {
     somPrintf ("\nRestore failed.\n");
     exit(-1);
   }

/* Display the directory.
   ---------------------- */
   _printDirInfo(mylist);

/* Finished.
   --------- */
   _somFree (pid);
}

main()
{
/* Initialize persistent framework.
   -------------------------------- */
   psm = SOMPPersistentStorageMgrNew();
   ev = somGetGlobalEnvironment();

   somPrintf("\nSave test\n");
   save();
   somPrintf("\nRestore test\n");
   restore();
   exit (0);
}

