/* @(#) somx/sample2.c 2.3 1/20/94 10:13:03 [5/15/94 17:58:53] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */

/*
 *  Persistent Framework Example Program 2.
 */

#include "direntry.h"        /*  Client Class Includes */
#include "phonedir.h"
#include <somp.h>            /*  Persistence Includes   */

/* Global Declarations.
   -------------------- */
SOMPPersistentStorageMgr psm;
SOMPIdAssigner idAssigner;
SOMClass encdecClass;
static char idBuff[SOMPMAXIDSIZE]; /*  Stores system Id of persistent object */
Environment *ev;

/*
--------------------------------------------------------------------
save
Demonstrates creating and storing of a compound
persistent object - a list of phone numbers.

Demonstrated Features:
  - system-assigned persistent id.
  - each objects in a separate io/group.
  - default attribute encoder/decoder.
--------------------------------------------------------------------
*/

save()
{
/* Local declarations.
   ------------------- */
   SOMPPersistentId pid;
   dirEntry name1, name2;
   phoneDir mylist;
   string fp;

/* Create phone directory.
   ----------------------- */
   mylist = phoneDirNew();
   _sompInitNextAvail (mylist, ev, idAssigner);    /* System-Assigned */
   if (ev->_major != NO_EXCEPTION) exit(-1);

/* Get the object id used for storing the directory.
   ------------------------------------------------- */
   pid = _sompGetPersistentId (mylist, ev);
   fp  = _sompGetIOGroupName (pid, ev, idBuff);

/* Add entry 1.
   ------------ */
   name1 = dirEntryNew();
   _mkEntry  (name1, "Roger", "555-5085");
   _sompInitNextAvail (name1, ev, idAssigner);     /* System-Assigned */
   if (ev->_major != NO_EXCEPTION) exit(-1);
   _addEntry (mylist, name1);

/* Add entry 2.
   ------------ */
   name2 = dirEntryNew();
   _mkEntry  (name2, "Hari", "555-5079");
   _sompInitNextAvail (name2, ev, idAssigner);     /* System-Assigned */
   if (ev->_major != NO_EXCEPTION) exit(-1);
   _addEntry (mylist, name2);

/* Display phone directory.
   ------------------------ */
   _printDirInfo(mylist);

/* Store the phone directory.
   -------------------------- */
   _sompStoreObject (psm, ev, mylist);
   if (ev->_major != NO_EXCEPTION) {
      printf ("\nBack from StoreObject - ERROR!\n");
   } else {
      printf ("\nBack from StoreObject - Ok\n");
   }

/* Finished.
   --------- */
   _somFree (idAssigner);
   _somFree (name2);
   _somFree (name1);
   _somFree (mylist);
}
/*
--------------------------------------------------------------------
restore
Demonstrates restoring a (previously created) compound
persistent object - a list of phone numbers.
--------------------------------------------------------------------
*/
restore()
{
/* Local declarations.
   ------------------- */
   SOMPPersistentId pid;
   phoneDir mylist;

/* Set Id of Persistent Object to be restored.
   ------------------------------------------- */
   pid = SOMPPersistentIdNew();                  /*  Free before exit */
   _sompSetIOGroupName(pid, ev, idBuff); /* default IO Group Mgr SOMPAscii */
   if (ev->_major != NO_EXCEPTION) {
      printf ("Set Persistent Name failed.\n");
      exit(-1);
   }

/* Restore phone directory.
   ------------------------ */
   mylist = _sompRestoreObject (psm, ev, pid);
   if (ev->_major != NO_EXCEPTION) {
     printf ("\nRestore failed.\n");
     exit(-1);
   }

/* Display the directory.
   ---------------------- */
   _printDirInfo(mylist);

/* Finished.
   --------- */
   _somFree (pid);
}

main()
{
/* Initialize persistent framework.
   -------------------------------- */
   psm         = SOMPPersistentStorageMgrNew();
   ev          = somGetGlobalEnvironment();
   idAssigner  = SOMPIdAssignerNew();

   printf("\nSave test\n");
   save();
   printf("\nRestore test\n");
   restore();
   exit (0);
}

