#ifndef lint
static char *sccsid = "@(#) 1.1 src/somples.os2/somd/cpp/animal/dloc.cpp, somx, som2.0.fix, csd2.0.4 4/15/94 13:22:31 [5/23/94 10:10:45]";
#endif

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


/*
 *  96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1994
 *  All Rights Reserved
 *  Licensed Materials - Property of IBM
 *
 *  DISCLAIMER OF WARRANTIES:  The following [enclosed] code is sample
 *  code created by IBM Corporation.  This sample code is not part of any
 *  standard or IBM product and is provided to you solely for the purpose
 *  of assisting you in the development of your applications.  This code
 *  is provided "AS IS", without warranty of any kind.  IBM shall not be
 *  liable for any damages arising out of your use of the sample code,
 *  even if they have been advised of the possibility of such damages.
 */

#define dLocation_Class_Source

#include <string.h>
#include "dloc.xih"


/*
 * Method from the IDL attribute statement:
 * "attribute string city"
 */

/*
 * City where animal was born.
 */

SOM_Scope void  SOMLINK _set_city(dLocation *somSelf, Environment *ev,
		string city)
{
    dLocationData *somThis = dLocationGetData(somSelf);
    dLocationMethodDebug("dLocation","_set_city");

    if (somThis->city) SOMFree(somThis->city);
    somThis->city = (string) SOMMalloc(strlen(city) + 1);
    strcpy(somThis->city, city);
}


/*
 * Method from the IDL attribute statement:
 * "attribute string state"
 */

/*
 * State where animal was born.
 */

SOM_Scope void  SOMLINK _set_state(dLocation *somSelf, Environment *ev,
		string state)
{
    dLocationData *somThis = dLocationGetData(somSelf);
    dLocationMethodDebug("dLocation","_set_state");

    if (somThis->state) SOMFree(somThis->state);
    somThis->state = (string) SOMMalloc(strlen(state) + 1);
    strcpy(somThis->state, state);
}


SOM_Scope void   SOMLINK somInit(dLocation *somSelf)
{
    Environment *ev;

    /* dLocationData *somThis = dLocationGetData(somSelf); */
    dLocationMethodDebug("dLocation","somInit");

    parent_somInit(somSelf);
    ev = somGetGlobalEnvironment();

    somSelf->_set_city(ev, "unknown city");
    somSelf->_set_state(ev, "unknown state");
}


SOM_Scope void   SOMLINK somUninit(dLocation *somSelf)
{
    dLocationData *somThis = dLocationGetData(somSelf);
    dLocationMethodDebug("dLocation","somUninit");

    parent_somUninit(somSelf);

    if (somThis->city) SOMFree(somThis->city);
    if (somThis->state) SOMFree(somThis->state);
}

