#ifndef lint
static char *sccsid = "@(#) 2.4 src/somples.os2/somd/c/stack/stack.c, somx, som2.0.fix, csd2.0.4 4/8/94 15:25:39 [5/23/94 10:01:55]";
#endif

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */

#define Stack_Class_Source
#include <stack.ih>


SOM_Scope boolean  SOMLINK full(Stack somSelf, Environment *ev)
{
    StackData *somThis = StackGetData(somSelf);
    StackMethodDebug("Stack","full");

    /* Return TRUE if stack is full. */
    return (_stackTop == stackSize);
}


SOM_Scope boolean  SOMLINK empty(Stack somSelf, Environment *ev)
{
    StackData *somThis = StackGetData(somSelf);
    StackMethodDebug("Stack","empty");

    /* Return TRUE if stack is empty.*/
    return (_stackTop == 0);
}


SOM_Scope long  SOMLINK top(Stack somSelf, Environment *ev)
{
    StackData *somThis = StackGetData(somSelf);
    StackMethodDebug("Stack","top");

    if (_stackTop > 0)
    {
       /* Return top element in stack without removing it from the stack. */
       return (_stackValues[_stackTop-1]);
    }
    else
    {
       somSetException(ev, USER_EXCEPTION, ex_STACK_UNDERFLOW, NULL);
       return (-1L);
    }
}


SOM_Scope long  SOMLINK pop(Stack somSelf, Environment *ev)
{
    StackData *somThis = StackGetData(somSelf);
    StackMethodDebug("Stack","pop");

    if (_stackTop > 0)
    {
       /* Return top element in stack and remove it from the stack. */
       _stackTop--;
       return (_stackValues[_stackTop]);
    }
    else
    {
       somSetException(ev, USER_EXCEPTION, ex_STACK_UNDERFLOW, NULL);
       return (-1L);
    }
}


SOM_Scope void  SOMLINK push(Stack somSelf, Environment *ev, long el)
{
    StackData *somThis = StackGetData(somSelf);
    StackMethodDebug("Stack","push");

    if (_stackTop < stackSize)
    {
      /* Add element to top of the stack. */
      _stackValues[_stackTop] = el;
      _stackTop++;
    }
    else
    {
       somSetException(ev, USER_EXCEPTION, ex_STACK_OVERFLOW, NULL);
    }
}


SOM_Scope void  SOMLINK somInit(Stack somSelf)
{
    StackData *somThis = StackGetData(somSelf);
    StackMethodDebug("Stack","somInit");

    Stack_parent_SOMObject_somInit(somSelf);

    /* stackTop is index into stackValues for next pushed stack element.
     * stackValues[0..(stackSize-1)] holds stack elements.
     */
    _stackTop = 0;
}

