/* @(#) somx/sompserv.c 2.3 1/20/94 09:36:10 [5/15/94 17:57:59] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */

/*
 *   Implementation of DSOM Server Object for Persistent Objects.
 *
 */

#define SOMPServer_Class_Source

#include <somp.h>
#include <somd.h>
#include <implrep.h>
#include <repostry.h>
#include <intfacdf.h>

#include "sompserv.ih"
#define NO_ERROR(ev) (ev->_major == NO_EXCEPTION)

#ifdef __IBMC__
  #pragma linkage(SOMInitModule, system)
#endif /* __IBMC__ */
/*--------------------------------------------------------------------------*
 * This function is called when we're dynamically loaded via somFindClass
 *--------------------------------------------------------------------------*/
SOMEXTERN void SOMLINK SOMInitModule (long majorVersion, long minorVersion)
{
   SOMPServerNewClass(0, 0);
}

/*--------------------------------------------------------------------------*
 * This function sets the given errorCode into the given environment.
 *--------------------------------------------------------------------------*/
static void serverError(Environment *ev, long errorCode)
{
  ServerError *params;
  params = (ServerError *) SOMMalloc(sizeof(ServerError));
  params->errorCode = errorCode;
  somSetException(ev, USER_EXCEPTION, ex_ServerError, params);
}

/*--------------------------------------------------------------------------*
 * Return the Persistent Storage Manager which can be used to store the given
 * object. In this implementation, do not free the returned object.
 * This implementation returns an instance of SOMPPersistentStorageMgr.
 *--------------------------------------------------------------------------*/
SOM_Scope SOMObject  SOMLINK somdGetStorageMgr(SOMPServer somSelf,
                                                 Environment *ev,
                                                SOMObject obj)
{
    /* SOMPServerData *somThis = SOMPServerGetData(somSelf); */
    SOMPServerMethodDebug("SOMPServer","somdGetStorageMgr");

    return(SOMPPersistentStorageMgrNew());
}

/*--------------------------------------------------------------------------*
 * Dispose of the given object and any references to it.
 * For the persistence server, this invokes deletePObj.
 *--------------------------------------------------------------------------*/
SOM_Scope void  SOMLINK somdDeleteObj(SOMPServer somSelf,  Environment *ev,
                                      SOMObject somobj)
{
    SOMDObject objref;
    /* SOMPServerData *somThis = SOMPServerGetData(somSelf); */
    SOMPServerMethodDebug("SOMPServer","somdFreeObj");

    if (_isPObj(somSelf, ev, somobj)) {
       objref = _somdRefFromSOMObj(somSelf, ev, somobj);
       if (NO_ERROR(ev)) {
          _dispose(SOMD_SOMOAObject, ev, objref);
          if (NO_ERROR(ev)) {
             _deletePObj(somSelf, ev, somobj);
          } /* endif */
       } /* endif */
    } else /* obj is not persistent, so delete as usual */
        parent_somdDeleteObj(somSelf, ev, somobj);
}

/*--------------------------------------------------------------------------*
 * Assigns an ID to the given object. The "hints" can be
 * used in the creation of an ID.
 * This implementation uses a system assigned persistent ID and
 * the hints are ignored.
 *--------------------------------------------------------------------------*/
SOM_Scope void  SOMLINK assignRefDataToPObj(SOMPServer somSelf,
                                             Environment *ev,
                                            SOMObject obj, string hints)
{
    SOMPIdAssigner idAssigner = SOMPIdAssignerNew();
    SOMPPersistentId pid = NULL;
    /* SOMPServerData *somThis = SOMPServerGetData(somSelf); */
    SOMPServerMethodDebug("SOMPServer","assignRefDataToPObj");

    _sompGetSystemAssignedId(idAssigner, ev, &pid);
    if (NO_ERROR(ev)) {
       _sompInitGivenId(obj, ev, pid);
    } /* endif */
    if (pid) _somFree(pid);
    _somFree(idAssigner);
}

/*--------------------------------------------------------------------------*
 * Return ReferenceData which can be used to build a DSOM object
 * reference. This method will return the data assigned to the
 * given object via assignRefDataToPObj. This implementation
 * returns ReferenceData which contains the pobj persistent ID.
 *
 * The caller is reponsible for freeing the returned ReferenceData._buffer.
 *--------------------------------------------------------------------------*/
SOM_Scope ReferenceData  SOMLINK getRefDataFromPObj(SOMPServer somSelf,
                                                     Environment *ev,
                                                     SOMObject pobj)
{
    SOMPPersistentId pid;
    char pidString[SOMPMAXIDSIZE];
    ReferenceData rd = {0,0,NULL};
    /* SOMPServerData *somThis = SOMPServerGetData(somSelf); */
    SOMPServerMethodDebug("SOMPServer","getRefDataFromPObj");

    pid = _sompGetPersistentId(pobj, ev);
    if (pid && NO_ERROR(ev)) {
       rd._maximum = SOMPMAXIDSIZE;
       /* note: _length is the string length PLUS 1 for the null terminator */
       /* This must be specified since ReferenceData is just a bunch of     */
       /* bytes and not a true "string".                                    */
       rd._length = _somutGetIdStringLen(pid, ev) + 1;
       rd._buffer = SOMMalloc((rd._length)+1);
       strcpy(rd._buffer, _somutGetIdString(pid, ev, pidString));
    } /* endif */
    return(rd);
}

/*--------------------------------------------------------------------------*
 * Use the given ReferenceData as a persistent ID to restore an object.
 *--------------------------------------------------------------------------*/
SOM_Scope SOMObject   SOMLINK activatePObjFromRefData(SOMPServer somSelf,
                                                      Environment *ev,
                                                     ReferenceData* rd)
{
    SOMPPersistentStorageMgr psm = SOMPPersistentStorageMgrNew();
    /* SOMPServerData *somThis = SOMPServerGetData(somSelf); */
    SOMPServerMethodDebug("SOMPServer","activatePObjFromRefData");

    return(_sompRestoreObjectFromIdString(psm, ev, (string)(rd->_buffer)));
}

/*--------------------------------------------------------------------------*
 * Determines whether the given object is one which this server
 * should handle. This implementation determines whether the
 * object is a SOMPPersistentObject.
 *--------------------------------------------------------------------------*/
SOM_Scope boolean  SOMLINK isPObj(SOMPServer somSelf,  Environment *ev,
                                  SOMObject obj)
{
    /* SOMPServerData *somThis = SOMPServerGetData(somSelf); */
    SOMPServerMethodDebug("SOMPServer","isPObj");

    return(_somIsA(obj, SOMPPersistentObjectNewClass(0, 0)));
}

/*--------------------------------------------------------------------------*
 * Deletes the given object. This implementation invokes
 * the sompDeleteObject method.
 *--------------------------------------------------------------------------*/
SOM_Scope void  SOMLINK deletePObj(SOMPServer somSelf,  Environment *ev,
                                   SOMObject pobj)
{
    SOMPPersistentId pid;
    SOMPPersistentStorageMgr psm = SOMPPersistentStorageMgrNew();
    /* SOMPServerData *somThis = SOMPServerGetData(somSelf); */
    SOMPServerMethodDebug("SOMPServer","deletePObj");

    if ( pid = _sompGetPersistentId(pobj, ev) ) {
       _sompDeleteObject(psm, ev, pid); /* frees object */
    } /* endif */
}

/*--------------------------------------------------------------------------*
 * Return the Persistent Storage Manager which can be used to store the given
 * object. In this implementation, do not free the returned object.
 * This implementation returns the instance of SOMPPersistentStorageMgr.
 *--------------------------------------------------------------------------*/
SOM_Scope SOMObject  SOMLINK getPStorageMgr(SOMPServer somSelf,
                                             Environment *ev,
                                            SOMObject obj)
{
    /* SOMPServerData *somThis = SOMPServerGetData(somSelf); */
    SOMPServerMethodDebug("SOMPServer","getPStorageMgr");

    return(SOMPPersistentStorageMgrNew());
}

/*--------------------------------------------------------------------------*
 * Creates an object of the specified class.
 * If the object is persistent, a persistent ID is assigned to
 * the object.
 *--------------------------------------------------------------------------*/
SOM_Scope SOMObject  SOMLINK somdCreateObj(SOMPServer somSelf,
                                            Environment *ev,
                                           Identifier objclass,
                                           string hints)
{
    SOMObject  obj = NULL;
    /* SOMPServerData *somThis = SOMPServerGetData(somSelf); */
    SOMPServerMethodDebug("SOMPServer","somdCreateObj");

    obj = parent_somdCreateObj(somSelf, ev, objclass, hints);
    /* if obj is persistent, assign Ref Data to it */
    if (NO_ERROR(ev) && _isPObj(somSelf, ev, obj)) {
       _assignRefDataToPObj(somSelf, ev, obj, hints);
    }
    return(obj);
}

/*--------------------------------------------------------------------------*
 * This method returns a DSOM object reference for a SOM object instance in
 * this server process.  The object adapter calls this method when it
 * returns a result from a method call which includes a SOMObject.  This
 * implementation returns an object reference with ReferenceData equivalent
 * to a persistent ID.
 *--------------------------------------------------------------------------*/
SOM_Scope SOMDObject  SOMLINK somdRefFromSOMObj(SOMPServer somSelf,
                                                 Environment *ev,
                                                SOMObject somobj)
{
    Repository repo = RepositoryNew();
    SOMDObject objref = NULL;
    ReferenceData rd;
    InterfaceDef intf = NULL;
    /* SOMPServerData *somThis = SOMPServerGetData(somSelf); */
    SOMPServerMethodDebug("SOMPServer","somdRefFromSOMObj");

    /* check to see if this object is a persistent object. If so,
       create an object ref */
    if (somobj && _isPObj(somSelf, ev, somobj)) {
       /* Create an object reference based on persistent ID. */
       rd = _getRefDataFromPObj(somSelf, ev, somobj);
       intf = _lookup_id(repo, ev, _somGetClassName(somobj));
       if (NO_ERROR(ev)) {
          objref = _create_constant(SOMD_SOMOAObject, ev, &rd, intf,
                                    SOMD_ImplDefObject);
       } else {
          /* no interface, so nothing left to do but call parent */
          objref = parent_somdRefFromSOMObj(somSelf, ev, somobj);
       } /* endif */
       if (intf) _somFree(intf);
       if (rd._buffer) SOMFree(rd._buffer);
    } else /* obj is not persistent, so get Ref in usual way */
        objref = parent_somdRefFromSOMObj(somSelf, ev, somobj);
    return(objref);
}

/*--------------------------------------------------------------------------*
 * This method maps a DSOM object reference into a SOM object.  If the
 * reference is to a persistent object, the ReferenceData can be used as
 * a persistent ID to restore the object.  This method is called by the
 * object adapter in order to translate any method call parameters which
 * are object references (created from somdRefFromSOMObj above) into SOM
 * objects.
 *--------------------------------------------------------------------------*/
SOM_Scope SOMObject  SOMLINK somdSOMObjFromRef(SOMPServer somSelf,
                                                Environment *ev,
                                               SOMDObject objref)
{
    SOMObject somobj = NULL;
    ReferenceData rd;
    StExcep *params;
    /* SOMPServerData *somThis = SOMPServerGetData(somSelf); */
    SOMPServerMethodDebug("SOMPServer","somdSOMObjFromRef");

    rd = BOA_get_id(SOMD_SOMOAObject, ev, objref);
    if (NO_ERROR(ev)) { /* if no error, it's mine */
       somobj = _activatePObjFromRefData(somSelf, ev, &rd);
    } else {
       params = exception_value(ev);
       if (params->minor == SOMDERROR_WrongRefType) {
          /* It's DSOM's ID, give it to them. */
          exception_free(ev);
          somobj = parent_somdSOMObjFromRef(somSelf, ev, objref);
       } /* endif */
    } /* endif */

    return(somobj);
}

