#ifndef lint
static char *sccsid = "@(#) 2.8 src/somples.os2/somd/c/event/consumer.c, somx, som2.0.fix, csd2.0.4 5/5/94 14:06:09 [5/23/94 10:10:27]";
#endif

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */

#ifdef __OS2__
#define INCL_DOSPROCESS
#include <os2.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <stdio.h>
#include <errno.h>

#include <somd.h>
#include <orb.h>

/* Local includes follow */
#include "eventcom.h"
#include "eventch.h"


int makeDSOMObject(char *, EventComm_EventConnection *);
int  read_obj_ref(SOMDObject *objref, char *file);
boolean  ExceptionCheck(Environment *ev);

extern ORB                       SOMD_ORBObject;
extern SOMDObjectMgr             SOMD_ObjectMgr;

Environment ev;
Disconnected                         *discon;
char                                 *exId;
StExcep                              *stExval;

int main(int argc, char *argv[])
{
    char                                 answer[10];
    EventChannelAdmin_EventChannel       evchObj;
    EventComm_Supplier                   supp_if;
    EventChannelAdmin_ConsumerAdmin      cons_admin;
    EventComm_EventConnection            evcon_if;
    int                                  rc;
    boolean                              has_event = FALSE;
    any                                  notify;
#ifdef __OS2__
    APIRET os2rc;
#endif

    SOM_InitEnvironment(&ev);
    SOMD_Init(&ev);

    /* The <object>NewClass invocation is optional and unnecessary
     * in the client program when the class object is created in the
     * SOMInitModule function that is invoked during DLL initialization.
     */
    EventComm_EventConnectionNewClass(0,0);
    EventComm_ConsumerNewClass(0,0);
    EventComm_SupplierNewClass(0,0);
    EventChannelAdmin_ConsumerAdminNewClass(0,0);
    EventChannelAdmin_SupplierAdminNewClass(0,0);
    EventChannelAdmin_EventChannelNewClass(0,0);

    rc =  read_obj_ref(&evchObj, "event.rep");
    if (rc) exit(1);

    cons_admin = _for_consumers(evchObj, &ev);
    if (makeDSOMObject("EventComm::EventConnection", &evcon_if)) exit(1);

    supp_if = _add_pull_consumer(cons_admin, &ev, evcon_if);
    printf("Poll the event channel? <return to continue or Q/q to quit>\n");
    fflush(stdout);
    gets(answer);

    while  (strcmp(answer,"q") != 0 && strcmp(answer, "Q") != 0)
    {
	notify = _try_pull(supp_if, &ev, &has_event);

	if (ExceptionCheck(&ev))
	{
	    printf("%s", discon->Reason);
	    exit (0);
	}

	while(!has_event)
	{
	    printf("Event Channel yet to be notified\n");
	    fflush(stdout);
	    notify = _try_pull(supp_if, &ev, &has_event);

	    if (ExceptionCheck(&ev))
	    {
		printf("%s", discon->Reason);
		exit (0);
	    }

	    if (has_event) break;

#ifdef __OS2__
	    os2rc = DosSleep((ULONG)1000);
#else
	    sleep(1);
#endif
	}

	printf("\n\nTHE EVENT CHANNEL HAS BEEN NOTIFIED\nThe notification obtained was:\n");
	printf("The new cell value is: %ld\n\n",  *((long *)notify._value));
	TypeCode_free(notify._type, &ev);
	printf("Poll the event channel? <return to continue or Q/q to quit>\n");
	gets(answer);
    }

    /* release the object and its reference */
    _somdReleaseObject(SOMD_ObjectMgr, &ev, evchObj);
    somExceptionFree(&ev);
    return 0;
}


boolean  ExceptionCheck(Environment *ev)
{
    switch(ev->_major)
    {
      case SYSTEM_EXCEPTION:
	exId = somExceptionId(ev);
	stExval = somExceptionValue(ev);
	break;

      case USER_EXCEPTION:
	exId = somExceptionId(ev);
	if (strcmp(exId, ex_Disconnected) == 0)
	{
	    discon = (Disconnected *) somExceptionValue(ev);
	}
	break;

      case NO_EXCEPTION:
	break;
    }

    return (ev->_major == SYSTEM_EXCEPTION || ev->_major == USER_EXCEPTION)
	    ? TRUE : FALSE;
}


/* Create Object instance  */

int makeDSOMObject(char *aclass, EventComm_EventConnection *aobject)
{
  SOMDServer server;

  server = _somdFindServerByName(SOMD_ObjectMgr, &ev, "Ccellsvr");
  *aobject =  _somdCreateObj(server, &ev, aclass, NULL);

  if (*aobject == NULL)
  {
    printf("CONSUMER - _somdCreateObj(%s) returned NULL\n", aclass);
    return (1);
  }

  return (0);
}


int  read_obj_ref(SOMDObject *objref, char *file)
{
    FILE *fd;
    char *objRefStr, *p;
    int rc = 0;

    if ((fd = fopen (file, "r")) == (FILE *) NULL)
    {
	printf ("Unable to find object ref string in %s\n", file);
	rc = -1;
    }
    else
    {
	objRefStr = (char *) SOMMalloc (512);
	p = objRefStr;

	while (! feof (fd))
	{
	    fread (p, sizeof (char), 1, fd);
	    ++p;
	}

	*(--p) = (char) NULL;

	*objref = _somdGetObjectFromId (SOMD_ObjectMgr, &ev, objRefStr);

	if (*objref == NULL)
	{
	    printf ("Unable to get objref from string %s.\n", objRefStr);
	    rc = -1;
	}

	SOMFree (objRefStr);
    }

    fclose (fd);
    return (rc);
}

