/* @(#) somx/danimal.c 2.3 1/20/94 09:21:37 [5/15/94 17:57:44] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


#define dAnimal_Class_Source

#include <stdio.h>
#include <string.h>
#include "dloc.h"
#include "danimal.ih"

/*
 * Method from the IDL attribute statement:
 * "attribute string name"
 */

/*
 *  Name of animal.
 */

SOM_Scope void  SOMLINK _set_name(dAnimal somSelf, Environment *ev,
		string name)
{
    dAnimalData *somThis = dAnimalGetData(somSelf);
    dAnimalMethodDebug("dAnimal","_set_name");

    if (_name) SOMFree(_name);
    _name = (string) SOMMalloc(strlen(name) + 1);
    strcpy(_name, name);
}

/*
 * Method from the IDL attribute statement:
 * "attribute string type"
 */

/*
 *  Type of animal.
 */

SOM_Scope void  SOMLINK _set_type(dAnimal somSelf, Environment *ev,
		string type)
{
    dAnimalData *somThis = dAnimalGetData(somSelf);
    dAnimalMethodDebug("dAnimal","_set_type");

    if (_type) SOMFree(_type);
    _type = (string) SOMMalloc(strlen(type) + 1);
    strcpy(_type, type);
}

/*
 * Method from the IDL attribute statement:
 * "attribute string food"
 */

/*
 *  Food animal likes to eat.
 */

SOM_Scope void  SOMLINK _set_food(dAnimal somSelf, Environment *ev,
		string food)
{
    dAnimalData *somThis = dAnimalGetData(somSelf);
    dAnimalMethodDebug("dAnimal","_set_food");

    if (_food) SOMFree(_food);
    _food = (string) SOMMalloc(strlen(food) + 1);
    strcpy(_food, food);
}

/*
 *  Work area for display method.
 */

SOM_Scope void  SOMLINK _set_buff(dAnimal somSelf, Environment *ev,
		string buff)
{
    dAnimalData *somThis = dAnimalGetData(somSelf);
    dAnimalMethodDebug("dAnimal","_set_buff");

    if (_buff) SOMFree(_buff);
    _buff = (string) SOMMalloc(strlen(buff) + 1);
    strcpy(_buff, buff);
}

/*
 *  Returns description of animal.
 */

SOM_Scope string  SOMLINK display(dAnimal somSelf, Environment *ev)
{
    string bp;

    dAnimalData *somThis = dAnimalGetData(somSelf);
    dAnimalMethodDebug("dAnimal","display");

    /*
     * Note that the object must allocate and free memory for the work 
     * space "buff".  The client must still free the returned string,
     * but the memory released is allocated by DSOM while marshalling the
     * result message.  The client is unable to free the memory allocated
     * by the object.
     */

    bp = _buff;
    sprintf(bp, "\nI am a %s.\n", _type);
    bp += strlen(bp);
    sprintf(bp, "My name is %s.\n", _name);
    bp += strlen(bp);
    sprintf(bp, "I like to eat %s.\n", _food);
    bp += strlen(bp);
    sprintf(bp, "I live in %s, %s.\n", __get_city(_loc, ev), __get_state(_loc, ev));
    return _buff;
}

SOM_Scope void   SOMLINK somInit(dAnimal somSelf)
{
    Environment *ev;

    dAnimalData *somThis = dAnimalGetData(somSelf);
    dAnimalMethodDebug("dAnimal","somInit");

    parent_somInit(somSelf);
    ev = somGetGlobalEnvironment();

    __set_name(somSelf, ev, "unknown name");
    __set_type(somSelf, ev, "unknown type");
    __set_food(somSelf, ev, "unknown food");
    _loc = dLocationNew();
    _buff = SOMMalloc(2048);
}

SOM_Scope void   SOMLINK somUninit(dAnimal somSelf)
{
    dAnimalData *somThis = dAnimalGetData(somSelf);
    dAnimalMethodDebug("dAnimal","somUninit");

    parent_somUninit(somSelf);

    if (_name) SOMFree(_name);
    if (_type) SOMFree(_type);
    if (_food) SOMFree(_food);
    if (_buff) SOMFree(_buff);
    _somFree(_loc);
}
