/* @(#) soms/somsinfo.h 2.2 5/4/93 07:41:11 [6/4/93 21:51:38] */

/*
 * 96F8647, 96F8648 (C) Copyright IBM Corp. 1992, 1993
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 */

#ifndef _ALL_SOURCE
#define _ALL_SOURCE
#endif

#ifdef _OS2
#ifdef _MPTS

#ifndef OS2
#define OS2
#endif

#ifndef MT
#define MT
#endif

#ifndef MPTN
#define MPTN
#endif

#ifndef SO32
#define SO32
#endif

#ifndef BSD_SELECT
#define BSD_SELECT
#endif

#endif /* _MPTS */

/* define INCL_DOSPROCESS for DosGetInfoBlocks to work correctly. */
#define __MIG_LIB__
#define INCL_DOSMODULEMGR
#define INCL_DOSMEMMGR
#define INCL_DOSQUEUES
#define INCL_DOSPROCESS
#define INCL_DOSSEMAPHORES
#define INCL_ERRORS
#define INCL_BASE
#include <os2.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <types.h>
#include <sys\socket.h>
#include <sys\select.h>
#include <sys\ioctl.h>
#include <netinet\in.h>
#include <time.h>
#include <netdb.h>
#include <utils.h>
#include <errno.h>
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <sys/uio.h>
#include <sys/ioctl.h>
#include <sys/select.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#endif /* _OS2 */

/* Sockets typedefs */
typedef struct sockaddr sockaddr;
typedef struct in_addr  in_addr;
typedef struct iovec    iovec;
typedef struct msghdr   msghdr;
typedef struct timeval  timeval;
typedef struct hostent  hostent;
typedef struct servent  servent;

/*
 * NOTE: These errno values are also defined in soms.h
 */
/* Sockets errnos */
#define SOMS_NOERROR		 0	/* no error */
#define SOMS_EWOULDBLOCK	 1	/* operation would block */
#define SOMS_EDEADLK		 SOMS_EWOULDBLOCK
#define SOMS_EAGAIN		 SOMS_EWOULDBLOCK
#define SOMS_EINPROGRESS	 2	/* operation now in progress */
#define SOMS_EALREADY		 3	/* operation already in progress */
#define SOMS_ENOTSOCK		 4	/* socket operation on non-socket */
#define SOMS_EDESTADDRREQ	 5	/* destination address required */
#define SOMS_EMSGSIZE		 6	/* message too long */
#define SOMS_EPROTOTYPE		 7	/* wrong protocol type for socket */
#define SOMS_ENOPROTOOPT	 8	/* protocol not available */
#define SOMS_EPROTONOSUPPORT	 9	/* protocol not supported */
#define SOMS_ESOCKTNOSUPPORT	10	/* socket type not supported */
#define SOMS_EOPNOTSUPP		11	/* operation not supported on socket */
#define SOMS_EPFNOSUPPORT	12	/* protocol family not supported */
#define SOMS_EAFNOSUPPORT	13	/* address family not supported */
#define SOMS_EADDRINUSE		14	/* address already in use */
#define SOMS_EADDRNOTAVAIL	15	/* can't assign requested address */
#define SOMS_ENETDOWN		16	/* network is down */
#define SOMS_ENETUNREACH	17	/* network is unreachable */
#define SOMS_ENETRESET		18	/* network dropped connection on reset*/
#define SOMS_ECONNABORTED	19	/* software caused connection abort */
#define SOMS_ECONNRESET		20	/* connection reset by peer */
#define SOMS_ENOBUFS		21	/* no buffers available */
#define SOMS_EISCONN		22	/* socket is already connected */
#define SOMS_ENOTCONN		23	/* socket is not connected */
#define SOMS_ESHUTDOWN		24	/* can't send after socket shutdown */
#define SOMS_ETOOMANYREFS	25	/* too many references */
#define SOMS_ETIMEDOUT		26	/* connection timed out */
#define SOMS_ECONNREFUSED	27	/* connection refused */
#define SOMS_ELOOP		28	/* too many levels of symbolic links */
#define SOMS_ENAMETOOLONG	29	/* file name too long */
#define SOMS_EHOSTDOWN		30	/* host is down */
#define SOMS_EHOSTUNREACH	31	/* no route to host */
#define SOMS_ENOTEMPTY		32	/* directory not empty */
#define SOMS_EBADF		33	/* bad socket descriptor */
#define SOMS_EINTR		34	/* socket call interrupted */
#define SOMS_EFAULT		35	/* bad address */
#define SOMS_EINVAL		36	/* invalid argument */
#define SOMS_EMFILE		37	/* no more socket descriptors */
#define SOMS_ENODEV		38	/* no such device */
#define SOMS_UNKNOWNERROR	39	/* unknown error */
#define SOMS_HOST_NOT_FOUND	40
#define SOMS_TRY_AGAIN		41
#define SOMS_NO_RECOVERY	42
#define SOMS_NO_ADDRESS		43

#define T_HOSTNOTFOUND		HOST_NOT_FOUND | 0x7000
#define T_NORECOVERY		NO_RECOVERY | 0x7000
#define T_NOADDRESS		NO_ADDRESS | 0x7000
#define T_TRYAGAIN		TRY_AGAIN | 0x7000
