/* @(#) 2.10 src/somd/somdext.h, somd, som2.0.fix, csd2.0.4 4/20/94 10:26:54 [5/16/94 11:54:43] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 */


/*
 *  somdext.h - miscellaneous external definitions for DSOM runtime
 *              (other external definitions are made in IDL files)
 */

#ifndef somdext_h
#define somdext_h

/* DSOM runtime functions */

#ifdef __IBMC__
  #pragma linkage(SOMD_Init, system)
  #pragma linkage(SOMD_Uninit, system)
  #pragma linkage(SOMD_RegisterCallback, system)
  #pragma linkage(SOMD_Callback, system)
  #pragma linkage(SOMInitsomd, system)
  #pragma linkage(ORBfree, system)
#endif

SOMEXTERN void SOMLINK SOMD_Init(Environment *);
SOMEXTERN void SOMLINK SOMD_Uninit(Environment *);

typedef void SOMD_Callback(void *, void *);

#ifdef SOM_STRICT_IDL
SOMEXTERN void SOMLINK SOMD_RegisterCallback(SOMObject emanObj, SOMD_Callback *func);
#else
SOMEXTERN void SOMLINK SOMD_RegisterCallback(SOMObject *emanObj, SOMD_Callback *func);
#endif /* SOM_STRICT_IDL */

SOMEXTERN void SOMLINK SOMInitsomd(void);
SOMEXTERN void SOMLINK ORBfree(void *);

/* DSOM global variables */

#ifdef _WIN16
#define SOMD_TraceLevel (*SOMD_TraceLevelResolve())
SOMEXTERN long * SOMLINK SOMD_TraceLevelResolve(void);
#define SOMD_DebugFlag (*SOMD_DebugFlagResolve())
SOMEXTERN long * SOMLINK SOMD_DebugFlagResolve(void);
#else
SOMEXTERN long SOMDLINK SOMD_TraceLevel;
SOMEXTERN long SOMDLINK SOMD_DebugFlag;
#endif /* _WIN16 */

#endif /* somdext_h */
