/* @(#) 2.5.1.5 src/somd/somderr.h, somd, som2.0.fix, csd2.0.4 4/25/94 10:09:17 [5/16/94 11:42:39] */


/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 */


/*
 *    SOMDERR.H
 *    Distributed System Object Model run-time error codes
 */


#ifndef somderr_h
#define somderr_h


/* Error Definition Macro */
#define SOMD_ERR_BASE 30000
#define SOMD_ErrorCode(incode) (SOMD_ERR_BASE + (incode))

#define SOMDERROR_NoMemory              SOMD_ErrorCode(1)
#define SOMDERROR_NotImplemented        SOMD_ErrorCode(2)
#define SOMDERROR_UnexpectedNULL        SOMD_ErrorCode(3)
#define SOMDERROR_IO                    SOMD_ErrorCode(4)
#define SOMDERROR_BadVersion            SOMD_ErrorCode(5)
#define SOMDERROR_ParmSize              SOMD_ErrorCode(6)
#define SOMDERROR_HostName              SOMD_ErrorCode(7)
#define SOMDERROR_HostAddress           SOMD_ErrorCode(8)
#define SOMDERROR_SocketCreate          SOMD_ErrorCode(9)
#define SOMDERROR_SocketBind            SOMD_ErrorCode(10)
#define SOMDERROR_SocketName            SOMD_ErrorCode(11)
#define SOMDERROR_SocketReceive         SOMD_ErrorCode(12)
#define SOMDERROR_SocketSend            SOMD_ErrorCode(13)
#define SOMDERROR_SocketIoctl           SOMD_ErrorCode(14)
#define SOMDERROR_SocketSelect          SOMD_ErrorCode(15)
#define SOMDERROR_PacketSequence        SOMD_ErrorCode(16)
#define SOMDERROR_PacketTooBig          SOMD_ErrorCode(17)
#define SOMDERROR_AddressNotFound       SOMD_ErrorCode(18)
#define SOMDERROR_NoMessages            SOMD_ErrorCode(19)
#define SOMDERROR_UnknownAddress        SOMD_ErrorCode(20)
#define SOMDERROR_RecvError             SOMD_ErrorCode(21)
#define SOMDERROR_SendError             SOMD_ErrorCode(22)
#define SOMDERROR_CommTimeOut           SOMD_ErrorCode(23)
#define SOMDERROR_CannotConnect         SOMD_ErrorCode(24)
#define SOMDERROR_BadConnection         SOMD_ErrorCode(25)
#define SOMDERROR_NoHostName            SOMD_ErrorCode(26)
#define SOMDERROR_BadBinding            SOMD_ErrorCode(27)
#define SOMDERROR_BadMethodName         SOMD_ErrorCode(28)
#define SOMDERROR_BadEnvironment        SOMD_ErrorCode(29)
#define SOMDERROR_BadContext            SOMD_ErrorCode(30)
#define SOMDERROR_BadNVList             SOMD_ErrorCode(31)
#define SOMDERROR_BadFlag               SOMD_ErrorCode(32)
#define SOMDERROR_BadLength             SOMD_ErrorCode(33)
#define SOMDERROR_BadObjref             SOMD_ErrorCode(34)
#define SOMDERROR_NullField             SOMD_ErrorCode(35)
#define SOMDERROR_UnknownReposId        SOMD_ErrorCode(36)
#define SOMDERROR_NVListAccess          SOMD_ErrorCode(37)
#define SOMDERROR_NVIndexError          SOMD_ErrorCode(38)
#define SOMDERROR_SysTime               SOMD_ErrorCode(39)
#define SOMDERROR_SystemCallFailed      SOMD_ErrorCode(40)
#define SOMDERROR_CouldNotStartProcess  SOMD_ErrorCode(41)
#define SOMDERROR_NoServerClass         SOMD_ErrorCode(42)
#define SOMDERROR_NoSOMDInit            SOMD_ErrorCode(43)
#define SOMDERROR_SOMDDIRNotSet         SOMD_ErrorCode(44)
#define SOMDERROR_NoImplDatabase        SOMD_ErrorCode(45)
#define SOMDERROR_ImplNotFound          SOMD_ErrorCode(46)
#define SOMDERROR_ClassNotFound         SOMD_ErrorCode(47)
#define SOMDERROR_ServerNotFound        SOMD_ErrorCode(48)
#define SOMDERROR_ServerAlreadyExists   SOMD_ErrorCode(49)
#define SOMDERROR_ServerNotActive       SOMD_ErrorCode(50)
#define SOMDERROR_CouldNotStartSOM      SOMD_ErrorCode(51)
#define SOMDERROR_ObjectNotFound        SOMD_ErrorCode(52)
#define SOMDERROR_NoParentClass         SOMD_ErrorCode(53)
#define SOMDERROR_DispatchError         SOMD_ErrorCode(54)
#define SOMDERROR_BadTypeCode           SOMD_ErrorCode(55)
#define SOMDERROR_BadDescriptor         SOMD_ErrorCode(56)
#define SOMDERROR_BadResultType         SOMD_ErrorCode(57)
#define SOMDERROR_KeyInUse              SOMD_ErrorCode(58)
#define SOMDERROR_KeyNotFound           SOMD_ErrorCode(59)
#define SOMDERROR_CtxInvalidPropName    SOMD_ErrorCode(60)
#define SOMDERROR_CtxNoPropFound        SOMD_ErrorCode(61)
#define SOMDERROR_CtxStartScopeNotFound SOMD_ErrorCode(62)
#define SOMDERROR_CtxAccess             SOMD_ErrorCode(63)
#define SOMDERROR_CouldNotStartThread   SOMD_ErrorCode(64)
#define SOMDERROR_AccessDenied          SOMD_ErrorCode(65)
#define SOMDERROR_BadParm               SOMD_ErrorCode(66)
#define SOMDERROR_Interrupt             SOMD_ErrorCode(67)
#define SOMDERROR_Locked                SOMD_ErrorCode(68)
#define SOMDERROR_Pointer               SOMD_ErrorCode(69)
#define SOMDERROR_Boundary              SOMD_ErrorCode(70)
#define SOMDERROR_UnknownError          SOMD_ErrorCode(71)
#define SOMDERROR_NoSpace               SOMD_ErrorCode(72)
#define SOMDERROR_DuplicateQueue        SOMD_ErrorCode(73)
#define SOMDERROR_BadQueueName          SOMD_ErrorCode(74)
#define SOMDERROR_DuplicateSem          SOMD_ErrorCode(75)
#define SOMDERROR_BadSemName            SOMD_ErrorCode(76)
#define SOMDERROR_TooManyHandles        SOMD_ErrorCode(77)
#define SOMDERROR_BadAddrFamily         SOMD_ErrorCode(78)
#define SOMDERROR_BadFormat             SOMD_ErrorCode(79)
#define SOMDERROR_BadDrive              SOMD_ErrorCode(80)
#define SOMDERROR_SharingViolation      SOMD_ErrorCode(81)
#define SOMDERROR_BadExeSignature       SOMD_ErrorCode(82)
#define SOMDERROR_BadExe                SOMD_ErrorCode(83)
#define SOMDERROR_Busy                  SOMD_ErrorCode(84)
#define SOMDERROR_BadThread             SOMD_ErrorCode(85)
#define SOMDERROR_SOMDPORTNotDefined    SOMD_ErrorCode(86)
#define SOMDERROR_ResourceExists        SOMD_ErrorCode(87)
#define SOMDERROR_UserName          	SOMD_ErrorCode(88)
#define SOMDERROR_WrongRefType     	SOMD_ErrorCode(89)
#define SOMDERROR_MustOverride         	SOMD_ErrorCode(90)
#define SOMDERROR_NoSocketsClass        SOMD_ErrorCode(91)
#define SOMDERROR_EManRegData           SOMD_ErrorCode(92)
#define SOMDERROR_NoRemoteComm          SOMD_ErrorCode(93)
#define SOMDERROR_RequestNotFound       SOMD_ErrorCode(94)
#define SOMDERROR_SocketClose           SOMD_ErrorCode(95)
#define SOMDERROR_GlobalAtomError       SOMD_ErrorCode(96)
#define SOMDERROR_NamedMemoryTableError SOMD_ErrorCode(97)
#define SOMDERROR_WMQUIT                SOMD_ErrorCode(98)
#define SOMDERROR_AnchorNotFound        SOMD_ErrorCode(99)
#define SOMDERROR_NotQueueOwner         SOMD_ErrorCode(100)
#define SOMDERROR_QueueNotFound         SOMD_ErrorCode(101)
#define SOMDERROR_BadQueueHandle        SOMD_ErrorCode(102)
#define SOMDERROR_DuplicateImplEntry    SOMD_ErrorCode(103)

#endif /* somderr_h */
