/* @(#) somc/smcidl.h 2.3 1/19/94 16:56:14 [5/15/94 17:53:05] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 */

/*
 *         File:    smcidl.h.
 *     Contents:    Header file which contains special macros for
 *                  so that we can easily construct c and idl header
 *                  files and types.
 *
 *                  It can be include multiple times without damage!
 */

#undef _case
#undef _switch
#undef _struct
#undef _typedef
#undef _name

#ifdef __SOMIDL__
    /*
     * The _case and _switch macro are for IDL Unions.
     */
    #define _case(n)                       case n:
    #define _switch(t)                     switch(t)
    #define _struct                        /* Nothing */
    #define _typedef                       /* Nothing */
    #define _name(name)                    /* Nothing */
#else
    #define _case(n)                       /* Nothing */
    #define _switch(t)                     /* Nothing */
    #define _struct                        struct
    #define _typedef                       typedef
    #define _name(name)                    name
#endif
