/* @(#) somc/emitlib.pub 2.5 1/19/94 17:00:04 [5/15/94 17:53:12] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 */

/*
 *         File:    emitlib.h.
 *     Contents:    General routines used by Emitter Framework.
 */

#ifndef emitlib_h
#define emitlib_h

#ifndef SOMEXTERN
    #ifdef __cplusplus
	#define SOMEXTERN extern "C"
    #else
	#define SOMEXTERN extern
    #endif /* __cplusplus */
#endif /* SOMEXTERN */

#include <stdio.h>
#include <stdlib.h>
    /* #ifdef __OS2__ */
        /* #include <io.h> */
    /* #else */
        /* #include <unistd.h> */
    /* #endif */
#include <sm.h>

SOMEXTERN FILE *somtopenEmitFile(char *file, char *ext);
SOMEXTERN int somtfclose(FILE *fp);
SOMEXTERN void somterror(char *file, long lineno, char *fmt, ...);
SOMEXTERN void somtfatal(char *file, long lineno, char *fmt, ...);
SOMEXTERN void somtinternal(char *file, long lineno, char *fmt, ...);
SOMEXTERN void somtmsg(char *file, long lineno, char *fmt, ...);
SOMEXTERN void somtresetEmitSignals();
SOMEXTERN void somtunsetEmitSignals(void);
SOMEXTERN void somtwarn(char *file, long lineno, char *fmt, ...);

#endif
