/* @(#) somd/commsys.h 2.3 5/5/93 15:03:09 [6/4/93 21:50:10] */

/*
 * 96F8647, 96F8648 (C) Copyright IBM Corp. 1992, 1993
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 */


/*
 *  commsys.h - include file for comm component system-dependent functions
 */

#include <som.h>

#ifndef commsys_h
#define commsys_h

#define SOMD_SHMFREEMARK	0xff

/* prototypes */
ORBStatus somdAllocSharedMem(Environment *, long *, void **, long, char *);
ORBStatus somdFreeSharedMem(Environment *, long, void *);
ORBStatus somdFreeBuffer(Environment *, long, void *);
ORBStatus somdCreateQueue(Environment *, long, long *, long *, boolean);
ORBStatus somdCreateUniqueQueue(Environment *, long *, long *, long *);
ORBStatus somdReadQueue(Environment *, long, long *, void **, long, 
				long *, long *, long *);
ORBStatus somdWriteQueue(Environment *, long, long, long, 
		long, void *, long);
ORBStatus somdWaitForInput(Sockets *, Environment *, long *, long, long, long, 
		long, struct timeval *, long);
ORBStatus somdWaitForEventSem(long, struct timeval *, long *);
ORBStatus somdResetEventSem(long);
ORBStatus somdCreateEventSem(long *);
ORBStatus somdRemoteComm(Environment *, long *);
ORBStatus somdDeleteQueue(Environment *, long, long);
ORBStatus somdDeleteSharedMemPool(Environment *); 
long getThreadId(Environment *);

#ifdef _OS2
ORBStatus somdWaitMsgQEvents(Environment *, long, SOMEClientEvent *);
#endif /* _OS2 */

#endif /* commsys_h */
