/*  [REXX]  */
/* @(#) somc/newemit.cmd 2.6 1/19/94 16:51:49 [5/15/94 17:52:56] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 */

/*
 *  SOMObjects Emitter Framework - Create a new Emitter.
 */

parse arg argv;
argc = words(argv);

if argc < 2 then do;
    parse source . . progname ".CMD";
    say "usage:" progname "[-C | -C++] <className> <stem>";
    exit(-1);
end;

if word(argv, 1) = "-C" | word(argv, 1) = "-c" then do;
   targetlang = "C";
   class = word(argv, 2);
   stem  = word(argv, 3);
end;
else if word(argv, 1) = "-C++" | word(argv, 1) = "-c++" then do;
   targetlang = "C++";    
   class = word(argv, 2);
   stem  = word(argv, 3);
end;
else if argc > 2 then do;
    parse source . . progname ".CMD";
    say "usage:" progname "[-C | -C++] <className> <stem>";
    exit(-1);
end;
else do;
   targetlang = "C";
   class = word(argv, 1);
   stem  = word(argv, 2);
end;

s_idl = stem || ".idl";
if targetlang = "C" then
   s_c   = stem || ".c";
else
   s_c   = stem || ".cpp";
s_efw = stem || ".efw";
s_def = "emit" || stem || ".def";
if targetlang = "C" then
   emits_c = "emit" || stem || ".c";
else
   emits_c = "emit" || stem || ".cpp";
sc = value("sc",,"os2environment");
if sc = "" then sc = "sc";

call RxFuncAdd "SysSearchPath", "RexxUtil", "SysSearchPath";

"@del " || s_idl;
r = stream(s_idl, "c", "open");
r = lineout(s_idl, "interface" class "{};");
r = stream(s_idl, "c", "close");

say s_idl || ":";
efwfile = SysSearchPath("SMINCLUDE", "gen_idl.efw");
"@" || sc "-aemitfile=_" || s_idl "-adeffile=" || efwfile "-sgen" s_idl;
"@del " || s_idl;
"@ren _" || s_idl s_idl;

say s_c || ":";
if targetlang = "C" then
   efwfile = SysSearchPath("SMINCLUDE", "gen_c.efw");
else
   efwfile = SysSearchPath("SMINCLUDE", "gen_cpp.efw");
"@" || sc "-aemitfile=" || s_c "-adeffile=" || efwfile "-sgen" s_idl;

say "emit" || s_c || ":";
if targetlang = "C" then
   efwfile = SysSearchPath("SMINCLUDE", "gen_emit.efw");
else
   efwfile = SysSearchPath("SMINCLUDE", "gen_emit.efx");
"@" || sc "-aemitfile=" || emits_c "-adeffile=" || efwfile "-sgen" s_idl;

if stream("Makefile", "c", "query exists") <> "" then do;
    "@del Makefile.bak >nul 2>&1";
    "@ren Makefile Makefile.bak";
end;

say "Makefile:";
if targetlang = "C" then
   efwfile = SysSearchPath("SMINCLUDE", "gen_mk32.efw");
else
   efwfile = SysSearchPath("SMINCLUDE", "gen_mk32.efx");
"@" || sc "-aemitfile=Makefile -adeffile=" || efwfile "-sgen" s_idl;

say s_def || ":";
efwfile = SysSearchPath("SMINCLUDE", "gen_def.efw");
"@" || sc "-aemitfile=" || s_def "-adeffile=" || efwfile "-sgen" s_idl;

say s_efw || ":";
efwfile = SysSearchPath("SMINCLUDE", "gen_temp.efw");
"@copy" efwfile s_efw;
