/*+----------------------------------------------------------------------------

Microsoft Windows Sample Program
Copyright (C) 1994 - 1996 Microsoft Corporation.  All rights reserved.

FILE:       client.cxx

USAGE:      client 

PURPOSE:    OLE client application uses a custom interface to call the 
            server and print "Hello".

FUNCTIONS:  main() - Main entry point for the client application.

COMMENTS:   The server program must be installed before running the client.
            Run server.exe /REGSERVER to install the server program.

-----------------------------------------------------------------------------*/
#include <windows.h>
#include <stdio.h>
#include "ohello.h"     // generated by MIDL from ohello.idl

// the class ID of the server exe
const CLSID CLSID_OHello = 
    {0xf9246031,0x9f33,0x11cd,{0xb2,0x3f,0x00,0xaa,0x00,0x33,0x9c,0xce}};

void PrintErrorMessage(HRESULT hr);

//+---------------------------------------------------------------------------
//
//  Function:   main
//
//  Synopsis:   Main entry point for the client application.  First we 
//              call CoCreateInstance to create an instance of the server
//              object.  Next, we use the IHello custom interface to 
//              call the server object and print "Hello".  After waiting
//              5 seconds, we call the server object to print "Goodbye".
//              Finally, we release the IHello interface pointer and
//              terminate.
//
//----------------------------------------------------------------------------
void __cdecl main(int argc, char *argv[])
{
    HRESULT hr;
    IHello *pHello = 0;
    IClassFactory *pClassFactory;

    hr = CoInitialize(NULL);

    if(SUCCEEDED(hr))
    {
        hr = CoCreateInstance(CLSID_OHello, 0, CLSCTX_LOCAL_SERVER, IID_IHello, (void **) &pHello);
        if(SUCCEEDED(hr))
        {
            hr = pHello->HelloProc((unsigned char *) "Hello");

            if(SUCCEEDED(hr))
            {
                printf("Successfully printed Hello.\n");
            }
            else
            {
                printf("IHello::HelloProc failed.\n");
                PrintErrorMessage(hr);
            }

            printf(" <pausing for 5 sec>\n");
            Sleep( 5000 ); // 5000 msec = 5 sec

            hr = pHello->HelloProc((unsigned char *) "Goodbye");

            if(SUCCEEDED(hr))
            {
                printf("Successfully printed Goodbye.\n");
            }
            else
            {
                printf("IHello::HelloProc failed.\n");
                PrintErrorMessage(hr);
            }

            pHello->Release();
        }
        else
        {
            printf("CoCreateInstance failed.\n");
            PrintErrorMessage(hr);

            if(hr == REGDB_E_CLASSNOTREG)
                printf("Run server.exe /REGSERVER to install the server program.\n");
        }

        CoUninitialize();
    }
    else
    {
        printf("CoInitialize failed.\n");
        PrintErrorMessage(hr);
    }   
}


