/*************************************************************************
**
**    HRESULT Decoder
**
**    decode.cpp
**
**
**     Written by Microsoft Product Support Services, Windows Developer Support
**    (c) Copyright Microsoft Corp. 1996 All Rights Reserved
**
*************************************************************************/

#include <windows.h>    
#include <stdio.h> 
#include <olectl.h>
#include "decode.h"          


int APIENTRY WinMain (HINSTANCE hinst, HINSTANCE hinstPrev, LPSTR lpCmdLine, int nCmdShow)
{
   WNDCLASS wc;

   wc.style = 0;
   wc.lpfnWndProc = DefDlgProc;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = DLGWINDOWEXTRA;
   wc.hInstance = hinst;
   wc.hIcon = LoadIcon(hinst, TEXT("AppIcon"));
   wc.hCursor = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = HBRUSH(COLOR_WINDOW + 1);
   wc.lpszMenuName = NULL;
   wc.lpszClassName = TEXT("DlgClass");
   RegisterClass(&wc);
   
   DialogBox(hinst, MAKEINTRESOURCE(IDD_HRESULTDIALOG), NULL, (DLGPROC)HResultDialogFunc);
   
   return 0;
}


BOOL CALLBACK HResultDialogFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
   TCHAR ach[30];
   long l;
   BOOL bOleError;

   
   switch (msg)
   {
	  case WM_INITDIALOG:
          CheckDlgButton(hwndDlg, IDC_OLEERROR, 1);
		  return TRUE;

      case WM_COMMAND:
         switch(LOWORD(wParam))
         {
             case IDC_DECODE:
                 GetDlgItemText(hwndDlg, IDC_EDIT, ach, 30);
				 bOleError = IsDlgButtonChecked(hwndDlg, IDC_OLEERROR);
				 if (bOleError)
				     sscanf(ach, "%lx", &l);    
				 else 
				 {
					 sscanf(ach, "%ld", &l);
                     l = MAKE_HRESULT(0x1, FACILITY_WIN32, l);
				 }

                 DecodeHResult((HRESULT)l,
                             GetDlgItem(hwndDlg, IDC_ERRORNAME),
                             GetDlgItem(hwndDlg, IDC_ERRORDESC),
							 bOleError);
                 return TRUE;
             
             case IDOK:    
             case IDCANCEL:
                 EndDialog(hwndDlg, IDCANCEL);
                 return TRUE;                                                                    
         }
         break;
   }
   return FALSE;
}

#define CASE_FACILITY(f)  \
        case f: \
            lstrcpy((LPTSTR)szFacility, (LPTSTR)#f); \
            break;

#define CASE_HRESULT(hr)  \
        case hr: \
            lstrcpy((LPTSTR)szErrorName, (LPTSTR)#hr); \
            FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, hr, \
                MAKELANGID(LANG_NEUTRAL, SUBLANG_NEUTRAL), \
                szErrorDesc, sizeof(szErrorDesc), NULL);\
            break;

#define CASE_CODE(c) \
        case c: \
            lstrcpy((LPTSTR)szErrorName, (LPTSTR)#c); \
            FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, hr, \
                MAKELANGID(LANG_NEUTRAL, SUBLANG_NEUTRAL), \
                szErrorDesc, sizeof(szErrorDesc), NULL);\
            break; 
                      
void DecodeHResult(HRESULT hr, HWND hwndDisplayErrorName, HWND hwndDisplayErrorDesc, BOOL bOleError)
{
    TCHAR szBuf[200];
    TCHAR szFacility[100];
    TCHAR szErrorName[100];
    TCHAR szErrorDesc[400];
    
    lstrcpy(szErrorDesc, TEXT(""));
    
    switch (HRESULT_FACILITY(hr))
    {
        CASE_FACILITY(FACILITY_WINDOWS)
        CASE_FACILITY(FACILITY_STORAGE)
        CASE_FACILITY(FACILITY_RPC)
        CASE_FACILITY(FACILITY_SSPI)
        CASE_FACILITY(FACILITY_WIN32)
        CASE_FACILITY(FACILITY_CONTROL)
        CASE_FACILITY(FACILITY_NULL)
		CASE_FACILITY(FACILITY_INTERNET)
        CASE_FACILITY(FACILITY_ITF)
        CASE_FACILITY(FACILITY_DISPATCH)
        CASE_FACILITY(FACILITY_CERT)

        default:
            lstrcpy(szFacility, TEXT("Unknown or new FACILITY code"));                
    }
    
    switch (hr) 
    {  
        CASE_HRESULT(E_UNEXPECTED)
        CASE_HRESULT(E_NOTIMPL)
        CASE_HRESULT(E_OUTOFMEMORY)
        CASE_HRESULT(E_INVALIDARG)
        CASE_HRESULT(E_NOINTERFACE)
        CASE_HRESULT(E_POINTER)
        CASE_HRESULT(E_HANDLE)
        CASE_HRESULT(E_ABORT)
        CASE_HRESULT(E_FAIL)
        CASE_HRESULT(E_ACCESSDENIED)
        CASE_HRESULT(E_PENDING)
        CASE_HRESULT(CO_E_INIT_TLS)
        CASE_HRESULT(CO_E_INIT_SHARED_ALLOCATOR)
        CASE_HRESULT(CO_E_INIT_MEMORY_ALLOCATOR)
        CASE_HRESULT(CO_E_INIT_CLASS_CACHE)
        CASE_HRESULT(CO_E_INIT_RPC_CHANNEL)
        CASE_HRESULT(CO_E_INIT_TLS_SET_CHANNEL_CONTROL)
        CASE_HRESULT(CO_E_INIT_TLS_CHANNEL_CONTROL)
        CASE_HRESULT(CO_E_INIT_UNACCEPTED_USER_ALLOCATOR)
        CASE_HRESULT(CO_E_INIT_SCM_MUTEX_EXISTS)
        CASE_HRESULT(CO_E_INIT_SCM_FILE_MAPPING_EXISTS)
        CASE_HRESULT(CO_E_INIT_SCM_MAP_VIEW_OF_FILE)
        CASE_HRESULT(CO_E_INIT_SCM_EXEC_FAILURE)
        CASE_HRESULT(CO_E_INIT_ONLY_SINGLE_THREADED)
        CASE_HRESULT(CO_E_CANT_REMOTE)
        CASE_HRESULT(CO_E_BAD_SERVER_NAME)
        CASE_HRESULT(CO_E_WRONG_SERVER_IDENTITY)
        CASE_HRESULT(CO_E_OLE1DDE_DISABLED)
        CASE_HRESULT(CO_E_RUNAS_SYNTAX)
        CASE_HRESULT(CO_E_CREATEPROCESS_FAILURE)
        CASE_HRESULT(CO_E_RUNAS_CREATEPROCESS_FAILURE)
        CASE_HRESULT(CO_E_RUNAS_LOGON_FAILURE)
        CASE_HRESULT(CO_E_LAUNCH_PERMSSION_DENIED)
        CASE_HRESULT(CO_E_START_SERVICE_FAILURE)
        CASE_HRESULT(CO_E_REMOTE_COMMUNICATION_FAILURE)
        CASE_HRESULT(CO_E_SERVER_START_TIMEOUT)
        CASE_HRESULT(CO_E_CLSREG_INCONSISTENT)
        CASE_HRESULT(CO_E_IIDREG_INCONSISTENT)
        CASE_HRESULT(CO_E_NOT_SUPPORTED)
        CASE_HRESULT(S_OK)
        CASE_HRESULT(S_FALSE)
        CASE_HRESULT(OLE_E_OLEVERB)
        CASE_HRESULT(OLE_E_ADVF)
        CASE_HRESULT(OLE_E_ENUM_NOMORE)
        CASE_HRESULT(OLE_E_ADVISENOTSUPPORTED)
        CASE_HRESULT(OLE_E_NOCONNECTION)
        CASE_HRESULT(OLE_E_NOTRUNNING)
        CASE_HRESULT(OLE_E_NOCACHE)
        CASE_HRESULT(OLE_E_BLANK)
        CASE_HRESULT(OLE_E_CLASSDIFF)
        CASE_HRESULT(OLE_E_CANT_GETMONIKER)
        CASE_HRESULT(OLE_E_CANT_BINDTOSOURCE)
        CASE_HRESULT(OLE_E_STATIC)
        CASE_HRESULT(OLE_E_PROMPTSAVECANCELLED)
        CASE_HRESULT(OLE_E_INVALIDRECT)
        CASE_HRESULT(OLE_E_WRONGCOMPOBJ)
        CASE_HRESULT(OLE_E_INVALIDHWND)
        CASE_HRESULT(OLE_E_NOT_INPLACEACTIVE)
        CASE_HRESULT(OLE_E_CANTCONVERT)
        CASE_HRESULT(OLE_E_NOSTORAGE)
        CASE_HRESULT(DV_E_FORMATETC)
        CASE_HRESULT(DV_E_DVTARGETDEVICE)
        CASE_HRESULT(DV_E_STGMEDIUM)
        CASE_HRESULT(DV_E_STATDATA)
        CASE_HRESULT(DV_E_LINDEX)
        CASE_HRESULT(DV_E_TYMED)
        CASE_HRESULT(DV_E_CLIPFORMAT)
        CASE_HRESULT(DV_E_DVASPECT)
        CASE_HRESULT(DV_E_DVTARGETDEVICE_SIZE)
        CASE_HRESULT(DV_E_NOIVIEWOBJECT)
        CASE_HRESULT(DRAGDROP_E_NOTREGISTERED)
        CASE_HRESULT(DRAGDROP_E_ALREADYREGISTERED)
        CASE_HRESULT(DRAGDROP_E_INVALIDHWND)
        CASE_HRESULT(CLASS_E_NOAGGREGATION)
        CASE_HRESULT(CLASS_E_CLASSNOTAVAILABLE)
        CASE_HRESULT(VIEW_E_DRAW)
        CASE_HRESULT(REGDB_E_READREGDB)
        CASE_HRESULT(REGDB_E_WRITEREGDB)
        CASE_HRESULT(REGDB_E_KEYMISSING)
        CASE_HRESULT(REGDB_E_INVALIDVALUE)
        CASE_HRESULT(REGDB_E_CLASSNOTREG)
        CASE_HRESULT(REGDB_E_IIDNOTREG)
        CASE_HRESULT(CACHE_E_NOCACHE_UPDATED)
        CASE_HRESULT(OLEOBJ_E_NOVERBS)
        CASE_HRESULT(OLEOBJ_E_INVALIDVERB)
        CASE_HRESULT(INPLACE_E_NOTUNDOABLE)
        CASE_HRESULT(INPLACE_E_NOTOOLSPACE)
        CASE_HRESULT(CONVERT10_E_OLESTREAM_GET)
        CASE_HRESULT(CONVERT10_E_OLESTREAM_PUT)
        CASE_HRESULT(CONVERT10_E_OLESTREAM_FMT)
        CASE_HRESULT(CONVERT10_E_OLESTREAM_BITMAP_TO_DIB)
        CASE_HRESULT(CONVERT10_E_STG_FMT)
        CASE_HRESULT(CONVERT10_E_STG_NO_STD_STREAM)
        CASE_HRESULT(CONVERT10_E_STG_DIB_TO_BITMAP)
        CASE_HRESULT(CLIPBRD_E_CANT_OPEN)
        CASE_HRESULT(CLIPBRD_E_CANT_EMPTY)
        CASE_HRESULT(CLIPBRD_E_CANT_SET)
        CASE_HRESULT(CLIPBRD_E_BAD_DATA)
        CASE_HRESULT(CLIPBRD_E_CANT_CLOSE)
        CASE_HRESULT(MK_E_CONNECTMANUALLY)
        CASE_HRESULT(MK_E_EXCEEDEDDEADLINE)
        CASE_HRESULT(MK_E_NEEDGENERIC)
        CASE_HRESULT(MK_E_UNAVAILABLE)
        CASE_HRESULT(MK_E_SYNTAX)
        CASE_HRESULT(MK_E_NOOBJECT)
        CASE_HRESULT(MK_E_INVALIDEXTENSION)
        CASE_HRESULT(MK_E_INTERMEDIATEINTERFACENOTSUPPORTED)
        CASE_HRESULT(MK_E_NOTBINDABLE)
        CASE_HRESULT(MK_E_NOTBOUND)
        CASE_HRESULT(MK_E_CANTOPENFILE)
        CASE_HRESULT(MK_E_MUSTBOTHERUSER)
        CASE_HRESULT(MK_E_NOINVERSE)
        CASE_HRESULT(MK_E_NOSTORAGE)
        CASE_HRESULT(MK_E_NOPREFIX)
        CASE_HRESULT(MK_E_ENUMERATION_FAILED)
        CASE_HRESULT(CO_E_NOTINITIALIZED)
        CASE_HRESULT(CO_E_ALREADYINITIALIZED)
        CASE_HRESULT(CO_E_CANTDETERMINECLASS)
        CASE_HRESULT(CO_E_CLASSSTRING)
        CASE_HRESULT(CO_E_IIDSTRING)
        CASE_HRESULT(CO_E_APPNOTFOUND)
        CASE_HRESULT(CO_E_APPSINGLEUSE)
        CASE_HRESULT(CO_E_ERRORINAPP)
        CASE_HRESULT(CO_E_DLLNOTFOUND)
        CASE_HRESULT(CO_E_ERRORINDLL)
        CASE_HRESULT(CO_E_WRONGOSFORAPP)
        CASE_HRESULT(CO_E_OBJNOTREG)
        CASE_HRESULT(CO_E_OBJISREG)
        CASE_HRESULT(CO_E_OBJNOTCONNECTED)
        CASE_HRESULT(CO_E_APPDIDNTREG)
        CASE_HRESULT(CO_E_RELEASED)
        CASE_HRESULT(OLE_S_USEREG)
        CASE_HRESULT(OLE_S_STATIC)
        CASE_HRESULT(OLE_S_MAC_CLIPFORMAT)
        CASE_HRESULT(DRAGDROP_S_DROP)
        CASE_HRESULT(DRAGDROP_S_CANCEL)
        CASE_HRESULT(DRAGDROP_S_USEDEFAULTCURSORS)
        CASE_HRESULT(DATA_S_SAMEFORMATETC)
        CASE_HRESULT(VIEW_S_ALREADY_FROZEN)
        CASE_HRESULT(CACHE_S_FORMATETC_NOTSUPPORTED)
        CASE_HRESULT(CACHE_S_SAMECACHE)
        CASE_HRESULT(CACHE_S_SOMECACHES_NOTUPDATED)
        CASE_HRESULT(OLEOBJ_S_INVALIDVERB)
        CASE_HRESULT(OLEOBJ_S_CANNOT_DOVERB_NOW)
        CASE_HRESULT(OLEOBJ_S_INVALIDHWND)
        CASE_HRESULT(INPLACE_S_TRUNCATED)
        CASE_HRESULT(CONVERT10_S_NO_PRESENTATION)
        CASE_HRESULT(MK_S_REDUCED_TO_SELF)
        CASE_HRESULT(MK_S_ME)
        CASE_HRESULT(MK_S_HIM)
        CASE_HRESULT(MK_S_US)
        CASE_HRESULT(MK_S_MONIKERALREADYREGISTERED)
        CASE_HRESULT(CO_E_CLASS_CREATE_FAILED)
        CASE_HRESULT(CO_E_SCM_ERROR)
        CASE_HRESULT(CO_E_SCM_RPC_FAILURE)
        CASE_HRESULT(CO_E_BAD_PATH)
        CASE_HRESULT(CO_E_SERVER_EXEC_FAILURE)
        CASE_HRESULT(CO_E_OBJSRV_RPC_FAILURE)
        CASE_HRESULT(MK_E_NO_NORMALIZED)
        CASE_HRESULT(CO_E_SERVER_STOPPING)
        CASE_HRESULT(MEM_E_INVALID_ROOT)
        CASE_HRESULT(MEM_E_INVALID_LINK)
        CASE_HRESULT(MEM_E_INVALID_SIZE)
        CASE_HRESULT(CO_S_NOTALLINTERFACES)
        CASE_HRESULT(DISP_E_UNKNOWNINTERFACE)
        CASE_HRESULT(DISP_E_MEMBERNOTFOUND)
        CASE_HRESULT(DISP_E_PARAMNOTFOUND)
        CASE_HRESULT(DISP_E_TYPEMISMATCH)
        CASE_HRESULT(DISP_E_UNKNOWNNAME)
        CASE_HRESULT(DISP_E_NONAMEDARGS)
        CASE_HRESULT(DISP_E_BADVARTYPE)
        CASE_HRESULT(DISP_E_EXCEPTION)
        CASE_HRESULT(DISP_E_OVERFLOW)
        CASE_HRESULT(DISP_E_BADINDEX)
        CASE_HRESULT(DISP_E_UNKNOWNLCID)
        CASE_HRESULT(DISP_E_ARRAYISLOCKED)
        CASE_HRESULT(DISP_E_BADPARAMCOUNT)
        CASE_HRESULT(DISP_E_PARAMNOTOPTIONAL)
        CASE_HRESULT(DISP_E_BADCALLEE)
        CASE_HRESULT(DISP_E_NOTACOLLECTION)
        CASE_HRESULT(TYPE_E_BUFFERTOOSMALL)
        CASE_HRESULT(TYPE_E_INVDATAREAD)
        CASE_HRESULT(TYPE_E_UNSUPFORMAT)
        CASE_HRESULT(TYPE_E_REGISTRYACCESS)
        CASE_HRESULT(TYPE_E_LIBNOTREGISTERED)
        CASE_HRESULT(TYPE_E_UNDEFINEDTYPE)
        CASE_HRESULT(TYPE_E_QUALIFIEDNAMEDISALLOWED)
        CASE_HRESULT(TYPE_E_INVALIDSTATE)
        CASE_HRESULT(TYPE_E_WRONGTYPEKIND)
        CASE_HRESULT(TYPE_E_ELEMENTNOTFOUND)
        CASE_HRESULT(TYPE_E_AMBIGUOUSNAME)
        CASE_HRESULT(TYPE_E_NAMECONFLICT)
        CASE_HRESULT(TYPE_E_UNKNOWNLCID)
        CASE_HRESULT(TYPE_E_DLLFUNCTIONNOTFOUND)
        CASE_HRESULT(TYPE_E_BADMODULEKIND)
        CASE_HRESULT(TYPE_E_SIZETOOBIG)
        CASE_HRESULT(TYPE_E_DUPLICATEID)
        CASE_HRESULT(TYPE_E_INVALIDID)
        CASE_HRESULT(TYPE_E_TYPEMISMATCH)
        CASE_HRESULT(TYPE_E_OUTOFBOUNDS)
        CASE_HRESULT(TYPE_E_IOERROR)
        CASE_HRESULT(TYPE_E_CANTCREATETMPFILE)
        CASE_HRESULT(TYPE_E_CANTLOADLIBRARY)
        CASE_HRESULT(TYPE_E_INCONSISTENTPROPFUNCS)
        CASE_HRESULT(TYPE_E_CIRCULARTYPE)
        CASE_HRESULT(STG_E_INVALIDFUNCTION)
        CASE_HRESULT(STG_E_FILENOTFOUND)
        CASE_HRESULT(STG_E_PATHNOTFOUND)
        CASE_HRESULT(STG_E_TOOMANYOPENFILES)
        CASE_HRESULT(STG_E_ACCESSDENIED)
        CASE_HRESULT(STG_E_INVALIDHANDLE)
        CASE_HRESULT(STG_E_INSUFFICIENTMEMORY)
        CASE_HRESULT(STG_E_INVALIDPOINTER)
        CASE_HRESULT(STG_E_NOMOREFILES)
        CASE_HRESULT(STG_E_DISKISWRITEPROTECTED)
        CASE_HRESULT(STG_E_SEEKERROR)
        CASE_HRESULT(STG_E_WRITEFAULT)
        CASE_HRESULT(STG_E_READFAULT)
        CASE_HRESULT(STG_E_SHAREVIOLATION)
        CASE_HRESULT(STG_E_LOCKVIOLATION)
        CASE_HRESULT(STG_E_FILEALREADYEXISTS)
        CASE_HRESULT(STG_E_INVALIDPARAMETER)
        CASE_HRESULT(STG_E_MEDIUMFULL)
        CASE_HRESULT(STG_E_PROPSETMISMATCHED)
        CASE_HRESULT(STG_E_ABNORMALAPIEXIT)
        CASE_HRESULT(STG_E_INVALIDHEADER)
        CASE_HRESULT(STG_E_INVALIDNAME)
        CASE_HRESULT(STG_E_UNKNOWN)
        CASE_HRESULT(STG_E_UNIMPLEMENTEDFUNCTION)
        CASE_HRESULT(STG_E_INVALIDFLAG)
        CASE_HRESULT(STG_E_INUSE)
        CASE_HRESULT(STG_E_NOTCURRENT)
        CASE_HRESULT(STG_E_REVERTED)
        CASE_HRESULT(STG_E_CANTSAVE)
        CASE_HRESULT(STG_E_OLDFORMAT)
        CASE_HRESULT(STG_E_OLDDLL)
        CASE_HRESULT(STG_E_SHAREREQUIRED)
        CASE_HRESULT(STG_E_NOTFILEBASEDSTORAGE)
        CASE_HRESULT(STG_E_EXTANTMARSHALLINGS)
        CASE_HRESULT(STG_E_DOCFILECORRUPT)
        CASE_HRESULT(STG_E_BADBASEADDRESS)
        CASE_HRESULT(STG_E_INCOMPLETE)
        CASE_HRESULT(STG_E_TERMINATED)
        CASE_HRESULT(STG_S_CONVERTED)
        CASE_HRESULT(STG_S_BLOCK)
        CASE_HRESULT(STG_S_RETRYNOW)
        CASE_HRESULT(STG_S_MONITORING)
        CASE_HRESULT(RPC_E_CALL_REJECTED)
        CASE_HRESULT(RPC_E_CALL_CANCELED)
        CASE_HRESULT(RPC_E_CANTPOST_INSENDCALL)
        CASE_HRESULT(RPC_E_CANTCALLOUT_INASYNCCALL)
        CASE_HRESULT(RPC_E_CANTCALLOUT_INEXTERNALCALL)
        CASE_HRESULT(RPC_E_CONNECTION_TERMINATED)
        CASE_HRESULT(RPC_E_SERVER_DIED)
        CASE_HRESULT(RPC_E_CLIENT_DIED)
        CASE_HRESULT(RPC_E_INVALID_DATAPACKET)
        CASE_HRESULT(RPC_E_CANTTRANSMIT_CALL)
        CASE_HRESULT(RPC_E_CLIENT_CANTMARSHAL_DATA)
        CASE_HRESULT(RPC_E_CLIENT_CANTUNMARSHAL_DATA)
        CASE_HRESULT(RPC_E_SERVER_CANTMARSHAL_DATA)
        CASE_HRESULT(RPC_E_SERVER_CANTUNMARSHAL_DATA)
        CASE_HRESULT(RPC_E_INVALID_DATA)
        CASE_HRESULT(RPC_E_INVALID_PARAMETER)
        CASE_HRESULT(RPC_E_CANTCALLOUT_AGAIN)
        CASE_HRESULT(RPC_E_SERVER_DIED_DNE)
        CASE_HRESULT(RPC_E_SYS_CALL_FAILED)
        CASE_HRESULT(RPC_E_OUT_OF_RESOURCES)
        CASE_HRESULT(RPC_E_ATTEMPTED_MULTITHREAD)
        CASE_HRESULT(RPC_E_NOT_REGISTERED)
        CASE_HRESULT(RPC_E_FAULT)
        CASE_HRESULT(RPC_E_SERVERFAULT)
        CASE_HRESULT(RPC_E_CHANGED_MODE)
        CASE_HRESULT(RPC_E_INVALIDMETHOD)
        CASE_HRESULT(RPC_E_DISCONNECTED)
        CASE_HRESULT(RPC_E_RETRY)
        CASE_HRESULT(RPC_E_SERVERCALL_RETRYLATER)
        CASE_HRESULT(RPC_E_SERVERCALL_REJECTED)
        CASE_HRESULT(RPC_E_INVALID_CALLDATA)
        CASE_HRESULT(RPC_E_CANTCALLOUT_ININPUTSYNCCALL)
        CASE_HRESULT(RPC_E_WRONG_THREAD)
        CASE_HRESULT(RPC_E_THREAD_NOT_INIT)
        CASE_HRESULT(RPC_E_VERSION_MISMATCH)
        CASE_HRESULT(RPC_E_INVALID_HEADER)
        CASE_HRESULT(RPC_E_INVALID_EXTENSION)
        CASE_HRESULT(RPC_E_INVALID_IPID)
        CASE_HRESULT(RPC_E_INVALID_OBJECT)
        CASE_HRESULT(RPC_S_CALLPENDING)
        CASE_HRESULT(RPC_S_WAITONTIMER)
        CASE_HRESULT(RPC_E_CALL_COMPLETE)
        CASE_HRESULT(RPC_E_UNSECURE_CALL)
        CASE_HRESULT(RPC_E_TOO_LATE)
        CASE_HRESULT(RPC_E_NO_GOOD_SECURITY_PACKAGES)
        CASE_HRESULT(RPC_E_ACCESS_DENIED)
        CASE_HRESULT(RPC_E_REMOTE_DISABLED)
        CASE_HRESULT(RPC_E_INVALID_OBJREF)
        CASE_HRESULT(RPC_E_UNEXPECTED)
        CASE_HRESULT(NTE_BAD_UID)
        CASE_HRESULT(NTE_BAD_HASH)
        CASE_HRESULT(NTE_BAD_KEY)
        CASE_HRESULT(NTE_BAD_LEN)
        CASE_HRESULT(NTE_BAD_DATA)
        CASE_HRESULT(NTE_BAD_SIGNATURE)
        CASE_HRESULT(NTE_BAD_VER)
        CASE_HRESULT(NTE_BAD_ALGID)
        CASE_HRESULT(NTE_BAD_FLAGS)
        CASE_HRESULT(NTE_BAD_TYPE)
        CASE_HRESULT(NTE_BAD_KEY_STATE)
        CASE_HRESULT(NTE_BAD_HASH_STATE)
        CASE_HRESULT(NTE_NO_KEY)
        CASE_HRESULT(NTE_NO_MEMORY)
        CASE_HRESULT(NTE_EXISTS)
        CASE_HRESULT(NTE_PERM)
        CASE_HRESULT(NTE_NOT_FOUND)
        CASE_HRESULT(NTE_DOUBLE_ENCRYPT)
        CASE_HRESULT(NTE_BAD_PROVIDER)
        CASE_HRESULT(NTE_BAD_PROV_TYPE)
        CASE_HRESULT(NTE_BAD_PUBLIC_KEY)
        CASE_HRESULT(NTE_BAD_KEYSET)
        CASE_HRESULT(NTE_PROV_TYPE_NOT_DEF)
        CASE_HRESULT(NTE_PROV_TYPE_ENTRY_BAD)
        CASE_HRESULT(NTE_KEYSET_NOT_DEF)
        CASE_HRESULT(NTE_KEYSET_ENTRY_BAD)
        CASE_HRESULT(NTE_PROV_TYPE_NO_MATCH)
        CASE_HRESULT(NTE_SIGNATURE_FILE_BAD)
        CASE_HRESULT(NTE_PROVIDER_DLL_FAIL)
        CASE_HRESULT(NTE_PROV_DLL_NOT_FOUND)
        CASE_HRESULT(NTE_BAD_KEYSET_PARAM)
        CASE_HRESULT(NTE_FAIL)
        CASE_HRESULT(NTE_SYS_ERR)
        CASE_HRESULT(TRUST_E_PROVIDER_UNKNOWN)
        CASE_HRESULT(TRUST_E_ACTION_UNKNOWN)
        CASE_HRESULT(TRUST_E_SUBJECT_FORM_UNKNOWN)
        CASE_HRESULT(TRUST_E_SUBJECT_NOT_TRUSTED)
        CASE_HRESULT(DIGSIG_E_ENCODE)
        CASE_HRESULT(DIGSIG_E_DECODE)
        CASE_HRESULT(DIGSIG_E_EXTENSIBILITY)
        CASE_HRESULT(DIGSIG_E_CRYPTO)
        CASE_HRESULT(PERSIST_E_SIZEDEFINITE)
        CASE_HRESULT(PERSIST_E_SIZEINDEFINITE)
        CASE_HRESULT(PERSIST_E_NOTSELFSIZING)
        CASE_HRESULT(TRUST_E_NOSIGNATURE)
        CASE_HRESULT(CERT_E_EXPIRED)
        CASE_HRESULT(CERT_E_VALIDIYPERIODNESTING)
        CASE_HRESULT(CERT_E_ROLE)
        CASE_HRESULT(CERT_E_PATHLENCONST)
        CASE_HRESULT(CERT_E_CRITICAL)
        CASE_HRESULT(CERT_E_PURPOSE)
        CASE_HRESULT(CERT_E_ISSUERCHAINING)
        CASE_HRESULT(CERT_E_MALFORMED)
        CASE_HRESULT(CERT_E_UNTRUSTEDROOT)
        CASE_HRESULT(CERT_E_CHAINING)
                
        // OLE controls         
        CASE_HRESULT(CTL_E_ILLEGALFUNCTIONCALL)
        CASE_HRESULT(CTL_E_OVERFLOW)
        CASE_HRESULT(CTL_E_OUTOFMEMORY)
        CASE_HRESULT(CTL_E_DIVISIONBYZERO)
        CASE_HRESULT(CTL_E_OUTOFSTRINGSPACE)
        CASE_HRESULT(CTL_E_OUTOFSTACKSPACE)
        CASE_HRESULT(CTL_E_BADFILENAMEORNUMBER)
        CASE_HRESULT(CTL_E_FILENOTFOUND)
        CASE_HRESULT(CTL_E_BADFILEMODE)
        CASE_HRESULT(CTL_E_FILEALREADYOPEN)
        CASE_HRESULT(CTL_E_DEVICEIOERROR)
        CASE_HRESULT(CTL_E_FILEALREADYEXISTS)
        CASE_HRESULT(CTL_E_BADRECORDLENGTH)
        CASE_HRESULT(CTL_E_DISKFULL)
        CASE_HRESULT(CTL_E_BADRECORDNUMBER)
        CASE_HRESULT(CTL_E_BADFILENAME)
        CASE_HRESULT(CTL_E_TOOMANYFILES)
        CASE_HRESULT(CTL_E_DEVICEUNAVAILABLE)
        CASE_HRESULT(CTL_E_PERMISSIONDENIED)
        CASE_HRESULT(CTL_E_DISKNOTREADY)
        CASE_HRESULT(CTL_E_PATHFILEACCESSERROR)
        CASE_HRESULT(CTL_E_PATHNOTFOUND)
        CASE_HRESULT(CTL_E_INVALIDPATTERNSTRING)
        CASE_HRESULT(CTL_E_INVALIDUSEOFNULL)
        CASE_HRESULT(CTL_E_INVALIDFILEFORMAT)
        CASE_HRESULT(CTL_E_INVALIDPROPERTYVALUE)
        CASE_HRESULT(CTL_E_INVALIDPROPERTYARRAYINDEX)
        CASE_HRESULT(CTL_E_SETNOTSUPPORTEDATRUNTIME)
        CASE_HRESULT(CTL_E_SETNOTSUPPORTED)
        CASE_HRESULT(CTL_E_NEEDPROPERTYARRAYINDEX)
        CASE_HRESULT(CTL_E_SETNOTPERMITTED)
        CASE_HRESULT(CTL_E_GETNOTSUPPORTEDATRUNTIME)
        CASE_HRESULT(CTL_E_GETNOTSUPPORTED)
        CASE_HRESULT(CTL_E_PROPERTYNOTFOUND)
        CASE_HRESULT(CTL_E_INVALIDCLIPBOARDFORMAT)
        CASE_HRESULT(CTL_E_INVALIDPICTURE)
        CASE_HRESULT(CTL_E_PRINTERERROR)
        CASE_HRESULT(CTL_E_CANTSAVEFILETOTEMP)
        CASE_HRESULT(CTL_E_SEARCHTEXTNOTFOUND)
        CASE_HRESULT(CTL_E_REPLACEMENTSTOOLONG)
        CASE_HRESULT(CLASS_E_NOTLICENSED)

        default:
                        // Check if the HRESULT has FACILITY_WIN32. If so,
                        // extract the code and check against the codes in winerror.h
            if (HRESULT_FACILITY(hr) == FACILITY_WIN32)
            {
                switch (HRESULT_CODE(hr)) 
                {
                CASE_CODE(ERROR_SUCCESS)
                CASE_CODE(ERROR_INVALID_FUNCTION)
                CASE_CODE(ERROR_FILE_NOT_FOUND)
                CASE_CODE(ERROR_PATH_NOT_FOUND)
                CASE_CODE(ERROR_TOO_MANY_OPEN_FILES)
                CASE_CODE(ERROR_ACCESS_DENIED)
                CASE_CODE(ERROR_INVALID_HANDLE)
                CASE_CODE(ERROR_ARENA_TRASHED)
                CASE_CODE(ERROR_NOT_ENOUGH_MEMORY)
                CASE_CODE(ERROR_INVALID_BLOCK)
                CASE_CODE(ERROR_BAD_ENVIRONMENT)
                CASE_CODE(ERROR_BAD_FORMAT)
                CASE_CODE(ERROR_INVALID_ACCESS)
                CASE_CODE(ERROR_INVALID_DATA)
                CASE_CODE(ERROR_OUTOFMEMORY)
                CASE_CODE(ERROR_INVALID_DRIVE)
                CASE_CODE(ERROR_CURRENT_DIRECTORY)
                CASE_CODE(ERROR_NOT_SAME_DEVICE)
                CASE_CODE(ERROR_NO_MORE_FILES)
                CASE_CODE(ERROR_WRITE_PROTECT)
                CASE_CODE(ERROR_BAD_UNIT)
                CASE_CODE(ERROR_NOT_READY)
                CASE_CODE(ERROR_BAD_COMMAND)
                CASE_CODE(ERROR_CRC)
                CASE_CODE(ERROR_BAD_LENGTH)
                CASE_CODE(ERROR_SEEK)
                CASE_CODE(ERROR_NOT_DOS_DISK)
                CASE_CODE(ERROR_SECTOR_NOT_FOUND)
                CASE_CODE(ERROR_OUT_OF_PAPER)
                CASE_CODE(ERROR_WRITE_FAULT)
                CASE_CODE(ERROR_READ_FAULT)
                CASE_CODE(ERROR_GEN_FAILURE)
                CASE_CODE(ERROR_SHARING_VIOLATION)
                CASE_CODE(ERROR_LOCK_VIOLATION)
                CASE_CODE(ERROR_WRONG_DISK)
                CASE_CODE(ERROR_SHARING_BUFFER_EXCEEDED)
                CASE_CODE(ERROR_HANDLE_EOF)
                CASE_CODE(ERROR_HANDLE_DISK_FULL)
                CASE_CODE(ERROR_NOT_SUPPORTED)
                CASE_CODE(ERROR_REM_NOT_LIST)
                CASE_CODE(ERROR_DUP_NAME)
                CASE_CODE(ERROR_BAD_NETPATH)
                CASE_CODE(ERROR_NETWORK_BUSY)
                CASE_CODE(ERROR_DEV_NOT_EXIST)
                CASE_CODE(ERROR_TOO_MANY_CMDS)
                CASE_CODE(ERROR_ADAP_HDW_ERR)
                CASE_CODE(ERROR_BAD_NET_RESP)
                CASE_CODE(ERROR_UNEXP_NET_ERR)
                CASE_CODE(ERROR_BAD_REM_ADAP)
                CASE_CODE(ERROR_PRINTQ_FULL)
                CASE_CODE(ERROR_NO_SPOOL_SPACE)
                CASE_CODE(ERROR_PRINT_CANCELLED)
                CASE_CODE(ERROR_NETNAME_DELETED)
                CASE_CODE(ERROR_NETWORK_ACCESS_DENIED)
                CASE_CODE(ERROR_BAD_DEV_TYPE)
                CASE_CODE(ERROR_BAD_NET_NAME)
                CASE_CODE(ERROR_TOO_MANY_NAMES)
                CASE_CODE(ERROR_TOO_MANY_SESS)
                CASE_CODE(ERROR_SHARING_PAUSED)
                CASE_CODE(ERROR_REQ_NOT_ACCEP)
                CASE_CODE(ERROR_REDIR_PAUSED)
                CASE_CODE(ERROR_FILE_EXISTS)
                CASE_CODE(ERROR_CANNOT_MAKE)
                CASE_CODE(ERROR_FAIL_I24)
                CASE_CODE(ERROR_OUT_OF_STRUCTURES)
                CASE_CODE(ERROR_ALREADY_ASSIGNED)
                CASE_CODE(ERROR_INVALID_PASSWORD)
                CASE_CODE(ERROR_INVALID_PARAMETER)
                CASE_CODE(ERROR_NET_WRITE_FAULT)
                CASE_CODE(ERROR_NO_PROC_SLOTS)
                CASE_CODE(ERROR_TOO_MANY_SEMAPHORES)
                CASE_CODE(ERROR_EXCL_SEM_ALREADY_OWNED)
                CASE_CODE(ERROR_SEM_IS_SET)
                CASE_CODE(ERROR_TOO_MANY_SEM_REQUESTS)
                CASE_CODE(ERROR_INVALID_AT_INTERRUPT_TIME)
                CASE_CODE(ERROR_SEM_OWNER_DIED)
                CASE_CODE(ERROR_SEM_USER_LIMIT)
                CASE_CODE(ERROR_DISK_CHANGE)
                CASE_CODE(ERROR_DRIVE_LOCKED)
                CASE_CODE(ERROR_BROKEN_PIPE)
                CASE_CODE(ERROR_OPEN_FAILED)
                CASE_CODE(ERROR_BUFFER_OVERFLOW)
                CASE_CODE(ERROR_DISK_FULL)
                CASE_CODE(ERROR_NO_MORE_SEARCH_HANDLES)
                CASE_CODE(ERROR_INVALID_TARGET_HANDLE)
                CASE_CODE(ERROR_INVALID_CATEGORY)
                CASE_CODE(ERROR_INVALID_VERIFY_SWITCH)
                CASE_CODE(ERROR_BAD_DRIVER_LEVEL)
                CASE_CODE(ERROR_CALL_NOT_IMPLEMENTED)
                CASE_CODE(ERROR_SEM_TIMEOUT)
                CASE_CODE(ERROR_INSUFFICIENT_BUFFER)
                CASE_CODE(ERROR_INVALID_NAME)
                CASE_CODE(ERROR_INVALID_LEVEL)
                CASE_CODE(ERROR_NO_VOLUME_LABEL)
                CASE_CODE(ERROR_MOD_NOT_FOUND)
                CASE_CODE(ERROR_PROC_NOT_FOUND)
                CASE_CODE(ERROR_WAIT_NO_CHILDREN)
                CASE_CODE(ERROR_CHILD_NOT_COMPLETE)
                CASE_CODE(ERROR_DIRECT_ACCESS_HANDLE)
                CASE_CODE(ERROR_NEGATIVE_SEEK)
                CASE_CODE(ERROR_SEEK_ON_DEVICE)
                CASE_CODE(ERROR_IS_JOIN_TARGET)
                CASE_CODE(ERROR_IS_JOINED)
                CASE_CODE(ERROR_IS_SUBSTED)
                CASE_CODE(ERROR_NOT_JOINED)
                CASE_CODE(ERROR_NOT_SUBSTED)
                CASE_CODE(ERROR_JOIN_TO_JOIN)
                CASE_CODE(ERROR_SUBST_TO_SUBST)
                CASE_CODE(ERROR_JOIN_TO_SUBST)
                CASE_CODE(ERROR_SUBST_TO_JOIN)
                CASE_CODE(ERROR_BUSY_DRIVE)
                CASE_CODE(ERROR_SAME_DRIVE)
                CASE_CODE(ERROR_DIR_NOT_ROOT)
                CASE_CODE(ERROR_DIR_NOT_EMPTY)
                CASE_CODE(ERROR_IS_SUBST_PATH)
                CASE_CODE(ERROR_IS_JOIN_PATH)
                CASE_CODE(ERROR_PATH_BUSY)
                CASE_CODE(ERROR_IS_SUBST_TARGET)
                CASE_CODE(ERROR_SYSTEM_TRACE)
                CASE_CODE(ERROR_INVALID_EVENT_COUNT)
                CASE_CODE(ERROR_TOO_MANY_MUXWAITERS)
                CASE_CODE(ERROR_INVALID_LIST_FORMAT)
                CASE_CODE(ERROR_LABEL_TOO_LONG)
                CASE_CODE(ERROR_TOO_MANY_TCBS)
                CASE_CODE(ERROR_SIGNAL_REFUSED)
                CASE_CODE(ERROR_DISCARDED)
                CASE_CODE(ERROR_NOT_LOCKED)
                CASE_CODE(ERROR_BAD_THREADID_ADDR)
                CASE_CODE(ERROR_BAD_ARGUMENTS)
                CASE_CODE(ERROR_BAD_PATHNAME)
                CASE_CODE(ERROR_SIGNAL_PENDING)
                CASE_CODE(ERROR_MAX_THRDS_REACHED)
                CASE_CODE(ERROR_LOCK_FAILED)
                CASE_CODE(ERROR_BUSY)
                CASE_CODE(ERROR_CANCEL_VIOLATION)
                CASE_CODE(ERROR_ATOMIC_LOCKS_NOT_SUPPORTED)
                CASE_CODE(ERROR_INVALID_SEGMENT_NUMBER)
                CASE_CODE(ERROR_INVALID_ORDINAL)
                CASE_CODE(ERROR_ALREADY_EXISTS)
                CASE_CODE(ERROR_INVALID_FLAG_NUMBER)
                CASE_CODE(ERROR_SEM_NOT_FOUND)
                CASE_CODE(ERROR_INVALID_STARTING_CODESEG)
                CASE_CODE(ERROR_INVALID_STACKSEG)
                CASE_CODE(ERROR_INVALID_MODULETYPE)
                CASE_CODE(ERROR_INVALID_EXE_SIGNATURE)
                CASE_CODE(ERROR_EXE_MARKED_INVALID)
                CASE_CODE(ERROR_BAD_EXE_FORMAT)
                CASE_CODE(ERROR_ITERATED_DATA_EXCEEDS_64k)
                CASE_CODE(ERROR_INVALID_MINALLOCSIZE)
                CASE_CODE(ERROR_DYNLINK_FROM_INVALID_RING)
                CASE_CODE(ERROR_IOPL_NOT_ENABLED)
                CASE_CODE(ERROR_INVALID_SEGDPL)
                CASE_CODE(ERROR_AUTODATASEG_EXCEEDS_64k)
                CASE_CODE(ERROR_RING2SEG_MUST_BE_MOVABLE)
                CASE_CODE(ERROR_RELOC_CHAIN_XEEDS_SEGLIM)
                CASE_CODE(ERROR_INFLOOP_IN_RELOC_CHAIN)
                CASE_CODE(ERROR_ENVVAR_NOT_FOUND)
                CASE_CODE(ERROR_NO_SIGNAL_SENT)
                CASE_CODE(ERROR_FILENAME_EXCED_RANGE)
                CASE_CODE(ERROR_RING2_STACK_IN_USE)
                CASE_CODE(ERROR_META_EXPANSION_TOO_LONG)
                CASE_CODE(ERROR_INVALID_SIGNAL_NUMBER)
                CASE_CODE(ERROR_THREAD_1_INACTIVE)
                CASE_CODE(ERROR_LOCKED)
                CASE_CODE(ERROR_TOO_MANY_MODULES)
                CASE_CODE(ERROR_NESTING_NOT_ALLOWED)
                CASE_CODE(ERROR_EXE_MACHINE_TYPE_MISMATCH)
                CASE_CODE(ERROR_BAD_PIPE)
                CASE_CODE(ERROR_PIPE_BUSY)
                CASE_CODE(ERROR_NO_DATA)
                CASE_CODE(ERROR_PIPE_NOT_CONNECTED)
                CASE_CODE(ERROR_MORE_DATA)
                CASE_CODE(ERROR_VC_DISCONNECTED)
                CASE_CODE(ERROR_INVALID_EA_NAME)
                CASE_CODE(ERROR_EA_LIST_INCONSISTENT)
                CASE_CODE(ERROR_NO_MORE_ITEMS)
                CASE_CODE(ERROR_CANNOT_COPY)
                CASE_CODE(ERROR_DIRECTORY)
                CASE_CODE(ERROR_EAS_DIDNT_FIT)
                CASE_CODE(ERROR_EA_FILE_CORRUPT)
                CASE_CODE(ERROR_EA_TABLE_FULL)
                CASE_CODE(ERROR_INVALID_EA_HANDLE)
                CASE_CODE(ERROR_EAS_NOT_SUPPORTED)
                CASE_CODE(ERROR_NOT_OWNER)
                CASE_CODE(ERROR_TOO_MANY_POSTS)
                CASE_CODE(ERROR_PARTIAL_COPY)
                CASE_CODE(ERROR_MR_MID_NOT_FOUND)
                CASE_CODE(ERROR_INVALID_ADDRESS)
                CASE_CODE(ERROR_ARITHMETIC_OVERFLOW)
                CASE_CODE(ERROR_PIPE_CONNECTED)
                CASE_CODE(ERROR_PIPE_LISTENING)
                CASE_CODE(ERROR_EA_ACCESS_DENIED)
                CASE_CODE(ERROR_OPERATION_ABORTED)
                CASE_CODE(ERROR_IO_INCOMPLETE)
                CASE_CODE(ERROR_IO_PENDING)
                CASE_CODE(ERROR_NOACCESS)
                CASE_CODE(ERROR_SWAPERROR)
                CASE_CODE(ERROR_STACK_OVERFLOW)
                CASE_CODE(ERROR_INVALID_MESSAGE)
                CASE_CODE(ERROR_CAN_NOT_COMPLETE)
                CASE_CODE(ERROR_INVALID_FLAGS)
                CASE_CODE(ERROR_UNRECOGNIZED_VOLUME)
                CASE_CODE(ERROR_FILE_INVALID)
                CASE_CODE(ERROR_FULLSCREEN_MODE)
                CASE_CODE(ERROR_NO_TOKEN)
                CASE_CODE(ERROR_BADDB)
                CASE_CODE(ERROR_BADKEY)
                CASE_CODE(ERROR_CANTOPEN)
                CASE_CODE(ERROR_CANTREAD)
                CASE_CODE(ERROR_CANTWRITE)
                CASE_CODE(ERROR_REGISTRY_RECOVERED)
                CASE_CODE(ERROR_REGISTRY_CORRUPT)
                CASE_CODE(ERROR_REGISTRY_IO_FAILED)
                CASE_CODE(ERROR_NOT_REGISTRY_FILE)
                CASE_CODE(ERROR_KEY_DELETED)
                CASE_CODE(ERROR_NO_LOG_SPACE)
                CASE_CODE(ERROR_KEY_HAS_CHILDREN)
                CASE_CODE(ERROR_CHILD_MUST_BE_VOLATILE)
                CASE_CODE(ERROR_NOTIFY_ENUM_DIR)
                CASE_CODE(ERROR_DEPENDENT_SERVICES_RUNNING)
                CASE_CODE(ERROR_INVALID_SERVICE_CONTROL)
                CASE_CODE(ERROR_SERVICE_REQUEST_TIMEOUT)
                CASE_CODE(ERROR_SERVICE_NO_THREAD)
                CASE_CODE(ERROR_SERVICE_DATABASE_LOCKED)
                CASE_CODE(ERROR_SERVICE_ALREADY_RUNNING)
                CASE_CODE(ERROR_INVALID_SERVICE_ACCOUNT)
                CASE_CODE(ERROR_SERVICE_DISABLED)
                CASE_CODE(ERROR_CIRCULAR_DEPENDENCY)
                CASE_CODE(ERROR_SERVICE_DOES_NOT_EXIST)
                CASE_CODE(ERROR_SERVICE_CANNOT_ACCEPT_CTRL)
                CASE_CODE(ERROR_SERVICE_NOT_ACTIVE)
                CASE_CODE(ERROR_FAILED_SERVICE_CONTROLLER_CONNECT)
                CASE_CODE(ERROR_EXCEPTION_IN_SERVICE)
                CASE_CODE(ERROR_DATABASE_DOES_NOT_EXIST)
                CASE_CODE(ERROR_SERVICE_SPECIFIC_ERROR)
                CASE_CODE(ERROR_PROCESS_ABORTED)
                CASE_CODE(ERROR_SERVICE_DEPENDENCY_FAIL)
                CASE_CODE(ERROR_SERVICE_LOGON_FAILED)
                CASE_CODE(ERROR_SERVICE_START_HANG)
                CASE_CODE(ERROR_INVALID_SERVICE_LOCK)
                CASE_CODE(ERROR_SERVICE_MARKED_FOR_DELETE)
                CASE_CODE(ERROR_SERVICE_EXISTS)
                CASE_CODE(ERROR_ALREADY_RUNNING_LKG)
                CASE_CODE(ERROR_SERVICE_DEPENDENCY_DELETED)
                CASE_CODE(ERROR_BOOT_ALREADY_ACCEPTED)
                CASE_CODE(ERROR_SERVICE_NEVER_STARTED)
                CASE_CODE(ERROR_DUPLICATE_SERVICE_NAME)
                CASE_CODE(ERROR_DIFFERENT_SERVICE_ACCOUNT)
                CASE_CODE(ERROR_END_OF_MEDIA)
                CASE_CODE(ERROR_FILEMARK_DETECTED)
                CASE_CODE(ERROR_BEGINNING_OF_MEDIA)
                CASE_CODE(ERROR_SETMARK_DETECTED)
                CASE_CODE(ERROR_NO_DATA_DETECTED)
                CASE_CODE(ERROR_PARTITION_FAILURE)
                CASE_CODE(ERROR_INVALID_BLOCK_LENGTH)
                CASE_CODE(ERROR_DEVICE_NOT_PARTITIONED)
                CASE_CODE(ERROR_UNABLE_TO_LOCK_MEDIA)
                CASE_CODE(ERROR_UNABLE_TO_UNLOAD_MEDIA)
                CASE_CODE(ERROR_MEDIA_CHANGED)
                CASE_CODE(ERROR_BUS_RESET)
                CASE_CODE(ERROR_NO_MEDIA_IN_DRIVE)
                CASE_CODE(ERROR_NO_UNICODE_TRANSLATION)
                CASE_CODE(ERROR_DLL_INIT_FAILED)
                CASE_CODE(ERROR_SHUTDOWN_IN_PROGRESS)
                CASE_CODE(ERROR_NO_SHUTDOWN_IN_PROGRESS)
                CASE_CODE(ERROR_IO_DEVICE)
                CASE_CODE(ERROR_SERIAL_NO_DEVICE)
                CASE_CODE(ERROR_IRQ_BUSY)
                CASE_CODE(ERROR_MORE_WRITES)
                CASE_CODE(ERROR_COUNTER_TIMEOUT)
                CASE_CODE(ERROR_FLOPPY_ID_MARK_NOT_FOUND)
                CASE_CODE(ERROR_FLOPPY_WRONG_CYLINDER)
                CASE_CODE(ERROR_FLOPPY_UNKNOWN_ERROR)
                CASE_CODE(ERROR_FLOPPY_BAD_REGISTERS)
                CASE_CODE(ERROR_DISK_RECALIBRATE_FAILED)
                CASE_CODE(ERROR_DISK_OPERATION_FAILED)
                CASE_CODE(ERROR_DISK_RESET_FAILED)
                CASE_CODE(ERROR_EOM_OVERFLOW)
                CASE_CODE(ERROR_NOT_ENOUGH_SERVER_MEMORY)
                CASE_CODE(ERROR_POSSIBLE_DEADLOCK)
                CASE_CODE(ERROR_MAPPED_ALIGNMENT)
                CASE_CODE(ERROR_SET_POWER_STATE_VETOED)
                CASE_CODE(ERROR_SET_POWER_STATE_FAILED)
                CASE_CODE(ERROR_TOO_MANY_LINKS)
                CASE_CODE(ERROR_OLD_WIN_VERSION)
                CASE_CODE(ERROR_APP_WRONG_OS)
                CASE_CODE(ERROR_SINGLE_INSTANCE_APP)
                CASE_CODE(ERROR_RMODE_APP)
                CASE_CODE(ERROR_INVALID_DLL)
                CASE_CODE(ERROR_NO_ASSOCIATION)
                CASE_CODE(ERROR_DDE_FAIL)
                CASE_CODE(ERROR_DLL_NOT_FOUND)
                CASE_CODE(ERROR_BAD_USERNAME)
                CASE_CODE(ERROR_NOT_CONNECTED)
                CASE_CODE(ERROR_OPEN_FILES)
                CASE_CODE(ERROR_ACTIVE_CONNECTIONS)
                CASE_CODE(ERROR_DEVICE_IN_USE)
                CASE_CODE(ERROR_BAD_DEVICE)
                CASE_CODE(ERROR_CONNECTION_UNAVAIL)
                CASE_CODE(ERROR_DEVICE_ALREADY_REMEMBERED)
                CASE_CODE(ERROR_NO_NET_OR_BAD_PATH)
                CASE_CODE(ERROR_BAD_PROVIDER)
                CASE_CODE(ERROR_CANNOT_OPEN_PROFILE)
                CASE_CODE(ERROR_BAD_PROFILE)
                CASE_CODE(ERROR_NOT_CONTAINER)
                CASE_CODE(ERROR_EXTENDED_ERROR)
                CASE_CODE(ERROR_INVALID_GROUPNAME)
                CASE_CODE(ERROR_INVALID_COMPUTERNAME)
                CASE_CODE(ERROR_INVALID_EVENTNAME)
                CASE_CODE(ERROR_INVALID_DOMAINNAME)
                CASE_CODE(ERROR_INVALID_SERVICENAME)
                CASE_CODE(ERROR_INVALID_NETNAME)
                CASE_CODE(ERROR_INVALID_SHARENAME)
                CASE_CODE(ERROR_INVALID_PASSWORDNAME)
                CASE_CODE(ERROR_INVALID_MESSAGENAME)
                CASE_CODE(ERROR_INVALID_MESSAGEDEST)
                CASE_CODE(ERROR_SESSION_CREDENTIAL_CONFLICT)
                CASE_CODE(ERROR_REMOTE_SESSION_LIMIT_EXCEEDED)
                CASE_CODE(ERROR_DUP_DOMAINNAME)
                CASE_CODE(ERROR_NO_NETWORK)
                CASE_CODE(ERROR_CANCELLED)
                CASE_CODE(ERROR_USER_MAPPED_FILE)
                CASE_CODE(ERROR_CONNECTION_REFUSED)
                CASE_CODE(ERROR_GRACEFUL_DISCONNECT)
                CASE_CODE(ERROR_ADDRESS_ALREADY_ASSOCIATED)
                CASE_CODE(ERROR_ADDRESS_NOT_ASSOCIATED)
                CASE_CODE(ERROR_CONNECTION_INVALID)
                CASE_CODE(ERROR_CONNECTION_ACTIVE)
                CASE_CODE(ERROR_NETWORK_UNREACHABLE)
                CASE_CODE(ERROR_HOST_UNREACHABLE)
                CASE_CODE(ERROR_PROTOCOL_UNREACHABLE)
                CASE_CODE(ERROR_PORT_UNREACHABLE)
                CASE_CODE(ERROR_REQUEST_ABORTED)
                CASE_CODE(ERROR_CONNECTION_ABORTED)
                CASE_CODE(ERROR_RETRY)
                CASE_CODE(ERROR_CONNECTION_COUNT_LIMIT)
                CASE_CODE(ERROR_LOGIN_TIME_RESTRICTION)
                CASE_CODE(ERROR_LOGIN_WKSTA_RESTRICTION)
                CASE_CODE(ERROR_INCORRECT_ADDRESS)
                CASE_CODE(ERROR_ALREADY_REGISTERED)
                CASE_CODE(ERROR_SERVICE_NOT_FOUND)
                CASE_CODE(ERROR_NOT_AUTHENTICATED)
                CASE_CODE(ERROR_NOT_LOGGED_ON)
                CASE_CODE(ERROR_CONTINUE)
                CASE_CODE(ERROR_ALREADY_INITIALIZED)
                CASE_CODE(ERROR_NO_MORE_DEVICES)
                CASE_CODE(ERROR_NOT_ALL_ASSIGNED)
                CASE_CODE(ERROR_SOME_NOT_MAPPED)
                CASE_CODE(ERROR_NO_QUOTAS_FOR_ACCOUNT)
                CASE_CODE(ERROR_LOCAL_USER_SESSION_KEY)
                CASE_CODE(ERROR_NULL_LM_PASSWORD)
                CASE_CODE(ERROR_UNKNOWN_REVISION)
                CASE_CODE(ERROR_REVISION_MISMATCH)
                CASE_CODE(ERROR_INVALID_OWNER)
                CASE_CODE(ERROR_INVALID_PRIMARY_GROUP)
                CASE_CODE(ERROR_NO_IMPERSONATION_TOKEN)
                CASE_CODE(ERROR_CANT_DISABLE_MANDATORY)
                CASE_CODE(ERROR_NO_LOGON_SERVERS)
                CASE_CODE(ERROR_NO_SUCH_LOGON_SESSION)
                CASE_CODE(ERROR_NO_SUCH_PRIVILEGE)
                CASE_CODE(ERROR_PRIVILEGE_NOT_HELD)
                CASE_CODE(ERROR_INVALID_ACCOUNT_NAME)
                CASE_CODE(ERROR_USER_EXISTS)
                CASE_CODE(ERROR_NO_SUCH_USER)
                CASE_CODE(ERROR_GROUP_EXISTS)
                CASE_CODE(ERROR_NO_SUCH_GROUP)
                CASE_CODE(ERROR_MEMBER_IN_GROUP)
                CASE_CODE(ERROR_MEMBER_NOT_IN_GROUP)
                CASE_CODE(ERROR_LAST_ADMIN)
                CASE_CODE(ERROR_WRONG_PASSWORD)
                CASE_CODE(ERROR_ILL_FORMED_PASSWORD)
                CASE_CODE(ERROR_PASSWORD_RESTRICTION)
                CASE_CODE(ERROR_LOGON_FAILURE)
                CASE_CODE(ERROR_ACCOUNT_RESTRICTION)
                CASE_CODE(ERROR_INVALID_LOGON_HOURS)
                CASE_CODE(ERROR_INVALID_WORKSTATION)
                CASE_CODE(ERROR_PASSWORD_EXPIRED)
                CASE_CODE(ERROR_ACCOUNT_DISABLED)
                CASE_CODE(ERROR_NONE_MAPPED)
                CASE_CODE(ERROR_TOO_MANY_LUIDS_REQUESTED)
                CASE_CODE(ERROR_LUIDS_EXHAUSTED)
                CASE_CODE(ERROR_INVALID_SUB_AUTHORITY)
                CASE_CODE(ERROR_INVALID_ACL)
                CASE_CODE(ERROR_INVALID_SID)
                CASE_CODE(ERROR_INVALID_SECURITY_DESCR)
                CASE_CODE(ERROR_BAD_INHERITANCE_ACL)
                CASE_CODE(ERROR_SERVER_DISABLED)
                CASE_CODE(ERROR_SERVER_NOT_DISABLED)
                CASE_CODE(ERROR_INVALID_ID_AUTHORITY)
                CASE_CODE(ERROR_ALLOTTED_SPACE_EXCEEDED)
                CASE_CODE(ERROR_INVALID_GROUP_ATTRIBUTES)
                CASE_CODE(ERROR_BAD_IMPERSONATION_LEVEL)
                CASE_CODE(ERROR_CANT_OPEN_ANONYMOUS)
                CASE_CODE(ERROR_BAD_VALIDATION_CLASS)
                CASE_CODE(ERROR_BAD_TOKEN_TYPE)
                CASE_CODE(ERROR_NO_SECURITY_ON_OBJECT)
                CASE_CODE(ERROR_CANT_ACCESS_DOMAIN_INFO)
                CASE_CODE(ERROR_INVALID_SERVER_STATE)
                CASE_CODE(ERROR_INVALID_DOMAIN_STATE)
                CASE_CODE(ERROR_INVALID_DOMAIN_ROLE)
                CASE_CODE(ERROR_NO_SUCH_DOMAIN)
                CASE_CODE(ERROR_DOMAIN_EXISTS)
                CASE_CODE(ERROR_DOMAIN_LIMIT_EXCEEDED)
                CASE_CODE(ERROR_INTERNAL_DB_CORRUPTION)
                CASE_CODE(ERROR_INTERNAL_ERROR)
                CASE_CODE(ERROR_GENERIC_NOT_MAPPED)
                CASE_CODE(ERROR_BAD_DESCRIPTOR_FORMAT)
                CASE_CODE(ERROR_NOT_LOGON_PROCESS)
                CASE_CODE(ERROR_LOGON_SESSION_EXISTS)
                CASE_CODE(ERROR_NO_SUCH_PACKAGE)
                CASE_CODE(ERROR_BAD_LOGON_SESSION_STATE)
                CASE_CODE(ERROR_LOGON_SESSION_COLLISION)
                CASE_CODE(ERROR_INVALID_LOGON_TYPE)
                CASE_CODE(ERROR_CANNOT_IMPERSONATE)
                CASE_CODE(ERROR_RXACT_INVALID_STATE)
                CASE_CODE(ERROR_RXACT_COMMIT_FAILURE)
                CASE_CODE(ERROR_SPECIAL_ACCOUNT)
                CASE_CODE(ERROR_SPECIAL_GROUP)
                CASE_CODE(ERROR_SPECIAL_USER)
                CASE_CODE(ERROR_MEMBERS_PRIMARY_GROUP)
                CASE_CODE(ERROR_TOKEN_ALREADY_IN_USE)
                CASE_CODE(ERROR_NO_SUCH_ALIAS)
                CASE_CODE(ERROR_MEMBER_NOT_IN_ALIAS)
                CASE_CODE(ERROR_MEMBER_IN_ALIAS)
                CASE_CODE(ERROR_ALIAS_EXISTS)
                CASE_CODE(ERROR_LOGON_NOT_GRANTED)
                CASE_CODE(ERROR_TOO_MANY_SECRETS)
                CASE_CODE(ERROR_SECRET_TOO_LONG)
                CASE_CODE(ERROR_INTERNAL_DB_ERROR)
                CASE_CODE(ERROR_TOO_MANY_CONTEXT_IDS)
                CASE_CODE(ERROR_LOGON_TYPE_NOT_GRANTED)
                CASE_CODE(ERROR_NT_CROSS_ENCRYPTION_REQUIRED)
                CASE_CODE(ERROR_NO_SUCH_MEMBER)
                CASE_CODE(ERROR_INVALID_MEMBER)
                CASE_CODE(ERROR_TOO_MANY_SIDS)
                CASE_CODE(ERROR_LM_CROSS_ENCRYPTION_REQUIRED)
                CASE_CODE(ERROR_NO_INHERITANCE)
                CASE_CODE(ERROR_FILE_CORRUPT)
                CASE_CODE(ERROR_DISK_CORRUPT)
                CASE_CODE(ERROR_NO_USER_SESSION_KEY)
                CASE_CODE(ERROR_LICENSE_QUOTA_EXCEEDED)
                CASE_CODE(ERROR_INVALID_WINDOW_HANDLE)
                CASE_CODE(ERROR_INVALID_MENU_HANDLE)
                CASE_CODE(ERROR_INVALID_CURSOR_HANDLE)
                CASE_CODE(ERROR_INVALID_ACCEL_HANDLE)
                CASE_CODE(ERROR_INVALID_HOOK_HANDLE)
                CASE_CODE(ERROR_INVALID_DWP_HANDLE)
                CASE_CODE(ERROR_TLW_WITH_WSCHILD)
                CASE_CODE(ERROR_CANNOT_FIND_WND_CLASS)
                CASE_CODE(ERROR_WINDOW_OF_OTHER_THREAD)
                CASE_CODE(ERROR_HOTKEY_ALREADY_REGISTERED)
                CASE_CODE(ERROR_CLASS_ALREADY_EXISTS)
                CASE_CODE(ERROR_CLASS_DOES_NOT_EXIST)
                CASE_CODE(ERROR_CLASS_HAS_WINDOWS)
                CASE_CODE(ERROR_INVALID_INDEX)
                CASE_CODE(ERROR_INVALID_ICON_HANDLE)
                CASE_CODE(ERROR_PRIVATE_DIALOG_INDEX)
                CASE_CODE(ERROR_LISTBOX_ID_NOT_FOUND)
                CASE_CODE(ERROR_NO_WILDCARD_CHARACTERS)
                CASE_CODE(ERROR_CLIPBOARD_NOT_OPEN)
                CASE_CODE(ERROR_HOTKEY_NOT_REGISTERED)
                CASE_CODE(ERROR_WINDOW_NOT_DIALOG)
                CASE_CODE(ERROR_CONTROL_ID_NOT_FOUND)
                CASE_CODE(ERROR_INVALID_COMBOBOX_MESSAGE)
                CASE_CODE(ERROR_WINDOW_NOT_COMBOBOX)
                CASE_CODE(ERROR_INVALID_EDIT_HEIGHT)
                CASE_CODE(ERROR_DC_NOT_FOUND)
                CASE_CODE(ERROR_INVALID_HOOK_FILTER)
                CASE_CODE(ERROR_INVALID_FILTER_PROC)
                CASE_CODE(ERROR_HOOK_NEEDS_HMOD)
                CASE_CODE(ERROR_GLOBAL_ONLY_HOOK)
                CASE_CODE(ERROR_JOURNAL_HOOK_SET)
                CASE_CODE(ERROR_HOOK_NOT_INSTALLED)
                CASE_CODE(ERROR_INVALID_LB_MESSAGE)
                CASE_CODE(ERROR_SETCOUNT_ON_BAD_LB)
                CASE_CODE(ERROR_LB_WITHOUT_TABSTOPS)
                CASE_CODE(ERROR_DESTROY_OBJECT_OF_OTHER_THREAD)
                CASE_CODE(ERROR_CHILD_WINDOW_MENU)
                CASE_CODE(ERROR_NO_SYSTEM_MENU)
                CASE_CODE(ERROR_INVALID_MSGBOX_STYLE)
                CASE_CODE(ERROR_INVALID_SPI_VALUE)
                CASE_CODE(ERROR_SCREEN_ALREADY_LOCKED)
                CASE_CODE(ERROR_HWNDS_HAVE_DIFF_PARENT)
                CASE_CODE(ERROR_NOT_CHILD_WINDOW)
                CASE_CODE(ERROR_INVALID_GW_COMMAND)
                CASE_CODE(ERROR_INVALID_THREAD_ID)
                CASE_CODE(ERROR_NON_MDICHILD_WINDOW)
                CASE_CODE(ERROR_POPUP_ALREADY_ACTIVE)
                CASE_CODE(ERROR_NO_SCROLLBARS)
                CASE_CODE(ERROR_INVALID_SCROLLBAR_RANGE)
                CASE_CODE(ERROR_INVALID_SHOWWIN_COMMAND)
                CASE_CODE(ERROR_NO_SYSTEM_RESOURCES)
                CASE_CODE(ERROR_NONPAGED_SYSTEM_RESOURCES)
                CASE_CODE(ERROR_PAGED_SYSTEM_RESOURCES)
                CASE_CODE(ERROR_WORKING_SET_QUOTA)
                CASE_CODE(ERROR_PAGEFILE_QUOTA)
                CASE_CODE(ERROR_COMMITMENT_LIMIT)
                CASE_CODE(ERROR_MENU_ITEM_NOT_FOUND)
                CASE_CODE(ERROR_INVALID_KEYBOARD_HANDLE)
                CASE_CODE(ERROR_HOOK_TYPE_NOT_ALLOWED)
                CASE_CODE(ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION)
                CASE_CODE(ERROR_EVENTLOG_FILE_CORRUPT)
                CASE_CODE(ERROR_EVENTLOG_CANT_START)
                CASE_CODE(ERROR_LOG_FILE_FULL)
                CASE_CODE(ERROR_EVENTLOG_FILE_CHANGED)
                CASE_CODE(RPC_S_INVALID_STRING_BINDING)
                CASE_CODE(RPC_S_WRONG_KIND_OF_BINDING)
                CASE_CODE(RPC_S_INVALID_BINDING)
                CASE_CODE(RPC_S_PROTSEQ_NOT_SUPPORTED)
                CASE_CODE(RPC_S_INVALID_RPC_PROTSEQ)
                CASE_CODE(RPC_S_INVALID_STRING_UUID)
                CASE_CODE(RPC_S_INVALID_ENDPOINT_FORMAT)
                CASE_CODE(RPC_S_INVALID_NET_ADDR)
                CASE_CODE(RPC_S_NO_ENDPOINT_FOUND)
                CASE_CODE(RPC_S_INVALID_TIMEOUT)
                CASE_CODE(RPC_S_OBJECT_NOT_FOUND)
                CASE_CODE(RPC_S_ALREADY_REGISTERED)
                CASE_CODE(RPC_S_TYPE_ALREADY_REGISTERED)
                CASE_CODE(RPC_S_ALREADY_LISTENING)
                CASE_CODE(RPC_S_NO_PROTSEQS_REGISTERED)
                CASE_CODE(RPC_S_NOT_LISTENING)
                CASE_CODE(RPC_S_UNKNOWN_MGR_TYPE)
                CASE_CODE(RPC_S_UNKNOWN_IF)
                CASE_CODE(RPC_S_NO_BINDINGS)
                CASE_CODE(RPC_S_NO_PROTSEQS)
                CASE_CODE(RPC_S_CANT_CREATE_ENDPOINT)
                CASE_CODE(RPC_S_OUT_OF_RESOURCES)
                CASE_CODE(RPC_S_SERVER_UNAVAILABLE)
                CASE_CODE(RPC_S_SERVER_TOO_BUSY)
                CASE_CODE(RPC_S_INVALID_NETWORK_OPTIONS)
                CASE_CODE(RPC_S_NO_CALL_ACTIVE)
                CASE_CODE(RPC_S_CALL_FAILED)
                CASE_CODE(RPC_S_CALL_FAILED_DNE)
                CASE_CODE(RPC_S_PROTOCOL_ERROR)
                CASE_CODE(RPC_S_UNSUPPORTED_TRANS_SYN)
                CASE_CODE(RPC_S_UNSUPPORTED_TYPE)
                CASE_CODE(RPC_S_INVALID_TAG)
                CASE_CODE(RPC_S_INVALID_BOUND)
                CASE_CODE(RPC_S_NO_ENTRY_NAME)
                CASE_CODE(RPC_S_INVALID_NAME_SYNTAX)
                CASE_CODE(RPC_S_UNSUPPORTED_NAME_SYNTAX)
                CASE_CODE(RPC_S_UUID_NO_ADDRESS)
                CASE_CODE(RPC_S_DUPLICATE_ENDPOINT)
                CASE_CODE(RPC_S_UNKNOWN_AUTHN_TYPE)
                CASE_CODE(RPC_S_MAX_CALLS_TOO_SMALL)
                CASE_CODE(RPC_S_STRING_TOO_LONG)
                CASE_CODE(RPC_S_PROTSEQ_NOT_FOUND)
                CASE_CODE(RPC_S_PROCNUM_OUT_OF_RANGE)
                CASE_CODE(RPC_S_BINDING_HAS_NO_AUTH)
                CASE_CODE(RPC_S_UNKNOWN_AUTHN_SERVICE)
                CASE_CODE(RPC_S_UNKNOWN_AUTHN_LEVEL)
                CASE_CODE(RPC_S_INVALID_AUTH_IDENTITY)
                CASE_CODE(RPC_S_UNKNOWN_AUTHZ_SERVICE)
                CASE_CODE(EPT_S_INVALID_ENTRY)
                CASE_CODE(EPT_S_CANT_PERFORM_OP)
                CASE_CODE(EPT_S_NOT_REGISTERED)
                CASE_CODE(RPC_S_NOTHING_TO_EXPORT)
                CASE_CODE(RPC_S_INCOMPLETE_NAME)
                CASE_CODE(RPC_S_INVALID_VERS_OPTION)
                CASE_CODE(RPC_S_NO_MORE_MEMBERS)
                CASE_CODE(RPC_S_NOT_ALL_OBJS_UNEXPORTED)
                CASE_CODE(RPC_S_INTERFACE_NOT_FOUND)
                CASE_CODE(RPC_S_ENTRY_ALREADY_EXISTS)
                CASE_CODE(RPC_S_ENTRY_NOT_FOUND)
                CASE_CODE(RPC_S_NAME_SERVICE_UNAVAILABLE)
                CASE_CODE(RPC_S_INVALID_NAF_ID)
                CASE_CODE(RPC_S_CANNOT_SUPPORT)
                CASE_CODE(RPC_S_NO_CONTEXT_AVAILABLE)
                CASE_CODE(RPC_S_INTERNAL_ERROR)
                CASE_CODE(RPC_S_ZERO_DIVIDE)
                CASE_CODE(RPC_S_ADDRESS_ERROR)
                CASE_CODE(RPC_S_FP_DIV_ZERO)
                CASE_CODE(RPC_S_FP_UNDERFLOW)
                CASE_CODE(RPC_S_FP_OVERFLOW)
                CASE_CODE(RPC_X_NO_MORE_ENTRIES)
                CASE_CODE(RPC_X_SS_CHAR_TRANS_OPEN_FAIL)
                CASE_CODE(RPC_X_SS_CHAR_TRANS_SHORT_FILE)
                CASE_CODE(RPC_X_SS_IN_NULL_CONTEXT)
                CASE_CODE(RPC_X_SS_CONTEXT_DAMAGED)
                CASE_CODE(RPC_X_SS_HANDLES_MISMATCH)
                CASE_CODE(RPC_X_SS_CANNOT_GET_CALL_HANDLE)
                CASE_CODE(RPC_X_NULL_REF_POINTER)
                CASE_CODE(RPC_X_ENUM_VALUE_OUT_OF_RANGE)
                CASE_CODE(RPC_X_BYTE_COUNT_TOO_SMALL)
                CASE_CODE(RPC_X_BAD_STUB_DATA)
                CASE_CODE(ERROR_INVALID_USER_BUFFER)
                CASE_CODE(ERROR_UNRECOGNIZED_MEDIA)
                CASE_CODE(ERROR_NO_TRUST_LSA_SECRET)
                CASE_CODE(ERROR_NO_TRUST_SAM_ACCOUNT)
                CASE_CODE(ERROR_TRUSTED_DOMAIN_FAILURE)
                CASE_CODE(ERROR_TRUSTED_RELATIONSHIP_FAILURE)
                CASE_CODE(ERROR_TRUST_FAILURE)
                CASE_CODE(RPC_S_CALL_IN_PROGRESS)
                CASE_CODE(ERROR_NETLOGON_NOT_STARTED)
                CASE_CODE(ERROR_ACCOUNT_EXPIRED)
                CASE_CODE(ERROR_REDIRECTOR_HAS_OPEN_HANDLES)
                CASE_CODE(ERROR_PRINTER_DRIVER_ALREADY_INSTALLED)
                CASE_CODE(ERROR_UNKNOWN_PORT)
                CASE_CODE(ERROR_UNKNOWN_PRINTER_DRIVER)
                CASE_CODE(ERROR_UNKNOWN_PRINTPROCESSOR)
                CASE_CODE(ERROR_INVALID_SEPARATOR_FILE)
                CASE_CODE(ERROR_INVALID_PRIORITY)
                CASE_CODE(ERROR_INVALID_PRINTER_NAME)
                CASE_CODE(ERROR_PRINTER_ALREADY_EXISTS)
                CASE_CODE(ERROR_INVALID_PRINTER_COMMAND)
                CASE_CODE(ERROR_INVALID_DATATYPE)
                CASE_CODE(ERROR_INVALID_ENVIRONMENT)
                CASE_CODE(RPC_S_NO_MORE_BINDINGS)
                CASE_CODE(ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT)
                CASE_CODE(ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT)
                CASE_CODE(ERROR_NOLOGON_SERVER_TRUST_ACCOUNT)
                CASE_CODE(ERROR_DOMAIN_TRUST_INCONSISTENT)
                CASE_CODE(ERROR_SERVER_HAS_OPEN_HANDLES)
                CASE_CODE(ERROR_RESOURCE_DATA_NOT_FOUND)
                CASE_CODE(ERROR_RESOURCE_TYPE_NOT_FOUND)
                CASE_CODE(ERROR_RESOURCE_NAME_NOT_FOUND)
                CASE_CODE(ERROR_RESOURCE_LANG_NOT_FOUND)
                CASE_CODE(ERROR_NOT_ENOUGH_QUOTA)
                CASE_CODE(RPC_S_NO_INTERFACES)
                CASE_CODE(RPC_S_CALL_CANCELLED)
                CASE_CODE(RPC_S_BINDING_INCOMPLETE)
                CASE_CODE(RPC_S_COMM_FAILURE)
                CASE_CODE(RPC_S_UNSUPPORTED_AUTHN_LEVEL)
                CASE_CODE(RPC_S_NO_PRINC_NAME)
                CASE_CODE(RPC_S_NOT_RPC_ERROR)
                CASE_CODE(RPC_S_UUID_LOCAL_ONLY)
                CASE_CODE(RPC_S_SEC_PKG_ERROR)
                CASE_CODE(RPC_S_NOT_CANCELLED)
                CASE_CODE(RPC_X_INVALID_ES_ACTION)
                CASE_CODE(RPC_X_WRONG_ES_VERSION)
                CASE_CODE(RPC_X_WRONG_STUB_VERSION)
                CASE_CODE(RPC_X_INVALID_PIPE_OBJECT)
                CASE_CODE(RPC_X_INVALID_PIPE_OPERATION)
                CASE_CODE(RPC_X_WRONG_PIPE_VERSION)
                CASE_CODE(RPC_S_GROUP_MEMBER_NOT_FOUND)
                CASE_CODE(EPT_S_CANT_CREATE)
                CASE_CODE(RPC_S_INVALID_OBJECT)
                CASE_CODE(ERROR_INVALID_TIME)
                CASE_CODE(ERROR_INVALID_FORM_NAME)
                CASE_CODE(ERROR_INVALID_FORM_SIZE)
                CASE_CODE(ERROR_ALREADY_WAITING)
                CASE_CODE(ERROR_PRINTER_DELETED)
                CASE_CODE(ERROR_INVALID_PRINTER_STATE)
                CASE_CODE(ERROR_PASSWORD_MUST_CHANGE)
                CASE_CODE(ERROR_DOMAIN_CONTROLLER_NOT_FOUND)
                CASE_CODE(ERROR_ACCOUNT_LOCKED_OUT)
                CASE_CODE(OR_INVALID_OXID)
                CASE_CODE(OR_INVALID_OID)
                CASE_CODE(OR_INVALID_SET)
                CASE_CODE(RPC_S_SEND_INCOMPLETE)
                CASE_CODE(ERROR_NO_BROWSER_SERVERS_FOUND)
                CASE_CODE(ERROR_INVALID_PIXEL_FORMAT)
                CASE_CODE(ERROR_BAD_DRIVER)
                CASE_CODE(ERROR_INVALID_WINDOW_STYLE)
                CASE_CODE(ERROR_METAFILE_NOT_SUPPORTED)
                CASE_CODE(ERROR_TRANSFORM_NOT_SUPPORTED)
                CASE_CODE(ERROR_CLIPPING_NOT_SUPPORTED)
                CASE_CODE(ERROR_UNKNOWN_PRINT_MONITOR)
                CASE_CODE(ERROR_PRINTER_DRIVER_IN_USE)
                CASE_CODE(ERROR_SPOOL_FILE_NOT_FOUND)
                CASE_CODE(ERROR_SPL_NO_STARTDOC)
                CASE_CODE(ERROR_SPL_NO_ADDJOB)
                CASE_CODE(ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED)
                CASE_CODE(ERROR_PRINT_MONITOR_ALREADY_INSTALLED)
                CASE_CODE(ERROR_INVALID_PRINT_MONITOR)
                CASE_CODE(ERROR_PRINT_MONITOR_IN_USE)
                CASE_CODE(ERROR_PRINTER_HAS_JOBS_QUEUED)
                CASE_CODE(ERROR_SUCCESS_REBOOT_REQUIRED)
                CASE_CODE(ERROR_SUCCESS_RESTART_REQUIRED)
                CASE_CODE(ERROR_WINS_INTERNAL)
                CASE_CODE(ERROR_CAN_NOT_DEL_LOCAL_WINS)
                CASE_CODE(ERROR_STATIC_INIT)
                CASE_CODE(ERROR_INC_BACKUP)
                CASE_CODE(ERROR_FULL_BACKUP)
                CASE_CODE(ERROR_REC_NON_EXISTENT)
                CASE_CODE(ERROR_RPL_NOT_ALLOWED)

                default:
                lstrcpy(szErrorName, TEXT("Unknown or new error"));
                FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, hr, 
                        MAKELANGID(LANG_NEUTRAL, SUBLANG_NEUTRAL), 
                        szErrorDesc, sizeof(szErrorDesc), NULL);
                }
           }  // if FACILITY_WIN32
           else  if (HRESULT_FACILITY(hr) == FACILITY_CONTROL && HRESULT_CODE(hr) >= 600)
           {
                szErrorName[0] = '\0';
                lstrcpy(szErrorDesc, TEXT("This is a FACILITY_CONTROL error that is specific to the control's interface that returned this error. See the documentation of the interface that returned this error for information about this HRESULT."));
           }
           else  if (HRESULT_FACILITY(hr) == FACILITY_ITF && HRESULT_CODE(hr) >= 0x200)
           {
                szErrorName[0] = '\0';
                lstrcpy(szErrorDesc, TEXT("This is a FACILITY_ITF error that is specific to the interface that returned this error. See the documentation of the interface that returned this error for information about this HRESULT."));
           }
           else 
           {
              lstrcpy(szErrorName, TEXT("Unknown or new error"));  // Not FACILITY_WIN32 or FACILITY_ITF(code >= 0x200) or FACILTY_CONTROL(code >= 600)
              FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, hr, 
                             MAKELANGID(LANG_NEUTRAL, SUBLANG_NEUTRAL), 
                             szErrorDesc, sizeof(szErrorDesc), NULL);
           }
    }       
   
    if (bOleError)
         wsprintf(szBuf, TEXT("HRESULT = %lx \r\nFACILITY = %s\n%s"), hr, (LPTSTR)szFacility, (LPTSTR)szErrorName);
    else wsprintf(szBuf, TEXT("ERROR = %ld \r\n%s"), HRESULT_CODE(hr), (LPTSTR)szErrorName);
	SetWindowText(hwndDisplayErrorName, szBuf);
    SetWindowText(hwndDisplayErrorDesc, szErrorDesc);
}



