/*
 *  _ T A G S . H
 *
 *  Property tag definitions for standard properties of MAPI
 *  objects.
 *
 *  The following ranges should be used for all property IDs. Note that
 *  property IDs for objects other than messages and recipients should
 *  all fall in the range 0x3000 to 0x3FFF:
 *
 *  From    To      Kind of property
 *  --------------------------------
 *  0001    0BFF    MAPI_defined envelope property
 *  0C00    0DFF    MAPI_defined per-recipient property
 *  1000    2FFF    MAPI_defined message content property
 *
 *  3000    3FFF    MAPI_defined property (usually not message or recipient)
 *
 *  4000    57FF    Transport-defined envelope property
 *  5800    5FFF    Transport-defined per-recipient property
 *  6800    7BFF    Message class-defined content property
 *                  property
 *
 *  8000    FFFE    User-defined Name-to-id mapped property
 *
 *  The 3000-3FFF range is further subdivided as follows:
 *
 *  From    To      Kind of property
 *  --------------------------------
 *  3000    33FF    Common property such as display name, entry ID
 *  3400    35FF    Message store object
 *  3600    36FF    Folder or AB container
 *  3700    38FF    Attachment
 *  3900    39FF    Address book object
 *  3A00    3BFF    Mail user
 *  3C00    3CFF    Distribution list
 *  3D00    3DFF    Profile section
 *  3E00    3FFF    Status object
 *
 *  Copyright 1993-1995 Microsoft Corporation. All Rights Reserved.
 */

#ifndef _TAGS_H
#define _TAGS_H



/*
 *  Message envelope properties
 */

Pt(PR_ACKNOWLEDGEMENT_MODE),
Pt(PR_ALTERNATE_RECIPIENT_ALLOWED),
Pt(PR_AUTHORIZING_USERS),
Pt(PR_AUTO_FORWARD_COMMENT),
Pt(PR_AUTO_FORWARD_COMMENT_W),
Pt(PR_AUTO_FORWARD_COMMENT_A),
Pt(PR_AUTO_FORWARDED),
Pt(PR_CONTENT_CONFIDENTIALITY_ALGORITHM_ID),
Pt(PR_CONTENT_CORRELATOR),
Pt(PR_CONTENT_IDENTIFIER),
Pt(PR_CONTENT_IDENTIFIER_W),
Pt(PR_CONTENT_IDENTIFIER_A),
Pt(PR_CONTENT_LENGTH),
Pt(PR_CONTENT_RETURN_REQUESTED),



Pt(PR_CONVERSATION_KEY),

Pt(PR_CONVERSION_EITS),
Pt(PR_CONVERSION_WITH_LOSS_PROHIBITED),
Pt(PR_CONVERTED_EITS),
Pt(PR_DEFERRED_DELIVERY_TIME),
Pt(PR_DELIVER_TIME),
Pt(PR_DISCARD_REASON),
Pt(PR_DISCLOSURE_OF_RECIPIENTS),
Pt(PR_DL_EXPANSION_HISTORY),
Pt(PR_DL_EXPANSION_PROHIBITED),
Pt(PR_EXPIRY_TIME),
Pt(PR_IMPLICIT_CONVERSION_PROHIBITED),
Pt(PR_IMPORTANCE),
Pt(PR_IPM_ID),
Pt(PR_LATEST_DELIVERY_TIME),
Pt(PR_MESSAGE_CLASS),
Pt(PR_MESSAGE_CLASS_W),
Pt(PR_MESSAGE_CLASS_A),
Pt(PR_MESSAGE_DELIVERY_ID),





Pt(PR_MESSAGE_SECURITY_LABEL),
Pt(PR_OBSOLETED_IPMS),
Pt(PR_ORIGINALLY_INTENDED_RECIPIENT_NAME),
Pt(PR_ORIGINAL_EITS),
Pt(PR_ORIGINATOR_CERTIFICATE),
Pt(PR_ORIGINATOR_DELIVERY_REPORT_REQUESTED),
Pt(PR_ORIGINATOR_RETURN_ADDRESS),



Pt(PR_PARENT_KEY),
Pt(PR_PRIORITY),



Pt(PR_ORIGIN_CHECK),
Pt(PR_PROOF_OF_SUBMISSION_REQUESTED),
Pt(PR_READ_RECEIPT_REQUESTED),
Pt(PR_RECEIPT_TIME),
Pt(PR_RECIPIENT_REASSIGNMENT_PROHIBITED),
Pt(PR_REDIRECTION_HISTORY),
Pt(PR_RELATED_IPMS),
Pt(PR_ORIGINAL_SENSITIVITY),
Pt(PR_LANGUAGES),
Pt(PR_LANGUAGES_W),
Pt(PR_LANGUAGES_A),
Pt(PR_REPLY_TIME),
Pt(PR_REPORT_TAG),
Pt(PR_REPORT_TIME),
Pt(PR_RETURNED_IPM),
Pt(PR_SECURITY),
Pt(PR_INCOMPLETE_COPY),
Pt(PR_SENSITIVITY),
Pt(PR_SUBJECT),
Pt(PR_SUBJECT_W),
Pt(PR_SUBJECT_A),
Pt(PR_SUBJECT_IPM),
Pt(PR_CLIENT_SUBMIT_TIME),
Pt(PR_REPORT_NAME),
Pt(PR_REPORT_NAME_W),
Pt(PR_REPORT_NAME_A),
Pt(PR_SENT_REPRESENTING_SEARCH_KEY),
Pt(PR_X400_CONTENT_TYPE),
Pt(PR_SUBJECT_PREFIX),
Pt(PR_SUBJECT_PREFIX_W),
Pt(PR_SUBJECT_PREFIX_A),
Pt(PR_NON_RECEIPT_REASON),
Pt(PR_RECEIVED_BY_ENTRYID),
Pt(PR_RECEIVED_BY_NAME),
Pt(PR_RECEIVED_BY_NAME_W),
Pt(PR_RECEIVED_BY_NAME_A),
Pt(PR_SENT_REPRESENTING_ENTRYID),
Pt(PR_SENT_REPRESENTING_NAME),
Pt(PR_SENT_REPRESENTING_NAME_W),
Pt(PR_SENT_REPRESENTING_NAME_A),
Pt(PR_RCVD_REPRESENTING_ENTRYID),
Pt(PR_RCVD_REPRESENTING_NAME),
Pt(PR_RCVD_REPRESENTING_NAME_W),
Pt(PR_RCVD_REPRESENTING_NAME_A),
Pt(PR_REPORT_ENTRYID),
Pt(PR_READ_RECEIPT_ENTRYID),
Pt(PR_MESSAGE_SUBMISSION_ID),
Pt(PR_PROVIDER_SUBMIT_TIME),
Pt(PR_ORIGINAL_SUBJECT),
Pt(PR_ORIGINAL_SUBJECT_W),
Pt(PR_ORIGINAL_SUBJECT_A),
Pt(PR_DISC_VAL),
Pt(PR_ORIG_MESSAGE_CLASS),
Pt(PR_ORIG_MESSAGE_CLASS_W),
Pt(PR_ORIG_MESSAGE_CLASS_A),
Pt(PR_ORIGINAL_AUTHOR_ENTRYID),
Pt(PR_ORIGINAL_AUTHOR_NAME),
Pt(PR_ORIGINAL_AUTHOR_NAME_W),
Pt(PR_ORIGINAL_AUTHOR_NAME_A),
Pt(PR_ORIGINAL_SUBMIT_TIME),
Pt(PR_REPLY_RECIPIENT_ENTRIES),
Pt(PR_REPLY_RECIPIENT_NAMES),
Pt(PR_REPLY_RECIPIENT_NAMES_W),
Pt(PR_REPLY_RECIPIENT_NAMES_A),

Pt(PR_RECEIVED_BY_SEARCH_KEY),
Pt(PR_RCVD_REPRESENTING_SEARCH_KEY),
Pt(PR_READ_RECEIPT_SEARCH_KEY),
Pt(PR_REPORT_SEARCH_KEY),
Pt(PR_ORIGINAL_DELIVERY_TIME),
Pt(PR_ORIGINAL_AUTHOR_SEARCH_KEY),

Pt(PR_MESSAGE_TO_ME),
Pt(PR_MESSAGE_CC_ME),
Pt(PR_MESSAGE_RECIP_ME),

Pt(PR_ORIGINAL_SENDER_NAME),
Pt(PR_ORIGINAL_SENDER_NAME_W),
Pt(PR_ORIGINAL_SENDER_NAME_A),
Pt(PR_ORIGINAL_SENDER_ENTRYID),
Pt(PR_ORIGINAL_SENDER_SEARCH_KEY),
Pt(PR_ORIGINAL_SENT_REPRESENTING_NAME),
Pt(PR_ORIGINAL_SENT_REPRESENTING_NAME_W),
Pt(PR_ORIGINAL_SENT_REPRESENTING_NAME_A),
Pt(PR_ORIGINAL_SENT_REPRESENTING_ENTRYID),
Pt(PR_ORIGINAL_SENT_REPRESENTING_SEARCH_KEY),

Pt(PR_START_DATE),
Pt(PR_END_DATE),
Pt(PR_OWNER_APPT_ID),
Pt(PR_RESPONSE_REQUESTED),

Pt(PR_SENT_REPRESENTING_ADDRTYPE),
Pt(PR_SENT_REPRESENTING_ADDRTYPE_W),
Pt(PR_SENT_REPRESENTING_ADDRTYPE_A),
Pt(PR_SENT_REPRESENTING_EMAIL_ADDRESS),
Pt(PR_SENT_REPRESENTING_EMAIL_ADDRESS_W),
Pt(PR_SENT_REPRESENTING_EMAIL_ADDRESS_A),

Pt(PR_ORIGINAL_SENDER_ADDRTYPE),
Pt(PR_ORIGINAL_SENDER_ADDRTYPE_W),
Pt(PR_ORIGINAL_SENDER_ADDRTYPE_A),
Pt(PR_ORIGINAL_SENDER_EMAIL_ADDRESS),
Pt(PR_ORIGINAL_SENDER_EMAIL_ADDRESS_W),
Pt(PR_ORIGINAL_SENDER_EMAIL_ADDRESS_A),

Pt(PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE),
Pt(PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_W),
Pt(PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_A),
Pt(PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS),
Pt(PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_W),
Pt(PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_A),

Pt(PR_CONVERSATION_TOPIC),
Pt(PR_CONVERSATION_TOPIC_W),
Pt(PR_CONVERSATION_TOPIC_A),
Pt(PR_CONVERSATION_INDEX),

Pt(PR_ORIGINAL_DISPLAY_BCC),
Pt(PR_ORIGINAL_DISPLAY_BCC_W),
Pt(PR_ORIGINAL_DISPLAY_BCC_A),
Pt(PR_ORIGINAL_DISPLAY_CC),
Pt(PR_ORIGINAL_DISPLAY_CC_W),
Pt(PR_ORIGINAL_DISPLAY_CC_A),
Pt(PR_ORIGINAL_DISPLAY_TO),
Pt(PR_ORIGINAL_DISPLAY_TO_W),
Pt(PR_ORIGINAL_DISPLAY_TO_A),

Pt(PR_RECEIVED_BY_ADDRTYPE),
Pt(PR_RECEIVED_BY_ADDRTYPE_W),
Pt(PR_RECEIVED_BY_ADDRTYPE_A),
Pt(PR_RECEIVED_BY_EMAIL_ADDRESS),
Pt(PR_RECEIVED_BY_EMAIL_ADDRESS_W),
Pt(PR_RECEIVED_BY_EMAIL_ADDRESS_A),

Pt(PR_RCVD_REPRESENTING_ADDRTYPE),
Pt(PR_RCVD_REPRESENTING_ADDRTYPE_W),
Pt(PR_RCVD_REPRESENTING_ADDRTYPE_A),
Pt(PR_RCVD_REPRESENTING_EMAIL_ADDRESS),
Pt(PR_RCVD_REPRESENTING_EMAIL_ADDRESS_W),
Pt(PR_RCVD_REPRESENTING_EMAIL_ADDRESS_A),

Pt(PR_ORIGINAL_AUTHOR_ADDRTYPE),
Pt(PR_ORIGINAL_AUTHOR_ADDRTYPE_W),
Pt(PR_ORIGINAL_AUTHOR_ADDRTYPE_A),
Pt(PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS),
Pt(PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_W),
Pt(PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_A),

Pt(PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE),
Pt(PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_W),
Pt(PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_A),
Pt(PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS),
Pt(PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_W),
Pt(PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_A),

Pt(PR_TRANSPORT_MESSAGE_HEADERS),
Pt(PR_TRANSPORT_MESSAGE_HEADERS_W),
Pt(PR_TRANSPORT_MESSAGE_HEADERS_A),

Pt(PR_DELEGATION),



/*
 *  Message content properties
 */

Pt(PR_BODY),
Pt(PR_BODY_W),
Pt(PR_BODY_A),
Pt(PR_REPORT_TEXT),
Pt(PR_REPORT_TEXT_W),
Pt(PR_REPORT_TEXT_A),
Pt(PR_ORIGINATOR_AND_DL_EXPANSION_HISTORY),
Pt(PR_REPORTING_DL_NAME),
Pt(PR_REPORTING_MTA_CERTIFICATE),

/*  Removed PR_REPORT_ORIGIN_AUTHENTICATION_CHECK with DCR 3865, use PR_ORIGIN_CHECK */

Pt(PR_RTF_SYNC_BODY_CRC),
Pt(PR_RTF_SYNC_BODY_COUNT),
Pt(PR_RTF_SYNC_BODY_TAG),
Pt(PR_RTF_SYNC_BODY_TAG_W),
Pt(PR_RTF_SYNC_BODY_TAG_A),
Pt(PR_RTF_COMPRESSED),
Pt(PR_RTF_SYNC_PREFIX_COUNT),
Pt(PR_RTF_SYNC_TRAILING_COUNT),
Pt(PR_ORIGINALLY_INTENDED_RECIP_ENTRYID),

/*
 *  Message recipient properties
 */

Pt(PR_CONTENT_INTEGRITY_CHECK),
Pt(PR_EXPLICIT_CONVERSION),
Pt(PR_IPM_RETURN_REQUESTED),
Pt(PR_MESSAGE_TOKEN),
Pt(PR_NDR_REASON_CODE),
Pt(PR_NDR_DIAG_CODE),
Pt(PR_NON_RECEIPT_NOTIFICATION_REQUESTED),
Pt(PR_DELIVERY_POINT),

Pt(PR_ORIGINATOR_NON_DELIVERY_REPORT_REQUESTED),
Pt(PR_ORIGINATOR_REQUESTED_ALTERNATE_RECIPIENT),
Pt(PR_PHYSICAL_DELIVERY_BUREAU_FAX_DELIVERY),
Pt(PR_PHYSICAL_DELIVERY_MODE),
Pt(PR_PHYSICAL_DELIVERY_REPORT_REQUEST),
Pt(PR_PHYSICAL_FORWARDING_ADDRESS),
Pt(PR_PHYSICAL_FORWARDING_ADDRESS_REQUESTED),
Pt(PR_PHYSICAL_FORWARDING_PROHIBITED),
Pt(PR_PHYSICAL_RENDITION_ATTRIBUTES),
Pt(PR_PROOF_OF_DELIVERY),
Pt(PR_PROOF_OF_DELIVERY_REQUESTED),
Pt(PR_RECIPIENT_CERTIFICATE),
Pt(PR_RECIPIENT_NUMBER_FOR_ADVICE),
Pt(PR_RECIPIENT_NUMBER_FOR_ADVICE_W),
Pt(PR_RECIPIENT_NUMBER_FOR_ADVICE_A),
Pt(PR_RECIPIENT_TYPE),
Pt(PR_REGISTERED_MAIL_TYPE),
Pt(PR_REPLY_REQUESTED),
Pt(PR_REQUESTED_DELIVERY_METHOD),
Pt(PR_SENDER_ENTRYID),
Pt(PR_SENDER_NAME),
Pt(PR_SENDER_NAME_W),
Pt(PR_SENDER_NAME_A),
Pt(PR_SUPPLEMENTARY_INFO),
Pt(PR_SUPPLEMENTARY_INFO_W),
Pt(PR_SUPPLEMENTARY_INFO_A),
Pt(PR_TYPE_OF_MTS_USER),
Pt(PR_SENDER_SEARCH_KEY),
Pt(PR_SENDER_ADDRTYPE),
Pt(PR_SENDER_ADDRTYPE_W),
Pt(PR_SENDER_ADDRTYPE_A),
Pt(PR_SENDER_EMAIL_ADDRESS),
Pt(PR_SENDER_EMAIL_ADDRESS_W),
Pt(PR_SENDER_EMAIL_ADDRESS_A),

/*
 */

/*
 * The two tags, PR_MESSAGE_RECIPIENTS and PR_MESSAGE_ATTACHMENTS,
 * are to be used in the exclude list passed to
 * IMessage::CopyTo when the caller wants either the recipients or attachments
 * of the message to not get copied.  It is also used in the ProblemArray
 * return from IMessage::CopyTo when an error is encountered copying them
 */

Pt(PR_CURRENT_VERSION),
Pt(PR_DELETE_AFTER_SUBMIT),
Pt(PR_DISPLAY_BCC),
Pt(PR_DISPLAY_BCC_W),
Pt(PR_DISPLAY_BCC_A),
Pt(PR_DISPLAY_CC),
Pt(PR_DISPLAY_CC_W),
Pt(PR_DISPLAY_CC_A),
Pt(PR_DISPLAY_TO),
Pt(PR_DISPLAY_TO_W),
Pt(PR_DISPLAY_TO_A),
Pt(PR_PARENT_DISPLAY),
Pt(PR_PARENT_DISPLAY_W),
Pt(PR_PARENT_DISPLAY_A),
Pt(PR_MESSAGE_DELIVERY_TIME),
Pt(PR_MESSAGE_FLAGS),
Pt(PR_MESSAGE_SIZE),
Pt(PR_PARENT_ENTRYID),
Pt(PR_SENTMAIL_ENTRYID),
Pt(PR_CORRELATE),
Pt(PR_CORRELATE_MTSID),
Pt(PR_DISCRETE_VALUES),
Pt(PR_RESPONSIBILITY),
Pt(PR_SPOOLER_STATUS),
Pt(PR_TRANSPORT_STATUS),
Pt(PR_MESSAGE_RECIPIENTS),
Pt(PR_MESSAGE_ATTACHMENTS),
Pt(PR_SUBMIT_FLAGS),
Pt(PR_RECIPIENT_STATUS),
Pt(PR_TRANSPORT_KEY),
Pt(PR_MSG_STATUS),
Pt(PR_MESSAGE_DOWNLOAD_TIME),
Pt(PR_CREATION_VERSION),
Pt(PR_MODIFY_VERSION),
Pt(PR_HASATTACH),
Pt(PR_BODY_CRC),
Pt(PR_NORMALIZED_SUBJECT),
Pt(PR_NORMALIZED_SUBJECT_W),
Pt(PR_NORMALIZED_SUBJECT_A),
Pt(PR_RTF_IN_SYNC),
Pt(PR_ATTACH_SIZE),
Pt(PR_ATTACH_NUM),
Pt(PR_PREPROCESS),

/* PR_ORIGINAL_DISPLAY_TO, _CC, and _BCC moved to transmittible range 03/09/95 */

Pt(PR_ORIGINATING_MTA_CERTIFICATE),
Pt(PR_PROOF_OF_SUBMISSION),


/*
 * The range of non-message and non-recipient property IDs (0x3000 - 0x3FFF) is
 * further broken down into ranges to make assigning new property IDs easier.
 *
 *  From    To      Kind of property
 *  --------------------------------
 *  3000    32FF    MAPI_defined common property
 *  3200    33FF    MAPI_defined form property
 *  3400    35FF    MAPI_defined message store property
 *  3600    36FF    MAPI_defined Folder or AB Container property
 *  3700    38FF    MAPI_defined attachment property
 *  3900    39FF    MAPI_defined address book property
 *  3A00    3BFF    MAPI_defined mailuser property
 *  3C00    3CFF    MAPI_defined DistList property
 *  3D00    3DFF    MAPI_defined Profile Section property
 *  3E00    3EFF    MAPI_defined Status property
 *  3F00    3FFF    MAPI_defined display table property
 */

/*
 *  Properties common to numerous MAPI objects.
 *
 *  Those properties that can appear on messages are in the
 *  end of that range and work down.
 *
 *  Properties that never appear on messages are defined in the common
 *  property range (see above).
 */

/*
 * properties that are common to multiple objects (including message objects)
 */

Pt(PR_ENTRYID),
Pt(PR_OBJECT_TYPE),
Pt(PR_ICON),
Pt(PR_MINI_ICON),
Pt(PR_STORE_ENTRYID),
Pt(PR_STORE_RECORD_KEY),
Pt(PR_RECORD_KEY),
Pt(PR_MAPPING_SIGNATURE),
Pt(PR_ACCESS_LEVEL),
Pt(PR_INSTANCE_KEY),
Pt(PR_ROW_TYPE),
Pt(PR_ACCESS),

/*
 * properties that are common to multiple objects (usually not including message objects)
 */

Pt(PR_ROWID),
Pt(PR_DISPLAY_NAME),
Pt(PR_DISPLAY_NAME_W),
Pt(PR_DISPLAY_NAME_A),
Pt(PR_ADDRTYPE),
Pt(PR_ADDRTYPE_W),
Pt(PR_ADDRTYPE_A),
Pt(PR_EMAIL_ADDRESS),
Pt(PR_EMAIL_ADDRESS_W),
Pt(PR_EMAIL_ADDRESS_A),
Pt(PR_COMMENT),
Pt(PR_COMMENT_W),
Pt(PR_COMMENT_A),
Pt(PR_DEPTH),
Pt(PR_PROVIDER_DISPLAY),
Pt(PR_PROVIDER_DISPLAY_W),
Pt(PR_PROVIDER_DISPLAY_A),
Pt(PR_CREATION_TIME),
Pt(PR_LAST_MODIFICATION_TIME),
Pt(PR_RESOURCE_FLAGS),
Pt(PR_PROVIDER_DLL_NAME),
Pt(PR_PROVIDER_DLL_NAME_W),
Pt(PR_PROVIDER_DLL_NAME_A),
Pt(PR_SEARCH_KEY),
Pt(PR_PROVIDER_UID),
Pt(PR_PROVIDER_ORDINAL),

/*
 *  MAPI Form properties
 */
Pt(PR_FORM_VERSION),
Pt(PR_FORM_VERSION_W),
Pt(PR_FORM_VERSION_A),
Pt(PR_FORM_CLSID),
Pt(PR_FORM_CONTACT_NAME),
Pt(PR_FORM_CONTACT_NAME_W),
Pt(PR_FORM_CONTACT_NAME_A),
Pt(PR_FORM_CATEGORY),
Pt(PR_FORM_CATEGORY_W),
Pt(PR_FORM_CATEGORY_A),
Pt(PR_FORM_CATEGORY_SUB),
Pt(PR_FORM_CATEGORY_SUB_W),
Pt(PR_FORM_CATEGORY_SUB_A),
Pt(PR_FORM_HOST_MAP),
Pt(PR_FORM_HIDDEN),
Pt(PR_FORM_DESIGNER_NAME),
Pt(PR_FORM_DESIGNER_NAME_W),
Pt(PR_FORM_DESIGNER_NAME_A),
Pt(PR_FORM_DESIGNER_GUID),
Pt(PR_FORM_MESSAGE_BEHAVIOR),

/*
 *  Message store properties
 */

Pt(PR_DEFAULT_STORE),
Pt(PR_STORE_SUPPORT_MASK),
Pt(PR_STORE_STATE),

Pt(PR_IPM_SUBTREE_SEARCH_KEY),
Pt(PR_IPM_OUTBOX_SEARCH_KEY),
Pt(PR_IPM_WASTEBASKET_SEARCH_KEY),
Pt(PR_IPM_SENTMAIL_SEARCH_KEY),
Pt(PR_MDB_PROVIDER),
Pt(PR_RECEIVE_FOLDER_SETTINGS),

Pt(PR_VALID_FOLDER_MASK),
Pt(PR_IPM_SUBTREE_ENTRYID),

Pt(PR_IPM_OUTBOX_ENTRYID),
Pt(PR_IPM_WASTEBASKET_ENTRYID),
Pt(PR_IPM_SENTMAIL_ENTRYID),
Pt(PR_VIEWS_ENTRYID),
Pt(PR_COMMON_VIEWS_ENTRYID),
Pt(PR_FINDER_ENTRYID),

/* Proptags 35E8-35FF reserved for folders "guaranteed" by PR_VALID_FOLDER_MASK */


/*
 *  Folder and AB Container properties
 */

Pt(PR_CONTAINER_FLAGS),
Pt(PR_FOLDER_TYPE),
Pt(PR_CONTENT_COUNT),
Pt(PR_CONTENT_UNREAD),
Pt(PR_CREATE_TEMPLATES),
Pt(PR_DETAILS_TABLE),
Pt(PR_SEARCH),
Pt(PR_SELECTABLE),
Pt(PR_SUBFOLDERS),
Pt(PR_STATUS),
Pt(PR_ANR),
Pt(PR_ANR_W),
Pt(PR_ANR_A),
Pt(PR_CONTENTS_SORT_ORDER),
Pt(PR_CONTAINER_HIERARCHY),
Pt(PR_CONTAINER_CONTENTS),
Pt(PR_FOLDER_ASSOCIATED_CONTENTS),
Pt(PR_DEF_CREATE_DL),
Pt(PR_DEF_CREATE_MAILUSER),
Pt(PR_CONTAINER_CLASS),
Pt(PR_CONTAINER_CLASS_W),
Pt(PR_CONTAINER_CLASS_A),
Pt(PR_CONTAINER_MODIFY_VERSION),
Pt(PR_AB_PROVIDER_ID),
Pt(PR_DEFAULT_VIEW_ENTRYID),
Pt(PR_ASSOC_CONTENT_COUNT),

/* Don't use 36FE and 36FF */

/*
 *  Attachment properties
 */

Pt(PR_ATTACHMENT_X400_PARAMETERS),
Pt(PR_ATTACH_DATA_OBJ),
Pt(PR_ATTACH_DATA_BIN),
Pt(PR_ATTACH_ENCODING),
Pt(PR_ATTACH_EXTENSION),
Pt(PR_ATTACH_EXTENSION_W),
Pt(PR_ATTACH_EXTENSION_A),
Pt(PR_ATTACH_FILENAME),
Pt(PR_ATTACH_FILENAME_W),
Pt(PR_ATTACH_FILENAME_A),
Pt(PR_ATTACH_METHOD),
Pt(PR_ATTACH_LONG_FILENAME),
Pt(PR_ATTACH_LONG_FILENAME_W),
Pt(PR_ATTACH_LONG_FILENAME_A),
Pt(PR_ATTACH_PATHNAME),
Pt(PR_ATTACH_PATHNAME_W),
Pt(PR_ATTACH_PATHNAME_A),
Pt(PR_ATTACH_RENDERING),
Pt(PR_ATTACH_TAG),
Pt(PR_RENDERING_POSITION),
Pt(PR_ATTACH_TRANSPORT_NAME),
Pt(PR_ATTACH_TRANSPORT_NAME_W),
Pt(PR_ATTACH_TRANSPORT_NAME_A),
Pt(PR_ATTACH_LONG_PATHNAME),
Pt(PR_ATTACH_LONG_PATHNAME_W),
Pt(PR_ATTACH_LONG_PATHNAME_A),
Pt(PR_ATTACH_MIME_TAG),
Pt(PR_ATTACH_MIME_TAG_W),
Pt(PR_ATTACH_MIME_TAG_A),

/*
 *  AB Object properties
 */

Pt(PR_DISPLAY_TYPE),
Pt(PR_TEMPLATEID),
Pt(PR_PRIMARY_CAPABILITY),

/*
 *  Mail user properties
 */

Pt(PR_ACCOUNT),
Pt(PR_ACCOUNT_W),
Pt(PR_ACCOUNT_A),
Pt(PR_ALTERNATE_RECIPIENT),
Pt(PR_CALLBACK_TELEPHONE_NUMBER),
Pt(PR_CALLBACK_TELEPHONE_NUMBER_W),
Pt(PR_CALLBACK_TELEPHONE_NUMBER_A),
Pt(PR_CONVERSION_PROHIBITED),
Pt(PR_DISCLOSE_RECIPIENTS),
Pt(PR_GENERATION),
Pt(PR_GENERATION_W),
Pt(PR_GENERATION_A),
Pt(PR_GIVEN_NAME),
Pt(PR_GIVEN_NAME_W),
Pt(PR_GIVEN_NAME_A),
Pt(PR_GOVERNMENT_ID_NUMBER),
Pt(PR_GOVERNMENT_ID_NUMBER_W),
Pt(PR_GOVERNMENT_ID_NUMBER_A),
Pt(PR_BUSINESS_TELEPHONE_NUMBER),
Pt(PR_BUSINESS_TELEPHONE_NUMBER_W),
Pt(PR_BUSINESS_TELEPHONE_NUMBER_A),
Pt(PR_OFFICE_TELEPHONE_NUMBER),
Pt(PR_OFFICE_TELEPHONE_NUMBER_W),
Pt(PR_OFFICE_TELEPHONE_NUMBER_A),
Pt(PR_HOME_TELEPHONE_NUMBER),
Pt(PR_HOME_TELEPHONE_NUMBER_W),
Pt(PR_HOME_TELEPHONE_NUMBER_A),
Pt(PR_INITIALS),
Pt(PR_INITIALS_W),
Pt(PR_INITIALS_A),
Pt(PR_KEYWORD),
Pt(PR_KEYWORD_W),
Pt(PR_KEYWORD_A),
Pt(PR_LANGUAGE),
Pt(PR_LANGUAGE_W),
Pt(PR_LANGUAGE_A),
Pt(PR_LOCATION),
Pt(PR_LOCATION_W),
Pt(PR_LOCATION_A),
Pt(PR_MAIL_PERMISSION),
Pt(PR_MHS_COMMON_NAME),
Pt(PR_MHS_COMMON_NAME_W),
Pt(PR_MHS_COMMON_NAME_A),
Pt(PR_ORGANIZATIONAL_ID_NUMBER),
Pt(PR_ORGANIZATIONAL_ID_NUMBER_W),
Pt(PR_ORGANIZATIONAL_ID_NUMBER_A),
Pt(PR_SURNAME),
Pt(PR_SURNAME_W),
Pt(PR_SURNAME_A),
Pt(PR_ORIGINAL_ENTRYID),
Pt(PR_ORIGINAL_DISPLAY_NAME),
Pt(PR_ORIGINAL_DISPLAY_NAME_W),
Pt(PR_ORIGINAL_DISPLAY_NAME_A),
Pt(PR_ORIGINAL_SEARCH_KEY),
Pt(PR_POSTAL_ADDRESS),
Pt(PR_POSTAL_ADDRESS_W),
Pt(PR_POSTAL_ADDRESS_A),
Pt(PR_COMPANY_NAME),
Pt(PR_COMPANY_NAME_W),
Pt(PR_COMPANY_NAME_A),
Pt(PR_TITLE),
Pt(PR_TITLE_W),
Pt(PR_TITLE_A),
Pt(PR_DEPARTMENT_NAME),
Pt(PR_DEPARTMENT_NAME_W),
Pt(PR_DEPARTMENT_NAME_A),
Pt(PR_OFFICE_LOCATION),
Pt(PR_OFFICE_LOCATION_W),
Pt(PR_OFFICE_LOCATION_A),
Pt(PR_PRIMARY_TELEPHONE_NUMBER),
Pt(PR_PRIMARY_TELEPHONE_NUMBER_W),
Pt(PR_PRIMARY_TELEPHONE_NUMBER_A),
Pt(PR_BUSINESS2_TELEPHONE_NUMBER),
Pt(PR_BUSINESS2_TELEPHONE_NUMBER_W),
Pt(PR_BUSINESS2_TELEPHONE_NUMBER_A),
Pt(PR_OFFICE2_TELEPHONE_NUMBER),
Pt(PR_OFFICE2_TELEPHONE_NUMBER_W),
Pt(PR_OFFICE2_TELEPHONE_NUMBER_A),
Pt(PR_MOBILE_TELEPHONE_NUMBER),
Pt(PR_MOBILE_TELEPHONE_NUMBER_W),
Pt(PR_MOBILE_TELEPHONE_NUMBER_A),
Pt(PR_CELLULAR_TELEPHONE_NUMBER),
Pt(PR_CELLULAR_TELEPHONE_NUMBER_W),
Pt(PR_CELLULAR_TELEPHONE_NUMBER_A),
Pt(PR_RADIO_TELEPHONE_NUMBER),
Pt(PR_RADIO_TELEPHONE_NUMBER_W),
Pt(PR_RADIO_TELEPHONE_NUMBER_A),
Pt(PR_CAR_TELEPHONE_NUMBER),
Pt(PR_CAR_TELEPHONE_NUMBER_W),
Pt(PR_CAR_TELEPHONE_NUMBER_A),
Pt(PR_OTHER_TELEPHONE_NUMBER),
Pt(PR_OTHER_TELEPHONE_NUMBER_W),
Pt(PR_OTHER_TELEPHONE_NUMBER_A),
Pt(PR_TRANSMITABLE_DISPLAY_NAME),
Pt(PR_TRANSMITABLE_DISPLAY_NAME_W),
Pt(PR_TRANSMITABLE_DISPLAY_NAME_A),
Pt(PR_PAGER_TELEPHONE_NUMBER),
Pt(PR_PAGER_TELEPHONE_NUMBER_W),
Pt(PR_PAGER_TELEPHONE_NUMBER_A),
Pt(PR_BEEPER_TELEPHONE_NUMBER),
Pt(PR_BEEPER_TELEPHONE_NUMBER_W),
Pt(PR_BEEPER_TELEPHONE_NUMBER_A),
Pt(PR_USER_CERTIFICATE),
Pt(PR_PRIMARY_FAX_NUMBER),
Pt(PR_PRIMARY_FAX_NUMBER_W),
Pt(PR_PRIMARY_FAX_NUMBER_A),
Pt(PR_BUSINESS_FAX_NUMBER),
Pt(PR_BUSINESS_FAX_NUMBER_W),
Pt(PR_BUSINESS_FAX_NUMBER_A),
Pt(PR_HOME_FAX_NUMBER),
Pt(PR_HOME_FAX_NUMBER_W),
Pt(PR_HOME_FAX_NUMBER_A),
Pt(PR_COUNTRY),
Pt(PR_COUNTRY_W),
Pt(PR_COUNTRY_A),
Pt(PR_LOCALITY),
Pt(PR_LOCALITY_W),
Pt(PR_LOCALITY_A),
Pt(PR_STATE_OR_PROVINCE),
Pt(PR_STATE_OR_PROVINCE_W),
Pt(PR_STATE_OR_PROVINCE_A),
Pt(PR_STREET_ADDRESS),
Pt(PR_STREET_ADDRESS_W),
Pt(PR_STREET_ADDRESS_A),
Pt(PR_POSTAL_CODE),
Pt(PR_POSTAL_CODE_W),
Pt(PR_POSTAL_CODE_A),
Pt(PR_POST_OFFICE_BOX),
Pt(PR_POST_OFFICE_BOX_W),
Pt(PR_POST_OFFICE_BOX_A),
Pt(PR_TELEX_NUMBER),
Pt(PR_TELEX_NUMBER_W),
Pt(PR_TELEX_NUMBER_A),
Pt(PR_ISDN_NUMBER),
Pt(PR_ISDN_NUMBER_W),
Pt(PR_ISDN_NUMBER_A),
Pt(PR_ASSISTANT_TELEPHONE_NUMBER),
Pt(PR_ASSISTANT_TELEPHONE_NUMBER_W),
Pt(PR_ASSISTANT_TELEPHONE_NUMBER_A),
Pt(PR_HOME2_TELEPHONE_NUMBER),
Pt(PR_HOME2_TELEPHONE_NUMBER_W),
Pt(PR_HOME2_TELEPHONE_NUMBER_A),
Pt(PR_ASSISTANT),
Pt(PR_ASSISTANT_W),
Pt(PR_ASSISTANT_A),
Pt(PR_SEND_RICH_INFO),

/*
 *  Profile section properties
 */

Pt(PR_STORE_PROVIDERS),
Pt(PR_AB_PROVIDERS),
Pt(PR_TRANSPORT_PROVIDERS),

Pt(PR_DEFAULT_PROFILE),
Pt(PR_AB_SEARCH_PATH),
Pt(PR_AB_DEFAULT_DIR),
Pt(PR_AB_DEFAULT_PAB),
Pt(PR_FILTERING_HOOKS),
Pt(PR_SERVICE_NAME),
Pt(PR_SERVICE_NAME_W),
Pt(PR_SERVICE_NAME_A),
Pt(PR_SERVICE_DLL_NAME),
Pt(PR_SERVICE_DLL_NAME_W),
Pt(PR_SERVICE_DLL_NAME_A),
Pt(PR_SERVICE_ENTRY_NAME),
Pt(PR_SERVICE_UID),
Pt(PR_SERVICE_EXTRA_UIDS),
Pt(PR_SERVICES),
Pt(PR_SERVICE_SUPPORT_FILES),
Pt(PR_SERVICE_SUPPORT_FILES_W),
Pt(PR_SERVICE_SUPPORT_FILES_A),
Pt(PR_SERVICE_DELETE_FILES),
Pt(PR_SERVICE_DELETE_FILES_W),
Pt(PR_SERVICE_DELETE_FILES_A),
Pt(PR_AB_SEARCH_PATH_UPDATE),
Pt(PR_PROFILE_NAME),
Pt(PR_PROFILE_NAME_A),
Pt(PR_PROFILE_NAME_W),

/*
 *  Status object properties
 */

Pt(PR_IDENTITY_DISPLAY),
Pt(PR_IDENTITY_DISPLAY_W),
Pt(PR_IDENTITY_DISPLAY_A),
Pt(PR_IDENTITY_ENTRYID),
Pt(PR_RESOURCE_METHODS),
Pt(PR_RESOURCE_TYPE),
Pt(PR_STATUS_CODE),
Pt(PR_IDENTITY_SEARCH_KEY),
Pt(PR_OWN_STORE_ENTRYID),
Pt(PR_RESOURCE_PATH),
Pt(PR_RESOURCE_PATH_W),
Pt(PR_RESOURCE_PATH_A),
Pt(PR_STATUS_STRING),
Pt(PR_STATUS_STRING_W),
Pt(PR_STATUS_STRING_A),
Pt(PR_X400_DEFERRED_DELIVERY_CANCEL),
Pt(PR_HEADER_FOLDER_ENTRYID),
Pt(PR_REMOTE_PROGRESS),
Pt(PR_REMOTE_PROGRESS_TEXT),
Pt(PR_REMOTE_PROGRESS_TEXT_W),
Pt(PR_REMOTE_PROGRESS_TEXT_A),
Pt(PR_REMOTE_VALIDATE_OK),

/*
 * Display table properties
 */

Pt(PR_CONTROL_FLAGS),
Pt(PR_CONTROL_STRUCTURE),
Pt(PR_CONTROL_TYPE),
Pt(PR_DELTAX),
Pt(PR_DELTAY),
Pt(PR_XPOS),
Pt(PR_YPOS),
Pt(PR_CONTROL_ID),
Pt(PR_INITIAL_DETAILS_PANE),

/*
 * Secure property id range
 */



#endif  /* _TAGS_H */
