#****************************************************************************
#
#  Work Place Shell Sample makefile
#
#  Copyright (C) 1992 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#****************************************************************************

!include ..\toolkit.inc

#****************************************************************************
#  Dot directive definition area (usually just suffixes)
#****************************************************************************

.SUFFIXES:
.SUFFIXES: .obj .dll .c .ih .csc .sc .h .ph .psc .rc .res

#****************************************************************************
#  Environment Setup for the component(s).
#****************************************************************************

SOMTEMP = .\somtemp
SCPATH  = ..\..\..\..\h\os2
HPATH   = ..\..\..\..\h\os2
LIBPATH = ..\..\..\..\lib386\os2

.before
    set SMINCLUDE=.;$(SCPATH);
    set SMTMP=$(SOMTEMP)
    set SMEMIT=ih;h;ph;psc;sc;c
    if not exist $(SOMTEMP) md $(SOMTEMP)

#
# Compiler/tools Macros
#

LINK    = WLINK
DLLLIBS = som.lib

#****************************************************************************
# Set up Macros that will contain all the different dependencies for the
# executables and dlls etc. that are generated.
#****************************************************************************

OBJS = car.obj

#****************************************************************************
#   Setup the inference rules for compiling source code to
#   object code.
#****************************************************************************

.c.obj:
        $(CC) -I$(HPATH) /bd $<

.csc.ih:
        sc -v -r $*.csc

all: car.dll .symbolic
    @%null

#
# Specific Process Tag
#

car.ih:   car.csc $(HPATH)\wpdataf.h

car.obj: car.c car.ih car.h  car.sc $(HPATH)\wpdataf.h

car.dll: car.lnk $(OBJS) car.res
	 wlink sys os2v2 dll initinstance file {$(OBJS)} @car lib {$(DLLLIBS)}
         rc -p -x $*.res $*.dll

car.res: car.rc car.ih
         rc -r $*.rc $*.res
