#===================================================================
#   Npipe.mak - Make file for named pipe sample
#   Copyright 1992 IBM Corporation
#
#===================================================================

!include ..\toolkit.inc

SVR_HEADERS = svrpmain.h svrpxtrn.h svrpglbl.h svrphelp.h namepipe.h
CLI_HEADERS = clnpmain.h clnpxtrn.h clnpglbl.h clnphelp.h namepipe.h


#-------------------------------------------------------------------
#   A list of all of the object files
#-------------------------------------------------------------------

SVR_OBJ = svrpmain.obj svrpthrd.obj svrppnt.obj svrpgame.obj svrphelp.obj
CLI_OBJ = clnpmain.obj clnpthrd.obj clnphelp.obj


#-------------------------------------------------------------------
#   A list of all of the Help text files
#-------------------------------------------------------------------

SVR_IPF = svrnpipe.ipf file.ipf svroptn.ipf help.ipf dlg.ipf
CLI_IPF = clinpipe.ipf clifile.ipf clioptn.ipf help.ipf clidlg.ipf


#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------

all: svrnpipe.exe svrnpipe.hlp clinpipe.exe clinpipe.hlp .symbolic
    @%null

#===================================================================
#
# Dependencies
#
#   This section lists all object files needed to be built for the
#   application, along with the files it is dependent upon (e.g. its
#   source and any header files).
#
#===================================================================

svrpmain.res: svrpmain.rc namepipe.ico svrpmain.h svrphelp.rc svrphelp.h

svrpmain.obj: svrpmain.c $(SVR_HEADERS)

svrpthrd.obj: svrpthrd.c $(SVR_HEADERS)

svrpgame.obj: svrpgame.c $(SVR_HEADERS)

svrppnt.obj:  svrppnt.c  $(SVR_HEADERS)

svrphelp.obj: svrphelp.c $(SVR_HEADERS)

clnpmain.res: clnpmain.rc namepipe.ico clnpmain.h clnphelp.rc clnphelp.h

clnpmain.obj: clnpmain.c $(CLI_HEADERS)

clnpthrd.obj: clnpthrd.c $(CLI_HEADERS)

clnphelp.obj: clnphelp.c $(CLI_HEADERS)

#-------------------------------------------------------------------
#   This section creates the help manager file.  The IPF compiler
#   creates a file called main.hlp which is renamed to template.hlp.
#-------------------------------------------------------------------

svrnpipe.hlp: $(SVR_IPF)
clinpipe.hlp: $(CLI_IPF)

#-------------------------------------------------------------------
#   This section links the object modules into the finished program
#   using the linker command file created earlier.  At the end, the
#   resource file is bound to the application.
#-------------------------------------------------------------------

svrnpipe.exe: $(SVR_OBJ) svrphelp.obj svrnpipe.lnk svrnpipe.res
    $(LINK) @svrnpipe.lnk
    rc -p -x svrnpipe.res svrnpipe.exe


clinpipe.exe: $(CLI_OBJ) clnphelp.obj clinpipe.lnk clinpipe.res
    $(LINK) @clinpipe.lnk
    rc -p -x clinpipe.res clinpipe.exe
