#===================================================================
#
# Makefile for IPF Sample
# Created by IBM Corporation 1991
#
#===================================================================

.SUFFIXES:
.SUFFIXES: .dll .obj .c .h .inf .ipf .res .rc .ico .bmp

#===================================================================
#
# Default compilation macros for sample programs
#===================================================================

CC      = wcc386 /W3

LFLAGS  =
LINK    = wlink $(LFLAGS)

#===================================================================
#
# Rules for generating object, linker response and definition files
#
#===================================================================

.c.obj:
    $(CC) -bd $*.c

.rc.res:
        rc -r $*.rc

.ipf.inf:
        ipfc /inf $*.ipf

#===================================================================

all: ipf.dll ipf.inf .symbolic
    @%null

#
# Create .DLL file
#

ipf.dll: ipf.obj ipf.res
         $(LINK) @ipf.lnk
         rc -p -x ipf.res ipf.dll

#
# Create .RES file
#

ipf.res: ipf.rc ipf.ico ipf.h &
         frame1.bmp frame2.bmp frame3.bmp frame4.bmp frame5.bmp

#
# Create .OBJ file
#

ipf.obj: ipf.c ipf.h

#
# Create .INF file
#

ipf.inf: ipf.ipf

