#===================================================================
#
#   DLLAPI.MAK - DLL Application Make file
#   (C) Copyright IBM Corporation 1992.
#
#===================================================================

!include ..\toolkit.inc

HEADERS = dllapi.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
ALL_OBJS = dllapi.obj dlapi_in.obj dlapi_hp.obj dlapi_dg.obj

ALL_IPF = dllapi.ipf

#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------
all: dllapi.exe dllapi.hlp dllib.dll .SYMBOLIC
    @%null

#-------------------------------------------------------------------
#   Dependencies
#     This section lists all object files needed to be built for the
#     application, along with the files it is dependent upon (e.g.
#     its source and any header files).
#-------------------------------------------------------------------
dllapi.res: dllapi.rc $(HEADERS) dllapi.dlg dllapi.ico

dllapi.hlp: $(ALL_IPF)

dllapi.obj: dllapi.c $(HEADERS)

dlapi_dg.obj: dlapi_dg.c $(HEADERS)

dlapi_in.obj: dlapi_in.c $(HEADERS)

dlapi_hp.obj: dlapi_hp.c $(HEADERS)


dllapi.exe: $(ALL_OBJS) dllapi.res dllapi.lnk
    $(LINK) @dllapi.lnk
    rc -p -x dllapi.res dllapi.exe


#===================================================================
#
#   DLLIB.MAK - Dynamic Linking Library Make file
#   (C) Copyright IBM Corporation 1992.
#
#===================================================================
LIBHEADERS  = dllib.h

#===================================================================
#
#   A list of all of the object files
#
#===================================================================
DLL_OBJS = dllib.obj

#-------------------------------------------------------------------
#   This section lists all files to be built by the make.  The
#   makefile builds the executible as well as its associated help
#   file.
#-------------------------------------------------------------------
dllib.obj : dllib.c $(LIBHEADERS)
  wcc386 -bd -s -D__MIG_LIB__ dllib.c

#-------------------------------------------------------------------
#   Dependencies
#     This section lists all object files needed to be built for the
#     application, along with the files it is dependent upon (e.g.
#     its source and any header files).
#-------------------------------------------------------------------
dllib.obj : dllib.c $(LIBHEADERS)

dllib.dll: $(DLL_OBJS) dllib.lnk
    $(LINK) @dllib.lnk
