// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992-1995 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and related
// electronic documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.

#include "stdafx.h"

#ifdef AFX_OLE5_SEG
#pragma code_seg(AFX_OLE5_SEG)
#endif

// Note: because of the nature of these functions, it is not possible
//  to create a 'C' or 'C++' version of them.  These functions are used
//  for the lowest level of the OLE IDispatch implementation, and need
//  to be ported to each supported platform.

extern "C" {

/////////////////////////////////////////////////////////////////////////////
// Intel 386 version

#ifdef _X86_

#ifdef __WATCOMC__
    #pragma off (check_stack)

__declspec(naked) void
_AfxDispatchCall(AFX_PMSG /*pfn*/, void* /*pArgs*/, UINT /*nSizeArgs*/)
{
    _asm {
    #ifdef __SW_3S
		"pop    ecx"		/* ecx = return address */ 
		"pop    edi"		/* edi = pfn thunk */ 
		"pop    edx"		/* discard pfn this offset */ 
		"pop    edx"		/* discard pfn vb adjust */ 
		"pop    edx"		/* ecx = pArgs */ 
		"mov    esp,edx"	/* esp = pArgs (usually already correct) */ 
		"call   edi"		/* call pfn thunk */ 
		"push   ecx"		/* setup return address */ 
		"jmp    eax"		/* call pfn */ 
		"ret"
    #else //__SW_3R
		"pop    ecx"		/* ecx = return address */ 
		"pop    edi"		/* edi = pfn thunk */ 
		"pop    edx"		/* discard pfn this offset */ 
		"pop    edx"		/* discard pfn vb adjust */ 
		"pop    edx"		/* edx = pArgs */ 
		"mov    esp,edx"	/* esp = pArgs (usually already correct) */ 
		"pop    esi"		/* esi = structure return ptr */ 
		"mov    eax,[esp]"	/* eax = this ptr */ 
		"call   edi"		/* call pfn thunk */ 
		"mov    edi,eax"	/* save pfn */ 
		"pop    eax"		/* eax = this ptr */ 
		"pop    edx"		/* edx = parm 1 */ 
		"pop    ebx"		/* ebx = parm 2 */ 
		"xchg   ecx,[esp]"	/* ecx = parm 3 */ 
		"jmp    edi"		/* call pfn */ 
		"ret"
    #endif // __SW_3S
    } /* _asm */
} /* _AfxDispatchCall() */

    #pragma aux _AfxDispatchCall parm caller [] modify [eax edx ebx ecx edi esi];
    #pragma on (check_stack)
#else //!__WATCOMC__
__declspec(naked) void AFXAPI
_AfxDispatchCall(AFX_PMSG /*pfn*/, void* /*pArgs*/, UINT /*nSizeArgs*/)
{
	_asm
	{
		pop     edx         // edx = return address
		pop     eax         // eax = pfn
		pop     ecx         // ecx = pArgs
		add     ecx,[esp]   // ecx += nSizeArgs (=scratch area)
		mov     [ecx],edx   // scratch[0] = return address
		sub     ecx,[esp]   // ecx = pArgs (again)
		mov     esp,ecx     // esp = pArgs (usually already correct)
		pop     ecx         // ecx = this pointer (the CCmdTarget*)
		call    eax         // call member function
		ret                 // esp[0] should = scratch[0] = return address
	}
}
#endif // __WATCOMC__
#endif // _X86_

/////////////////////////////////////////////////////////////////////////////
// MIPS R4000 version

#ifdef _MIPS_

extern "C" void _asm(char *, ...);
void AFXAPI
_AfxDispatchCall(AFX_PMSG /*pfn*/, void* /*pArgs*/, UINT /*nSizeArgs*/)
{
	_asm("addiu     %sp,%a1,0x0");      // sp = pArgs
	_asm("addiu     %t6,%a0,0x0");      // t6 = pfn (save it)
	_asm("lw        %a0,0x0(%sp)");     // a0 = param0
	_asm("lw        %a1,0x4(%sp)");     // a1 = param1
	_asm("lw        %a2,0x8(%sp)");     // a2 = param2
	_asm("lw        %a3,0xc(%sp)");     // a3 = param3
	_asm("j         %t6");              // ip = pfn (jump to target function)
}

#endif // _MIPS_

/////////////////////////////////////////////////////////////////////////////
// DEC Alpha AXP version

#ifdef _ALPHA_

// Note: ALPHA version is in src\alpha\olecall_.s

// The ALPHA compiler does not support inline assembly, so it
//  must be build separately with the ASAXP assembler.

#endif // _ALPHA_

/////////////////////////////////////////////////////////////////////////////
// 680x0 version

#ifdef _68K_

// Note: Mac68k version is in src\m68k\olecall.obj

// The 68k compiler does not support inline assembly, so it
//  has been build separate and included as an object


#endif // _68K_

/////////////////////////////////////////////////////////////////////////////
// PowerMac version

#ifdef _MPPC_

// Note: MacPPC version is in src\mppc\olecall.obj

// The Mac PowerPC compiler does not support inline assembly, so it
//  has been build separate and included as an object

#endif // _MPPC_


} // end extern "C" block

/////////////////////////////////////////////////////////////////////////////
