/*
 *  Copyright by WATCOM International Corp. 1988-1996.  All rights reserved.

   Special include for 32-bit Windows 3.x

 */
#ifndef ___WIN386_INCLUDED__
#define ___WIN386_INCLUDED__
#if !defined(_ENABLE_AUTODEPEND)
  #pragma read_only_file;
#endif
#ifdef __cplusplus
extern "C" {
#endif

#ifndef RC_INVOKED
#include <stddef.h>
#endif

#ifdef __WINDOWS_386__
#ifndef NOAUTOPROCS
typedef void __far *REALFARPROC;
#endif
#define int short
#define __huge
#define __far
#define __export

#define NOMINMAX
#include <win16.h>
#ifndef NOCOVERSENDS
#define SendMessage _Cover_SendMessage
#define SendDlgItemMessage _Cover_SendDlgItemMessage
#endif
#ifndef NOCOVERRC
#define RegisterClass _Cover_RegisterClass
#endif
#ifndef NOAUTOPROCS
#define CreateDialog 			_Cover_CreateDialog
#define CreateDialogIndirect 		_Cover_CreateDialogIndirect
#define CreateDialogParam 		_Cover_CreateDialogParam
#define CreateDialogIndirectParam 	_Cover_CreateDialogIndirectParam
#define DialogBox 			_Cover_DialogBox
#define DialogBoxIndirect 		_Cover_DialogBoxIndirect
#define DialogBoxParam 			_Cover_DialogBoxParam
#define DialogBoxIndirectParam 		_Cover_DialogBoxIndirectParam
#define EnumChildWindows 		_Cover_EnumChildWindows
#define EnumFonts 			_Cover_EnumFonts
#define EnumFontFamilies		_Cover_EnumFontFamilies
#define EnumMetaFile 			_Cover_EnumMetaFile
#define EnumObjects 			_Cover_EnumObjects
#define EnumProps 			_Cover_EnumProps
#define EnumTaskWindows 		_Cover_EnumTaskWindows
#define EnumWindows 			_Cover_EnumWindows
#define Escape	 			_Cover_Escape
#define FreeProcInstance 		_Cover_FreeProcInstance
#define GetClassLong 			_Cover_GetClassLong
#define GetWindowLong 			_Cover_GetWindowLong
#define GlobalNotify 			_Cover_GlobalNotify
#define GrayString 			_Cover_GrayString
#define LineDDA 			_Cover_LineDDA
#define MakeProcInstance 		_Cover_MakeProcInstance
#define SetClassLong 			_Cover_SetClassLong
#define SetResourceHandler 		_Cover_SetResourceHandler
#define SetTimer 			_Cover_SetTimer
#define SetWindowsHook 			_Cover_SetWindowsHook
#define SetWindowsHookEx		_Cover_SetWindowsHookEx
#define SetWindowLong 			_Cover_SetWindowLong
#endif
#else
#include <win16.h>
#endif
#define API WINAPI

#ifndef NOKERNEL
FARPROC API _16MakeProcInstance(FARPROC, HANDLE);
#if !defined(NOAUTOPROCS) && defined(__WINDOWS_386__)
FARPROC API _Cover_MakeProcInstance(REALFARPROC, HANDLE);
#endif
void	API _16FreeProcInstance(FARPROC);
void	API _Cover_FreeProcInstance(FARPROC);
void    API _16GetCodeInfo(FARPROC lpProc, LPVOID lpSegInfo);
HANDLE  API _16GetModuleHandle(LPSTR);
int     API _16GetModuleFileName(HANDLE, LPSTR, int);
int     API _16GetInstanceData(HANDLE, NPSTR, int);
FARPROC API _16GetProcAddress(HANDLE, LPSTR);
HANDLE  API _16LoadLibrary(LPSTR);
HANDLE  API _16LoadModule(LPSTR, LPVOID);
WORD    API _16WinExec(LPSTR, WORD);
void    API _16OutputDebugString(LPSTR);
#ifndef NOOPENFILE
int  API _16OpenFile(LPSTR, LPOFSTRUCT, WORD);
int  API _16GetTempFileName(BYTE, LPSTR, WORD, LPSTR);
#endif /* NOOPENFILE */
HANDLE API _16FindResource(HANDLE, LPSTR, LPSTR);
FARPROC API _16SetResourceHandler(HANDLE, LPSTR, FARPROC);
FARPROC API _Cover_SetResourceHandler(HANDLE, LPSTR, FARPROC);
#ifndef NOATOM
ATOM   API _16AddAtom(LPSTR);
ATOM   API _16FindAtom(LPSTR);
WORD   API _16GetAtomName(ATOM, LPSTR, int);
ATOM   API _16GlobalAddAtom(LPSTR);
ATOM   API _16GlobalFindAtom(LPSTR);
WORD   API _16GlobalGetAtomName(ATOM, LPSTR, int);
#endif /* NOATOM */
WORD API _16GetProfileInt(LPSTR, LPSTR, int);
int  API _16GetProfileString(LPSTR, LPSTR, LPSTR, LPSTR, int);
BOOL API _16WriteProfileString(LPSTR, LPSTR, LPSTR);
WORD API _16GetPrivateProfileInt(LPSTR, LPSTR, int, LPSTR);
int  API _16GetPrivateProfileString(LPSTR, LPSTR, LPSTR, LPSTR, int, LPSTR);
BOOL API _16WritePrivateProfileString(LPSTR, LPSTR, LPSTR, LPSTR);
WORD API _16GetWindowsDirectory(LPSTR,WORD);
WORD API _16GetSystemDirectory(LPSTR,WORD);
int   API _16AnsiToOem(LPSTR, LPSTR);
BOOL  API _16OemToAnsi(LPSTR, LPSTR);
void  API _16AnsiToOemBuff(LPSTR, LPSTR, int);
void  API _16OemToAnsiBuff(LPSTR, LPSTR, int);
LPSTR API _16AnsiUpper(LPSTR);
WORD  API _16AnsiUpperBuff(LPSTR, WORD);
LPSTR API _16AnsiLower(LPSTR);
WORD  API _16AnsiLowerBuff(LPSTR, WORD);
LPSTR API _16AnsiNext(LPSTR);
LPSTR API _16AnsiPrev(LPSTR, LPSTR);
#ifndef NOKEYBOARDINFO
int   API _16GetKeyNameText(LONG, LPSTR, int);
int   API _16ToAscii(WORD wVirtKey, WORD wScanCode, LPSTR lpKeyState, LPVOID lpChar, WORD wFlags);
#endif /* NOKEYBOARDINFO */
#ifndef NOMEMMGR
VOID API _16GlobalNotify(FARPROC);
VOID API _Cover_GlobalNotify(FARPROC);
#endif /* NOMEMMGR */

#endif /* NOKERNEL */

#ifndef NOGDI
#ifndef NODRAWTEXT
int  API _16DrawText(HDC, LPSTR, int, LPRECT, WORD);
#endif /* NODRAWTEXT */
HDC   API _16CreateDC(LPSTR, LPSTR, LPSTR, LPSTR);
HDC   API _16CreateIC(LPSTR, LPSTR, LPSTR, LPSTR);
BOOL API _16ExtTextOut(HDC, int, int, WORD, LPRECT, LPSTR, WORD, LPINT);
BOOL API _16Polyline(HDC, LPPOINT, int);
BOOL API _16Polygon(HDC, LPPOINT, int);
BOOL API _16PolyPolygon(HDC, LPPOINT, LPINT, int);
BOOL  API _16TextOut(HDC, int, int, LPSTR, int);
LONG  API _16TabbedTextOut(HDC, int, int, LPSTR, int, int, LPINT, int);
BOOL  API _16GetCharWidth(HDC, WORD, WORD, LPINT);
void  API _16LineDDA(int, int, int, int, FARPROC, LPARAM);
void  API _Cover_LineDDA(int, int, int, int, FARPROC, LPARAM);
HPEN API _16CreatePenIndirect( LPLOGPEN );
HBRUSH API _16CreateBrushIndirect( LPLOGBRUSH );
HBITMAP API _16CreateBitmap(int, int, UINT, UINT, LPSTR);
HBITMAP API _16CreateBitmapIndirect( LPBITMAP );
HBITMAP API _16CreateDIBitmap(HDC, LPBITMAPINFOHEADER, DWORD, LPSTR, LPBITMAPINFO, UINT);
LONG  API _16SetBitmapBits(HBITMAP, DWORD, LPSTR);
LONG  API _16GetBitmapBits(HBITMAP, LONG, LPSTR);
HFONT API _16CreateFont(int, int, int, int, int, BYTE, BYTE, BYTE, BYTE, BYTE, BYTE, BYTE, BYTE, LPSTR);
HFONT API _16CreateFontIndirect( LPLOGFONT );
HRGN API _16CreateRectRgnIndirect(LPRECT);
HRGN API _16CreateEllipticRgnIndirect(LPRECT);
HRGN API _16CreatePolygonRgn(LPPOINT, int, int);
HRGN API _16CreatePolyPolygonRgn(LPPOINT, LPINT, int, int);
int    API _16GetObject(HANDLE, int, LPSTR);
int  API _16GetClipBox(HDC, LPRECT);
int  API _16GetRgnBox(HRGN, LPRECT);
DWORD API _16GetTextExtent(HDC, LPSTR, int);
DWORD API _16GetTabbedTextExtent(HDC, LPSTR, int, int, LPINT);
HANDLE API _16GetMetaFile(LPSTR);
HANDLE API _16CopyMetaFile(HANDLE, LPSTR);
#ifndef NOMETAFILE
void API _16PlayMetaFileRecord(HDC, LPHANDLETABLE, LPMETARECORD, WORD);
BOOL API _16EnumMetaFile(HDC, LOCALHANDLE, FARPROC, LPSTR );
BOOL API _Cover_EnumMetaFile(HDC, LOCALHANDLE, FARPROC, LPSTR );
#endif
int API _16Escape(HDC, int, int, LPSTR, LPSTR);
int API _Cover_Escape(HDC, int, int, LPSTR, LPSTR);
int API _16EnumFonts(HDC, LPSTR, FARPROC, LPSTR);
int API _Cover_EnumFonts(HDC, LPSTR, FARPROC, LPSTR);
int API _Cover_EnumFontFamilies(HDC, LPSTR, FARPROC, LPSTR);
int API _16EnumObjects(HDC, int, FARPROC, LPSTR);
int API _Cover_EnumObjects(HDC, int, FARPROC, LPSTR);
int API _16GetTextFace(HDC, int, LPSTR);
#ifndef NOTEXTMETRIC
BOOL API _16GetTextMetrics(HDC, LPTEXTMETRIC );
#endif /* NOTEXTMETRIC */
int API _16SetEnvironment(LPSTR, LPSTR, WORD);
int API _16GetEnvironment(LPSTR, LPSTR, WORD);
BOOL API _16DPtoLP(HDC, LPPOINT, int);
BOOL API _16LPtoDP(HDC, LPPOINT, int);
HANDLE API _16CreateMetaFile(LPSTR);
int API _16SetDIBits(HDC,HANDLE,WORD,WORD,LPSTR,LPBITMAPINFO,WORD);
int API _16GetDIBits(HDC,HANDLE,WORD,WORD,LPSTR,LPBITMAPINFO,WORD);
int API _16SetDIBitsToDevice(HDC,WORD,WORD,WORD,WORD,
					WORD,WORD,WORD,WORD,
					LPSTR,LPBITMAPINFO,WORD);
int API _16StretchDIBits(HDC, WORD, WORD, WORD, WORD, WORD, WORD, WORD, WORD, LPSTR, LPBITMAPINFO, WORD, DWORD);
HPALETTE API _16CreatePalette (LPLOGPALETTE);
void API _16AnimatePalette(HPALETTE, WORD, WORD, LPPALETTEENTRY);
WORD API _16SetPaletteEntries(HPALETTE,WORD,WORD,LPPALETTEENTRY);
WORD API _16GetPaletteEntries(HPALETTE,WORD,WORD,LPPALETTEENTRY);
WORD API _16GetSystemPaletteEntries(HDC,WORD,WORD,LPPALETTEENTRY);
#endif /* NOGDI */

#ifndef NOUSER
/*
 * replace windows fns with c library ones
 */
#ifdef __WINDOWS_386__
#undef wsprintf
#undef wvsprintf
#define wsprintf sprintf
#define wvsprintf vsprintf
#ifndef NOLSTRING
#undef lstrcmp
#undef lstrcmpi
#undef lstrcpy
#undef lstrcat
#undef lstrlen
#define lstrcmp strcmp
#define lstrcmpi strcmpi
#define lstrcpy strcpy
#define lstrcat strcat
#define lstrlen strlen
#endif /* NOLSTRING */
#endif
#ifndef NOWINMESSAGES
WORD API _16RegisterWindowMessage(LPSTR);
#endif /* NOWINMESSAGES */
#ifndef NOMSG
BOOL API _16TranslateMessage(LPMSG);
LONG API _16DispatchMessage(LPMSG);
#endif /* NOMSG */
LONG  API _Cover_SendMessage(HWND, WORD, WORD, LONG);
LONG  API _16SendMessage(HWND, WORD, WORD, LONG);
BOOL  API _Cover_RegisterClass(LPWNDCLASS);
BOOL  API _16UnregisterClass(LPSTR, HANDLE);
BOOL  API _16GetClassInfo(HANDLE, LPSTR, LPWNDCLASS);
HWND  API _16CreateWindow(LPSTR, LPSTR, DWORD, int, int, int, int, HWND, HMENU, HANDLE, LPSTR);
HWND  API _16CreateWindowEx(DWORD, LPSTR, LPSTR, DWORD, int, int, int, int, HWND, HMENU, HANDLE, LPSTR);
#ifndef NOCTLMGR
HWND API _Cover_CreateDialog(HANDLE, LPSTR, HWND, FARPROC);
HWND API _Cover_CreateDialogIndirect(HANDLE, LPSTR, HWND, FARPROC);
HWND API _Cover_CreateDialogParam(HANDLE, LPSTR, HWND, FARPROC, LONG);
HWND API _Cover_CreateDialogIndirectParam(HANDLE, LPSTR, HWND, FARPROC, LONG);
HWND API _16CreateDialog(HANDLE, LPSTR, HWND, FARPROC);
HWND API _16CreateDialogIndirect(HANDLE, LPSTR, HWND, FARPROC);
HWND API _16CreateDialogParam(HANDLE, LPSTR, HWND, FARPROC, LONG);
HWND API _16CreateDialogIndirectParam(HANDLE, LPSTR, HWND, FARPROC, LONG);
int  API _Cover_DialogBox(HANDLE, LPSTR, HWND, FARPROC);
int  API _Cover_DialogBoxParam(HANDLE, LPSTR, HWND, FARPROC, LONG);
int  API _Cover_DialogBoxIndirect(HANDLE, HANDLE, HWND, FARPROC);
int  API _Cover_DialogBoxIndirectParam(HANDLE, HANDLE, HWND, FARPROC, LONG);
int  API _16DialogBox(HANDLE, LPSTR, HWND, FARPROC);
int  API _16DialogBoxParam(HANDLE, LPSTR, HWND, FARPROC, LONG);
int  API _16DialogBoxIndirect(HANDLE, HANDLE, HWND, FARPROC);
int  API _16DialogBoxIndirectParam(HANDLE, HANDLE, HWND, FARPROC, LONG);
LONG API _Cover_SendDlgItemMessage(HWND, int, WORD, WORD, LONG);
WORD API _16GetDlgItemInt(HWND, int, BOOL *, BOOL);
void API _16SetDlgItemText(HWND, int, LPSTR);
int  API _16GetDlgItemText(HWND, int, LPSTR, int);
#endif /* NOCTLMSG */
#ifndef NOMSG
BOOL API _16CallMsgFilter(LPMSG, int);
#endif /* NOMSG */
#ifndef NOCLIPBOARD
WORD   API _16RegisterClipboardFormat(LPSTR);
int    API _16GetClipboardFormatName(WORD, LPSTR, int);
int    API _16GetPriorityClipboardFormat(WORD  *, int);
#endif /* NOCLIPBOARD */
void API _16GetKeyboardState(BYTE *);
void API _16SetKeyboardState(BYTE *);
WORD API _16SetTimer(HWND, int, WORD, FARPROC);
WORD API _Cover_SetTimer(HWND, int, WORD, FARPROC);
HANDLE API _16LoadAccelerators(HANDLE, LPSTR);
#ifndef NOMSG
int  API _16TranslateAccelerator(HWND, HANDLE, LPMSG);
#endif /* NOMSG */
#ifndef NOMENUS
HMENU API _16LoadMenu(HANDLE, LPSTR);
HMENU API _16LoadMenuIndirect(LPSTR);
BOOL  API _16ChangeMenu(HMENU, WORD, LPSTR, WORD, WORD);
int   API _16GetMenuString(HMENU, WORD, LPSTR, int, WORD);
BOOL  API _16TrackPopupMenu(HMENU, WORD, int, int, int, HWND, LPRECT);
#endif /* NOMENUS */
BOOL API _16GrayString(HDC, HBRUSH, FARPROC, DWORD, int, int, int, int, int);
BOOL API _Cover_GrayString(HDC, HBRUSH, FARPROC, DWORD, int, int, int, int, int);
void API _16EndPaint(HWND, LPPAINTSTRUCT);
BOOL API _16GetUpdateRect(HWND, LPRECT, BOOL);
void API _16InvalidateRect(HWND, LPRECT, BOOL);
void API _16ValidateRect(HWND, LPRECT);
void API _16ScrollWindow(HWND, int, int, LPRECT, LPRECT);
BOOL API _16ScrollDC(HDC, int, int, LPRECT, LPRECT, HRGN, LPRECT);
#ifndef NOSCROLL
void API _16GetScrollRange(HWND, int, LPINT, LPINT);
#endif /* NOSCROLL */
BOOL   API _16SetProp(HWND, LPSTR, HANDLE);
HANDLE API _16GetProp(HWND, LPSTR);
HANDLE API _16RemoveProp(HWND, LPSTR);
void   API _16SetWindowText(HWND, LPSTR);
int    API _16GetWindowText(HWND, LPSTR, int);
int    API _16EnumProps(HWND, FARPROC);
int    API _Cover_EnumProps(HWND, FARPROC);
void API _16GetClientRect(HWND, LPRECT);
void API _16GetWindowRect(HWND, LPRECT);
void API _16AdjustWindowRect(LPRECT, LONG, BOOL);
void API _16AdjustWindowRectEx(LPRECT, LONG, BOOL, DWORD);
#ifndef NOMB
int  API _16MessageBox(HWND, LPSTR, LPSTR, WORD);
#endif /* NOMB */
void    API _16GetCursorPos(LPPOINT);
void    API _16ClipCursor(LPRECT);
void API _16GetCaretPos(LPPOINT);
void API _16ClientToScreen(HWND, LPPOINT);
void API _16ScreenToClient(HWND, LPPOINT);
#ifndef NOCOLOR
void  API _16SetSysColors(int, LPINT, LONG *);
#endif /* NOCOLOR */
void API _16DrawFocusRect(HDC, LPRECT);
int  API _16FillRect(HDC, LPRECT, HBRUSH);
int  API _16FrameRect(HDC, LPRECT, HBRUSH);
void API _16InvertRect(HDC, LPRECT);
void API _16SetRect(LPRECT, int, int, int, int);
void API _16SetRectEmpty(LPRECT);
int  API _16CopyRect(LPRECT, LPRECT);
void API _16InflateRect(LPRECT, int, int);
int  API _16IntersectRect(LPRECT, LPRECT, LPRECT);
int  API _16UnionRect(LPRECT, LPRECT, LPRECT);
void API _16OffsetRect(LPRECT, int, int);
BOOL API _16IsRectEmpty(LPRECT);
BOOL API _16EqualRect(LPRECT, LPRECT);
BOOL API _16PtInRect(LPRECT, POINT);
BOOL API _16RectVisible(HDC, LPRECT);
BOOL API _16RectInRegion(HRGN, LPRECT);
#ifndef NOWINOFFSETS
LONG API _16SetWindowLong(HWND, int, LONG);
LONG API _16SetClassLong(HWND, int, LONG);
LONG API _Cover_GetWindowLong(HWND, int);
LONG API _Cover_SetWindowLong(HWND, int, LONG);
LONG API _Cover_GetClassLong(HWND, int);
LONG API _Cover_SetClassLong(HWND, int, LONG);
#endif /* NOWINOFFSETS */
HWND   API _16FindWindow(LPSTR, LPSTR);
BOOL   API _16EnumWindows(FARPROC, LONG);
BOOL   API _Cover_EnumWindows(FARPROC, LONG);
BOOL   API _16EnumTaskWindows(HANDLE, FARPROC, LONG);
BOOL   API _Cover_EnumTaskWindows(HANDLE, FARPROC, LONG);
BOOL   API _16EnumChildWindows(HWND, FARPROC, LONG);
BOOL   API _Cover_EnumChildWindows(HWND, FARPROC, LONG);
int    API _16GetClassName(HWND, LPSTR, int);
#ifndef NOWH
FARPROC API _16SetWindowsHook(int, FARPROC);
FARPROC API _Cover_SetWindowsHook(int, FARPROC);
BOOL	API _16UnhookWindowsHook(int, FARPROC);
#if (WINVER >= 0x030a)
HHOOK   API _Cover_SetWindowsHookEx(int idHook, HOOKPROC lpfn, HINSTANCE hInstance, HTASK hTask);
#endif  /* WINVER >= 0x030a */
#endif
HBITMAP API _16LoadBitmap(HANDLE, LPSTR);
HCURSOR API _16LoadCursor(HANDLE, LPSTR);
HCURSOR API _16CreateCursor(HANDLE, int, int, int, int, LPSTR, LPSTR);
HICON API _16LoadIcon(HANDLE, LPSTR);
HICON API _16CreateIcon(HANDLE, int, int, BYTE, BYTE, LPSTR, LPSTR);
int  API _16LoadString(HANDLE, WORD, LPSTR, int);
int  API _16AddFontResource(LPSTR);
BOOL API _16RemoveFontResource(LPSTR);

#ifndef NOCTLMGR
#ifndef NOMSG
BOOL API _16IsDialogMessage(HWND, LPMSG);
#endif /* NOMSG */
void API _16MapDialogRect(HWND, LPRECT);
int  API _16DlgDirList(HWND, LPSTR, int, int, WORD);
BOOL API _16DlgDirSelect(HWND, LPSTR, int);
int  API _16DlgDirListComboBox(HWND, LPSTR, int, int, WORD);
BOOL API _16DlgDirSelectComboBox(HWND, LPSTR, int);
#endif /* NOCTLMGR */
#ifdef USECOMM
int  API _16OpenComm(LPSTR, WORD, WORD);
int  API _16SetCommState(DCB *);
int  API _16GetCommState(int, DCB *);
int  API _16ReadComm(int, LPSTR, int);
int  API _16WriteComm(int, LPSTR, int);
int  API _16GetCommError(int, COMSTAT *);
int  API _16BuildCommDCB(LPSTR, DCB *);
#endif /* USECOMM */
#ifndef NOMDI
#ifndef NOMSG
BOOL API _16TranslateMDISysAccel(HWND,LPMSG);
#endif /* NOMSG */
#endif /* NOMDI */

#ifndef NOLFILEIO
WORD API _16_lread( int, LPSTR, int );
WORD API _16_lwrite( int, LPSTR, int );
#endif
#endif /* NOUSER */
#ifndef NOHELP
BOOL API _16WinHelp(HWND hwndMain, LPSTR lpszHelp, WORD usCommand, DWORD ulData);
#endif /* NOHELP */

#ifdef INCLUDE_DRIVINIT_H
#include <drivinit.h>
#endif
#ifdef INCLUDE_PRINT_H
#include <print.h>
#endif
#ifdef INCLUDE_DDE_H
#define unsigned unsigned short
#include <dde.h>
#undef unsigned
#endif
#ifdef INCLUDE_CUSTCNTL_H
#include <custcntl.h>
#endif
#ifdef INCLUDE_COMMDLG_H
#include <commdlg.h>
BOOL WINAPI _16ChooseColor(LPCHOOSECOLOR);
BOOL WINAPI _16ChooseFont(LPCHOOSEFONT);
HWND WINAPI _16FindText(LPFINDREPLACE);
int WINAPI _16GetFileTitle(LPCSTR, LPSTR, UINT);
BOOL WINAPI _16GetOpenFileName(LPOPENFILENAME);
BOOL WINAPI _16GetSaveFileName(LPOPENFILENAME);
BOOL WINAPI _16PrintDlg(LPPRINTDLG);
HWND WINAPI _16ReplaceText(LPFINDREPLACE);
#if !defined(NOAUTOPROCS) && defined(__WINDOWS_386__)
#define ChooseColor _CoverChooseColor
#define ChooseFont _CoverChooseFont
#define FindText _CoverFindText
#define GetOpenFileName _CoverGetOpenFileName
#define GetSaveFileName _CoverGetSaveFileName
#define PrintDlg _CoverPrintDlg
#define ReplaceText _CoverReplaceText
BOOL WINAPI _CoverChooseColor(LPCHOOSECOLOR);
BOOL WINAPI _CoverChooseFont(LPCHOOSEFONT);
HWND WINAPI _CoverFindText(LPFINDREPLACE);
BOOL WINAPI _CoverGetOpenFileName(LPOPENFILENAME);
BOOL WINAPI _CoverGetSaveFileName(LPOPENFILENAME);
BOOL WINAPI _CoverPrintDlg(LPPRINTDLG);
HWND WINAPI _CoverReplaceText(LPFINDREPLACE);
#endif

#endif
#ifdef INCLUDE_OLE_H
#include <ole.h>
OLESTATUS   WINAPI  _16OleActivate(LPOLEOBJECT, UINT, BOOL, BOOL, HWND, const RECT FAR*);
OLESTATUS   WINAPI  _16OleClone(LPOLEOBJECT, LPOLECLIENT, LHCLIENTDOC, LPCSTR, LPOLEOBJECT FAR*);
OLESTATUS   WINAPI  _16OleClose(LPOLEOBJECT);
OLESTATUS   WINAPI  _16OleCopyFromLink(LPOLEOBJECT, LPCSTR, LPOLECLIENT, LHCLIENTDOC, LPCSTR, LPOLEOBJECT FAR*);
OLESTATUS   WINAPI  _16OleCopyToClipboard(LPOLEOBJECT);
OLESTATUS   WINAPI  _16OleCreate(LPCSTR, LPOLECLIENT, LPCSTR, LHCLIENTDOC, LPCSTR, LPOLEOBJECT FAR*, OLEOPT_RENDER, OLECLIPFORMAT);
OLESTATUS   WINAPI  _16OleCreateFromClip(LPCSTR, LPOLECLIENT, LHCLIENTDOC, LPCSTR,  LPOLEOBJECT FAR*, OLEOPT_RENDER, OLECLIPFORMAT);
OLESTATUS   WINAPI  _16OleCreateFromFile(LPCSTR, LPOLECLIENT, LPCSTR, LPCSTR, LHCLIENTDOC, LPCSTR, LPOLEOBJECT FAR*, OLEOPT_RENDER, OLECLIPFORMAT);
OLESTATUS   WINAPI  _16OleCreateFromTemplate(LPCSTR, LPOLECLIENT, LPCSTR, LHCLIENTDOC, LPCSTR, LPOLEOBJECT FAR*, OLEOPT_RENDER, OLECLIPFORMAT);
OLESTATUS   WINAPI  _16OleCreateInvisible(LPCSTR, LPOLECLIENT, LPCSTR, LHCLIENTDOC, LPCSTR, LPOLEOBJECT FAR*, OLEOPT_RENDER, OLECLIPFORMAT, BOOL);
OLESTATUS   WINAPI  _16OleCreateLinkFromClip(LPCSTR, LPOLECLIENT, LHCLIENTDOC, LPCSTR, LPOLEOBJECT FAR*, OLEOPT_RENDER, OLECLIPFORMAT);
OLESTATUS   WINAPI  _16OleCreateLinkFromFile(LPCSTR, LPOLECLIENT, LPCSTR, LPCSTR, LPCSTR, LHCLIENTDOC, LPCSTR, LPOLEOBJECT FAR*, OLEOPT_RENDER, OLECLIPFORMAT);
OLESTATUS   WINAPI  _16OleDelete(LPOLEOBJECT);
OLESTATUS   WINAPI  _16OleDraw(LPOLEOBJECT, HDC, const RECT FAR*, const RECT FAR*, HDC);
OLECLIPFORMAT  WINAPI  _16OleEnumFormats(LPOLEOBJECT, OLECLIPFORMAT);
OLESTATUS   WINAPI  _16OleEnumObjects(LHCLIENTDOC, LPOLEOBJECT FAR*);
OLESTATUS   WINAPI  _16OleEqual(LPOLEOBJECT, LPOLEOBJECT );
OLESTATUS   WINAPI  _16OleExecute(LPOLEOBJECT, HGLOBAL, UINT);
OLESTATUS   WINAPI  _16OleGetData(LPOLEOBJECT, OLECLIPFORMAT, HANDLE FAR*);
OLESTATUS   WINAPI  _16OleGetLinkUpdateOptions(LPOLEOBJECT, OLEOPT_UPDATE FAR*);
OLESTATUS   WINAPI  _16OleLoadFromStream(LPOLESTREAM, LPCSTR, LPOLECLIENT, LHCLIENTDOC, LPCSTR, LPOLEOBJECT FAR*);
OLESTATUS   WINAPI  _16OleLockServer(LPOLEOBJECT, LHSERVER FAR*);
OLESTATUS   WINAPI  _16OleObjectConvert(LPOLEOBJECT, LPCSTR, LPOLECLIENT, LHCLIENTDOC, LPCSTR, LPOLEOBJECT FAR*);
OLESTATUS   WINAPI  _16OleQueryBounds(LPOLEOBJECT, RECT FAR*);
OLESTATUS   WINAPI  _16OleQueryCreateFromClip(LPCSTR, OLEOPT_RENDER, OLECLIPFORMAT);
OLESTATUS   WINAPI  _16OleQueryLinkFromClip(LPCSTR, OLEOPT_RENDER, OLECLIPFORMAT);
OLESTATUS   WINAPI  _16OleQueryName(LPOLEOBJECT, LPSTR, UINT FAR*);
OLESTATUS   WINAPI  _16OleQueryOpen(LPOLEOBJECT);
OLESTATUS   WINAPI  _16OleQueryOutOfDate(LPOLEOBJECT);
void FAR*   WINAPI  _16OleQueryProtocol(LPOLEOBJECT, LPCSTR);
OLESTATUS   WINAPI  _16OleQueryReleaseError(LPOLEOBJECT);
OLE_RELEASE_METHOD WINAPI _16OleQueryReleaseMethod(LPOLEOBJECT);
OLESTATUS   WINAPI  _16OleQueryReleaseStatus(LPOLEOBJECT);
OLESTATUS   WINAPI  _16OleQuerySize(LPOLEOBJECT, DWORD FAR*);
OLESTATUS   WINAPI  _16OleQueryType(LPOLEOBJECT, LONG FAR*);
OLESTATUS   WINAPI  _16OleReconnect(LPOLEOBJECT);
OLESTATUS   WINAPI  _16OleRegisterClientDoc(LPCSTR, LPCSTR, LONG, LHCLIENTDOC FAR*);
OLESTATUS   WINAPI  _16OleRelease(LPOLEOBJECT);
OLESTATUS   WINAPI  _16OleRename(LPOLEOBJECT, LPCSTR);
OLESTATUS   WINAPI  _16OleRenameClientDoc(LHCLIENTDOC, LPCSTR);
OLESTATUS   WINAPI  _16OleRequestData(LPOLEOBJECT, OLECLIPFORMAT);
OLESTATUS   WINAPI  _16OleSaveToStream(LPOLEOBJECT, LPOLESTREAM);
OLESTATUS   WINAPI  _16OleSetBounds(LPOLEOBJECT, const RECT FAR*);
OLESTATUS   WINAPI  _16OleSetColorScheme(LPOLEOBJECT, const LOGPALETTE FAR*);
OLESTATUS   WINAPI  _16OleSetData(LPOLEOBJECT, OLECLIPFORMAT, HANDLE);
OLESTATUS   WINAPI  _16OleSetHostNames(LPOLEOBJECT, LPCSTR, LPCSTR);
OLESTATUS   WINAPI  _16OleSetLinkUpdateOptions(LPOLEOBJECT, OLEOPT_UPDATE);
OLESTATUS   WINAPI  _16OleSetTargetDevice(LPOLEOBJECT, HGLOBAL);
OLESTATUS   WINAPI  _16OleUpdate(LPOLEOBJECT);
OLESTATUS   WINAPI  _16OleRegisterServer(LPCSTR, LPOLESERVER, LHSERVER FAR*, HINSTANCE, OLE_SERVER_USE);
OLESTATUS   WINAPI  _16OleRegisterServerDoc(LHSERVER, LPCSTR, LPOLESERVERDOC, LHSERVERDOC FAR*);
OLESTATUS   WINAPI  _16OleRenameServerDoc(LHSERVERDOC, LPCSTR);
OLESTATUS   WINAPI  _16OleRevokeObject(LPOLECLIENT);
OLESTATUS   WINAPI  _16OleUnblockServer(LHSERVER, BOOL FAR*);
#endif
#ifdef INCLUDE_DDEML_H
#include <ddeml.h>
HCONVLIST EXPENTRY _16DdeConnectList(DWORD idInst, HSZ hszService, HSZ hszTopic,
        HCONVLIST hConvList, PCONVCONTEXT pCC);
HCONV EXPENTRY _16DdeConnect(DWORD idInst, HSZ hszService, HSZ hszTopic,
        PCONVCONTEXT pCC);
WORD EXPENTRY _16DdeQueryConvInfo(HCONV hConv, DWORD idTransaction, PCONVINFO pConvInfo);
HDDEDATA EXPENTRY _16DdeClientTransaction(LPBYTE pData, DWORD cbData,
        HCONV hConv, HSZ hszItem, WORD wFmt, WORD wType, DWORD dwTimeout,
        LPDWORD pdwResult);
HDDEDATA EXPENTRY _16DdeCreateDataHandle(DWORD idInst, LPBYTE pSrc, DWORD cb,
        DWORD cbOff, HSZ hszItem, WORD wFmt, WORD afCmd);
HDDEDATA EXPENTRY _16DdeAddData(HDDEDATA hData, LPBYTE pSrc, DWORD cb, DWORD cbOff);
DWORD EXPENTRY _16DdeGetData(HDDEDATA hData, LPBYTE pDst, DWORD cbMax, DWORD cbOff);
LPBYTE EXPENTRY _16DdeAccessData(HDDEDATA hData, LPDWORD pcbDataSize);
HSZ  EXPENTRY _16DdeCreateStringHandle(DWORD idInst, LPSTR psz, int iCodePage);
DWORD EXPENTRY _16DdeQueryString(DWORD idInst, HSZ hsz, LPSTR psz, DWORD cchMax, int iCodePage);
UINT  EXPENTRY _16DdeInitialize(LPDWORD idInst, PFNCALLBACK pfnCallback,
				DWORD afCmd, DWORD ulRes);
#if !defined(NOAUTOPROCS) && defined(__WINDOWS_386__)
#define DdeInitialize _Cover_DdeInitialize
#define DdeClientTransaction _Cover_DdeClientTransaction
UINT  EXPENTRY _Cover_DdeInitialize(LPDWORD idInst, PFNCALLBACK pfnCallback,
				DWORD afCmd, DWORD ulRes);
HDDEDATA EXPENTRY _Cover_DdeClientTransaction(LPBYTE pData, DWORD cbData,
        HCONV hConv, HSZ hszItem, WORD wFmt, WORD wType, DWORD dwTimeout,
        LPDWORD pdwResult);
#endif
#endif
#ifdef INCLUDE_SHELLAPI_H
#include <shellapi.h>
#endif
#ifdef INCLUDE_VER_H
#include <ver.h>
#endif
#ifdef INCLUDE_LZEXPAND_H
#include <lzexpand.h>
#endif
#ifdef INCLUDE_STRESS_H
#include <stress.h>
#endif
#ifdef INCLUDE_PENWIN_H
#include <penwin.h>
#if !defined(NOAUTOPROCS) && defined(__WINDOWS_386__)
#define Recognize _Cover_Recognize
#define RecognizeData _Cover_RecognizeData
#define TrainInk _Cover_TrainInk
#define ProcessWriting _Cover_ProcessWriting
#define CorrectWriting _Cover_CorrectWriting
#define DictionarySearch _Cover_DictionarySearch
#define SetPenHook _Cover_SetPenHook
#define EnumSymbols _Cover_EnumSymbols
REC WINAPI _Cover_Recognize( LPRC lprc );
REC WINAPI _Cover_RecognizeData( LPRC lprc, HPENDATA hpd );
BOOL WINAPI _Cover_TrainInk(LPRC lprc, HPENDATA hpd, LPSYV lpsvy );
REC WINAPI _Cover_ProcessWriting( HWND hwnd, LPRC lprc );
BOOL WINAPI _Cover_CorrectWriting( HWND hwnd, LPSTR lpstr, UINT cb, LPRC lprc, DWORD dw1, DWORD dw2 );
BOOL WINAPI _Cover_DictionarySearch( LPRC lprc, LPSYE lpsye, int i1, LPSYV lpsyv, int i2 );
BOOL WINAPI _Cover_SetPenHook(HKP hkpop, LPFNRAWHOOK lpfn );
UINT WINAPI _Cover_EnumSymbols(LPSYG, WORD, ENUMPROC, LPVOID);
#endif
#endif
#ifdef INCLUDE_PENWOEM_H
#include <penwoem.h>
#endif
#ifdef INCLUDE_MMSYSTEM_H
#include <mmsystem.h>
#if !defined(NOAUTOPROCS) && defined(__WINDOWS_386__)
#define mmioInstallIOProc _Cover_mmioInstallIOProc
#define mciSetYieldProc _Cover_mciSetYieldProc
LPMMIOPROC WINAPI _Cover_mmioInstallIOProc(FOURCC fccIOProc, LPMMIOPROC pIOProc, DWORD dwFlags);
BOOL WINAPI _Cover_mciSetYieldProc(UINT uDeviceID, YIELDPROC fpYieldProc, DWORD dwYieldData);
#endif
UINT WINAPI _16waveOutPrepareHeader(HWAVEOUT hWaveOut,DWORD,UINT uSize);
UINT WINAPI _16waveOutUnprepareHeader(HWAVEOUT hWaveOut,DWORD,UINT uSize);
UINT WINAPI _16waveOutWrite(HWAVEOUT hWaveOut, DWORD,UINT uSize);
#endif

#ifdef INCLUDE_TOOLHELP_H
#include <toolhelp.h>
#if !defined(NOAUTOPROCS) && defined(__WINDOWS_386__)
BOOL WINAPI _Cover_NotifyRegister(HTASK hTask, LPFNNOTIFYCALLBACK lpfn, WORD wFlags);
#define NotifyRegister _Cover_NotifyRegister
#endif
#endif

#ifdef __WINDOWS_386__

/*
 * re-define the pseudo-pointers
 */
#undef MAKEINTRESOURCE
#define MAKEINTRESOURCE(i)  (LPSTR)(0xFFFF0000L+(DWORD)((WORD)(i)))
#undef MAKEINTATOM
#define MAKEINTATOM(i)	(LPSTR)(0xFFFF0000L+(DWORD)((WORD)(i)))

#undef int
#undef __far
#undef __huge
#undef FAR
#define FAR far

/*
 * types
 */
typedef unsigned int PROCPTR;
typedef void * CALLBACKPTR;
typedef void * HINDIR;

/*
 * prototypes for special WIN386 library functions
 */
#define GETPROC_CALLBACK 0
#define GETPROC_SETTIMER 0
#define GETPROC_ABORTPROC 1
#define GETPROC_ENUMFONTS 2
#define GETPROC_ENUMMETAFILE 3
#define GETPROC_ENUMOBJECTS 4
#define GETPROC_ENUMPROPS_FIXED_DS 5
#define GETPROC_GRAYSTRING 5
#define GETPROC_ENUMPROPS_MOVEABLE_DS 6
#define GETPROC_ENUMTASKWINDOWS 7
#define GETPROC_ENUMWINDOWS 7
#define GETPROC_ENUMCHILDWINDOWS 7
#define GETPROC_TOOLHELP_NOTIFY 7
#define GETPROC_GLOBALNOTIFY 8
#define GETPROC_LINEDDA 9
#define GETPROC_SETWINDOWSHOOK 9
#define GETPROC_SETRESOURCEHANDLER 10
#define GETPROC_DDEMLCALLBACK 11
#define GETPROC_PENWIN_RCYIELDPROC 12
#define GETPROC_PENWIN_LPDF 13
#define GETPROC_PENWIN_LPFNRAWHOOK 14
#define GETPROC_PENWIN_ENUMPROC 15
#define GETPROC_MMSYSTEM_MMIOPROC 16
#define GETPROC_MMSYSTEM_YIELDPROC 17
#define GETPROC_USERDEFINED_1 101
#define GETPROC_USERDEFINED_2 102
#define GETPROC_USERDEFINED_3 103
#define GETPROC_USERDEFINED_4 104
#define GETPROC_USERDEFINED_5 105
#define GETPROC_USERDEFINED_6 106
#define GETPROC_USERDEFINED_7 107
#define GETPROC_USERDEFINED_8 108
#define GETPROC_USERDEFINED_9 109
#define GETPROC_USERDEFINED_10 110
#define GETPROC_USERDEFINED_11 111
#define GETPROC_USERDEFINED_12 112
#define GETPROC_USERDEFINED_13 113
#define GETPROC_USERDEFINED_14 114
#define GETPROC_USERDEFINED_15 115
#define GETPROC_USERDEFINED_16 116
#define GETPROC_USERDEFINED_17 117
#define GETPROC_USERDEFINED_18 118
#define GETPROC_USERDEFINED_19 119
#define GETPROC_USERDEFINED_20 120
#define GETPROC_USERDEFINED_21 121
#define GETPROC_USERDEFINED_22 122
#define GETPROC_USERDEFINED_23 123
#define GETPROC_USERDEFINED_24 124
#define GETPROC_USERDEFINED_25 125
#define GETPROC_USERDEFINED_26 126
#define GETPROC_USERDEFINED_27 127
#define GETPROC_USERDEFINED_28 128
#define GETPROC_USERDEFINED_29 129
#define GETPROC_USERDEFINED_30 130
#define GETPROC_USERDEFINED_31 131
#define GETPROC_USERDEFINED_32 132

#define GCB_DWORD		4
#define GCB_WORD		2
#define GCB_ENDLIST		-1
#define GCB_CDECL		-2

extern CALLBACKPTR GetProc16( PROCPTR, long );
extern void ReleaseProc16( CALLBACKPTR );
extern void ReleaseCallbackRoutine( CALLBACKPTR cbp );
CALLBACKPTR GetCallbackRoutine( PROCPTR fn, ... );
void ReleaseCallbackRoutine( CALLBACKPTR cbp );

extern void far *MK_LOCAL32( void * );
extern void far *MK_FP32( void * );
extern DWORD MK_FP16( void far * );

#pragma aux MK_LOCAL32 "*_" __parm [__eax] __value [__eax __dx];
#pragma aux MK_FP32 = 0x8B 0xD0 0xC1 0xEA 0x10 0x25 0xFF 0xFF 0x00 0x00 \
   __parm [__eax] __value [__eax __dx];
#pragma aux  MK_FP16 = 0xC1 0xE2 0x10 0x66 0x8B 0xD0 \
   __parm [__eax __dx] __value [__edx];

extern DWORD _Call16( FARPROC lpFunc, char *fmt, ... );
/*
;  _Call16 performs the same function as "GetIndirectFunctionHandle,
;  InvokeIndirectFunctionHandle, FreeIndirectFunctionHandle" but is
;  much easier to use.
;  Fmt specifiers for _Call16:
;	c - call 'cdecl' func as opposed to 'pascal' func (must be first char)
;	b - unsigned byte
;	w - 16-bit word
;	d - 32-bit dword
;	f - double precision floating-point
;	p - 32-bit flat pointer (converted to 16:16 pointer)
*/
extern DWORD InvokeIndirectFunction( HINDIR handle, ... );
extern HINDIR GetIndirectFunctionHandle( FARPROC proc, ... );
extern void  FreeIndirectFunctionHandle( HINDIR );
#define INDIR_DWORD     ((int) 4)
#define INDIR_WORD      ((int) 2)
#define INDIR_CHAR      ((int) 2)
#define INDIR_PTR       ((int) -1)
#define INDIR_ENDLIST   ((int) -2)
#define INDIR_CDECL	((int) -3)

extern int DefineDLLEntry( int, void *, ... );
#define DLL_DWORD	((int) 4)
#define DLL_PTR		((int) 4)
#define DLL_WORD	((int) 2)
#define DLL_CHAR	((int) 2)
#define DLL_ENDLIST	((int) -1)

extern int DefineUserProc16( int, PROCPTR, ... );
#define UDP16_DWORD	((int) 4)
#define UDP16_PTR	((int) 4)
#define UDP16_WORD	((int) 2)
#define UDP16_CHAR	((int) 2)
#define UDP16_ENDLIST	((int) -1)
#define UDP16_CDECL	((int) -2)

#define DWORD_TO_PTR(i)  ((LPSTR)(0xFFFF0000L+(DWORD)((WORD)(i))))
#define PASS_WORD_AS_POINTER(i)  ((LPSTR)(0xFFFF0000L+(DWORD)((WORD)(i))))

extern DWORD AllocAlias16( void * );
extern void FreeAlias16( DWORD );
extern DWORD AllocHugeAlias16( void *, DWORD );
extern void FreeHugeAlias16( DWORD, DWORD );
void *MapAliasToFlat( DWORD alias );

extern WORD __A000;
#pragma aux __A000 "_*";
extern WORD __B000;
#pragma aux __B000 "_*";
extern WORD __B800;
#pragma aux __B800 "_*";
extern WORD __C000;
#pragma aux __C000 "_*";
extern WORD __D000;
#pragma aux __D000 "_*";
extern WORD __E000;
#pragma aux __E000 "_*";
extern WORD __F000;
#pragma aux __F000 "_*";
extern WORD LocalPtr;
#pragma aux LocalPtr "_*";

#pragma library (WIN386);

#else
typedef void __far * PROCPTR;
typedef void __far * CALLBACKPTR;
typedef void * HINDIR;

#define PASS_WORD_AS_POINTER(i) ((LPSTR)(WORD)(i))
#define AllocAlias16(a) ((DWORD)(LPSTR)(a))
#define FreeAlias16(a)
#define AllocHugeAlias16(a,b) ((DWORD)(LPSTR)(a))
#define FreeHugeAlias16(a,b)
#define MK_LOCAL32(a) ((void far *) a)
#define MK_FP32(a) (a)
#define MK_FP16(a) (a)
#define GetProc16(a,b) (a)
#define ReleaseProc16(a)

#ifndef NOKERNEL
#define _16MakeProcInstance MakeProcInstance
#define _16FreeProcInstance FreeProcInstance
#define _16GetCodeInfo GetCodeInfo
#define _16GetModuleHandle GetModuleHandle
#define _16GetModuleFileName GetModuleFileName
#define _16GetInstanceData GetInstanceData
#define _16GetProcAddress GetProcAddress
#define _16LoadLibrary LoadLibrary
#define _16LoadModule LoadModule
#define _16WinExec WinExec
#define _16OutputDebugString OutputDebugString
#ifndef NOOPENFILE
#define _16OpenFile OpenFile
#define _16GetTempFileName GetTempFileName
#endif /* NOOPENFILE */
#define _16FindResource FindResource
#define _16SetResourceHandler SetResourceHandler
#ifndef NOATOM
#define _16AddAtom AddAtom
#define _16FindAtom FindAtom
#define _16GetAtomName GetAtomName
#define _16GlobalAddAtom GlobalAddAtom
#define _16GlobalFindAtom GlobalFindAtom
#define _16GlobalGetAtomName GlobalGetAtomName
#endif /* NOATOM */
#define _16GetProfileInt GetProfileInt
#define _16GetProfileString GetProfileString
#define _16WriteProfileString WriteProfileString
#define _16GetPrivateProfileInt GetPrivateProfileInt
#define _16GetPrivateProfileString GetPrivateProfileString
#define _16WritePrivateProfileString WritePrivateProfileString
#define _16GetWindowsDirectory GetWindowsDirectory
#define _16GetSystemDirectory GetSystemDirectory
#define _16AnsiToOem AnsiToOem
#define _16OemToAnsi OemToAnsi
#define _16AnsiToOemBuff AnsiToOemBuff
#define _16OemToAnsiBuff OemToAnsiBuff
#define _16AnsiUpper AnsiUpper
#define _16AnsiUpperBuff AnsiUpperBuff
#define _16AnsiLower AnsiLower
#define _16AnsiLowerBuff AnsiLowerBuff
#define _16AnsiNext AnsiNext
#define _16AnsiPrev AnsiPrev
#ifndef NOKEYBOARDINFO
#define _16GetKeyNameText GetKeyNameText
#define _16ToAscii ToAscii
#endif /* NOKEYBOARDINFO */
#ifndef NOMEMMGR
#define _16GlobalNotify GlobalNotify
#endif /* NOMEMMGR */
#endif /* NOKERNEL */

#ifndef NOGDI
#ifndef NODRAWTEXT
#define _16DrawText DrawText
#endif /* NODRAWTEXT */
#define _16CreateDC CreateDC
#define _16CreateIC CreateIC
#define _16ExtTextOut ExtTextOut
#define _16Polyline Polyline
#define _16Polygon Polygon
#define _16PolyPolygon PolyPolygon
#define _16TextOut TextOut
#define _16TabbedTextOut TabbedTextOut
#define _16GetCharWidth GetCharWidth
#define _16LineDDA LineDDA
#define _16CreatePenIndirect CreatePenIndirect
#define _16CreateBrushIndirect CreateBrushIndirect
#define _16CreateBitmap CreateBitmap
#define _16CreateBitmapIndirect CreateBitmapIndirect
#define _16SetBitmapBits SetBitmapBits
#define _16GetBitmapBits GetBitmapBits
#define _16CreateFont CreateFont
#define _16CreateFontIndirect CreateFontIndirect
#define _16CreateRectRgnIndirect CreateRectRgnIndirect
#define _16CreateEllipticRgnIndirect CreateEllipticRgnIndirect
#define _16CreatePolygonRgn CreatePolygonRgn
#define _16CreatePolyPolygonRgn CreatePolyPolygonRgn
#define _16GetObject GetObject
#define _16GetClipBox GetClipBox
#define _16GetRgnBox GetRgnBox
#define _16GetTextExtent GetTextExtent
#define _16GetTabbedTextExtent GetTabbedTextExtent
#define _16GetMetaFile GetMetaFile
#define _16CopyMetaFile CopyMetaFile
#ifndef NOMETAFILE
#define _16PlayMetaFileRecord PlayMetaFileRecord
#define _16EnumMetaFile EnumMetaFile
#endif
#define _16Escape Escape
#define _16EnumFonts EnumFonts
#define _16EnumObjects EnumObjects
#define _16GetTextFace GetTextFace
#ifndef NOTEXTMETRIC
#define _16GetTextMetrics GetTextMetrics
#endif /* NOTEXTMETRIC */
#define _16SetEnvironment SetEnvironment
#define _16GetEnvironment GetEnvironment
#define _16DPtoLP DPtoLP
#define _16LPtoDP LPtoDP
#define _16CreateMetaFile CreateMetaFile
#define _16SetDIBits SetDIBits
#define _16GetDIBits GetDIBits
#define _16SetDIBitsToDevice SetDIBitsToDevice
#define _16StretchDIBits StretchDIBits
#define _16CreatePalette  CreatePalette 
#define _16AnimatePalette AnimatePalette
#define _16SetPaletteEntries SetPaletteEntries
#define _16GetPaletteEntries GetPaletteEntries
#define _16GetSystemPaletteEntries GetSystemPaletteEntries
#endif /* NOGDI */

#ifndef NOUSER
#ifndef NOWINMESSAGES
#define _16RegisterWindowMessage RegisterWindowMessage
#endif /* NOWINMESSAGES */
#ifndef NOMSG
#define _16TranslateMessage TranslateMessage
#define _16DispatchMessage DispatchMessage
#endif /* NOMSG */
#define _16UnregisterClass UnregisterClass
#define _16GetClassInfo GetClassInfo
#define _16CreateWindow CreateWindow
#define _16CreateWindowEx CreateWindowEx
#ifndef NOCTLMGR
#define _16CreateDialog CreateDialog
#define _16CreateDialogIndirect CreateDialogIndirect
#define _16CreateDialogParam CreateDialogParam
#define _16CreateDialogIndirectParam CreateDialogIndirectParam
#define _16DialogBox DialogBox
#define _16DialogBoxParam DialogBoxParam
#define _16DialogBoxIndirect DialogBoxIndirect
#define _16DialogBoxIndirectParam DialogBoxIndirectParam
#define _16GetDlgItemInt GetDlgItemInt
#define _16SetDlgItemText SetDlgItemText
#define _16GetDlgItemText GetDlgItemText
#endif /* NOCTLMSG */
#ifndef NOMSG
#define _16CallMsgFilter CallMsgFilter
#endif /* NOMSG */
#ifndef NOCLIPBOARD
#define _16RegisterClipboardFormat RegisterClipboardFormat
#define _16GetClipboardFormatName GetClipboardFormatName
#define _16GetPriorityClipboardFormat GetPriorityClipboardFormat
#endif /* NOCLIPBOARD */
#define _16GetKeyboardState GetKeyboardState
#define _16SetKeyboardState SetKeyboardState
#define _16LoadAccelerators LoadAccelerators
#define _16SetTimer SetTimer
#ifndef NOMSG
#define _16TranslateAccelerator TranslateAccelerator
#endif /* NOMSG */
#ifndef NOMENUS
#define _16LoadMenu LoadMenu
#define _16LoadMenuIndirect LoadMenuIndirect
#define _16ChangeMenu ChangeMenu
#define _16GetMenuString GetMenuString
#define _16TrackPopupMenu TrackPopupMenu
#endif /* NOMENUS */
#define _16GrayString GrayString
#define _16EndPaint EndPaint
#define _16GetUpdateRect GetUpdateRect
#define _16InvalidateRect InvalidateRect
#define _16ValidateRect ValidateRect
#define _16ScrollWindow ScrollWindow
#define _16ScrollDC ScrollDC
#ifndef NOSCROLL
#define _16GetScrollRange GetScrollRange
#endif /* NOSCROLL */
#define _16SetProp SetProp
#define _16GetProp GetProp
#define _16RemoveProp RemoveProp
#define _16SetWindowText SetWindowText
#define _16GetWindowText GetWindowText
#define _16GetClientRect GetClientRect
#define _16EnumProps EnumProps
#define _16GetWindowRect GetWindowRect
#define _16AdjustWindowRect AdjustWindowRect
#define _16AdjustWindowRectEx AdjustWindowRectEx
#ifndef NOMB
#define _16MessageBox MessageBox
#endif /* NOMB */
#define _16GetCursorPos GetCursorPos
#define _16ClipCursor ClipCursor
#define _16GetCaretPos GetCaretPos
#define _16ClientToScreen ClientToScreen
#define _16ScreenToClient ScreenToClient
#ifndef NOCOLOR
#define _16SetSysColors SetSysColors
#endif /* NOCOLOR */
#define _16DrawFocusRect DrawFocusRect
#define _16FillRect FillRect
#define _16FrameRect FrameRect
#define _16InvertRect InvertRect
#define _16SetRect SetRect
#define _16SetRectEmpty SetRectEmpty
#define _16CopyRect CopyRect
#define _16InflateRect InflateRect
#define _16IntersectRect IntersectRect
#define _16UnionRect UnionRect
#define _16OffsetRect OffsetRect
#define _16IsRectEmpty IsRectEmpty
#define _16EqualRect EqualRect
#define _16PtInRect PtInRect
#define _16RectVisible RectVisible
#define _16RectInRegion RectInRegion
#define _16EnumChildWindows EnumChildWindows
#define _16FindWindow FindWindow
#define _16EnumWindows EnumWindows
#define _16EnumTaskWindows EnumTaskWindows
#define _16GetClassName GetClassName
#ifndef NOWH
#define _16SetWindowsHook SetWindowsHook
#define _16UnhookWindowsHook UnhookWindowsHook
#endif
#define _16LoadBitmap LoadBitmap
#define _16LoadCursor LoadCursor
#define _16CreateCursor CreateCursor
#define _16LoadIcon LoadIcon
#define _16CreateIcon CreateIcon
#define _16LoadString LoadString
#define _16AddFontResource AddFontResource
#define _16RemoveFontResource RemoveFontResource

#ifndef NOCTLMGR
#ifndef NOMSG
#define _16IsDialogMessage IsDialogMessage
#endif /* NOMSG */
#define _16MapDialogRect MapDialogRect
#define _16DlgDirList DlgDirList
#define _16DlgDirSelect DlgDirSelect
#define _16DlgDirListComboBox DlgDirListComboBox
#define _16DlgDirSelectComboBox DlgDirSelectComboBox
#endif /* NOCTLMGR */
#ifdef USECOMM
#define _16OpenComm OpenComm
#define _16SetCommState SetCommState
#define _16GetCommState GetCommState
#define _16ReadComm ReadComm
#define _16WriteComm WriteComm
#define _16GetCommError GetCommError
#define _16BuildCommDCB BuildCommDCB
#endif /* USECOMM */
#ifndef NOMDI
#ifndef NOMSG
#define _16TranslateMDISysAccel TranslateMDISysAccel
#endif /* NOMSG */
#endif /* NOMDI */

#ifndef NOLFILEIO
#define _16_lread _lread
#define _16_lwrite _lwrite
#endif
#endif /* NOUSER */
#ifndef NOHELP
#define _16WinHelp WinHelp
#endif /* NOHELP */

#ifdef INCLUDE_COMMDLG_H
#define _16ChooseColor ChooseColor
#define _16ChooseFont ChooseFont
#define _16FindText FindText
#define _16GetFileTitle GetFileTitle
#define _16GetOpenFileName GetOpenFileName
#define _16GetSaveFileName GetSaveFileName
#define _16PrintDlg PrintDlg
#define _16ReplaceText ReplaceText
#endif
#ifdef INCLUDE_DDEML_H
#define _16DdeConnectList DdeConnectList
#define _16DdeConnect DdeConnect
#define _16DdeQueryConvInfo DdeQueryConvInfo
#define _16DdeClientTransaction DdeClientTransaction
#define _16DdeCreateDataHandle DdeCreateDataHandle
#define _16DdeAddData DdeAddData
#define _16DdeGetData DdeGetData
#define _16DdeAccessData DdeAccessData
#define _16DdeCreateStringHandle DdeCreateStringHandle
#define _16DdeQueryString DdeQueryString
#define _16DdeInitialize DdeInitialize
#endif
#ifdef INCLUDE_PENWIN_H
#endif
#endif

#ifdef __cplusplus
};
#endif
#endif
