
# This file was generated by the SOM Compiler.
# FileName: wppalet.sc.
# Generated using:
#     SOM Precompiler spc: 1.22
#     SOM Emitter emitcsc: 1.10

/*
 *  Module Header
 * 
 *  Module Name: WPPALET
 * 
 *  OS/2 Presentation Manager Workplace class definitions
 * 
 *  Copyright (c) International Business Machines Corporation 1991, 1992
 * 
 */

#include "wpabs.sc"

class: WPPalette, 
    external stem = wppal, local, external prefix = pal_, 
    classprefix = palM_, major version = 1, minor version = 2, 
    file stem = wppalet;


parent class: WPAbstract;


release order:
    wpPaintCell, wpSelectCell, wpSetupCell, 
    wpQueryPaletteInfo, wpSetPaletteInfo, wpEditCell, 
    wpDragCell, withdrawn, wpInitCellStructs, 
    wpRedrawCell, wpPaintPalette, wpMouseAction, 
    wpQueryPaletteHelp, wpShowPalettePointer, wpclsQueryEditString;


passthru: C.h, after;

      /*
       *  Open view for the wpOpen() method
       */

      #define OPEN_PALETTE       121

      /*
       *  Palette save-restore keys
       */

      #define IDKEY_PALXCELLCOUNT      1000
      #define IDKEY_PALYCELLCOUNT      1001
      #define IDKEY_PALXCELLWIDTH      1002
      #define IDKEY_PALYCELLHEIGHT     1003
      #define IDKEY_PALXGAP            1004
      #define IDKEY_PALYGAP            1005
      #define IDKEY_PALSCREENSIZEX     1006
      #define IDKEY_PALSCREENSIZEY     1007
      #define IDKEY_PALCELLDATA_FIRST  1050

      /*
       *  Default palette information
       */

      #define DEF_XCELLCOUNT      6
      #define DEF_YCELLCOUNT      5

      /*
       *  Variables kept for each open palette window as
       *  a structure pointed to by the QWL_USER window
       *  word ...
       */

      typedef struct _CELL
      {
         ULONG       cbData;           /* Size of the data that follows */

         /* Class specific cell data follows immediately afterwards -
          * for example the font palette would store the ASCII name of
          * the font, and the color palette would store the RGB color
          * of the cell.
          */
      } CELL;
      typedef CELL *PCELL;

      typedef struct _PALINFO
      {
         ULONG       xCellCount;       /* Number of columns of cells */
         ULONG       yCellCount;       /* Number of rows of cells */
         ULONG       xCursor;          /* Cursor location (readonly) */
         ULONG       yCursor;          /* Cursor location (readonly) */
         ULONG       xCellWidth;       /* Width of each cell */
         ULONG       yCellHeight;      /* Height of each cell */
         ULONG       xGap;             /* X separation of cells */
         ULONG       yGap;             /* Y separation of cells */
      } PALINFO;
      typedef PALINFO *PPALINFO;

      #define SetPaletteDataPtr( hwnd, pPaletteData ) \
           WinSetWindowULong( hwnd, QWL_USER, (ULONG)pPaletteData )

      #define QueryPaletteDataPtr( hwnd ) \
           (PPALETTEDATA)WinQueryWindowULong( hwnd, QWL_USER )

      typedef struct _PALETTEDATA
      {
         WPFolder   *Palette;          /* Folder object for this window */
         USEITEM     UseItem;          /* Folder object's INUSE list item */
         VIEWITEM    ViewItem;
         ULONG       xCursor;
         ULONG       yCursor;
      } PALETTEDATA;
      typedef PALETTEDATA *PPALETTEDATA;

      typedef struct _CELLSTRUCT
      {
         RECTL       rclCell;          /* Cell coordinates */
         PCELL       pCell;            /* Cell data pointer */
      } CELLSTRUCT;
      typedef CELLSTRUCT *PCELLSTRUCT;
      /*
       *  Miscellaneous
       */

      #define PM_INVALIDATECELL WM_USER+1000

      /* Macros that act on a PALINFO...
       */
      #define PALETTE_WIDTH(p)  ( p.xCellCount*(p.xCellWidth+p.xGap) )
      #define PALETTE_HEIGHT(p) ( p.yCellCount*(p.yCellHeight+p.yGap) )
      #define ID_PALSCROLLHORZ     8091
      #define ID_PALSCROLLVERT     8092

      /* Coordinates (these are in DIALOG UNITS)
       */
      #define CXBUTTON          12       /* Width of a button (with no text) */
      #define CYBUTTON          12       /* Height of a button */
      #define XBUTTONGAP        6
      #define YBUTTONGAP        4
      #define CYBUTTONAREA      (CYBUTTON + 2*YBUTTONGAP)
      #define DEF_XCELLWIDTH    22
      #define DEF_YCELLHEIGHT   16
      #define DEF_XCELLGAP      4
      #define DEF_YCELLGAP      4


endpassthru;
methods:


    VOID    wpPaintCell(PCELL pCell,
		HPS hps,
		PRECTL prcl,
		BOOL fHilite);

    BOOL    wpSetupCell(PVOID pCellData,
		ULONG cb,
		ULONG x,
		ULONG y);

    BOOL    wpRedrawCell(PCELL pCell);

    BOOL    wpQueryPaletteInfo(PPALINFO pPalInfo);

    BOOL    wpSetPaletteInfo(PPALINFO pPalInfo);

    BOOL    wpEditCell(PCELL pCell,
		HWND hwndPal);

    BOOL    wpDragCell(PCELL pCell,
		HWND hwndPal,
		PPOINTL ptlDrag);

    PSZ    wpclsQueryEditString(), class;

    ULONG    wpQueryPaletteHelp();

    override wpInitData;

    -- From WPObject

    override wpUnInitData;

    -- From WPObject

    override wpSetup;

    -- From WPObject

    override wpSaveState;

    -- From WPObject

    override wpRestoreState;

    -- From WPObject

    override wpMenuItemSelected;

    -- From WPObject

    override wpModifyPopupMenu;

    -- From WPObject

    override wpFilterPopupMenu;

    -- From WPObject

    override wpOpen;

    -- From WPObject

    override wpMenuItemHelpSelected;

    -- From WPObject

    override wpclsQueryTitle, class;

    -- From WPObject

    override wpclsQueryStyle, class;

    -- From WPObject

    override wpclsQueryDefaultView, class;

    -- From WPObject

    override wpclsQueryDefaultHelp, class;

    -- From WPObject

