/*
 *    SOMERR.H
 *    System Object Model run-time error codes
 *
 *    Copyright (c) International Business Machines Corporation
 *		    1991, 1992
 *
 *    @(#)somerr.h 1.16 1/30/92 16:53:20 [1/30/92] (c)IBM Corp. 1992
 */

#ifndef somerr_h
#define somerr_h

#define SOM_EB 20000

/*
 * The somDescendedFrom method was passed a NULL class argument.
 */
#define SOMERROR_CCNullClass		SOM_WarnCode(1)

/*
 * The internal buffer used in somPrintf overflowed.
 */
#define SOMERROR_SompntOverflow 	SOM_FatalCode(2)

/*
 * somFindMethodOk failed to find the indicated method.
 */
#define SOMERROR_MethodNotFound 	SOM_FatalCode(3)

/*
 * Method table overflow in somAddStaticMethod
 */
#define SOMERROR_StaticMethodTableOverflow  SOM_FatalCode(4)

/*
 * The somDefaultMethod was called, probably means a defined method
 *  was not added before it was invoked
 */
#define SOMERROR_DefaultMethod		SOM_FatalCode(5)

/*
 *   The specified method was not defined on the target object.
 */
#define SOMERROR_MissingMethod		SOM_FatalCode(6)

/*
 *    Attempt to load, create or use a version of a class object
 *    implementation that is incompatible with the using program.
 */
#define SOMERROR_BadVersion		SOM_FatalCode(7)

/*
 *   somCheckId was given a NULL id to check.
 */
#define SOMERROR_NullId 		SOM_FatalCode(8)

/*
 *   Memory exhausted
 */
#define SOMERROR_OutOfMemory		SOM_FatalCode(9)

/*
 *   somObjectTest found problems with the object it was testing
 */
#define SOMERROR_TestObjectFailure	SOM_FatalCode(10)

/*
 *   somTest detected a failure, only generated by test code
 */
#define SOMERROR_FailedTest		SOM_FatalCode(11)

/*
 *   somFindClass could not find the requested class.
 */
#define SOMERROR_ClassNotFound		SOM_WarnCode(12)

/*
 *   Old style method name used, change to appropriate name
 */
#define SOMERROR_OldMethod		SOM_WarnCode(13)

/*
 *   Calling somEnvironmentNew did not create the root class
 */
#define SOMERROR_CouldNotStartup	SOM_FatalCode(14)

/*
 *    somUnloadClassFile argument was not a registered class
 */
#define SOMERROR_NotRegistered		SOM_FatalCode(15)

/*
 *   Call to somOverrideSMethod for a method that was not defined in a
 *   parent class
 */
#define SOMERROR_BadOverride		SOM_FatalCode(16)

/*
 *   The method raising the error message is not implemented yet
 */
#define SOMERROR_NotImplementedYet	SOM_FatalCode(17)

/*
 *   The method raising the error message should have been overridden
 */
#define SOMERROR_MustOverride		SOM_FatalCode(18)

/*
 *   An argument to a core SOM method failed a validity test
 */
#define SOMERROR_BadArgument		SOM_FatalCode(19)

/*
 *   During class object create, the parent class object could not be found.
 */
#define SOMERROR_NoParentClass		SOM_FatalCode(21)

/*
 *   During class object create, the metaclass object could not be found.
 */
#define SOMERROR_NoMetaClass		SOM_FatalCode(22)

/*
 *   An attempt to index an out-of-range buffer entry
 */
#define SOMERROR_Indexrange		SOM_FatalCode(23)

/*
 *   An attempt to delete a character from an empty buffer
 */
#define SOMERROR_Underflow		SOM_FatalCode(24)

/*
 *   Internal logic error during buffer manipulation
 */
#define SOMERROR_Logic			SOM_FatalCode(25)

/*
 *
 */
#define SOMERROR_6			SOM_FatalCode(26)

/*
 *
 */
#define SOMERROR_7			SOM_FatalCode(27)

#endif /* somerr_h */
