
# This file was generated by the SOM Compiler.
# FileName: somcls.sc.
# Generated using:
#     SOM Precompiler spc: 1.22
#     SOM Emitter emitcsc: 1.10

--  SOMClass: System Object Model base metaclass
--  Copyright (c) International Business Machines Corporation
--                1991, 1992

#include <somobj.sc>

class: SOMClass, 
    external stem = sommc, function prefix = somc_, major version = 1, 
    minor version = 1, file stem = somcls;

    --  This is the SOM metaclass.  That is, the instances of this class
    --  are class objects.  When the SOM environment is created one
    --  instance of this class with the external name
    --  <SOMClassClassData.classObject> is created. This class object is
    --  unique in that it is its own class object.  That is,
    --  _SOMClass == _somGetClass(SOMClassClassData.classObject).
    --  SOMClass can be subclassed just like any SOM class. The subclasses
    --  of SOMClass are new metaclasses and can generate class objects with
    --  different implementations than those produced by _SOMClass.


parent class: SOMObject;


release order:
    somNew, somRenew, somInitClass, 
    somClassReady, somGetName, somGetParent, 
    somDescendedFrom, somCheckVersion, somFindMethod, 
    somFindMethodOk, somSupportsMethod, somGetNumMethods, 
    somGetInstanceSize, somGetInstanceOffset, somGetInstancePartSize, 
    somGetMethodIndex, somGetNumStaticMethods, somGetPClsMtab, 
    somGetClassMtab, somAddStaticMethod, somOverrideSMethod, 
    somAddDynamicMethod, somGetMethodOffset, somGetApplyStub, 
    somFindSMethod, somFindSMethodOk, somGetMethodDescriptor, 
    somGetNthMethodInfo, somSetClassData, somGetClassData, 
    somNewNoInit, somRenewNoInit, somGetInstanceToken, 
    somGetMemberToken, somSetMethodDescriptor, somGetMethodData;

methods:
group: InitTerm;

    --  Initialization / Termination / Class construction group

    somMToken    somAddStaticMethod(INOUT somId methodId,
		INOUT somId methodDescriptor,
		IN somMethodProc *method,
		IN somMethodProc *redispatchStub,
		IN somMethodProc *applyStub);

    --  Adds/overrides the indicated method, returns the value that
    --  should be used to set the method slot in the class data structure
    --  for this method name.
    -- 
    --  <methodDescriptor> is a somId for a string describing the calling
    --  sequence to this method as described in <somcGetNthMethodInfo>
    --  defined in the SOMObject class definition.
    -- 
    --  <method> is the actual method procedure for this method
    -- 
    --  <redispatchStub> is a procedure with the same calling sequence as
    --  <method> that re-dispatches the method to one of this class's
    --  dispatch functions.
    -- 
    --  <applyStub> is a procedure that takes a standard variable argument
    --  list data structure applies it to its target object by calling
    --  <method> with arguments derived from the data structure.  Its
    --  calling sequence is the same as the calling sequence of the
    --  dispatch methods defined in SOMObject.  This stub is used in the
    --  support of the dispatch methods used in some classes.  In classes
    --  where the dispatch functions do not need such a function this
    --  parameter may be null.

    void    somClassReady();

    --  This method is invoked when all of the static initialization for
    --  the class has been finished.  The default implementation simply
    --  registers the newly constructed class with the SOMClassMgr.
    --  Metaclasses may override this method to augment the class construction
    --  sequence in any way that they wish.

    void    somInitClass(IN zString className,
		IN SOMAny *parentClass,
		IN integer4 instanceSize,
		IN int maxStaticMethods,
		IN integer4 majorVersion,
		IN integer4 minorVersion);

    --  Initializes <self>.
    --  <parentClass> is the parent (or parent class) of this class, it may
    --  be NULL in which case it defaults to SOMObject (actually
    --  SOMObjectClassData.classObject the class object for SOMObject).
    --  If a parent class is specifed then it must have already been created
    --  as a pointer to its class object is required.
    -- 
    --  <instanceSize> should be just the space needed for this class, it
    --  is not necessary to consider the parent class's (if any) space
    --  requirements.
    -- 
    --  <maxStaticMethods> should be just the static methods defined by
    --  this class, it is not necessary to consider the parent class's
    --  methods (if any), even if they are overriden in this class.
    -- 
    --  <majorVersion> indicates the major version number for this
    --  implementation of the class definition, and <minorVersion>
    --  indicates the minor version number.

    void    somOverrideSMethod(INOUT somId methodId,
		IN somMethodProc *method);

    --  This method can be used instead of <somAddStaticMethod> or
    --  <somAddDynamicMethod> when it is known that the class' parent
    --  class already supports this method.  This call does not require the
    --  method descriptor and stub methods that the others do.

group: Factory;

    --  Instance creation / Constructor group

    SOMAny *   somNew();

    --  Make an instance of this class.  When applied to _SOMClass, or any
    --  other metaclass object, this will produce a new class object;
    --  when applied to a regular class object, this will produce an
    --  instance of that class.  The somInit method of the newly created
    --  object is then invoked automatically.

    SOMAny *   somNewNoInit();

    --  Equivalent to somNew except that somInit is not automatically invoked.

    SOMAny *   somRenew(IN void *obj);

    --  Make an instance of this class, but use the space pointed to by
    --  <obj> rather than allocating new space for the object.  Note: no
    --  test is made to insure that <obj> points to enough space.  <obj>
    --  is returned, but it is now a pointer to a valid, initialized,
    --  object (the somInit method of the "renewed" object is invoked
    --  automatically).

    SOMAny *   somRenewNoInit(IN void *obj);

    --  Equivalent to somRenew except that somInit is not automatically invoked.

group: Access;

    somMethodProc *   somGetApplyStub(INOUT somId methodId);

    --  Returns the apply stub associated with the specified method. NULL
    --  is returned if the method is not supported by this class.  An apply
    --  stub is a procedure that is called with a fixed calling sequence,
    --  namely (SOMAny *self, somId methodId, somId descriptor, ap_list
    --  ap) where <ap> is a varargs data structure that contains the actual
    --  argument list to be passed to the method.  The apply stub fowards
    --  the call to its associated method and then returns any result
    --  produced by the method.

    somClassDataStructure *   somGetClassData();

    --  Returns a pointer to the static <className>ClassData structure.

    somMethodTab *   somGetClassMtab();

    --  Returns a pointer to the method table of this class.

    somDToken    somGetInstanceToken();

    --  Returns a token that identifies the introduced portion of this class
    --  within itself or any derived class.  This token can be subsequently
    --  passed to the run-time somDataResolve function to locate the instance
    --  data introduced by this class.

    somDToken    somGetMemberToken(integer4 memberOffset,
		somDToken instanceToken);

    --  Returns a token that represents the data member at offset
    --  "memberOffset" within the introduced portion of the class identified
    --  by instanceToken.  The instance token must have been obtained from a
    --  previous invocation of somGetInstanceToken.  The returned member
    --  token can be subsequently passed to the run-time somDataResolve
    --  function to locate the data member.

    integer4    somGetInstanceOffset();

    --  Returns the offset in the body part of this [class] object for the
    --  instance data introduced by this class, as the distance in bytes along
    --  the class' "left-hand" derivation path.

    integer4    somGetInstancePartSize();

    --  Returns the size in bytes of the instance data introduced by this
    --  class.  This does not include the instance data space required for
    --  this class' ancestor or descendent classes.

    integer4    somGetInstanceSize();

    --  Returns the total size of an instance of <self>.
    --  All instances of <self> have the same size.

    somId    somGetMethodDescriptor(IN somId methodId);

    --  Returns the method descriptor for the indicated method.  If
    --  this object does not support the indicated method then NULL is
    --  returned.

    zString    somGetName();

    --  Returns this object's class name as a NULL terminated string.

    int    somGetNumMethods();

    --  Returns the number of methods currently supported by this class,
    --  including inherited methods (both static and dynamic).

    int    somGetNumStaticMethods();

    --  Returns the number of static methods that this class has.  This is
    --  used by a child class in initializing its method table.

    SOMClass *   somGetParent();

    --  Returns the parent class of self (along its "left-hand" derivation
    --  path), if one exists and NULL otherwise.

    somMethodTab *   somGetPClsMtab();

    --  Returns a pointer to the method table of this class's parent class
    --  (along its "left-hand" derivation path).  If this class is a root
    --  class (SOMObject), NULL is returned.

    void    somSetClassData(IN somClassDataStructure *cds);

    --  Sets the class' pointer to the static <className>ClassData structure.

group: Testing;

    int    somCheckVersion(IN integer4 majorVersion,
		IN integer4 minorVersion);

    --  Returns 1 (true) if the implementation of this class is
    --  compatible with the specified major and minor version number and
    --  false (0) otherwise.  An implementation is compatible with the
    --  specified version numbers if it has the same major version number
    --  and a minor version number that is equal to or greater than
    --  <minorVersion>.  The major, minor version number pair (0,0) is
    --  considered to match any version.  This method is usually called
    --  immediately after creating the class object to verify that a
    --  dynamically loaded class definition is compatible with a using
    --  application.

    int    somDescendedFrom(IN SOMClass *aClassObj);

    --  Returns 1 (true) if <self> is a descendent class of <aClassObj> and
    --  0 (false) otherwise.  Note: a class object is considered to be
    --  descended itself for the purposes of this method.

    int    somSupportsMethod(INOUT somId mId);

    --  Returns 1 (true) if the indicated method is supported by this
    --  class and 0 (false) otherwise.

group: Dynamic;

    int    somFindMethod(INOUT somId methodId,
		OUT somMethodProc **m);

    --  Finds the method procedure associated with <methodId> for this
    --  class and sets <m> to it.  1 (true) is returned when the
    --  method procedure is directly callable and 0 (false) is returned
    --  when the method procedure is a dispatch function.
    -- 
    --  If the class does not support the specified method then
    --  <m> is set to NULL and the return value is meaningless.
    -- 
    --  Returning a dispatch function does not guarantee that a
    --  class supports the specified method; the dispatch may fail.

    int    somFindMethodOk(INOUT somId methodId,
		OUT somMethodProc **m);

    --  Just like <somFindMethod> except that if the method is not
    --  supported then an error is raised and execution is halted.

    somMethodProc *   somFindSMethod(INOUT somId methodId);

    --  Finds the indicated method, which must be a static method defined
    --  for this class, and returns a pointer to its method procedure.
    -- 
    --  If the method is not defined (as a static method or at all) for
    --  this class then a NULL pointer is returned.

    somMethodProc *   somFindSMethodOk(INOUT somId methodId);

    --  Just like <somFindSMethod> except that an error is raised if the
    --  method is not defined for this class.

    override somInit;

    -- From SOMObject

    override somUninit;

    -- From SOMObject

    override somDumpSelfInt;

    -- From SOMObject

