@echo off

REM This is a part of the Microsoft Foundation Classes C++ library.
REM Copyright (C) 1994 WATCOM International Corporation
REM All rights reserved.
REM
REM This source code is only intended as a supplement to the
REM Microsoft Foundation Classes Reference and Microsoft
REM documentation provided with the library.

echo.
echo Microsoft Foundation Classes -- Sample Applications (batch build)
echo.
echo This batch file will build most of the Windows/MFC sample
echo applications.  Use of the batch file will save time and
echo disk space if you are interested in seeing all of the 
echo working samples as you learn the Microsoft Foundation Classes.
echo.
echo.

set __DEBUG=debug#1
if "%1"=="DEBUG" goto doit
if "%1"=="debug" goto doit

set __DEBUG=debug#0

if "%1"=="RETAIL" goto doit
if "%1"=="retail" goto doit

if "%1"=="CLEAN" goto doit_clean
if "%1"=="clean" goto doit_clean

echo Please specify DEBUG or RETAIL or CLEAN on the command line.
echo.
echo     DEBUG will build executables with symbolic information,
echo         diagnostics, and no optimizations (large and slow).
echo     RETAIL will build ship quality executables that
echo         are fully optimized (small and fast).
echo     CLEAN will remove all compiler generated files (object
echo         files, executables, etc.)  Use this to switch between
echo         DEBUG and RETAIL.
echo.

goto end

:doit
shift

echo.
echo NOTE: Since this builds all the sample programs it could 
echo take a little while.  Type Ctrl-C now if you wish
echo to build them later.  You can stop the build at
echo any time by typing Ctrl-C (several times) and 
echo answer 'Y' to terminate.
echo.
pause

:doit_clean

@echo on

cd CHKBOOK
wmake.exe %__DEBUG% %1
cd ..\CTRLBARS
wmake.exe %__DEBUG% %1
cd ..\CTRLTEST
wmake.exe %__DEBUG% %1
cd ..\DIBLOOK
wmake.exe %__DEBUG% %1
rem Must be build for debug.
cd ..\DLLTRACE
wmake.exe debug=1 %1
cd ..\HELLO
wmake.exe %__DEBUG% %1
cd ..\HELLOAPP
wmake.exe %__DEBUG% %1
cd ..\HIERSVR
wmake.exe %__DEBUG% %1
cd ..\MAKEHM
wmake.exe %__DEBUG% %1
cd ..\MDI
wmake.exe %__DEBUG% %1
cd ..\MINSVR
wmake.exe %__DEBUG% %1
cd ..\MULTIPAD
wmake.exe %__DEBUG% %1
cd ..\OCLIENT
wmake.exe %__DEBUG% %1
cd ..\SCRIBBLE\STEP0
wmake.exe %__DEBUG% %1
cd ..\STEP1
wmake.exe %__DEBUG% %1
cd ..\STEP2
wmake.exe %__DEBUG% %1
cd ..\STEP3
wmake.exe %__DEBUG% %1
cd ..\STEP4
wmake.exe %__DEBUG% %1
cd ..\STEP5
wmake.exe %__DEBUG% %1
cd ..\..\SPEAKN
wmake.exe %__DEBUG% %1
cd ..\SUPERPAD
wmake.exe %__DEBUG% %1
cd ..\TEMPLDEF
wmake.exe %__DEBUG% %1
cd ..\TRACER
wmake.exe %__DEBUG% %1
cd ..\VIEWEX
wmake.exe %__DEBUG% %1

cd ..

:end
set __DEBUG=
@echo on
