/*
 *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 *%									   %
 *%	Copyright (C) 1991,1994 by WATCOM International Inc.		   %
 *%	All rights reserved.						   %
 *%									   %
 *%     Permission is granted to anyone to use this example program for	   %
 *%     any purpose on any computer system, subject to the following	   %
 *%	restrictions:							   %
 *%									   %
 *%     1. This example is provided on an "as is" basis, without warranty. %
 *%	   You indemnify, hold harmless and defend WATCOM from and against %
 *%	   any claims or lawsuits, including attorney's, that arise or	   %
 *%	   result from the use or distribution of this example, or any     %
 *%	   modification thereof.					   %
 *%									   %
 *%     2. You may not remove, alter or suppress this notice from this	   %
 *%        example program or any modification thereof.			   %
 *%									   %
 *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 */

#include "box.hpp"

class cupboard : public box {
public:
    enum handle_position_flag {
        MIDDLE = 0,
        LEFT = 1,
        RIGHT = 2,
        TOP = 4,
        BOTTOM = 8 };

private:
    void build( unsigned pos );

public:
    cupboard( float width, float depth, float height, unsigned pos );
    cupboard( cupboard& left_neighbor, unsigned pos );
};

class fridge : public box {
public:
    enum handle_position { LEFT, RIGHT };

private:
    void make_fridge( handle_position pos );

public:
    fridge( float width, float depth, float height, handle_position pos );
};

class table : public box {
private:
    void top_and_four_legs( float leg_width );

public:
    table( float width, float depth, float height, float leg_width );
};

class chair : public box {
public:
    chair( float width, float depth, float height );
};

