
grant connect to "order" identified by "entry";
grant group to "order";
grant resource to "order";
grant membership in group "order" to "dba";
connect user "order" identified by "entry";

set temporary option input_format = ascii;

create table Customer (
    customer            integer not null,
    name                char(40) not null,
    street              char(40),
    city                char(40),
    state               char(20),
    zip                 char(20),
    phone               char(15),
                        primary key (customer)
);

create table Product (
    product            integer not null,
    list_price         decimal(13,2),
    description        char(40) not null,
                       primary key (product)
);

create table "Order" (
    "order"             integer not null,
    order_date          date,
    note                char(80),
    customer            integer not null,
                        primary key ("order"),
                        not null foreign key references Customer
);

create table Order_Item (
    "order"             integer not null,
    item                integer not null,
    product             integer not null,
    price               decimal(13,2),
    quantity            integer,
                        primary key ("order",item),
                        not null foreign key references "Order",
                        not null foreign key references Product
);

input into Customer;
1, Wile E. Coyote, 32 Desert Fox Lane
2, Yosemite Sam, 47 Wild West Avenue
3, Daffy Duck, 129 Laughing Stock Drive
4, Foghorn Leghorn, 819 Barnyard Boulevard
5, Bugs Bunny, 1 Looney Tune Lane
6, Elmer Fudd, 4927 Smoking Gun Woad
7, Tweety Bird, 54 Suburbia Street
8, Sylvester, 58 Suburbia Street
9, Granny, 54 Suburbia Street
10, Speedy Gonzales, 12 Rapid Rodent Road
11, Tasmanian Devil, 666 Frenzy Filled Crescent
end

input into Product;
1, 149.95, Rocket Roller Skates
2, 189.50, Explosive Bird Feeder
3,  19.99, Instant Dry Super Glue
4,  49.99, Heavy Duty Suction Cups
5,  14.99, Bird Seed
6,  12.00, Instant Manholes
7,  50.95, Deluxe Anvil
8, 109.95, Extra Large Wings
9,  85.00, Catapult Plans
10, 19.50, Giant Rubber Band
11, 39.99, Dynamite
end

