 /****************************************************************
 *       Copyright (C) 1988-1999, by Sybase, Inc.                *
 *       All rights reserved. No part of this software may be    *
 *       reproduced in any form or by any means - graphic,       *
 *       electronic or mechanical, including photocopying,       *
 *       recording, taping or information storage and retrieval  *
 *       systems - except with the written permission of         *
 *       Sybase, Inc.                                            *
 ****************************************************************/

#ifndef _SQLERR_H_INCLUDED
#define _SQLERR_H_INCLUDED
#define II_SQLERR

/**************************/
/* sql error return codes */
/**************************/

#define SQLE_GENERIC_ERROR          SQLE_ERROR

#define SQLE_ROLLBACK_RANGE_LOW     -320L
#define SQLE_ROLLBACK_RANGE_HIGH    SQLE_ERROR

#define _SQL_cause_rollback( stat )     \
                  ((stat) >= SQLE_ROLLBACK_RANGE_LOW && \
                   (stat) <= SQLE_ROLLBACK_RANGE_HIGH)
#define _SQL_is_fatal_error( stat )     (  (stat) == SQLE_ERROR  \
                                        || (stat) == SQLE_DATABASE_ERROR \
                                        || (stat) == SQLE_DEVICE_ERROR \
                                        || (stat) == SQLE_DEVICE_FULL \
					)
					
/*      Subtransaction Errors */

#define SQLE_SUBTRANS_NOTFOUND                      -220L
#define SQLE_SUBTRANS_REQUIRE_UNDO                  -213L


/*	Warnings */

#define SQLE_NOERROR                                0L
#define SQLE_NOTFOUND                               100L
#define SQLE_TRUNCATED                              101L
#define SQLE_TEMPORARY_TABLE                        102L
#define SQLE_CANNOT_CONVERT                         103L
#define SQLE_ROW_UPDATED_WARNING                    104L
#define SQLE_PROCEDURE_COMPLETE                     105L
#define SQLE_COLUMN_VALUE_CHANGED                   106L
#define SQLE_CANNOT_EXECUTE_STMT                    111L
#define SQLE_WARNING                                200L
#define SQLE_HLI_MORE_DATA_AVAILABLE                400L
#define SQLE_UNABLE_TO_START_ENGINE                 -80L
#define SQLE_INVALID_COMMAND_LINE                   -81L
#define SQLE_DATABASE_NOT_ACTIVE                    -74L
#define SQLE_START_STOP_DATABASE_DENIED             -75L
#define SQLE_REQUEST_DENIED_NO_DATABASES            -76L
#define SQLE_ALIAS_CLASH                            -77L
#define SQLE_INVALID_LOCAL_OPTION                   -79L
#define SQLE_UNABLE_TO_START_DATABASE               -82L
#define SQLE_DATABASE_NOT_FOUND                     -83L
#define SQLE_INVALID_DATABASE                       -84L
#define SQLE_COMMUNICATIONS_ERROR                   -85L
#define SQLE_COMMUNICATIONS_UNDERFLOW               -73L
#define SQLE_DYNAMIC_MEMORY_EXHAUSTED               -78L
#define SQLE_NO_MEMORY                              -86L
#define SQLE_DATABASE_NAME_REQUIRED                 -87L
#define SQLE_PROTOCOL_MISMATCH                      -88L
#define SQLE_ENGINE_ALREADY_RUNNING                 -96L
#define SQLE_ENGINE_NOT_MULTIUSER                   -89L
#define SQLE_INVALID_PARAMETER                      -95L
#define SQLE_PAGE_SIZE_TOO_BIG                      -97L
#define SQLE_PAGE_SIZE_INVALID                      -644L
#define SQLE_DATABASE_NOT_CREATED                   -645L
#define SQLE_AUTHENTICATION_VIOLATION               -98L
#define SQLE_CONNECTIONS_DISABLED                   -99L
#define SQLE_ENGINE_NOT_RUNNING                     -100L
#define SQLE_NOT_CONNECTED                          -101L
#define SQLE_TOO_MANY_CONNECTIONS                   -102L
#define SQLE_INVALID_LOGON                          -103L
#define SQLE_INVALID_PASSWORD                       -103L
#define SQLE_INVALID_MODULE_LOGON                   -104L
#define SQLE_UNABLE_TO_CONNECT                      -105L
#define SQLE_CANNOT_OPEN_LOG                        -106L
#define SQLE_ERROR_WRITING_LOG                      -107L
#define SQLE_CONNECTION_NOT_FOUND                   -108L
#define SQLE_STILL_ACTIVE_CONNECTIONS               -109L
#define SQLE_NAME_NOT_UNIQUE                        -110L
#define SQLE_INDEX_NAME_NOT_UNIQUE                  -111L
#define SQLE_EXISTING_PRIMARY_KEY                   -112L
#define SQLE_INVALID_FOREIGN_KEY_DEF                -113L
#define SQLE_VIEW_DEFINITION_ERROR                  -114L
#define SQLE_MUST_DROP_INDEX                        -115L
#define SQLE_TABLE_MUST_BE_EMPTY                    -116L
#define SQLE_PRIMARY_KEY_REFERENCED                 -117L
#define SQLE_NO_PRIMARY_KEY                         -118L
#define SQLE_PRIMARY_KEY_COLUMN_DEFINED             -119L
#define SQLE_ALTER_CLAUSE_CONFLICT                  -125L
#define SQLE_PRIMARY_KEY_TWICE                      -126L
#define SQLE_COLUMN_IN_INDEX                        -127L
#define SQLE_USER_OWNS_TABLES                       -128L
#define SQLE_IDENTIFIER_TOO_LONG                    -250L
#define SQLE_DUPLICATE_FOREIGN_KEY                  -251L
#define SQLE_INDEX_NOT_FOUND                        -183L
#define SQLE_MESSAGE_ALREADY_EXISTS                 -610L
#define SQLE_ALREADY_HAS_GRANT_PERMS                -120L
#define SQLE_PERMISSION_DENIED                      -121L
#define SQLE_GROUP_CYCLE                            -122L
#define SQLE_NOT_A_GROUP                            -123L
#define SQLE_ALREADY_HAS_GROUP_MEMBERSHIP           -312L
#define SQLE_INVALID_STATEMENT                      -130L
#define SQLE_SYNTAX_ERROR                           -131L
#define SQLE_STATEMENT_ERROR                        -132L
#define SQLE_INVALID_STATEMENT_TYPE                 -133L
#define SQLE_NOT_IMPLEMENTED                        -134L
#define SQLE_TSQL_FEATURE_NOT_SUPPORTED             -611L
#define SQLE_LANGUAGE_EXTENSION                     -135L
#define SQLE_STMT_NOT_ALLOWED_IN_PASSTHROUGH        -707L
#define SQLE_DBSPACE_NOT_FOUND                      -138L
#define SQLE_CORRELATION_NAME_AMBIGUOUS             -139L
#define SQLE_UNKNOWN_USERID                         -140L
#define SQLE_TABLE_NOT_FOUND                        -141L
#define SQLE_CORRELATION_NAME_NOT_FOUND             -142L
#define SQLE_COLUMN_NOT_FOUND                       -143L
#define SQLE_COLUMN_AMBIGUOUS                       -144L
#define SQLE_FOREIGN_KEY_NAME_NOT_FOUND             -145L
#define SQLE_CANNOT_JOIN                            -146L
#define SQLE_AMBIGUOUS_JOIN                         -147L
#define SQLE_OUTER_JOIN_CYCLE                       -136L
#define SQLE_CANNOT_OUTER_JOIN                      -162L
#define SQLE_CORRELATION_NAME_NEEDED                -137L
#define SQLE_UNKNOWN_FUNC                           -148L
#define SQLE_INVALID_GROUP_SELECT                   -149L
#define SQLE_AGGREGATES_NOT_ALLOWED                 -150L
#define SQLE_SUBQUERY_SELECT_LIST                   -151L
#define SQLE_INVALID_ORDER                          -152L
#define SQLE_INVALID_UNION                          -153L
#define SQLE_MESSAGE_NOT_FOUND                      -612L
#define SQLE_USER_TYPE_NOT_FOUND                    -613L
#define SQLE_USER_OWNS_MESSAGES_OR_DATATYPES        -614L
#define SQLE_USER_OWNS_REPLICATED_OBJECTS           -731L
#define SQLE_WRONG_PARAMETER_COUNT                  -154L
#define SQLE_INVALID_PARAMETER_NAME                 -615L
#define SQLE_VARIABLE_INVALID                       -155L
#define SQLE_EXPRESSION_ERROR                       -156L
#define SQLE_CONVERSION_ERROR                       -157L
#define SQLE_OVERFLOW_ERROR                         -158L
#define SQLE_INVALID_COLUMN_NUMBER                  -159L
#define SQLE_DESCRIBE_NONSELECT                     -160L
#define SQLE_INVALID_DESCRIBE_TYPE                  -161L
#define SQLE_CURSOR_NOT_DECLARED                    -170L
#define SQLE_OPEN_CURSOR_ERROR                      -171L
#define SQLE_CURSOR_ALREADY_OPEN                    -172L
#define SQLE_CURSOR_NOT_OPEN                        -180L
#define SQLE_NO_INDICATOR                           -181L
#define SQLE_SQLDA_TOO_SMALL                        -182L
#define SQLE_PUT_CURSOR_ERROR                       -184L
#define SQLE_TOO_MANY_RECORDS                       -185L
#define SQLE_SUBQUERY_RESULT_NOT_UNIQUE             -186L
#define SQLE_CURSOROP_NOT_ALLOWED                   -187L
#define SQLE_NOT_ENOUGH_HOST_VARS                   -188L
#define SQLE_NOT_FOUND_IN_INDEX                     -189L
#define SQLE_NON_UPDATEABLE_COLUMN                  -190L
#define SQLE_CANNOT_MODIFY                          -191L
#define SQLE_NON_UPDATEABLE_VIEW                    -192L
#define SQLE_PRIMARY_KEY_NOT_UNIQUE                 -193L
#define SQLE_INVALID_FOREIGN_KEY                    -194L
#define SQLE_COLUMN_CANNOT_BE_NULL                  -195L
#define SQLE_INDEX_NOT_UNIQUE                       -196L
#define SQLE_NO_CURRENT_ROW                         -197L
#define SQLE_PRIMARY_KEY_VALUE_REF                  -198L
#define SQLE_ONLY_ONE_TABLE                         -199L
#define SQLE_INVALID_COLUMN_VALUE                   -209L
#define SQLE_ROW_UPDATED_SINCE_READ                 -208L
#define SQLE_WRONG_NUM_OF_INSERT_COLS               -207L
#define SQLE_PRIMARY_KEY_MULTI_ROW_UPDATE           -252L
#define SQLE_PRIMARY_KEY_CURSOR_UPDATE              -253L
#define SQLE_DELETE_SUBQUERY_SAME_TABLE             -254L
#define SQLE_CURSOR_DELETE_SELF_REF                 -255L
#define SQLE_INSERT_SELF_REFERENCING                -256L
#define SQLE_VARIABLE_NOT_FOUND                     -260L
#define SQLE_VARIABLE_EXISTS                        -261L
#define SQLE_LABEL_NOT_FOUND                        -262L
#define SQLE_INVALID_FETCH_POSITION                 -263L
#define SQLE_WRONG_NUM_OF_FETCH_VARIABLES           -264L
#define SQLE_PROCEDURE_NOT_FOUND                    -265L
#define SQLE_OLD_DBINIT                             -266L
#define SQLE_ATOMIC_OPERATION                       -267L
#define SQLE_TRIGGER_NOT_FOUND                      -268L
#define SQLE_COLUMN_IN_TRIGGER                      -269L
#define SQLE_USER_OWNS_PROCEDURES                   -270L
#define SQLE_TRIGGER_DEFN_CONFLICT                  -271L
#define SQLE_INVALID_TRIGGER_COL_REFS               -272L
#define SQLE_INVALID_TRIGGER_STATEMENT              -273L
#define SQLE_NESTING_TOO_DEEP                       -274L
#define SQLE_PROCEDURES_NOT_IN_DESKTOP              -275L
#define SQLE_PUBLICATION_NOT_FOUND                  -280L
#define SQLE_TABLE_HAS_PUBLICATIONS                 -281L
#define SQLE_SUBSCRIPTION_NOT_UNIQUE                -282L
#define SQLE_SUBSCRIPTION_NOT_FOUND                 -283L
#define SQLE_ONLY_ONE_PUBLISHER                     -284L
#define SQLE_NOT_REMOTE_USER                        -285L
#define SQLE_NOT_REMOTE_TYPE                        -286L
#define SQLE_PASSTHROUGH_INCONSISTENT               -287L
#define SQLE_REMOTE_STATEMENT_FAILED                -288L
#define SQLE_CANNOT_UNIQUELY_IDENTIFY_ROWS          -295L
#define SQLE_ERROR_NUMBER_OUT_OF_RANGE              -296L
#define SQLE_INVALID_FORMAT_STRING_ARG_NUM          -294L
#define SQLE_INVALID_OPTION                         -200L
#define SQLE_INVALID_OPTION_SETTING                 -201L
#define SQLE_LOCKED                                 -210L
#define SQLE_MUST_BE_ONLY_CONNECTION                -211L
#define SQLE_CHECKPOINT_REQUIRES_UNDO               -212L
#define SQLE_TABLE_IN_USE                           -214L
#define SQLE_PROCEDURE_IN_USE                       -215L
#define SQLE_SAVEPOINT_NOTFOUND                     -220L
#define SQLE_ROLLBACK_NOT_ALLOWED                   -221L
#define SQLE_RESULT_NOT_ALLOWED                     -222L
#define SQLE_SAVEPOINTS_REQUIRE_UNDO                -213L
#define SQLE_PP_DBLIB_MISMATCH                      -230L
#define SQLE_DBLIB_ENGINE_MISMATCH                  -231L
#define SQLE_SERVER_ENGINE_MISMATCH                 -232L
#define SQLE_UNKNOWN_BACKUP_OPERATION               -240L
#define SQLE_BACKUP_NOT_STARTED                     -241L
#define SQLE_BACKUP_CANNOT_RENAME_LOG_YET           -242L
#define SQLE_BACKUP_UNABLE_TO_DELETE_FILE           -243L
#define SQLE_LOG_TRUNCATED                          -244L
#define SQLE_USER_DEFINED_EXCEPTION                 -297L
#define SQLE_DOUBLE_REQUEST                         -298L
#define SQLE_INTERRUPTED                            -299L
#define SQLE_ERROR                                  -300L
#define SQLE_DATABASE_ERROR                         -301L
#define SQLE_TERMINATED_BY_USER                     -302L
#define SQLE_DEVICE_FULL                            -304L
#define SQLE_DEVICE_ERROR                           -305L
#define SQLE_DEADLOCK                               -306L
#define SQLE_THREAD_DEADLOCK                        -307L
#define SQLE_CONNECTION_TERMINATED                  -308L
#define SQLE_HLI_BAD_SYNTAX                         -400L
#define SQLE_HLI_BAD_CURSOR                         -401L
#define SQLE_HLI_BAD_STATEMENT                      -402L
#define SQLE_HLI_BAD_HOST_VAR_NAME                  -403L
#define SQLE_HLI_BAD_HOST_VAR_VALUE                 -404L
#define SQLE_HLI_BAD_CALLBACK                       -405L
#define SQLE_HLI_INTERNAL                           -406L
#define SQLE_HLI_BAD_ARGUMENT                       -407L
#define SQLE_BEYOND_EOF                             -310L
#define SQLE_PHANTOM                                -501L
#define SQLE_UNBLOCKED                              -502L
#define SQLE_LOG_CORRUPTED                          -311L
#define SQLE_UNSUPPORTED_LOAD_FORMAT                -601L
#define SQLE_CANNOT_ACCESS_FILE                     -602L
#define SQLE_COLUMN_VALUE_TOO_LONG                  -603L
#define SQLE_CANNOT_UNLOAD_A_VIEW                   -643L
#define SQLE_DBSPACE_FULL                           -604L
#define SQLE_ACCESS_BEYOND_END_OF_MAX_DBSPACE       -605L
#define SQLE_PATTERN_TOO_LONG                       -606L
#define SQLE_CANNOT_STOP_SERVER                     -607L
#define SQLE_INVALID_TEXTPTR_VALUE                  -608L
#define SQLE_INVALID_TEXT_IMAGE_DATATYPE            -609L
#define SQLE_TOO_MANY_COLUMNS_IN_TABLE              -616L
#define SQLE_EXTERNAL_CALLS_NOT_SUPPORTED           -617L
#define SQLE_EXTERNAL_PLATFORM_FAILURE              -618L
#define SQLE_REQUIRE_DLL_NAME                       -619L
#define SQLE_COULD_NOT_LOAD_LIBRARY                 -620L
#define SQLE_COULD_NOT_FIND_FUNCTION                -621L
#define SQLE_ERROR_CALLING_FUNCTION                 -622L
#define SQLE_DDL_NOT_ALLOWED_IN_PROCEDURES          -623L
#define SQLE_DATATYPE_NOT_ALLOWED                   -624L
#define SQLE_TOO_MANY_PARAMETERS                    -625L
#define SQLE_THREAD_START_FAILURE                   -626L
#define SQLE_INVALID_SYNTAX_EXTENSION               -627L
#define SQLE_DIV_ZERO_ERROR                         -628L
#define SQLE_INVALID_ESCAPE_CHAR                    -629L
#define SQLE_INVALID_ESCAPE_SEQ                     -630L
#define SQLE_RAISERROR_STMT                         -631L
#define SQLE_WITH_CHECK_OPTION_VIOLATION            -632L
#define SQLE_READ_ONLY_CURSOR                       -633L
#define SQLE_UNTERMINATED_C_STR                     -634L
#define SQLE_SYNTAX_EXTENSION_WARNING               107L
#define SQLE_CURSOR_OPERATION_CONFLICT              108L
#define SQLE_NO_COLUMN_PERMS_FOR_VIEWS              -635L
#define SQLE_NULL_VALUE_ELIMINATED                  109L
#define SQLE_DUPLICATE_REFERENCING_COLUMN           -636L
#define SQLE_DUPLICATE_INSERT_COLUMN                -637L
#define SQLE_STRING_RIGHT_TRUNCATION                -638L
#define SQLE_PARAMETER_NAME_MISSING                 -639L
#define SQLE_INVALID_DESCRIPTOR_INDEX               -640L
#define SQLE_ERROR_IN_ASSIGNMENT                    -641L
#define SQLE_INVALID_DESCRIPTOR_NAME                -642L
#define SQLE_BACKUP_PAGE_INCOMPLETE                 110L
#define SQLE_NO_DESCRIPTOR_DATA                     100L
#define SQLE_NOT_PUBLIC_ID                          -202L
#define SQLE_MORE_INFO                              112L
#define SQLE_TOO_MANY_COLUMNS_DELETED               -124L
#define SQLE_TEMPORARY_NOT_ALLOWED                  -203L
#define SQLE_INVALID_OPTION_ON_CONNECT              113L
#define SQLE_OPTION_REQUIRES_DBA                    -204L
#define SQLE_INVALID_STANDARD_LOGON                 -205L
#define SQLE_INVALID_INTEGRATED_LOGON               -206L
#define SQLE_INTEGRATED_LOGON_FAILED                -245L
#define SQLE_PREEMPTED                              -503L
#define SQLE_RETRY                                  -504L
#define SQLE_INTEGRATED_LOGON_UNSUPPORTED           -246L
#define SQLE_INTEGRATED_LOGON_GUESTMAP              -247L
#define SQLE_INTEGRATED_LOGON_SYSMAP                -248L
#define SQLE_INTEGRATED_LOGON_MAPPED                -249L
#define SQLE_INTEGRATED_LOGON_UNMAPPED              -313L
#define SQLE_ARGUMENT_CANNOT_BE_NULL                -90L
#define SQLE_UNHANDLED_JAVA_EXCEPTION               -91L
#define SQLE_BAD_CLASS_FILE                         -92L
#define SQLE_STORE_NOT_LOADED                       -646L
#define SQLE_STORE_ENTRY_NOT_FOUND                  -647L
#define SQLE_INVALID_DBSPACE_FOR_CREATE             -648L
#define SQLE_FIELD_NOT_FOUND                        -93L
#define SQLE_INVALID_FIELD_REFERENCE                -94L
#define SQLE_FIELD_CANNOT_BE_NULL                   -649L
#define SQLE_INVALID_INDEX_TYPE                     -650L
#define SQLE_DROP_DATABASE_FAILED                   -651L
#define SQLE_CANNOT_DECOMPRESS_CLASS                -652L
#define SQLE_CLASS_MEMBER_OF_JAR                    -653L
#define SQLE_NO_PROFILE_FILE                        -654L
#define SQLE_GEN_PARSE_ERROR                        -655L
#define SQLE_CANNOT_UPDATE_NULL_ROW                 -734L
#endif
