 /****************************************************************
 *       Copyright (C) 1988-1999, by Sybase, Inc.                *
 *       All rights reserved. No part of this software may be    *
 *       reproduced in any form or by any means - graphic,       *
 *       electronic or mechanical, including photocopying,       *
 *       recording, taping or information storage and retrieval  *
 *       systems - except with the written permission of         *
 *       Sybase, Inc.                                            *
 ****************************************************************/

#ifndef _SQLDEF_H_INCLUDED
#define _SQLDEF_H_INCLUDED
#define II_SQLDEF

#include "sqlca.h"
#include "sqlda.h"
#include "sqlerr.h"
#include "sqlstate.h"

#include "pshpk1.h"

/********************************************/
/* general definition of database constants */
/********************************************/

#define DB_MAX_IDENTIFIER_LEN   128


/**************************************************/
/* definitions for connection parms to dblib      */
/*   - used in functions: db_build_parms          */
/*                        db_free_parms           */
/*                        db_start                */
/*                        db_parm_connect         */
/**************************************************/

typedef struct a_dblib_info {
    char                _sqlfar *userid;
    char                _sqlfar *password;
    char                _sqlfar *database_name;
    char                _sqlfar *connection_name;
    char                _sqlfar *dbstartcommline;
} a_dblib_info;


/**************************************************/
/* constants for return values of DOS executables */
/**************************************************/

typedef short int an_exit_code;

#define EXIT_OKAY                   0   /* everything is okay */
#define EXIT_FAIL                   1   /* general failure */
#define EXIT_BAD_DATA               2   /* invalid file format, etc.*/
#define EXIT_FILE_ERROR             3   /* file not found, */
                                        /* unable to open, etc. */
#define EXIT_OUT_OF_MEMORY          4   /* out of memory */
#define EXIT_BREAK                  5   /* terminated by user */
#define EXIT_COMMUNICATIONS_FAIL    6   /* failed communications */
#define EXIT_MISSING_DATABASE       7   /* missing required db name */
#define EXIT_PROTOCOL_MISMATCH      8   /* client/server protocol */
                                        /* mismatch */
#define EXIT_UNABLE_TO_CONNECT      9   /* unable to connect to db */
#define EXIT_ENGINE_NOT_RUNNING     10  /* database not running */
#define EXIT_SERVER_NOT_FOUND       11  /* server not running */
#define EXIT_SUICIDE_SUCCESS	    253 /* suicide with success */
#define EXIT_TIMEOUT                254 /* stop time reached */
#define EXIT_USAGE                  255 /* invalid command line */


/************************************************/
/* constants for return value of db_find_engine */
/************************************************/

#define DB_ENGINE               0x0001
#define DB_CLIENT               0x0002
#define DB_CAN_MULTI_DB_NAME    0x0004
#define DB_DATABASE_SPECIFIED   0x0008
#define DB_ACTIVE_CONNECTION    0x0010
#define DB_CONNECTION_DIRTY     0x0020
#define DB_CAN_MULTI_CONNECT    0x0040
#define DB_NO_DATABASES         0x0080

/**********************************/
/* host language type definitions */
/**********************************/

typedef unsigned short  a_sql_data_type;

#define DT_TYPES        0x03fe
#define DT_FLAGS        0xfc01

#define DT_NULLS_ALLOWED        0x0001

/* The following flags are used in the */
/* indicator variable on a describe */

#define DT_PROCEDURE_OUT	0x8000
#define DT_PROCEDURE_IN		0x4000
#define DT_UPDATABLE            0x2000
#define DT_DESCRIBE_INPUT       0x1000
#define DT_AUTO_INCREMENT	0x0800
#define DT_KEY_COLUMN		0x0400
#define DT_HIDDEN_COLUMN	0x0200


#define DT_NOTYPE       0
#define DT_SMALLINT     500
#define DT_INT          496
#define DT_DECIMAL      484
#define DT_FLOAT        482
#define DT_DOUBLE       480
#define DT_DATE         384
#define DT_STRING       460
#define DT_FIXCHAR      452
#define DT_VARCHAR      448
#define DT_LONGVARCHAR  456
#define DT_TIME         388
#define DT_TIMESTAMP    392
#define DT_TIMESTAMP_STRUCT 390
#define DT_BINARY       524
#define DT_LONGBINARY   528
#define DT_VARIABLE     600
#define DT_TINYINT	604
#define DT_BIGINT	608
#define DT_UNSINT	612
#define DT_UNSSMALLINT	616
#define DT_UNSBIGINT	620
#define DT_BIT		624

/**************************/
/* Backup operation types */
/**************************/

#define DB_BACKUP_START             1
#define DB_BACKUP_OPEN_FILE         2
#define DB_BACKUP_READ_PAGE         3
#define DB_BACKUP_CLOSE_FILE        4
#define DB_BACKUP_END               5
#define DB_BACKUP_READ_RENAME_LOG   6

/******************************/
/* Log Backup operation types */
/******************************/

#define DB_LOG_BACKUP_START         51
#define DB_LOG_BACKUP_READ_PAGE     52
#define DB_LOG_BACKUP_READ_PAGE_WAIT 53
#define DB_LOG_BACKUP_END           54

/**************************/
/* Backup file constants  */
/**************************/

#define DB_BACKUP_MAX_FILE          12
#define DB_BACKUP_WRITE_FILE        -1
#define DB_BACKUP_TRANS_LOG_FILE    -2

/**************************/
/* Backup version         */
/**************************/

#define DB_BACKUP_VERSION            1

/****************************/
/* db_environment constants */
/****************************/

#define DB_ENV_FLAGS                0       /* Short int */
#define DB_ENV_ENGVERSION           1       /* String */
#define DB_ENV_ENGNAME              2       /* String */
#define DB_ENV_DBNAME               3       /* String */
#define DB_ENV_SRVNAME              4       /* String */
#define DB_ENV_SRVVERSION           5       /* String */

/**********************************/
/* db_interface_option constants */
/**********************************/

typedef int			    a_db_interface_option;

#define DBO_ANSI_TRUNCATION         1
#define DBO_ANSI_BLANKS             2

/**************************************/
/* db_init_dll return value constants */
/**************************************/

#define ESQLDLL_OK		    0
#define ESQLDLL_DLL_NOT_FOUND	    1
#define ESQLDLL_WRONG_VERSION	    2

#include "poppk.h"

#endif
