 /****************************************************************
 *       Copyright (C) 1988-1999, by Sybase, Inc.                *
 *       All rights reserved. No part of this software may be    *
 *       reproduced in any form or by any means - graphic,       *
 *       electronic or mechanical, including photocopying,       *
 *       recording, taping or information storage and retrieval  *
 *       systems - except with the written permission of         *
 *       Sybase, Inc.                                            *
 ****************************************************************/

#ifndef _SQLDA_H_INCLUDED
#define _SQLDA_H_INCLUDED
#define II_SQLDA

#include "pshpk1.h"

#include "sqlca.h"

#define SQL_MAX_NAME_LEN        30

#define _sqldafar		_sqlfar

typedef	short int	a_sql_type;

struct sqlname {
    short int           length;                     /* length of char data */
    char		data[ SQL_MAX_NAME_LEN ];   /* data                */
};

struct sqlvar {                  /* array of variable descriptors        */
    short int           sqltype;           /* type of  host variable     */
    short int           sqllen;            /* length of host variable    */
    void _sqldafar      *sqldata;           /* address of variable        */
    short int _sqldafar *sqlind;           /* indicator variable pointer */
    struct sqlname      sqlname;
};

struct sqlda{
    unsigned char       sqldaid[8];  /* eye catcher "SQLDA"                  */
    long  int           sqldabc;     /* length of sqlda structure            */
    short int           sqln;        /* descriptor size in number of entries */
    short int           sqld;        /* number of variables found by DESCRIBE*/
    struct sqlvar       sqlvar[1];   /* array of variable descriptors        */
};

#define SCALE(sqllen)           ((sqllen)/256)
#define PRECISION(sqllen)       ((sqllen)&0xff)
#define SET_PRECISION_SCALE(sqllen,precision,scale)     \
                                sqllen = (scale)*256 + (precision)
#define DECIMALSTORAGE(sqllen)  (PRECISION(sqllen)/2 + 1)

typedef struct sqlda    SQLDA;
typedef struct sqlvar   SQLVAR, SQLDA_VARIABLE;
typedef struct sqlname  SQLNAME, SQLDA_NAME;

#ifndef SQLDASIZE
#define SQLDASIZE(n)    ( sizeof( struct sqlda ) +  \
                          (n-1) * sizeof( struct sqlvar) )
#endif

#include "poppk.h"

#endif
