{$floatcalls-,$real:8,$debug-}

{$include:'d:\compiler\fink.int'}
{$include:'d:\compiler\finu.int'}
program weekly(input,output);
uses filuqq;

procedure date(var DDMMYY:string); EXTERN;

const
  none =0; asis = 1; clok=2;
  Nadir=0; EASt = 1; WESt=2; Zenith=3;
  Jan  =1; Dec  =12;
  Day1 =1; DayN =31;
  PiscA=0; PiscB=14;
  JDN0 =2451626;
  half ='12:00';
  full ='24:00';
  hr12 =60*12;
  hr24 =60*24;

! Primary ...............................  Secondary  Codes
  SUN     = 1; DEEp     =11; PHAse   =21;  NAMe     =31; STAr   =41;
  MOOn    = 2; CIVil    =12; JULian  =22;  DISt     =32; ZODiac =42;
  MERcury = 3; NAUti    =13; DELta   =23;  UNIts    =33; AZImuth=43;
  VENus   = 4; ASTro    =14; OPEning =24;  LIGht    =34;
  MARs    = 5; MONth    =15; CLOsing =25;  SIZe     =35;
  JUPiter = 6; DAY      =16;               RISes    =36;
  SATurn  = 7; YY       =17;               SETs     =37;
  URAnus  = 8; MM       =18;               MAGn     =38;
  NEPtune = 9; DD       =19;               ILLum    =39;
  PLUto   =10; YYMMDD   =20;               ELOng    =40;

type
  vstring=lstring(255);
  lstring_32s = array[Name..AZIMuth] of lstring(32);

var [public]
  scaffold : text;
  ephemera : text;
  weakly   : text;

var [static]
  W         : array[  SUN..PLUto  ] of lstring_32s;
  V         : array[ DEEp..CLOsing] of lstring(32);
  msgs      : array[NADIr..ZENith ] of lstring(32);
  NEWZ      : array[NADir..ZENith ] of lstring(32);
  keys      : array[ none..AZImuth] of lstring( 3);
  code      : array[ none..AZImuth] of integer;
  months    : array[  Jan..DEC    ] of lstring( 9);
  days      : array[ Day1..DayN   ] of lstring( 4);
  signs     : array[PiscA..PiscB  ] of lstring(12);
  longitude : array[ none..PiscB  ] of integer;

value
  keys[none   ]:='???'; code[none   ]:=none;
  keys[SUN    ]:='SUN'; code[SUN    ]:=none;
  keys[MOOn   ]:='MOO'; code[MOOn   ]:=none;
  keys[MERcury]:='MER'; code[MERcury]:=none;
  keys[VENus  ]:='VEN'; code[VENus  ]:=none;
  keys[MARs   ]:='MAR'; code[MARs   ]:=none;
  keys[JUPiter]:='JUP'; code[JUPiter]:=none;
  keys[SATurn ]:='SAT'; code[SATurn ]:=none;
  keys[URAnus ]:='URA'; code[URAnus ]:=none;
  keys[NEPtune]:='NEP'; code[NEPtune]:=none;
  keys[PLUto  ]:='PLU'; code[PLUto  ]:=none;
  keys[DEEp   ]:='DEE'; code[DEEp   ]:=asis;
  keys[CIVil  ]:='CIV'; code[CIVil  ]:=clok;
  keys[NAUti  ]:='NAU'; code[NAUti  ]:=clok;
  keys[ASTro  ]:='AST'; code[ASTro  ]:=clok;
  keys[MONth  ]:='MON'; code[MONth  ]:=asis;
  keys[DAY    ]:='DAY'; code[DAY    ]:=asis;
  keys[YY     ]:='YY';  code[YY     ]:=asis;
  keys[MM     ]:='MM';  code[MM     ]:=asis;
  keys[DD     ]:='DD';  code[DD     ]:=asis;
  keys[YYMMDD ]:='YYM'; code[YYMMDD ]:=asis;
  keys[PHAse  ]:='PHA'; code[PHAse  ]:=asis;
  keys[JULian ]:='JUL'; code[JULian ]:=asis;
  keys[DELta  ]:='DEL'; code[DELta  ]:=asis;
  keys[OPEning]:='OPE'; code[OPEning]:=clok;
  keys[CLOsing]:='CLO'; code[CLOsing]:=clok;
  keys[NAMe   ]:='NAM'; code[NAMe   ]:=asis;
  keys[DISt   ]:='DIS'; code[DISt   ]:=asis;
  keys[UNIts  ]:='UNI'; code[UNIts  ]:=asis;
  keys[LIGht  ]:='LIG'; code[LIGht  ]:=asis;
  keys[SIZe   ]:='SIZ'; code[SIZe   ]:=asis;
  keys[RISes  ]:='RIS'; code[RISes  ]:=clok;
  keys[SETs   ]:='SET'; code[SETs   ]:=clok;
  keys[MAGn   ]:='MAG'; code[MAGn   ]:=asis;
  keys[ILLum  ]:='ILL'; code[ILLum  ]:=asis;
  keys[ELOng  ]:='ELO'; code[ELOng  ]:=asis;
  keys[STAr   ]:='STA'; code[STAr   ]:=asis;
  keys[ZODiac ]:='ZOD'; code[ZODiac ]:=asis;
  keys[AZImuth]:='AZI'; code[AZImuth]:=asis;

  months[ 1]:='January';   months[ 2]:='Februray';
  months[ 3]:='March';     months[ 4]:='April';
  months[ 5]:='May';       months[ 6]:='June';
  months[ 7]:='July';      months[ 8]:='August';
  months[ 9]:='September'; months[10]:='October';
  months[11]:='November';  months[12]:='December';

  days[ 1]:='1st';   days[11]:='11th';  days[21]:='21st';
  days[ 2]:='2nd';   days[12]:='12th';  days[22]:='22nd';
  days[ 3]:='3rd';   days[13]:='13th';  days[23]:='23rd';
  days[ 4]:='4th';   days[14]:='14th';  days[24]:='24th';
  days[ 5]:='5th';   days[15]:='15th';  days[25]:='25th';
  days[ 6]:='6th';   days[16]:='16th';  days[26]:='26th';
  days[ 7]:='7th';   days[17]:='17th';  days[27]:='27th';
  days[ 8]:='8th';   days[18]:='18th';  days[28]:='28th';
  days[ 9]:='9th';   days[19]:='19th';  days[29]:='29th';
  days[10]:='10th';  days[20]:='20th';  days[30]:='30th';
  days[31]:='31st';

  msgs[NADir ]:='won''t interfere';
  msgs[EASt  ]:='will interfere until  setting';
  msgs[WESt  ]:='will interfere after rising';
  msgs[ZENith]:='will interfere all night';

  NEWZ[NADir ]:='below the horizon';
  NEWZ[EASt  ]:='in the eastern sky';
  NEWZ[WESt  ]:='in the western sky';
  NEWZ[ZENith]:='high in the South';

  longitude[0]:=  0;       longitude[ 7]:=218;
      signs[1]:='Pisces';      signs[ 8]:='Libra';
  longitude[1]:= 28;       longitude[ 8]:=240;
      signs[2]:='Aries';       signs[ 9]:='Scorpio';
  longitude[2]:= 53;       longitude[ 9]:=248;
      signs[3]:='Taurus';      signs[10]:='Ophiuchus';
  longitude[3]:= 90;       longitude[10]:=266;
      signs[4]:='Gemini';      signs[11]:='Sagittarius';
  longitude[4]:=118;       longitude[11]:=300;
      signs[5]:='Cancer';      signs[12]:='Capricorn';
  longitude[5]:=139;       longitude[12]:=327;
      signs[6]:='Leo';         signs[13]:='Aquarius';
  longitude[6]:=173;       longitude[13]:=352;
      signs[7]:='Virgo';       signs[14]:='Pisces';
  longitude[7]:=218;       longitude[14]:=360;

! --------------------------------------------------------------------
! | This selects  a subset  of of  string starting  at posn  for cnt |
! | bytes. Cnt=0  means "the  remainder" of  the string.  If cnt  is |
! | greater than the  string, then the output is blank padded.       |
! --------------------------------------------------------------------
function substr(consts vs:vstring;posn,cnt:integer):vstring;
var
  c,i,j : integer;
  vst   : vstring;
begin
  c:=0;
  i:=1+ord(vs.len)-posn;
  if (i>=1) and (posn>=1) and (cnt>=0) then begin
    if cnt=0 then begin
      c:=i;
      j:=i;
    end
    else begin
      c:=cnt;
      for j:=i to c do vst[j]:=' ';
      if i<cnt then j:=i else j:=cnt;
    end;
    movesl(ads vs[posn], ads vst[1], wrd(j));
  end;
  vst.len:=wrd(c);
  substr:=vst;
end;

! --------------------------------------------------------------------
! | This functions mimics (allowing  for PASCAL's inability to  have |
! | infix functions) the concatenation operator || of REXX. The REXX |
! | statement A||B would be represented as js(A,B) in LCT.           |
! --------------------------------------------------------------------
function j2(consts s1,s2:vstring):vstring;
var
  st:vstring;
begin
  movesl(ads s1[1], ads st[1], s1.len);
  movesl(ads s2[1], ads st[1+s1.len], s2.len);
  st.len:=s1.len+s2.len;
  j2:=st;
end;

! --------------------------------------------------------------------
! | See J2. A||B||C is j3(A,B,C)                                     |
! --------------------------------------------------------------------
function j3(consts s1,s2,s3:vstring):vstring;
var
  i   : word;
  st  : vstring;
begin
  i:=1;
  movesl(ads s1[1], ads st[i], s1.len); i:=i+s1.len;
  movesl(ads s2[1], ads st[i], s2.len); i:=i+s2.len;
  movesl(ads s3[1], ads st[i], s3.len); i:=i+s3.len;
  st.len:=i-1;
  j3:=st;
end;

! --------------------------------------------------------------------
! | See J2. A||B||C||D is j4(A,B,C,D)                                |
! --------------------------------------------------------------------
function j4(consts s1,s2,s3,s4:vstring):vstring;
var
  i  : word;
  st  : vstring;
begin
  i:=1;
  movesl(ads s1[1], ads st[i], s1.len); i:=i+s1.len;
  movesl(ads s2[1], ads st[i], s2.len); i:=i+s2.len;
  movesl(ads s3[1], ads st[i], s3.len); i:=i+s3.len;
  movesl(ads s4[1], ads st[i], s4.len); i:=i+s4.len;
  st.len:=i-1;
  j4:=st;
end;

! --------------------------------------------------------------------
! | This  is  modeled  after  the  REXX  "WORD(string,n)"  function. |
! --------------------------------------------------------------------
function word_n(consts vsx:vstring;n:integer):vstring;
var
  vst      : vstring;
  vs       : vstring;
  beg,fin  : integer;
  vln,m    : integer;
  posn     : integer;
begin
   vs:=vsx;
   vs.len:=vs.len+1;
   vs[vs.len]:=' ';
   posn:=1;
   vln:=ord(vs.len);
   m:=0;
   beg:=0;
   fin:=0;
   while m<n do begin
     beg:=posn;
     while (vs[beg] =' ') and (beg<=vln) do beg:=beg+1;
     fin:=beg;
     while (vs[fin]<>' ') and (fin<=vln) do fin:=fin+1;
     if fin>vln then
       m:=n+1
     else begin
       m:=m+1;
       posn:=fin;
     end;
   end;
   if m=n then
     word_n:=substr(vs,beg,fin-beg)
   else begin
     vst.len:=0;
     word_n:=vst;
   end;
end;

! --------------------------------------------------------------------
! | This  function  is  a  close  approximation of the REXX function |
! | "TRANSLATE(string,tableo,tablei)". It translates "vs" characters |
! | from in "inpt" to corresponding characters in "outp". If  "inpt" |
! | is null then translate  "vs" to upper-case. "outp"  is truncated |
! | or blank padded to match the length of "inpt".                   |
! --------------------------------------------------------------------
function translate(consts vs,outp,inpt:vstring):vstring;
var [static] trtab : array[0..255] of char; value trtab[1]:=chr(0);
var
  os,is,ws : vstring;
  i        : integer;
begin
  if trtab[1]=chr(0) then
    for i:=0 to 255 do trtab[i]:=chr(i);
  ws:=vs; os:=outp; is:=inpt;
  if is.len=0 then begin
    is:='abcdefghijklmnopqrstuvwxyz';
    os:='ABCDEFGHIJKLMNOPQRSTUVWXYZ';
  end;
  if os.len<is.len then
    for i:=ord(os.len)+1 to ord(is.len) do os[i]:=' ';
  for i:=1 to ord(is.len) do trtab[ord(is[i])]:=os[i];
  for i:=1 to ord(ws.len) do ws[i]:=trtab[ord(ws[i])];
  for i:=1 to ord(is.len) do trtab[ord(is[i])]:=is[i];
  translate:=ws;
end;

! --------------------------------------------------------------------
! | Convert characters to 2 byte signed integers.                    |
! --------------------------------------------------------------------
function c2i(consts ch:vstring):integer;
var
  i    : integer;
  work : lstring(255);
begin
  work:=ch;
  if work=null
    then i:=trunc(0.0)
    else if not decode(work,i) then i:=0;
  c2i:=i;
end;

! --------------------------------------------------------------------
! | Convert 2 byte integers to printable character format. If n is   |
! | greater than 0, then left zero padding occurs to make n digits.  |
! --------------------------------------------------------------------
function i2c(i,n:integer):vstring;
var
  work : lstring(12);
  j,k  : integer;

begin
  if not encode(work,i:-1) then work:='**';
  if (ord(work.len)<n) and (i>=0) then begin
    j:=n-ord(work.len);
    for k:=n downto 1 do begin
      if (k-j)>0 then
        work[k]:=work[k-j]
      else
        work[k]:='0';
    end;
    work.len:=wrd(n);
  end;
  i2c:=work;
end;

! --------------------------------------------------------------------
! | Convert a specified number of minutes to hh|mm format            |
! --------------------------------------------------------------------
function hours(min:integer):vstring;
begin
  hours:=j3(i2c((min div 60),2),':',i2c((min mod 60),2));
end;

! --------------------------------------------------------------------
! | Convert a a string in hh|mm format to equivalent minutes         |
! --------------------------------------------------------------------
function mins(h24:vstring):integer;
begin
  mins:=60*c2i(substr(h24,1,2))+c2i(substr(h24,4,2));
end;

! --------------------------------------------------------------------
! | Compute the part of the sky where a body is located during       |
! | normal Frosty Drew Observatory hours.                            |
! --------------------------------------------------------------------
function horizon(bodyrise,bodysets:vstring):integer;
var
  br,bs,op,cl : integer;
begin
  op:=mins(V[OPEning]);
  cl:=mins(V[CLOsing]);
  br:=mins(bodyrise);
  bs:=mins(bodysets);
  if bs<br then bs:=bs+mins(full);
  if cl<op then cl:=cl+mins(full);
  if      (op<=bs) and (bs<=cl) then horizon:=WESt
  else if (op<=br) and (br<=cl) then horizon:=EASt
  else if (br<=op) and (cl<=bs) then horizon:=ZENith
                                else horizon:=NADir;
end;

! --------------------------------------------------------------------
! | Convert 24 hour clock hh|mm time to 12 hour hh|mm AM/PM format.  |
! --------------------------------------------------------------------
function AMPM(h24:vstring):vstring;
var
  clk : vstring;
  h,m : integer;
begin
  if h24=half then begin AMPM:='Noon'; return; end;
  if h24=full then begin AMPM:='Midnight'; return; end;
  h:=c2i(substr(h24,1,2));
  m:=c2i(substr(h24,4,2));
  if h<12
    then
      clk:=' AM'
    else begin
      clk:=' PM';
      if h>12
        then h:=h-12;
    end;
  clk:=j4(i2c(h,2),':',i2c(m,2),clk);
  if clk[1]='0'
    then clk:=substr(clk,2,0);
  AMPM:=clk;
end;

! --------------------------------------------------------------------
! | Determine what (if any) symbol was specified. This is a          |
! | procedure which is a subprocedure of "substitute".               |
! --------------------------------------------------------------------
procedure symbol(l:integer;vars r,id:integer;line:vstring);
var
  i : integer;
  u : vstring;
begin
  r:=l+1;
  while((('a'<=line[r]) and (line[r]<='z'))  or
        (('A'<=line[r]) and (line[r]<='Z'))) do r:=r+1;
  u:=translate(substr(line,l+1,r-l-1),null,null);
  if u.len>3 then u.len:=3;
  id:=none;
  for i:=SUN to AZImuth do if u=keys[i] then begin
    id:=i;
    break;
  end;
end;

! --------------------------------------------------------------------
! | Replace a ^symbol{_qualifier} if it is valid by its value.       |
! --------------------------------------------------------------------
procedure replace(i:integer; vars lline:vstring);
var
  what,main,qual      : integer;
  left,midl,rite      : integer;
  line,head,tale,item : vstring;

begin
! --------------------------------------------------------------------
! | Parse the symbol into a main symbol and a qualifier symbol       |
! | if the main part is a solar system name.                         |
! --------------------------------------------------------------------
  line:=lline;
  left:=i;
  symbol(left,midl,main,line);
  rite:=midl;
  if line[midl]='_' then
    symbol(midl,rite,qual,line)
  else
    qual:=none;

! --------------------------------------------------------------------
! | Assume the worst, prepare to issue a message.                    |
! --------------------------------------------------------------------
  what:=none;

! --------------------------------------------------------------------
! | If this is a solar system name check it has a valid              |
! | qualifier following it.                                          |
! --------------------------------------------------------------------
  if  ((SUN <=main) and (main<=PLUto))
  and ((NAMe<=qual) and (qual<=AZImuth)) then begin
    what:=code[qual];
    item:=W[main][qual];
  end;

! --------------------------------------------------------------------
! | If this is a single variable, make sure that it does NOT         |
! | have an invalid qualifier attached.                              |
! --------------------------------------------------------------------
  if (DEEp<=main) and (main<=CLOsing) and (qual=none) then begin
    what:=code[main];
    item:=V[main];
  end;

! --------------------------------------------------------------------
! | Worse has come to worst so issue a message.                      |
! --------------------------------------------------------------------
  if what=none then begin
    item:=substr(line,(left+1),(rite-left-1));
    writeln(output,'Unknown identifier = ',item);
    item:=j3('<! Unknown identifier = ',item,' >');
  end;

! --------------------------------------------------------------------
! | If the value is a 24 hour clock form convert to AM/PM form.      |
! --------------------------------------------------------------------
  if what=clok then
    item:=AMPM(item);

! --------------------------------------------------------------------
! | Reassemble the line with the value in place of the ^symbol.      |
! --------------------------------------------------------------------
  head:=substr(line,1,left-1);
  tale:=substr(line,rite,0);
  lline:=j3(head,item,tale);
end;

! --------------------------------------------------------------------
! | This utility program takes data from an ephem##.htm entry        |
! | for YYYY MM DD and places it into a scaffold at points where     |
! | a ^symbol appears creating a weekly.htm.                         |
! --------------------------------------------------------------------
var
  h,i,j,k,l,m : integer;
  body,data   : integer;
  N           : integer4;
  line,work   : vstring;
  Friday,item : vstring;
  found,first : boolean;
  DDMMYY      : string(8);

! --------------------------------------------------------------------
! | Opening and CLOsing times are any valid 24 hour clock values     |
! --------------------------------------------------------------------
begin
  V[OPEning]:='18:30';
  V[CLOsing]:='24:00';

! --------------------------------------------------------------------
! | Read in parameter if specified or prompt for the information.    |
! --------------------------------------------------------------------
  eval(ppmuqq(0,adr null,line));
  if line.len=0 then begin
    write(output,'Specify NEXT [or just Enter] or a date: YY/MM/DD = ');
    readln(input,line);
  end;
  if line.len=0 then line:='NEXT';
  line:=translate(line,null,null);

! --------------------------------------------------------------------
! | If a request for NEXT Friday determine today's date              |
! | for the start of the scan. Don't scan over breaks in years.      |
! --------------------------------------------------------------------
  if word_n(line,1)='NEXT' then begin
    date(DDMMYY);
    item.len:=8;
    for i:=1 to 8 do item[i]:=DDMMYY[i];
    item:=translate(item,' ','+-\|/,:.''"');
    V[YY]:=word_n(item,3);
    V[MM]:=word_n(item,1);
    V[DD]:=word_n(item,2);
    first:=false;
    if (V[MM]='12') and (V[DD]>='24')
      then first:=true;
  end

! --------------------------------------------------------------------
! | If a specific date was provided (or what we hope is a date)      |
! | convert it to YY MM DD values  and prepare to accept the         |
! | Friday which is this date or just follows it.                    |
! --------------------------------------------------------------------
  else begin
    line:=translate(line,' ','/,:.''"');
    V[YY]:=word_n(line,1);
    if V[YY].len>2 then V[YY]:=substr(V[YY],2,2);
    V[MM]:=word_n(line,2);
    V[DD]:=word_n(line,3);
    first:=true;
  end;
  V[YYMMDD]:=j3(V[YY],V[MM],V[DD]);

! --------------------------------------------------------------------
! | Scan the ephem##.htm file for correct YYMMDD FRiday entry.       |
! --------------------------------------------------------------------
  work:=j3('ephem',V[YY],'.htm');
  assign(ephemera,work);
  reset(ephemera);

  found:=false;
  repeat
    readln(ephemera,line);
    line:=translate(line,null,null);
    if substr(line,1,8)='<A NAME=' then begin
      Friday:=substr(line,9,6);
      if (first and (Friday=V[YYMMDD])) or (Friday>V[YYMMDD]) then
        found:=true;
    end;
  until (eof(ephemera)) OR (found);

! --------------------------------------------------------------------
! | No such date found so issue error message and stop               |
! --------------------------------------------------------------------
  if found=false then begin
    write(output,'No entry in ephem',V[YY],'.htm for ',YYMMDD,'.');
    readln(input,work);
    return;
  end;

! --------------------------------------------------------------------
! | Convert the dates to various printable formats                   |
! --------------------------------------------------------------------
  V[YYMMDD]:=Friday;
  V[YY]:=substr(Friday,1,2);
  V[MM]:=substr(Friday,3,2);
  V[DD]:=substr(Friday,5,2);
  V[MONth]:=months[c2i(V[MM])];
  V[DAY]:=days[c2i(V[DD])];
  writeln(output,'Processing weekly.htm for Friday ',V[month],' ',V[day],'.');

! --------------------------------------------------------------------
! | Skip over a couple of white noise lines                          |
! --------------------------------------------------------------------
  readln(ephemera,line);
  readln(ephemera,line);

! --------------------------------------------------------------------
! | Read in a line of the ephem##.htm at a specified YYMMDD          |
! | for each of the bodies of the solar system                       |
! --------------------------------------------------------------------
  for body:=SUN to PLUto do begin
    readln(ephemera,line);

!   ------------------------------------------------------------------
!   | For the Moon strip the Moon Icon file name from the            |
!   | comment field and store it into Phase.                         |
!   ------------------------------------------------------------------
    if body=MOOn then begin
      work:=' <! FULL >';
      for j:=1 to ord(line.len) do begin
        if line[j]='<' then begin
          work:=substr(line,j-1,0);
          line:=substr(line,1,j-1);
          break;
        end;
      end;
      V[PHAse]:=word_n(work,2);
    end;

!   ------------------------------------------------------------------
!   | Create a zero elongation for the Sun.                          |
!   ------------------------------------------------------------------
    if body=SUN then line:=j2(line,'   0+');

!   ------------------------------------------------------------------
!   | Load the basics entries into a pseudo string array.            |
!   ------------------------------------------------------------------
    for data:=NAME to ELONG do
      W[body][data]:=word_n(line,data-NAME+1);

!   ------------------------------------------------------------------
!   | Derive "Morning" and "Evening" star and distance from Sun.     |
!   ------------------------------------------------------------------
    item:=W[body][ELOng];
    if item[ord(item.len)]='+'
      then work:='Evening'
      else work:='Morning';
    item.len:=item.len-1;
    W[body][ELOng]:=item;
    W[body][STAr]:=work;

  end;

! --------------------------------------------------------------------
! | Skip over a couple of white noise lines                          |
! --------------------------------------------------------------------
  readln(ephemera,line);
  readln(ephemera,line);

! --------------------------------------------------------------------
! | Determine the twilight ending times                              |
! --------------------------------------------------------------------
  readln(ephemera,line);
  line:=translate(line,' ','=');
  V[CIVil]:=word_n(line,2);
  V[NAUti]:=word_n(line,4);
  V[ASTro]:=word_n(line,6);

! --------------------------------------------------------------------
! | Read the Julian date and the sidereal clock delta                |
! --------------------------------------------------------------------
  readln(ephemera,line);
  line:=translate(line,' ','=');
  V[JULian]:=word_n(line,2);
  V[DELta]:=word_n(line,4);

! --------------------------------------------------------------------
! | Determine the "OPEning" time to nearest 15 minutes before        |
! | sunset or 6|30 whichever comes LATER.                            |
! --------------------------------------------------------------------
  i:=mins(W[SUN][SETs]);
  j:=mins(V[OPEning]);
  i:=15*(i div 15);
  if i<j then i:=j;
  V[OPEning]:=hours(i);

! --------------------------------------------------------------------
! | Will the Moon interfere with viewing deep space objects?         |
! --------------------------------------------------------------------
  V[DEEp]:=msgs[horizon(W[MOOn][RISes],W[MOOn][SETs])];

! --------------------------------------------------------------------
! | Where is the solar system body located along the horizon?        |
! --------------------------------------------------------------------
  for body:=SUN to PLUto do
    W[body][AZImuth]:=NEWZ[horizon(W[body][RISes],W[body][SETs])];

! --------------------------------------------------------------------
! | Compute the constellation housing each so solar system body.     |
! --------------------------------------------------------------------
  eval(decode(V[JULian],N));
  N:=N-JDN0;
  m:=round(N*(360.0/365.25));
  for body:=SUN to PLUto do begin
    j:=mins(W[body][RISes]);
    k:=mins(W[body][SETs ]);
    if k<j then j:=j+hr24;
    j:=(((j-k) div 2)+k+hr24) mod hr24;
    i:=c2i(W[body][ELOng]);
    if j>hr12
      then k:=(m+i+360) mod 360
      else k:=(m-i+360) mod 360;
    for j:=PiscA to PiscB do begin
      item:=signs[j];
      if (longitude[j-1]<k) and (k<=longitude[j]) then break;
    end;
    W[body][ZODiac]:=item;
  end;

! --------------------------------------------------------------------
! | Prepare the scaffold.txt file for reading and erase old          |
! | weekly.htm (if any) preparatory to creating a new version.       |
! --------------------------------------------------------------------
  assign(scaffold,'scaffold.txt');
  reset(scaffold);
  assign(weakly,'weekly.htm');
  rewrite(weakly);

! --------------------------------------------------------------------
! | Read the scaffold.txt and enclose it in a pair of line           |
! | markers that avoid problems if substitutions start/end at ends.  |
! --------------------------------------------------------------------
  while not eof(scaffold) do begin
    readln(scaffold,line);
    line:=j3('',line,'');

!   ------------------------------------------------------------------
!   | Substitute any ^symbol with either the appropriate data        |
!   | or a "<! Unhnown identifier = symbol>" HTML comment.           |
!   ------------------------------------------------------------------
    i:=1; j:=ord(line.len);
    while i<j do begin
      if line[i]='^' then begin
        replace(i,line);
        i:=0; j:=ord(line.len);
      end;
      i:=i+1;
    end;

!   ------------------------------------------------------------------
!   | Strip the line end markers and write the modified              |
!   | line into the weekly.htm file                                  |
!   ------------------------------------------------------------------
    line:=substr(line,2,0);
    line.len:=line.len-1;
    writeln(weakly,line);
  end;

! --------------------------------------------------------------------
! | Close all files and write a message saying we are finished.      |
! --------------------------------------------------------------------
  close(ephemera);
  close(weakly);
  close(scaffold);

  write(output,'Complete.'); readln(input,line);

end.
