PAGE 60,96
TITLE 'MVPFORTH VERSION 1.0305.03 - 20 FEB 83'
;
;      MVPFORTH KERNEL VERSION 1.0305.03
;
;	  A FORTH OPERATING SYSSTEM 
;
;      FORTH THE IBM PERSONAL COMPUTER
;
;
;		PREPARED FOR
;
;	 MOUNTAIN VIEW PRESS, INC.
;	       PO BOX 4656
;	 MOUNTAIN VIEW, CA 94040
;
;	     IMPLEMENTATION BY
;
;	    HAYDON ENTERPRISES
;	      BOX 429 ROUTE 2
;	    LA HONDA, CA 94020
;
;
;THIS PUBLICATION IS PLACED IN THE PUBLIC 
;DOMAIN.  PERMISSION TO DISTRIBUTE IS GRANTED
;BY THE INCLUSION OF CREDIT TO MOUNTAIN VIEW
;PRESS, INC., AND HAYDON ENTERPRISES. 
;
;
;THIS IMPLEMENTATION INCLUDES THE ENTIRE 
;FORTH-79 REQUIRED WORD SET.  THE BOOK
;"ALL ABOUT FORTH"  BY GLEN B. HAYDON FULLY
;DOCUMENTS MVPFORTH. IT IS AVAILABLE FROM 
;MOUNTAIN VIEW PRESS, INC.  
;
;THE IMPLEMENTATION HAS BEEN TRANSCRIBED FROM
;THE ORIGINAL CROSS COMPILER VER. 1.0000.02 .
;IT WILL ASSEMBLE WITH "MASM.COM" UNDER MDOS
;VER. 1.0 OR 1.1 . 
;
;BECAUSE OF THE TYPE-AHEAD BUFFER OF THE IBM,
;?TERMINAL HAS A SLIGHTLY DIFFERENT FUNCTION
;FROM STANDARD MVPFORTH.  THE TRUE FLAG IS 
;THE ASCII VALUE OF THE KEY STRUCK (THE FALSE
;FLAG REMAINS 0).  BY USING  ?DUP  BEFORE 
;TESTING, THE VALUE OF THE STRUCK KEY WILL BE
;LEFT ON THE STACK.  THUS IT IS NOT NECESSARY
;TO CLEAR THE STATUS FLAG WITH THE SEQUENCE
; - KEY DROP . 
;UPDATE: ?STACK, BUFFER, COLD, LIST
;20 FEB 1983
PAGE
;
;THE FORTH REGISTERS ARE ASSIGNED ACCORDING
;TO FIG-FORTH FOR THE 8086/88, VERSION 1.0,
;AS IMPLEMENTED BY THOMAS NEWMAN, 27444
;BERENDA WAY, HAYWARD, CA 94544, AND MADE
;AVAILABLE BY THE FORTH INTEREST GROUP, 
;BOX 1105, SAN CARLOS, CA 94070.
;
;FORTH REGISTERS
;
;FORTH	8088  FORTH PRESERVATION RULES
;
; IP	 SI   INTERPRETER POINTER.
;	      MUST BE PRESERVED 
;	      ACROSS FORTH WORDS. 
;
; W	 DX   WORKING REGISTER.
;	      JUMP TO 'DPUSH' WILL 
;	      PUSH CONTENTS ONTO THE
;	      PARAMETER STACK BEFORE
;	      EXECUTING 'APUSH'.
;
; SP	 SP   PARAMETER STACK POINTER.
;	      MUST BE PRESERVED ACROSS
;	      FORTH WORDS.  THIS IS ALSO
;	      THE SYSTEM STACK, WHICH 
;	      IS SOMETIMES CALLED THE
;	      HARDWARE STACK  -HS .
;
; RP	 BP   RETURN STACK POINTER.
;	      MUST BE PRESERVED ACROSS
;	      FORTH WORDS. 
;
;
;IN ADDITION, THE 8088 CODE SEGMENT, DATA
;SEGMENT AND STACK SEGMENT REGISTERS ( CS,
;DS, AND SS, MUST BE PRESERVED ACROSS 
;FORTH WORDS.
;
;THE OTHER REGISTERS OF THE 8088 CPU MAY 
;BE USED FREELY. 
;
;10 AUGUST 1982
PAGE
;
;	EQUATES:
;
ABL	EQU	20H
ACR	EQU	0DH
AMINUS	EQU	2DH
ADOT	EQU	2EH
BELL	EQU	07H
ALF	EQU	0AH
FFEED	EQU	0CH
ADEL	EQU	7FH
ADLE	EQU	10H
BSOUT	EQU	08H
BSIN	EQU	08H
;
;
;
BPS	EQU	80H
EM	EQU	6000H
HDBT	EQU	404H
NBUF	EQU	02H
BUF1	EQU	EM-HDBT*NBUF
US	EQU	52H
INITR0	EQU	BUF1-US
RTS	EQU	0A0H
INITSP0 EQU	INITR0-RTS
;
STACK	SEGMENT		PARA STACK 
	DB	200H  DUP( 0 ) 
STACK	ENDS
;
FSEG	SEGMENT		COMMON
	ASSUME		CS:FSEG,SS:STACK,DS:FSEG,ES:FSEG
PAGE
;
	ORG	100H
;
ORIG:	MOV	AX,CS
	MOV	DS,AX
	MOV	SS,AX
	MOV	ES,AX
	MOV	SI,TCOLD
	MOV	SP,INITUSER
	MOV	BP,RPP
	JMP	NEXT
TCOLD	DW	TCOLD1
TCOLD1	DW	COLD
;
;
INITFORTH	DW	RBRAC-4
INITUSER	DW	INITSP0
;
	DW	INITR0
	DW	INITSP0
	DW	01FH
	DW	01H
;
;
INITFENCE	DW	RBRAC-4
INITDP		DW	RBRAC+0CH
INITVOCLINK	DW	FORTH+6
;
;
	DW	ADFIND
	DW	AQTERM
	DW	AABORT
	DW	ABLOCK
	DW	ACRA
	DW	AEMIT
	DW	AEXPECT
	DW	AINTER
	DW	AKEY
	DW	ALOAD
	DW	ANUM
	DW	APAGE
	DW	ARSLW
	DW	ATSCALC
	DW	AV79
	DW	AWORD
UP	DW	INITR0
RPP	DW	INITR0
;
;
;
PAGE
;
;
;
DPUSH:	PUSH	DX
APUSH:	PUSH	AX
NEXT:	MOV	AX,[SI]
	INC	SI
	INC	SI
	MOV	BX,AX
NEXT1:	MOV	DX,BX
	INC	DX
	JMP	WORD PTR [BX]
;
;
;
DP0	DB	81H	;  STORE 
	DB	'!'+80H
	DW	0
STORE	DW	$+2
	POP	BX
	POP	AX
	MOV	[BX],AX
	JMP	NEXT
;
	DB	82H		;  STOREL
	DB	'!'
	DB	'L'+80H
	DW	STORE-4
STOREL	DW	$+2
	POP	BX
	POP	DS
	POP	AX
	MOV	[BX],AX
	MOV	BX,CS
	MOV	DS,BX
	JMP	NEXT
;
	DB	81H	;  #
	DB	'#'+80H
	DW	STOREL-5
DIG	DW	DOCOL
	DW	BASE
	DW	ATT	 
	DW	MSMOD
	DW	ROT
	DW	LIT
	DW	9
	DW	OVER
	DW	LESS
	DW	ZBRAN
	DW	OFFSET DIG1-$
	DW	LIT
	DW	7
	DW	PLUS
DIG1	DW	LIT
	DW	30H
	DW	PLUS
	DW	HOLD
	DW	EXIT
;
	DB	82H	;  #>
	DB	'#'
	DB	'>'+80H
	DW	DIG-4
EDIGS	DW	DOCOL
	DW	DDROP
	DW	HLD
	DW	ATT
	DW	PAD
	DW	OVER
	DW	SUBB
	DW	EXIT
;
	DB	85H	;  #BUFF
	DB	'#BUF'
	DB	'F'+80H
	DW	EDIGS-5
NOBUF	DW	DOCON
	DW	NBUF
;
	DB	82H	;  #S
	DB	'#'
	DB	'S'+80H
	DW	NOBUF-8
DIGS	DW	DOCOL
DIGS1	DW	DIG
	DW	DDUP
	DW	ORR
	DW	NOTT
	DW	ZBRAN
	DW	OFFSET DIGS1-$
	DW	EXIT
;
	DB	0C1H	;  '
	DB	0A7H
	DW	DIGS-5
TICK	DW	DOCOL
	DW	DFIND
	DW	NOTT
	DW	AABORTQ
	DB	09H
	DB	'NOT FOUND'
	DW	DROP
	DW	LITER
	DW	EXIT
;
	DB	86H	;  '-FIND
	DB	27H,'-FIN'
	DB	'D'+80H
	DW	TICK-4
TDFIND	DW	DOUSE
	DW	16H
;
	DB	8AH	;  '?TERMINAL
	DB	27H,'?TERMINA'
	DB	'L'+80H
	DW	TDFIND-9
TQTERM	DW	DOUSE
	DW	18H
;
	DB	86H	;  'ABORT
	DB	27H,'ABOR'
	DB	'T'+80H
	DW	TQTERM-0DH
TABORT	DW	DOUSE
	DW	1AH
;
	DB	86H	;  'BLOCK
	DB	27H,'BLOC'
	DB	'K'+80H
	DW	TABORT-9
TBLOCK	DW	DOUSE
	DW	1CH
;
	DB	83H	;  'CR
	DB	27H,'C'
	DB	'R'+80H
	DW	TBLOCK-9
TCR	DW	DOUSE
	DW	1EH
;
	DB	85H	;  'EMIT
	DB	27H,'EMI'
	DB	'T'+80H
	DW	TCR-6
TEMIT	DW	DOUSE
	DW	20H
;
	DB	87H	;  'EXPECT
	DB	27H,'EXPEC'
	DB	'T'+80H
	DW	TEMIT-8
TEXPECT DW	DOUSE
	DW	22H
;
	DB	8AH	;  'INTERPRET
	DB	27H,'INTERPRE'
	DB	'T'+80H
	DW	TEXPECT-0AH
TINTER	DW	DOUSE
	DW	24H
;
	DB	84H	;  'KEY
	DB	27H,'KE'
	DB	'Y'+80H
	DW	TINTER-0DH
TKEY	DW	DOUSE
	DW	26H
;
	DB	85H	;  'LOAD
	DB	27H,'LOA'
	DB	'D'+80H
	DW	TKEY-7
TLOAD	DW	DOUSE
	DW	28H
;
	DB	87H	;  'NUMBER
	DB	27H,'NUMBE'
	DB	'R'+80H
	DW	TLOAD-8
TNUM	DW	DOUSE
	DW	2AH
;
	DB	85H	;  'PAGE
	DB	27H,'PAG'
	DB	'E'+80H
	DW	TNUM-0AH
TPAGE	DW	DOUSE
	DW	2CH
;
	DB	84H	;  'R/W
	DB	27H,'R/'
	DB	'W'+80H
	DW	TPAGE-8
TRSLW	DW	DOUSE
	DW	2EH
;
	DB	87H	;  'STREAM
	DB	27H,'STREA'
	DB	'M'+80H
	DW	TRSLW-7
TSTREAM DW	DOCOL
	DW	BLK
	DW	ATT
	DW	QDUP
	DW	ZBRAN
	DW	TSTRM1-$
	DW	BLOCK
	DW	BRAN
	DW	TSTRM2-$
TSTRM1	DW	TIB
	DW	ATT
TSTRM2	DW	TOIN
	DW	ATT
	DW	PLUS
	DW	EXIT
;
	DB	88H	;  'T&SCALC
	DB	27H,'T&SCAL'
	DB	'C'+80H
	DW	TSTREAM-0AH
TTSCALC DW	DOUSE
	DW	30H
;
	DB	8BH	;  'VOCABULARY
	DB	27H,'VOCABULAR'
	DB	'Y'+80H
	DW	TTSCALC-0BH
TVOCAB	DW	DOUSE
	DW	32H
;
	DB	85H	;  'WORD
	DB	27H,'WOR'
	DB	'D'+80H
	DW	TVOCAB-0EH
TWORD	DW	DOUSE
	DW	34H
;
	DB	0C1H	;  (
	DB	'('+80H
	DW	TWORD-8
PAREN	DW	DOCOL
	DW	LIT
	DW	0FFFFH
	DW	TOIN
	DW	PSTOR
	DW	LIT
	DW	29H
	DW	WORDD
	DW	CAT
	DW	ONEP
	DW	HERE
	DW	PLUS
	DW	CAT
	DW	LIT
	DW	29H
	DW	EQUAL
	DW	NOTT
	DW	QSTREAM
	DW	EXIT
;
	DB	81H	;  *
	DB	'*'+80H
	DW	PAREN-4
STAR	DW	DOCOL
	DW	USTAR
	DW	DROP
	DW	EXIT
;
	DB	82H	;  */
	DB	'*'
	DB	'/'+80H
	DW	STAR-4
SSLA	DW	DOCOL
	DW	SSMOD
	DW	SWAP
	DW	DROP
	DW	EXIT
;
	DB	85H	;  */MOD
	DB	'*/MO'
	DB	'D'+80H
	DW	SSLA-5
SSMOD	DW	DOCOL
	DW	TOR
	DW	MSTAR
	DW	FROMR
	DW	MSLAS
	DW	EXIT
;
	DB	81H	;  +
	DB	'+'+80H
	DW	SSMOD-8
PLUS	DW	$+2
	POP	AX
	POP	BX
	ADD	AX,BX
	JMP	APUSH
;
	DB	82H	;  +STORE
	DB	'+'
	DB	'!'+80H
	DW	PLUS-4
PSTOR	DW	$+2
	POP	BX
	POP	AX
	ADD	[BX],AX
	JMP	NEXT
;
	DB	82H	;  +-
	DB	'+'
	DB	'-'+80H
	DW	PSTOR-5
PM	DW	DOCOL
	DW	ZLESS
	DW	ZBRAN
	DW	OFFSET PM1-$
	DW	NEG
PM1	DW	EXIT
;
	DB	84H	;  +BUF
	DB	'+BU'
	DB	'F'+80H
	DW	PM-5
PBUF	DW	DOCOL
	DW	LIT
	DW	HDBT
	DW	PLUS
	DW	DUPP
	DW	LIMIT
	DW	EQUAL
	DW	ZBRAN
	DW	OFFSET PBUF1-$
	DW	DROP
	DW	FIRST
PBUF1	DW	DUPP
	DW	PREV
	DW	ATT
	DW	SUBB
	DW	EXIT
;
	DB	0C5H	;  +LOOP
	DB	'+LOO'
	DB	'P'+80H
	DW	PBUF-7
PLOOP	DW	DOCOL
	DW	LIT
	DW	3
	DW	QPAIR
	DW	COMP
	DW	APLOOP
	DW	HERE
	DW	SUBB
	DW	COMMA
	DW	EXIT
;
	DB	81H	;  ,
	DB	','+80H
	DW	PLOOP-8
COMMA	DW	DOCOL
	DW	HERE
	DW	STORE
	DW	TWO
	DW	ALLOT
	DW	EXIT
;
	DB	81H	;  -
	DB	'-'+80H
	DW	COMMA-4
SUBB	DW	$+2
	POP	DX
	POP	AX
	SUB	AX,DX
	JMP	APUSH
;
	DB	85H	;  -FIND
	DB	'-FIN'
	DB	'D'+80H
	DW	SUBB-4
DFIND	DW	DOCOL
	DW	TDFIND
	DW	ATT
	DW	EXEC
	DW	EXIT
;
	DB	89H	;  -TRAILING
	DB	'-TRAILIN'
	DB	'G'+80H
	DW	DFIND-8
DTRAI	DW	DOCOL
	DW	DUPP
	DW	ZERO
	DW	ADO
DTRAI1	DW	DDUP
	DW	PLUS
	DW	ONEM
	DW	CAT
	DW	BLL
	DW	SUBB
	DW	ZBRAN
	DW	OFFSET DTRAI2-$
	DW	LEAVE
	DW	BRAN
	DW	OFFSET DTRAI3-$
DTRAI2	DW	ONEM
DTRAI3	DW	ALOOP
	DW	OFFSET DTRAI1-$
	DW	EXIT
;
	DB	81H	;  .
	DB	'.'+80H
	DW	DTRAI-0CH
DOT	DW	DOCOL
	DW	STOD
	DW	DDOT
	DW	EXIT
;
	DB	0C2H	;  ."
	DB	'.'
	DB	'"'+80H
	DW	DOT-4
DOTQ	DW	DOCOL
	DW	TSTREAM
	DW	CAT
	DW	LIT
	DW	22H
	DW	EQUAL
	DW	ZBRAN
	DW	OFFSET DOTQ1-$
	DW	ONE
	DW	TOIN
	DW	PSTOR
	DW	BRAN
	DW	OFFSET DOTQ2-$
DOTQ1	DW	LIT
	DW	22H
	DW	STATE
	DW	ATT
	DW	ZBRAN
	DW	OFFSET DOTQ3-$
	DW	COMP
	DW	ADOTQ
DOTQ3	DW	WORDD
	DW	DUPP
	DW	CAT
	DW	ONEP
	DW	OVER
	DW	PLUS
	DW	CAT
	DW	LIT
	DW	22H
	DW	EQUAL
	DW	NOTT
	DW	QSTREAM
	DW	STATE
	DW	ATT
	DW	ZBRAN
	DW	OFFSET DOTQ4-$
	DW	CAT
	DW	ONEP
	DW	ALLOT
	DW	BRAN
	DW	OFFSET DOTQ2-$
DOTQ4	DW	COUNT
	DW	TYPEE
DOTQ2	DW	EXIT
;
	DB	85H	;  .LINE
	DB	'.LIN'
	DB	'E'+80H
	DW	DOTQ-5
DLINE	DW	DOCOL
	DW	ALINE
	DW	DTRAI
	DW	TYPEE
	DW	EXIT
;
	DB	82H	;  .R
	DB	'.'
	DB	'R'+80H
	DW	DLINE-8
DOTR	DW	DOCOL
	DW	TOR
	DW	STOD
	DW	FROMR
	DW	DDOTR
	DW	EXIT
;
	DB	81H	;  /
	DB	'/'+80H
	DW	DOTR-5
SLASH	DW	DOCOL
	DW	SLMOD
	DW	SWAP
	DW	DROP
	DW	EXIT
;
	DB	0C5H	;  /LOOP
	DB	'/LOO'
	DB	'P'+80H
	DW	SLASH-4
UPLOOP	DW	DOCOL
	DW	LIT
	DW	3
	DW	QPAIR
	DW	COMP
	DW	AUPLOOP
	DW	HERE
	DW	SUBB
	DW	COMMA
	DW	EXIT
;
	DB	84H	;  /MOD
	DB	'/MO'
	DB	'D'+80H
	DW	UPLOOP-8
SLMOD	DW	DOCOL
	DW	TOR
	DW	STOD
	DW	FROMR
	DW	MSLAS
	DW	EXIT
;
	DB	81H	;  0
	DB	'0'+80H
	DW	SLMOD-7
ZERO	DW	DOCON
	DW	00
;
	DB	82H	;  0<
	DB	'0'
	DB	'<'+80H
	DW	ZERO-4
ZLESS	DW	$+2
	POP	AX
	OR	AX,AX
	MOV	AX,1
	JS	ZLES1
	DEC	AX
ZLES1:	JMP	APUSH
;
	DB	82H	;  0=
	DB	'0'
	DB	'='+80H
	DW	ZLESS-5
ZEQU	DW	DOCOL
	DW	NOTT
	DW	EXIT
;
	DB	82H	;  0>
	DB	'0'
	DB	'>'+80H
	DW	ZEQU-5
ZGREAT	DW	DOCOL
	DW	ZERO
	DW	GREAT
	DW	EXIT
;
	DB	87H	;  0BRANCH
	DB	'0BRANC'
	DB	'H'+80H
	DW	ZGREAT-5
ZBRAN	DW	$+2
	POP	AX
	OR	AX,AX
	JZ	ZBRAN1
	INC	SI
	INC	SI
	JMP	NEXT
ZBRAN1: JMP	BRAN1
;
	DB	81H	;  1
	DB	'1'+80H
	DW	ZBRAN-0AH
ONE	DW	DOCON
	DW	01
;
	DB	82H	;  1+
	DB	'1'
	DB	'+'+80H 
	DW	ONE-4
ONEP	DW	$+2
	POP	AX
	INC	AX
	JMP	APUSH
;
	DB	82H	;  1-
	DB	'1'
	DB	'-'+80H
	DW	ONEP-5
ONEM	DW	$+2
	POP	AX
	DEC	AX
	JMP	APUSH
;
	DB	81H	;  2
	DB	'2'+80H
	DW	ONEM-5
TWO	DW	DOCON
	DW	02
;
	DB	82H	;  2*
	DB	'2'
	DB	'*'+80H
	DW	TWO-4
TWOST	DW	$+2
	POP	AX
	ADD	AX,AX
	JMP	APUSH
;
	DB	82H	;	2+
	DB	'2'
	DB	'+'+80H
	DW	TWOST-5
TWOP	DW	$+2
	POP	AX
	INC	AX
	INC	AX
	JMP	APUSH
;
	DB	82H	;  2-
	DB	'2'
	DB	'-'+80H
	DW	TWOP-5
TWOM	DW	$+2
	POP	AX
	DEC	AX
	DEC	AX
	JMP	APUSH
;
	DB	82H	;  2/
	DB	'2'
	DB	'/'+80H
	DW	TWOM-5
TWOSL	DW	DOCOL
	DW	TWO
	DW	SLASH
	DW	EXIT
;
	DB	8BH	;  79-STANDARD
	DB	'79-STANDAR'
	DB	'D'+80H
	DW	TWOSL-5
STAND	DW	DOCOL
	DW	EXIT
;
	DB	81H	;  :
	DB	':'+80H
	DW	STAND-0EH
COLON	DW	DOCOL
	DW	SPAT
	DW	CSP
	DW	STORE
	DW	CURR
	DW	ATT
	DW	CONT
	DW	STORE
	DW	CREATE
	DW	SMUDG
	DW	RBRAC
	DW	ASCODE
DOCOL:	INC	DX
	DEC	BP
	DEC	BP
	MOV	[BP],SI
	MOV	SI,DX
	JMP	NEXT
;
	DB	0C1H	;  ;
	DB	';'+80H
	DW	COLON-4
SEMI	DW	DOCOL
	DW	QCSP
	DW	COMP
	DW	EXIT
	DW	SMUDG
	DW	LBRAC
	DW	EXIT
;
	DB	81H	;  <
	DB	'<'+80H
	DW	SEMI-4
LESS	DW	$+2
	POP	DX
	POP	AX
	MOV	BX,DX
	XOR	BX,AX
	JS	LES1
	SUB	AX,DX
LES1:	OR	AX,AX
	MOV	AX,0
	JNS	LES2
	INC	AX
LES2:	JMP	APUSH
;
	DB	82H	;  <#
	DB	'<'
	DB	'#'+80H
	DW	LESS-4
BDIGS	DW	DOCOL
	DW	PAD
	DW	HLD
	DW	STORE
	DW	EXIT
;
	DB	87H	;  <+LOOP>
	DB	'<+LOOP'
	DB	'>'+80H
	DW	BDIGS-5
APLOOP	DW	$+2
	POP	BX
	JMP	ALOOP1
;
	DB	87H	;  <-FIND>
	DB	'<-FIND'
	DB	'>'+80H
	DW	APLOOP-0AH
ADFIND	DW	DOCOL
	DW	BLL
	DW	WORDD
	DW	CONT
	DW	ATT
	DW	ATT
	DW	AFIND
	DW	EXIT
;
	DB	84H	;  <.">
	DB	'<."'
	DB	'>'+80H
	DW	ADFIND-0AH
ADOTQ	DW	DOCOL
	DW	RAT
	DW	COUNT
	DW	DUPP
	DW	ONEP
	DW	FROMR
	DW	PLUS
	DW	TOR
	DW	TYPEE
	DW	EXIT
;
	DB	87H	;  </LOOP>
	DB	'</LOOP'
	DB	'>'+80H
	DW	ADOTQ-7
AUPLOOP DW	$+2
	POP	BX
	ADD	[BP],BX
	JB	AUPLO1
	MOV	AX,[BP]
	SUB	AX,2[BP]
	JNB	AUPLO1
	JMP	BRAN1
AUPLO1: ADD	BP,4H
	INC	SI
	INC	SI
	JMP	NEXT
;
	DB	87H	;  <;CODE>
	DB	'<;CODE'
	DB	'>'+80H
	DW	AUPLOOP-0AH
ASCODE	DW	DOCOL
	DW	FROMR
	DW	LATES
	DW	PFA
	DW	CFA
	DW	STORE
	DW	EXIT
;
	DB	88H	;  <<CMOVE>
	DB	'<<CMOVE'
	DB	'>'+80H
	DW	ASCODE-0AH
ADCMOVE DW	$+2
	MOV 	BX,SI
	POP	CX
	POP	DI
	ADD	DI,CX
	DEC	DI
	POP	SI
	ADD	SI,CX
	DEC	SI
	STD
REP	MOVSB
	CLD
	MOV	SI,BX
	JMP	NEXT
;
	DB	8BH		;  <?TERMINAL>	 ( ---	C , F )
	DB	'<?TERMINAL'
	DB	'>'+80H
	DW	ADCMOVE-0BH
AQTERM	DW	$+2
	PUSH	DS
	PUSH	BX
	MOV	BX,40H
	MOV	DS,BX
	MOV	BX,1AH
	MOV	CX,[BX]
	MOV	AX,CX
	MOV	BX,1CH
	SUB	AX,[BX]
	MOV	[BX],CX
	JZ	AQTER1
	MOV	AX,[BX]
	MOV	BX,AX
	MOV	AX,[BX]
	SUB	AH,AH
AQTER1: POP	BX
	POP	DS
	JMP	APUSH
;
	DB	88H	;  <ABORT">
	DB	'<ABORT"'
	DB	'>'+80H
	DW	AQTERM-0EH
AABORTQ DW	DOCOL
	DW	ZBRAN
	DW	AABTQ1-$
	DW	WHERE
	DW	CR
	DW	RAT
	DW	COUNT
	DW	TYPEE
	DW	SPSTO
	DW	QUIT
	DW	BRAN
	DW	AABTQ2-$
AABTQ1	DW	FROMR
	DW	DUPP
	DW	CAT
	DW	PLUS
	DW	ONEP
	DW	TOR
AABTQ2	DW	EXIT
;
	DB	87H	;  <ABORT>
	DB	'<ABORT'
	DB	'>'+80H
	DW	AABORTQ-0BH
AABORT	DW	DOCOL
	DW	SPSTO
	DW	QSTAC
	DW	FORTH
	DW	DEFIN
	DW	QUIT
	DW	EXIT
;
	DB	87H	;  <BLOCK>
	DB	'<BLOCK'
	DB	'>'+80H
	DW	AABORT-0AH
ABLOCK	DW	DOCOL
	DW	OFSET
	DW	ATT
	DW	PLUS
	DW	TOR
	DW	PREV
	DW	ATT
	DW	DUPP
	DW	ATT
	DW	RAT
	DW	SUBB
	DW	TWOST
	DW	ZBRAN
	DW	OFFSET ABLOCK3-$
ABLOCK1 DW	PBUF
	DW	NOTT
	DW	ZBRAN
	DW	OFFSET ABLOCK2-$
	DW	DROP
	DW	RAT
	DW	BUFFE
	DW	DUPP
	DW	RAT
	DW	ONE
	DW	RSLW
	DW	TWOM
ABLOCK2 DW	DUPP
	DW	ATT
	DW	RAT
	DW	SUBB
	DW	TWOST
	DW	NOTT
	DW	ZBRAN
	DW	OFFSET ABLOCK1-$
	DW	DUPP
	DW	PREV
	DW	STORE
ABLOCK3 DW	FROMR
	DW	DROP
	DW	TWOP
	DW	EXIT
;
	DB	86H	;  <CMOVE
	DB	'<CMOV'
	DB	'E'+80H
	DW	ABLOCK-0AH
DCMOVE	DW	DOCOL
	DW	DUPP
	DW	ONE
	DW	LESS
	DW	ZBRAN
	DW	DCMOVE1-$
	DW	DDROP
	DW	DROP
	DW	BRAN
	DW	DCMOVE2-$
DCMOVE1 DW	ADCMOVE
DCMOVE2 DW	EXIT
;
	DB	87H	;  <CMOVE>
	DB	'<CMOVE'
	DB	'>'+80H
	DW	DCMOVE-09
ACMOVE	DW	$+2
	CLD
	MOV	BX,SI
	POP	CX
	POP	DI
	POP	SI
	MOV	AX,DS
	MOV	ES,AX
REP	MOVSB
	MOV	SI,BX
	JMP	NEXT
;
	DB	84H	;  <CR>
	DB	'<CR'
	DB	'>'+80H
	DW	ACMOVE-0AH
ACRA	DW	DOCOL
	DW	LIT
	DW	0DH
	DW	EMIT
	DW	LIT
	DW	0AH
	DW	EMIT
	DW	ZERO
	DW	OUTT
	DW	STORE
	DW	EXIT
;
	DB	84H	;  <DO>
	DB	'<DO'
	DB	'>'+80H
	DW	ACRA-7
ADO	DW	$+2
	POP	DX
	POP	AX
	XCHG	BP,SP
	PUSH	AX
	PUSH	DX
	XCHG	BP,SP
	JMP	NEXT
;
	DB	86H	;  <EMIT>
	DB	'<EMIT'
	DB	'>'+80H
	DW	ADO-7
AEMIT	DW	DOCOL
	DW	EPRINT
	DW	ATT
	DW	ZBRAN
	DW	OFFSET AEMIT1-$
	DW	DUPP
	DW	ZERO
	DW	ZERO
	DW	ZERO
	DW	LIT
	DW	17H
	DW	INTCAL
	DW	DROP
AEMIT1	DW	LIT
	DW	0E00H
	DW	PLUS
	DW	LIT
	DW	07H
	DW	ZERO
	DW	ZERO
	DW	LIT
	DW	10H
	DW	INTCAL
	DW	DROP
	DW	ONE
	DW	OUTT
	DW	PSTOR
	DW	EXIT
;
	DB	88H	;  <EXPECT>
	DB	'<EXPECT'
	DB	'>'+80H
	DW	AEMIT-9
AEXPECT DW	DOCOL
	DW	OVER
	DW	PLUS
	DW	OVER
	DW	ADO
AEXPEC1 DW	KEY
	DW	DUPP
	DW	LIT
	DW	8
	DW	EQUAL
	DW	OVER
	DW	LIT
	DW	7FH
	DW	EQUAL
	DW	ORR
	DW	ZBRAN
	DW	OFFSET AEXPEC4-$
	DW	DROP
	DW	DUPP
	DW	IDO
	DW	EQUAL
	DW	DUPP
	DW	FROMR
	DW	TWOM
	DW	PLUS
	DW	TOR
	DW	ZBRAN
	DW	OFFSET AEXPEC2-$
	DW	LIT
	DW	7
	DW	BRAN
	DW	OFFSET AEXPEC3-$
AEXPEC2 DW	LIT
	DW	8
	DW	DUPP
	DW	EMIT
	DW	LIT
	DW	20H
	DW	EMIT
	DW	LIT
	DW	0FFFDH
	DW	OUTT
	DW	PSTOR
AEXPEC3 DW	BRAN
	DW	OFFSET AEXPEC7-$
AEXPEC4 DW	DUPP
	DW	LIT
	DW	0DH
	DW	EQUAL
	DW	ZBRAN
	DW	OFFSET AEXPEC5-$
	DW	LEAVE
	DW	DROP
	DW	BLL
	DW	ZERO
	DW	BRAN
	DW	OFFSET AEXPEC6-$
AEXPEC5 DW	DUPP
AEXPEC6 DW	IDO
	DW	CSTOR
	DW	ZERO
	DW	IDO
	DW	ONEP
	DW	STORE
AEXPEC7 DW	EMIT
	DW	ONE
	DW	AUPLOOP
	DW	OFFSET AEXPEC1-$
	DW	DROP
	DW	EXIT
;
	DB	86H	;  <FILL>
	DB	'<FILL'
	DB	'>'+80H
	DW	AEXPECT-0BH
AFILL	DW	$+2
	POP	AX
	POP	CX
	POP	DI
	MOV	BX,DS
	MOV	ES,BX
	CLD
	REP	STOSB
	JMP	NEXT
;
	DB	86H	;  <FIND>
	DB	'<FIND'
	DB	'>'+80H
	DW	AFILL-9
AFIND	DW	$+2
	MOV	AX,DS
	MOV	ES,AX
	POP	BX
	POP	CX
AFIND1: MOV	DI,CX
	MOV	AL,[BX]
	MOV	DL,AL
	XOR	AL,[DI]
	AND	AL,3FH
	JNZ	AFIND3
AFIND2: INC	BX
	INC	DI
	MOV	AL,[BX]
	XOR	AL,[DI]
	ADD	AL,AL
	JNZ	AFIND3
	JNB	AFIND2
	ADD	BX,5
	PUSH	BX
	MOV	AX,1
	SUB	DH,DH
	JMP	DPUSH
AFIND3: INC	BX
	JB	AFIND4
	MOV	AL,[BX]
	ADD	AL,AL
	JMP	AFIND3
AFIND4: MOV	BX,[BX]
	OR	BX,BX
	JNZ	AFIND1
	MOV	AX,0
	JMP	APUSH
;
	DB	8BH	;  <INTERPRET>
	DB	'<INTERPRET'
	DB	'>'+80H
	DW	AFIND-9
AINTER	DW	DOCOL
AINTER1 DW	DFIND
	DW	ZBRAN
	DW	OFFSET AINTER4-$
	DW	STATE
	DW	ATT
	DW	LESS
	DW	ZBRAN
	DW	OFFSET AINTER2-$
	DW	CFA
	DW	COMMA
	DW	BRAN
	DW	OFFSET AINTER3-$
AINTER2 DW	CFA
	DW	EXEC
AINTER3 DW	BRAN
	DW	OFFSET AINTER6-$
AINTER4 DW	HERE
	DW	NUM
	DW	DPL
	DW	ATT
	DW	ONEP
	DW	ZBRAN
	DW	OFFSET AINTER5-$
	DW	DLITE
	DW	BRAN
	DW	OFFSET AINTER6-$
AINTER5 DW	DROP
	DW	LITER
AINTER6 DW	QSTAC
	DW	BRAN
	DW	OFFSET AINTER1-$
	DW	EXIT
;
	DB	85H	;  <KEY>
	DB	'<KEY'
	DB	'>'+80H
	DW	AINTER-0EH
AKEY	DW	DOCOL
AKEY1	DW	ZERO
	DW	ZERO
	DW	ZERO
	DW	ZERO
	DW	LIT
	DW	16H
	DW	INTCAL
	DW	LIT
	DW	0FFH
	DW	ANDD
	DW	DUPP
	DW	LIT
	DW	10H
	DW	SUBB
	DW	NOTT
	DW	ZBRAN
	DW	OFFSET AKEY2-$
	DW	DROP
	DW	ONE
	DW	EPRINT
	DW	ATT
	DW	XORR
	DW	EPRINT
	DW	STORE
	DW	BRAN
	DW	OFFSET AKEY1-$
AKEY2	DW	EXIT
;
	DB	86H	;  <LINE>
	DB	'<LINE'
	DB	'>'+80H
	DW	AKEY-8
ALINE	DW	DOCOL
	DW	BLOCK
	DW	SWAP
	DW	CSLL
	DW	STAR
	DW	PLUS
	DW	CSLL
	DW	EXIT
;
	DB	86H	;  <LOAD>
	DB	'<LOAD'
	DB	'>'+80H
	DW	ALINE-9
ALOAD	DW	DOCOL
	DW	QDUP
	DW	NOTT
	DW	AABORTQ
	DB	0AH
	DB	'UNLOADABLE'
	DW	BLK
	DW	ATT
	DW	TOR
	DW	TOIN
	DW	ATT
	DW	TOR
	DW	ZERO
	DW	TOIN
	DW	STORE
	DW	BLK
	DW	STORE
	DW	INTER
	DW	FROMR
	DW	TOIN
	DW	STORE
	DW	FROMR
	DW	BLK
	DW	STORE
	DW	EXIT
;
	DB	86H	;  <LOOP>
	DB	'<LOOP'
	DB	'>'+80H
	DW	ALOAD-9
ALOOP	DW	$+2
	MOV	BX,1H
ALOOP1: MOV	CX,[BP]
	ADD	[BP],BX
	JS	ALOOP2
	MOV	AX,CX
	AND	AX,BX
	JNS	ALOOP3
ALOOP2: MOV	AX,CX
	OR	AX,BX
	JNS	ALOOP8
ALOOP3: MOV	AX,[BP]
	SUB	AX,2[BP]
	JS	ALOOP7
	MOV	AX,[BP]
	AND	AX,AX
	JS	ALOOP5
ALOOP4: MOV	AX,BX
	AND	AX,AX
	JNS	ALOOP8
	JMP	BRAN1
ALOOP5: MOV	AX,2[BP]
	AND	AX,AX
	JS	ALOOP4
ALOOP6: MOV	AX,BX
	AND	AX,AX
	JS	ALOOP8
	JMP	BRAN1
ALOOP7: MOV	AX,[BP]
	AND	AX,AX
	JS	ALOOP6
	JMP	ALOOP5
ALOOP8: ADD	BP,4H
	INC	SI
	INC	SI
	JMP	NEXT
;
	DB	88H	;  <NUMBER>
	DB	'<NUMBER'
	DB	'>'+80H
	DW	ALOOP-9
ANUM	DW	DOCOL
	DW	ZERO
	DW	ZERO
	DW	ROT
	DW	DUPP
	DW	ONEP
	DW	CAT
	DW	LIT
	DW	2DH
	DW	EQUAL
	DW	DUPP
	DW	TOR
	DW	PLUS
	DW	LIT
	DW	0FFFFH
	DW	DPL
	DW	STORE
	DW	CONV
	DW	DUPP
	DW	CAT
	DW	BLL
	DW	GREAT
	DW	ZBRAN
	DW	OFFSET ANUM1-$
	DW	DUPP
	DW	CAT
	DW	LIT
	DW	2EH
	DW	EQUAL
	DW	NOTT
	DW	AABORTQ
	DB	0EH
	DB	'NOT RECOGNIZED'
	DW	ZERO
	DW	DPL
	DW	STORE
	DW	CONV
	DW	DUPP
	DW	CAT
	DW	BLL
	DW	GREAT
	DW	AABORTQ
	DB	0EH
	DB	'NOT RECOGNIZED'
ANUM1	DW	DROP
	DW	FROMR
	DW	ZBRAN
	DW	OFFSET ANUM2-$
	DW	DNEG
ANUM2	DW	EXIT
;
	DB	86H	;  <PAGE>
	DB	'<PAGE'
	DB	'>'+80H
	DW	ANUM-0BH
APAGE	DW	DOCOL
	DW	ZERO
	DW	ZERO
	DW	ZERO
	DW	ZERO
	DW	LIT
	DW	10H
	DW	INTCAL
	DW	DROP
	DW	EXIT
;
	DB	85H	;  <R/W>
	DB	'<R/W'
	DB	'>'+80H
	DW	APAGE-9
ARSLW	DW	DOCOL
	DW	USEE
	DW	ATT
	DW	TOR
	DW	ROT
	DW	USEE
	DW	STORE
	DW	SWAP
	DW	MAXDRV
	DW	ZERO
	DW	ADO
ARSLW1	DW	IDO
	DW	DRDEN
	DW	DENSTY
	DW	STORE
	DW	DUPP
	DW	BPDRV
	DW	SUBB
	DW	LIT
	DW	0FFFFH
	DW	GREAT
	DW	ZBRAN
	DW	ARSLW3-$
	DW	BPDRV
	DW	SUBB
	DW	IDO
	DW	ONEP
	DW	MAXDRV
	DW	EQUAL
	DW	ZBRAN
	DW	ARSLW2-$
	DW	FROMR
	DW	FROMR
	DW	DDROP
	DW	FROMR
	DW	USEE
	DW	STORE
	DW	ONE
	DW	AABORTQ
	DB	12H
	DB	'BLOCK OUT OF RANGE'
ARSLW2	DW	BRAN
	DW	ARSLW4-$
ARSLW3	DW	IDO
	DW	DRIVE
	DW	STORE
	DW	LEAVE
ARSLW4	DW	ALOOP
	DW	ARSLW1-$
	DW	SPBLK
	DW	STAR
	DW	SPBLK
	DW	ZERO
	DW	ADO
ARSLW5	DW	DDUP
	DW	TSCALC
	DW	ZBRAN
	DW	ARSLW6-$
	DW	SECRD
	DW	BRAN
	DW	ARSLW7-$
ARSLW6	DW	SECWT
ARSLW7	DW	ONEP
	DW	LIT
	DW	404H
	DW	LIT
	DW	4
	DW	SUBB
	DW	SPBLK
	DW	SLASH
	DW	USEE
	DW	PSTOR
	DW	ALOOP
	DW	ARSLW5-$
	DW	DDROP
	DW	FROMR
	DW	USEE
	DW	STORE
	DW	EXIT
;
	DB	89H	;  <T&SCALC>
	DB	'<T&SCALC'
	DB	'>'+80H
	DW	ARSLW-8
ATSCALC DW	DOCOL
	DW	SPT
	DW	SLMOD
	DW	TRACK
	DW	STORE
	DW	DEN
	DW	DRIVE
	DW	ATT
	DW	TWOST
	DW	PLUS
	DW	ATT
	DW	ONE
	DW	EQUAL
	DW	ZBRAN
	DW	ATSCAL2-$
	DW	LIT
	DW	08H
	DW	SLMOD
	DW	DRIVE
	DW	ATT
	DW	LIT
	DW	0FH
	DW	ANDD
	DW	SWAP
	DW	ZBRAN
	DW	ATSCAL1-$
	DW	LIT
	DW	100H
	DW	PLUS
ATSCAL1	DW	DRIVE
	DW	STORE
ATSCAL2 DW	ONEP
	DW	SEC
	DW	STORE
	DW	EXIT
;
	DB	8EH	;  <VOCABULARY79>
	DB	'<VOCABULARY79'
	DB	'>'+80H
	DW	ATSCALC-0CH
AV79	DW	DOCOL
	DW	CREATE
	DW	LIT
	DW	0A081H
	DW	COMMA
	DW	LIT
	DW	FORTH+2
	DW	COMMA
	DW	HERE
	DW	VOCL
	DW	ATT
	DW	COMMA
	DW	VOCL
	DW	STORE
	DW	ASCODE
DOVOC	DB	0E8H
	DW	DODOES-$-2
	DW	TWOP
	DW	CONT
	DW	STORE
	DW	EXIT
;
	DB	8FH	;  <VOCABULARYFIG>
	DB	'<VOCABULARYFIG'
	DB	'>'+80H
	DW	AV79-11H
AVFIG	DW	DOCOL
	DW	CREATE
	DW	LIT
	DW	0A081H
	DW	COMMA
	DW	CURR
	DW	ATT
	DW	CFA
	DW	COMMA
	DW	HERE
	DW	VOCL
	DW	ATT
	DW	COMMA
	DW	VOCL
	DW	STORE
	DW	ASCODE
	DB	0E8H
	DW	DODOES-$-2
	DW	TWOP
	DW	CONT
	DW	STORE
	DW	EXIT
;
	DB	86H	;  <WORD>
	DB	'<WORD'
	DB	'>'+80H
	DW	AVFIG-12H
AWORD	DW	DOCOL
	DW	TSTREAM
	DW	SWAP
	DW	ENCL
	DW	DDUP
	DW	GREAT
	DW	ZBRAN
	DW	OFFSET AWORD1-$
	DW	DDROP
	DW	DDROP
	DW	ZERO
	DW	HERE
	DW	STORE
	DW	BRAN
	DW	OFFSET AWORD2-$
AWORD1	DW	TOIN
	DW	PSTOR
	DW	OVER
	DW	SUBB
	DW	DUPP
	DW	TOR
	DW	HERE
	DW	CSTOR
	DW	PLUS
	DW	HERE
	DW	ONEP
	DW	FROMR
	DW	DUPP
	DW	LIT
	DW	0FFH
	DW	GREAT
	DW	AABORTQ
	DB	0BH
	DB	'INPUT > 255'
	DW	ONEP
	DW	CMOVE
AWORD2	DW	HERE
	DW	EXIT
;
	DB	81H		;  =
	DB	'='+80H
	DW	AWORD-9
EQUAL	DW	DOCOL
	DW	SUBB
	DW	NOTT
	DW	EXIT
;
	DB	81H		;  >
	DB	'>'+80H
	DW	EQUAL-4
GREAT	DW	DOCOL
	DW	SWAP
	DW	LESS
	DW	EXIT
;
	DB	83H		;  >IN
	DB	'>I'
	DB	'N'+80H
	DW	GREAT-4
TOIN	DW	DOUSE
	DW	36H
;
	DB	82H		;  >R
	DB	'>'
	DB	'R'+80H
	DW	TOIN-6
TOR	DW	$+2
	POP	BX
	DEC	BP
	DEC	BP
	MOV	[BP],BX
	JMP	NEXT
;
	DB	81H		;  ?
	DB	'?'+80H
	DW	TOR-5
QUES	DW	DOCOL
	DW	ATT
	DW	DOT
	DW	EXIT
;
	DB	85H		;  ?COMP
	DB	'?COM'
	DB	'P'+80H
	DW	QUES-4
QCOMP	DW	DOCOL
	DW	STATE
	DW	ATT
	DW	NOTT
	DW	AABORTQ
	DB	0CH
	DB	'COMPILE ONLY'
	DW	EXIT
;
	DB	8AH		;  ?CONFIGURE
	DB	'?CONFIGUR'
	DB	'E'+80H
	DW	QCOMP-8
QCONF	DW	DOCOL
	DW	CR
	DW	CR
	DW	MAXDRV
	DW	DOT
	DW	ADOTQ
	DB	16H
	DB	'DRIVES WITH DENSITIES:'
	DW	MAXDRV
	DW	ZERO
	DW	ADO
QCONF1	DW	IDO
	DW	DRDEN
	DW	TWO
	DW	SPACS
	DW	DOT
	DW	ALOOP
	DW	QCONF1-$
	DW	CR
	DW	CR
	DW	ADOTQ
	DB	0CH
	DB	'DENSITY CODE'
	DW	CR
	DW	ADOTQ
	DB	0AH
	DB	'0 - 5-SSDD'
	DW	CR
	DW	ADOTQ
	DB	0AH
	DB	'1 - 5-DSDD'
	DW	CR
	DW	ADOTQ
	DB	0AH
	DB	'2 - 8-DSSD'
	DW	CR
	DW	ADOTQ
	DB	0AH
	DB	'3 - 8-SSDD'
	DW	CR
	DW	ADOTQ
	DB	0AH
	DB	'4 - 8-DSDD'
	DW	CR
	DW	ADOTQ
	DB	0BH
	DB	'5 - 8-SSEXT'
	DW	CR
	DW	ADOTQ
	DB	0BH
	DB	'6 - 8-DSEXT'
	DW	CR
	DW	EXIT
;
	DB	84H		;  ?CSP
	DB	'?CS'
	DB	'P'+80H
	DW	QCONF-0DH
QCSP	DW	DOCOL
	DW	SPAT
	DW	CSP
	DW	ATT
	DW	SUBB
	DW	AABORTQ
	DB	17H
	DB	'DEFINITION NOT FINISHED'
	DW	EXIT
;
	DB	84H		;  ?DUP
	DB	'?DU'
	DB	'P'+80H
	DW	QCSP-7
QDUP	DW	DOCOL
	DW	DUPP
	DW	ZBRAN
	DW	QDUP1-$
	DW	DUPP
QDUP1	DW	EXIT
;
	DB	88H		;  ?LOADING
	DB	'?LOADIN'
	DB	'G'+80H
	DW	QDUP-7
QLOAD	DW	DOCOL
	DW	BLK
	DW	ATT
	DW	NOTT
	DW	AABORTQ
	DB	0CH
	DB	'LOADING ONLY'
	DW	EXIT
;
	DB	86H		;  ?PAIRS
	DB	'?PAIR'
	DB	'S'+80H
	DW	QLOAD-0BH
QPAIR	DW	DOCOL
	DW	SUBB
	DW	AABORTQ
	DB	17H
	DB	'CONDITIONALS NOT PAIRED'
	DW	EXIT
;
	DB	86H		;  ?STACK
	DB	'?STAC'
	DB	'K'+80H
	DW	QPAIR-9
QSTAC	DW	DOCOL
	DW	SPAT
	DW	SZERO
	DW	SWAP
	DW	ULESS
	DW	AABORTQ
	DB	13H
	DB	'STACK OUT OF BOUNDS'
	DW	SPAT
	DW	HERE
	DW	LIT
	DW	80H
	DW	PLUS
	DW	ULESS
	DW	AABORTQ
	DB	0AH
	DB	'FULL STACK'
	DW	EXIT
;
	DB	87H		;  ?STREAM
	DB	'?STREA'
	DB	'M'+80H
	DW	QSTAC-9
QSTREAM DW	DOCOL
	DW	AABORTQ
	DB	16H
	DB	'INPUT STREAM EXHAUSTED'
	DW	EXIT
;
	DB	89H		;  ?TERMINAL
	DB	'?TERMINA'
	DB	'L'+80H
	DW	QSTREAM-0AH
QTERM	DW	DOCOL
	DW	TQTERM
	DW	ATT
	DW	EXEC
	DW	EXIT
;
	DB	81H		;  @
	DB	'@'+80H
	DW	QTERM-0CH
ATT	DW	$+2
	POP	BX
	MOV	AX,[BX]
	JMP	APUSH
;
	DB	82H		;  @L
	DB	'@'
	DB	'L'+80H
	DW	ATT-4
ATL	DW	$+2
	POP	BX
	POP	DS
	MOV	AX,[BX]
	MOV	BX,CS
	MOV	DS,BX
	JMP	APUSH
;
	DB	85H		;  ABORT
	DB	'ABOR'
	DB	'T'+80H
	DW	ATL-5
ABORT	DW	DOCOL
	DW	TABORT
	DW	ATT
	DW	EXEC
	DW	EXIT
;
	DB	0C6H		;  ABORT"
	DB	'ABORT'
	DB	'"'+80H
	DW	ABORT-8
ABORTQ	DW	DOCOL
	DW	QCOMP
	DW	COMP
	DW	AABORTQ
	DW	TSTREAM
	DW	CAT
	DW	LIT
	DW	22H
	DW	EQUAL
	DW	ZBRAN
	DW	ABORTQ1-$
	DW	ONE
	DW	TOIN
	DW	PSTOR
	DW	ZERO
	DW	CCOMM
	DW	BRAN
	DW	ABORTQ2-$
ABORTQ1 DW	LIT
	DW	22H
	DW	WORDD
	DW	DUPP
	DW	CAT
	DW	ONEP
	DW	SWAP
	DW	OVER
	DW	PLUS
	DW	CAT
	DW	LIT
	DW	22H
	DW	EQUAL
	DW	NOTT
	DW	QSTREAM
	DW	ALLOT
ABORTQ2 DW	EXIT
;
	DB	83H		;  ABS
	DB	'AB'
	DB	'S'+80H
	DW	ABORTQ-9
ABSS	DW	DOCOL
	DW	DUPP
	DW	PM
	DW	EXIT
;
	DB	0C5H		;  AGAIN
	DB	'AGAI'
	DB	'N'+80H
	DW	ABSS-6
AGAIN	DW	DOCOL
	DW	ONE
	DW	QPAIR
	DW	COMP
	DW	BRAN
	DW	HERE
	DW	SUBB
	DW	COMMA
	DW	EXIT
;
	DB	85H		;  ALLOT
	DB	'ALLO'
	DB	'T'+80H
	DW	AGAIN-8
ALLOT	DW	DOCOL
	DW	DP
	DW	PSTOR
	DW	EXIT
;
	DB	83H		;  AND
	DB	'AN'
	DB	'D'+80H
	DW	ALLOT-8
ANDD	DW	$+2
	POP	BX
	POP	AX
	AND	AX,BX
	JMP	APUSH
;
	DB	85H		;  APUSH
	DB	'APUS'
	DB	'H'+80H
	DW	ANDD-6
APUSHH	DW	DOCON
	DW	APUSH
;
	DB	84H		;  BASE
	DB	'BAS'
	DB	'E'+80H
	DW	APUSHH-8
BASE	DW	DOUSE
	DW	38H
;
	DB	0C5H		;  BEGIN
	DB	'BEGI'
	DB	'N'+80H
	DW	BASE-7
BEGIN	DW	DOCOL
	DW	QCOMP
	DW	HERE
	DW	ONE
	DW	EXIT
;
	DB	82H		;  BL
	DB	'B'
	DB	'L'+80H
	DW	BEGIN-8
BLL	DW	DOCON
	DW	20H
;
	DB	85H		;  BLANK
	DB	'BLAN'
	DB	'K'+80H
	DW	BLL-5
BLANK	DW	DOCOL
	DW	BLL
	DW	FILL
	DW	EXIT
;
	DB	83H		;  BLK
	DB	'BL'
	DB	'K'+80H
	DW	BLANK-8
BLK	DW	DOUSE
	DW	3AH
;
	DB	87H		;  BLK/DRV
	DB	'BLK/DR'
	DB	'V'+80H
	DW	BLK-6
BPDR	DW	DOVAR
	DW	0A0H
	DW	140H
	DW	1F4H
	DW	1F4H
	DW	3E8H
	DW	268H
	DW	4D0H
;
	DB	85H		;  BLOCK 
	DB	'BLOC'
	DB	'K'+80H
	DW	BPDR-0AH
BLOCK	DW	DOCOL
	DW	TBLOCK
	DW	ATT
	DW	EXEC
	DW	EXIT
;
	DB	85H		;  BPDRV
	DB	'BPDR'
	DB	'V'+80H
	DW	BLOCK-8
BPDRV	DW	DOCOL
	DW	DENSTY
	DW	ATT
	DW	LIT
	DW	6H
	DW	MIN
	DW	TWOST
	DW	BPDR
	DW	PLUS
	DW	ATT
	DW	EXIT
;
	DB	86H		;  BRANCH
	DB	'BRANC'
	DB	'H'+80H
	DW	BPDRV-8
BRAN	DW	$+2
BRAN1:	ADD	SI,[SI]
	JMP	NEXT
;
	DB	86H		;  BUFFER
	DB	'BUFFE'
	DB	'R'+80H
	DW	BRAN-9
BUFFE	DW	DOCOL
	DW	USEE
	DW	ATT
	DW	PREV
	DW	ATT
	DW	EQUAL
	DW	ZBRAN
	DW	BUFF1-$
	DW	USEE
	DW	ATT
	DW	PBUF
	DW	DROP
	DW	USEE
	DW	STORE
BUFF1	DW	USEE
	DW	ATT
	DW	DUPP
	DW	TOR
BUFF2	DW	PBUF
	DW	ZBRAN
	DW	OFFSET BUFF2-$
	DW	USEE
	DW	STORE
	DW	RAT
	DW	ATT
	DW	ZLESS
	DW	ZBRAN
	DW	OFFSET BUFF3-$
	DW	RAT
	DW	TWOP
	DW	RAT
	DW	ATT	 
	DW	LIT
	DW	7FFFH
	DW	ANDD
	DW	ZERO
	DW	RSLW
BUFF3	DW	RAT
	DW	STORE
	DW	RAT
	DW	PREV
	DW	STORE
	DW	FROMR
	DW	TWOP
	DW	EXIT
;
	DB	83H		;  BYE
	DB	'BY'
	DB	'E'+80H
	DW	BUFFE-9
BYE	DW	DOCOL
	DW	FREEZE
	DW	ZERO
	DW	ZERO
	DW	SYSCALL
	DW	EXIT
;
	DB	82H		;  CSTORE
	DB	'C'
	DB	'!'+80H
	DW	BYE-6
CSTOR	DW	$+2
	POP	BX
	POP	AX
	MOV	[BX],AL
	JMP	NEXT
;
	DB	83H		;  CSTOREL
	DB	'C!'
	DB	'L'+80H
	DW	CSTOR-5
CSTORL	DW	$+2
	POP	BX
	POP	DS
	POP	AX
	MOV	[BX],AL
	MOV	BX,CS
	MOV	DS,BX
	JMP	NEXT
;
	DB	82H		;  C,
	DB	'C'
	DB	','+80H
	DW	CSTORL-6
CCOMM	DW	DOCOL
	DW	HERE
	DW	CSTOR
	DW	ONE
	DW	ALLOT
	DW	EXIT
;
	DB	83H		;  C/L
	DB	'C/'
	DB	'L'+80H
	DW	CCOMM-5
CSLL	DW	DOCON
	DW	40H
;
	DB	82H		;  C@
	DB	'C'
	DB	'@'+80H
	DW	CSLL-6
CAT	DW	$+2
	POP	BX
	MOV	AL,[BX]
	SUB	AH,AH
	JMP	APUSH
;
	DB	83H		;  C@L
	DB	'C@'
	DB	'L'+80H
	DW	CAT-5
CATL	DW	$+2
	POP	BX
	POP	DS
	MOV	AL,[BX]
	SUB	AH,AH
	MOV	BX,CS
	MOV	DS,BX
	JMP	APUSH
;
	DB	83H		;  CFA
	DB	'CF'
	DB	'A'+80H
	DW	CATL-6
CFA	DW	DOCOL
	DW	TWOM
	DW	EXIT
;
	DB	86H		;  CHANGE
	DB	'CHANG'
	DB	'E'+80H
	DW	CFA-6
CHANGE	DW	DOCOL
	DW	FREEZE
	DW	LIMIT
	DW	LIT
	DW	404H
	DW	NOBUF
	DW	STAR
	DW	SUBB
	DW	DUPP
	DW	LIT
	DW	FIRST+2
	DW	STORE
	DW	LIT
	DW	US
	DW	SUBB
	DW	DUPP
	DW	LIT
	DW	RTS
	DW	SUBB
	DW	DUPP
	DW	LIT
	DW	INITUSER
	DW	STORE
	DW	LIT
	DW	INITUSER+4
	DW	STORE
	DW	DUPP
	DW	LIT
	DW	INITUSER+2
	DW	STORE
	DW	LIT
	DW	UP
	DW	OVER
	DW	LIT
	DW	RPP
	DW	LIT
	DW	ORIG
	DW	HERE
	DW	STORE
	DW	HERE
	DW	ROT
	DW	ROT
	DW	STORE
	DW	ROT
	DW	ROT
	DW	STORE
	DW	EXEC
	DW	EXIT
;
	DB	85H		;  CLEAR
	DB	'CLEA'
	DB	'R'+80H
	DW	CHANGE-9
CLEAR	DW	DOCOL
	DW	OFSET
	DW	ATT
	DW	PLUS
	DW	BUFFE
	DW	LIT
	DW	400H
	DW	BLL
	DW	FILL	
	DW	UPDAT
	DW	EXIT
;
	DB	85H		;  CMOVE
	DB	'CMOV'
	DB	'E'+80H
	DW	CLEAR-8
CMOVE	DW	DOCOL
	DW	DUPP
	DW	ONE
	DW	LESS
	DW	ZBRAN
	DW	CMOVE1-$
	DW	DDROP
	DW	DROP
	DW	BRAN
	DW	CMOVE2-$
CMOVE1	DW	ACMOVE
CMOVE2	DW	EXIT
;
	DB	84H		;  COLD
	DB	'COL'
	DB	'D'+80H
	DW	CMOVE-8
COLD	DW	DOCOL
	DW	MTBUF
	DW	LIT
	DW	INITUSER
	DW	LIT
	DW	UP
	DW	ATT
	DW	LIT
	DW	6
	DW	PLUS
	DW	LIT
	DW	30H
	DW	CMOVE
	DW	PAGEE
	DW	ADOTQ
	DB	1DH
	DB	'MVP-FORTH   VERSION 1.0305.03'
	DW	CR
	DW	ONE
	DW	DENSTY
	DW	STORE
	DW	FIRST
	DW	USEE
	DW	STORE
	DW	FIRST
	DW	PREV
	DW	STORE
	DW	DR0
	DW	ZERO
	DW	EPRINT
	DW	STORE
	DW	LIT
	DW	INITFORTH
	DW	ATT
	DW	LIT
	DW	FORTH+2
	DW	TWOP
	DW	STORE
	DW	DEC
	DW	LIT
	DW	40H
	DW	LIT
	DW	40H
	DW	LIT
	DW	17H
	DW	STOREL
	DW	ABORT
	DW	EXIT
;
	DB	87H		;  COMPILE
	DB	'COMPIL'
	DB	'E'+80H
	DW	COLD-7
COMP	DW	DOCOL
	DW	QCOMP
	DW	FROMR
	DW	DUPP
	DW	TWOP
	DW	TOR
	DW	ATT
	DW	COMMA
	DW	EXIT
;
	DB	89H		;  CONFIGURE
	DB	'CONFIGUR'
	DB	'E'+80H
	DW	COMP-0AH
CONF	DW	DOCOL
	DW	QCONF
	DW	CR
	DW	ADOTQ
	DB	13H
	DB	'NUMBER OF DRIVES ? '
	DW	KEY
	DW	LIT
	DW	31H
	DW	SUBB
	DW	DUPP
	DW	LIT
	DW	5
	DW	ULESS	
	DW	NOTT
	DW	AABORTQ
	DB	0FH
	DB	'TOO MANY DRIVES'
	DW	DUPP
	DW	LIT
	DW	31H
	DW	PLUS
	DW	EMIT
	DW	ONEP
	DW	LIT
	DW	MAXDRV+2
	DW	STORE
	DW	MAXDRV 
	DW	ZERO
	DW	ADO
CONF1	DW	CR
	DW	ADOTQ
	DB	6
	DB	'DRIVE '
	DW	IDO
	DW	DOT
	DW	ADOTQ
	DB	2
	DB	'? '
	DW	KEY
	DW	LIT
	DW	30H
	DW	SUBB
	DW	DUPP
	DW	LIT
	DW	7
	DW	ULESS
	DW	NOTT
	DW	AABORTQ
	DB	0CH
	DB	'OUT OF RANGE'
	DW	DUPP
	DW	LIT
	DW	30H
	DW	PLUS
	DW	EMIT
	DW	IDO
	DW	TWOST
	DW	DEN
	DW	PLUS
	DW	STORE
	DW	ALOOP
	DW	CONF1-$ 
	DW	DR0
	DW	CR
	DW	CR
	DW	ADOTQ
	DB	0DH
	DB	'DR0 SELECTED '
	DW	CR
	DW	EXIT
;
	DB	88H		; CONSTANT
	DB	'CONSTAN'
	DB	'T'+80H
	DW	CONF-0CH
CON	DW	DOCOL
	DW	CREATE
	DW	COMMA
	DW	ASCODE
DOCON:	INC	DX
	MOV	BX,DX
	MOV	AX,[BX]
	JMP	APUSH
;
	DB	87H		;  CONTEXT
	DB	'CONTEX'
	DB	'T'+80H
	DW	CON-0BH
CONT	DW	DOUSE
	DW	3CH
;
	DB	87H		;  CONVERT
	DB	'CONVER'
	DB	'T'+80H
	DW	CONT-0AH
CONV	DW	DOCOL
CONV1	DW	ONEP
	DW	DUPP
	DW	TOR
	DW	CAT
	DW	BASE
	DW	ATT
	DW	DIGIT
	DW	ZBRAN
	DW	OFFSET CONV3-$
	DW	SWAP
	DW	BASE
	DW	ATT
	DW	USTAR
	DW	DROP
	DW	ROT
	DW	BASE
	DW	ATT
	DW	USTAR
	DW	DPLUS
	DW	DPL
	DW	ATT
	DW	ONEP
	DW	ZBRAN
	DW	OFFSET CONV2-$
	DW	ONE
	DW	DPL
	DW	PSTOR
CONV2	DW	FROMR
	DW	BRAN
	DW	OFFSET CONV1-$
CONV3	DW	FROMR
	DW	EXIT
;
	DB	85H		;  COUNT
	DB	'COUN'
	DB	'T'+80H
	DW	CONV-0AH
COUNT	DW	DOCOL
	DW	DUPP
	DW	ONEP
	DW	SWAP
	DW	CAT
	DW	EXIT
;
	DB	82H		;  CR
	DB	'C'
	DB	'R'+80H
	DW	COUNT-8
CR	DW	DOCOL
	DW	TCR
	DW	ATT
	DW	EXEC
	DW	EXIT
;
	DB	86H		;  CREATE
	DB	'CREAT'
	DB	'E'+80H
	DW	CR-5
CREATE	DW	DOCOL
	DW	BLL
	DW	WORDD
	DW	DUPP
	DW	DUPP
	DW	ONEP
	DW	CAT
	DW	ZERO
	DW	EQUAL
	DW	AABORTQ
	DB	1AH
	DB	'ATTEMPTED TO REDEFINE NULL'
	DW	DUPP
	DW	CONT
	DW	ATT
	DW	ATT
	DW	AFIND
	DW	ZBRAN
	DW	OFFSET CREA1-$
	DW	DDROP
	DW	WARN
	DW	ATT
	DW	ZBRAN
	DW	OFFSET CREA1-$
	DW	DUPP
	DW	COUNT
	DW	TYPEE
	DW	SPACE
	DW	ADOTQ
	DB	0DH
	DB	'ISN',27H,'T UNIQUE '
CREA1	DW	CAT
	DW	WIDTHH
	DW	ATT
	DW	MIN
	DW	ONEP
	DW	ALLOT
	DW	DUPP
	DW	LIT
	DW	80H
	DW	TOGGL
	DW	HERE
	DW	ONEM
	DW	LIT
	DW	80H
	DW	TOGGL
	DW	LATES
	DW	COMMA
	DW	TWO
	DW	ALLOT
	DW	CURR
	DW	ATT
	DW	STORE
	DW	ASCODE
DOVAR:	INC	DX
	PUSH	DX
	JMP	NEXT 
;
	DB	83H		;  CSP
	DB	'CS'
	DB	'P'+80H
	DW	CREATE-9
CSP	DW	DOUSE
	DW	3EH
;
	DB	87H		; CURRENT
	DB	'CURREN'
	DB	'T'+80H
	DW	CSP-6
CURR	DW	DOUSE
	DW	40H
;
	DB	82H		;  DSTORE
	DB	'D'
	DB	'!'+80H
	DW	CURR-0AH
DSTOR	DW	$+2
	POP	BX
	POP	AX
	MOV	[BX],AX
	POP	AX
	MOV	2[BX],AX
	JMP	NEXT
;
	DB	82H		  ;  D+
	DB	'D'
	DB	'+'+80H
	DW	DSTOR-5
DPLUS	DW	$+2
	POP	AX
	POP	DX
	POP	BX
	POP	CX
	ADD	DX,CX
	ADC	AX,BX
	JMP	DPUSH
;
	DB	83H		;  D+-
	DB	'D+'
	DB	'-'+80H
	DW	DPLUS-5
DPM	DW	DOCOL
	DW	ZLESS
	DW	ZBRAN
	DW	OFFSET DPM1-$
	DW	DNEG
DPM1	DW	EXIT
;
	DB	82H		;  D.
	DB	'D'
	DB	'.'+80H
	DW	DPM-6
DDOT	DW	DOCOL
	DW	ZERO
	DW	DDOTR
	DW	SPACE
	DW	EXIT
;
	DB	83H		;  D.R
	DB	'D.'
	DB	'R'+80H
	DW	DDOT-5
DDOTR	DW	DOCOL
	DW	DEPTH
	DW	LIT
	DW	3
	DW	LESS
	DW	AABORTQ
	DB	0BH
	DB	'EMPTY STACK'
	DW	TOR
	DW	SWAP
	DW	OVER
	DW	DUPP
	DW	DPM
	DW	BDIGS
	DW	DIGS
	DW	ROT
	DW	SIGN
	DW	EDIGS
	DW	FROMR
	DW	OVER
	DW	SUBB
	DW	SPACS
	DW	TYPEE
	DW	EXIT
;
	DB	82H		;  D<
	DB	'D'
	DB	'<'+80H
	DW	DDOTR-6
DLESS	DW	DOCOL
	DW	ROT
	DW	DDUP
	DW	EQUAL
	DW	ZBRAN
	DW	DLESS1-$
	DW	ROT
	DW	ROT
	DW	DNEG
	DW	DPLUS
	DW	ZLESS
	DW	BRAN
	DW	DLESS2-$
DLESS1	DW	SWAP
	DW	LESS
	DW	SWAP
	DW	DROP
DLESS2	DW	SWAP
	DW	DROP
	DW	EXIT
;
	DB	84H		;  DABS
	DB	'DAB'
	DB	'S'+80H
	DW	DLESS-5
DABS	DW	DOCOL
	DW	DUPP
	DW	DPM
	DW	EXIT
;
	DB	85H		;  DDROP
	DB	'DDRO'
	DB	'P'+80H
	DW	DABS-7
DDROP	DW	$+2
	POP	BX
	POP	BX
	JMP	NEXT
;
	DB	84H		;  DDUP
	DB	'DDU'
	DB	'P'+80H
	DW	DDROP-8
DDUP	DW	$+2
	POP	AX
	POP	DX
	PUSH	DX
	PUSH	AX
	JMP	DPUSH
;
	DB	87H		;  DECIMAL
	DB	'DECIMA'
	DB	'L'+80H
	DW	DDUP-7
DEC	DW	DOCOL
	DW	LIT
	DW	0AH
	DW	BASE
	DW	STORE
	DW	EXIT
;
	DB	8BH		;  DEFINITIONS
	DB	'DEFINITION'
	DB	'S'+80H
	DW	DEC-0AH
DEFIN	DW	DOCOL
	DW	CONT
	DW	ATT
	DW	CURR
	DW	STORE
	DW	EXIT
;
	DB	83H		;  DEN
	DB	'DE'	
	DB	'N'+80H
	DW	DEFIN-0EH
DEN	DW	DOVAR
	DW	0
	DW	0
	DW	1
	DW	1
	DW	1
;
	DB	87H		;  DENSITY
	DB	'DENSIT'
	DB	'Y'+80H
	DW	DEN-6
DENSTY	DW	DOVAR
	DW	0
;
	DB	85H		;  DEPTH
	DB	'DEPT'
	DB	'H'+80H
	DW	DENSTY-0AH
DEPTH	DW	DOCOL
	DW	SPAT
	DW	SZERO
	DW	SWAP
	DW	SUBB
	DW	TWOSL
	DW	EXIT
;
	DB	85H		;  DIGIT
	DB	'DIGI'
	DB	'T'+80H
	DW	DEPTH-8
DIGIT	DW	$+2
	POP	DX
	POP	AX
	SUB	AL,'0'
	JB	DIGI2
	CMP	AL,9H
	JBE	DIGI1
	SUB	AL,7H
	CMP	AL,0AH
	JB	DIGI2
DIGI1:	CMP	AL,DL
	JAE	DIGI2
	SUB	DX,DX
	MOV	DL,AL
	MOV	AL,01H
	JMP	DPUSH
DIGI2:	SUB	AX,AX
	JMP	APUSH
;
	DB	8AH		;  DISK-ERROR
	DB	'DISK-ERRO'
	DB	'R'+80H
	DW	DIGIT-8
DSKERR	DW	DOVAR
	DW	0
;
	DB	0C8H		;  DLITERAL
	DB	'DLITERA'
	DB	'L'+80H
	DW	DSKERR-0DH
DLITE	DW	DOCOL
	DW	STATE
	DW	ATT
	DW	ZBRAN
	DW	OFFSET DLITE1-$
	DW	SWAP
	DW	LITER
	DW	LITER
DLITE1	DW	EXIT
;
	DB	87H		;  DNEGATE
	DB	'DNEGAT'
	DB	'E'+80H
	DW	DLITE-0BH
DNEG	DW	$+2
	POP	BX
	POP	CX
	SUB	AX,AX
	MOV	DX,AX
	SUB	DX,CX
	SBB	AX,BX
	JMP	DPUSH
;
	DB	0C2H		;  DO
	DB	'D'
	DB	'O'+80H
	DW	DNEG-0AH
DO	DW	DOCOL
	DW	COMP
	DW	ADO
	DW	HERE
	DW	LIT
	DW	3
	DW	EXIT
;
	DB	0C5H		;  DOES>
	DB	'DOES'
	DB	'>'+80H
	DW	DO-5
DOES	DW	DOCOL
	DW	QCSP
	DW	COMP
	DW	ASCODE
	DW	LIT
	DW	0E8H
	DW	CCOMM
	DW	LIT
	DW	DODOES
	DW	HERE
	DW	TWOP
	DW	SUBB
	DW	COMMA
	DW	EXIT
;
DODOES: INC	DX
	DEC	BP
	DEC	BP
	MOV	[BP],SI
	POP	SI
	PUSH	DX
	JMP	NEXT
;
	DB	82H		;  DP
	DB	'D'
	DB	'P'+80H
	DW	DOES-8
DP	DW	DOUSE
	DW	12H
;
	DB	83H		;  DPL
	DB	'DP'
	DB	'L'+80H
	DW	DP-5
DPL	DW	DOUSE
	DW	42H
;
	DB	85H		;  DPUSH
	DB	'DPUS'
	DB	'H'+80H
	DW	DPL-6
DPUS	DW	DOCON
	DW	DPUSH
;
	DB	86H		;  DR-DEN
	DB	'DR-DE'
	DB	'N'+80H
	DW	DPUS-8
DRDEN	DW	DOCOL
	DW	TWOST
	DW	DEN
	DW	PLUS
	DW	ATT
	DW	EXIT
;
	DB	83H		;  DR0
	DB	'DR'
	DB	'0'+80H
	DW	DRDEN-9
DR0	DW	DOCOL
	DW	ZERO
	DW	OFSET
	DW	STORE
	DW	EXIT
;
	DB	83H		;  DR1
	DB	'DR'
	DB	'1'+80H
	DW	DR0-6
DR1	DW	DOCOL
	DW	DR0
	DW	ZERO
	DW	SETDRX
	DW	EXIT
;
	DB	83H		; DR2
	DB	'DR'
	DB	'2'+80H
	DW	DR1-6
DR2	DW	DOCOL
	DW	DR1
	DW	ONE
	DW	SETDRX
	DW	EXIT
;
	DB	83H		;  DR3
	DB	'DR'
	DB	'3'+80H
	DW	DR2-6
DR3	DW	DOCOL
	DW	DR2
	DW	TWO
	DW	SETDRX
	DW	EXIT
;
	DB	83H		;  DR4
	DB	'DR'
	DB	'4'+80H
	DW	DR3-6
DR4	DW	DOCOL
	DW	DR3
	DW	LIT
	DW	3
	DW	SETDRX
	DW	EXIT
;
	DB	85H		;  DRIVE
	DB	'DRIV'
	DB	'E'+80H
	DW	DR4-6
DRIVE	DW	DOVAR
	DW	00
;
	DB	84H		;  DROP
	DB	'DRO'
	DB	'P'+80H
	DW	DRIVE-8
DROP	DW	$+2
	POP	AX
	JMP	NEXT 
;
	DB	83H		;  DUP
	DB	'DU'
	DB	'P'+80H
	DW	DROP-7
DUPP	DW	$+2
	POP	AX
	PUSH	AX
	JMP	APUSH
;
	DB	0C4H		;  ELSE
	DB	'ELS'
	DB	'E'+80H
	DW	DUPP-6
ELSEE	DW	DOCOL
	DW	TWO
	DW	QPAIR
	DW	COMP
	DW	BRAN
	DW	HERE
	DW	ZERO
	DW	COMMA
	DW	SWAP
	DW	TWO
	DW	THENN
	DW	TWO
	DW	EXIT
;
	DB	84H		;  EMIT
	DB	'EMI'
	DB	'T'+80H
	DW	ELSEE-7
EMIT	DW	DOCOL
	DW	TEMIT
	DW	ATT
	DW	EXEC
	DW	EXIT
;
	DB	8DH		;  EMPTY-BUFFERS
	DB	'EMPTY-BUFFER'
	DB	'S'+80H
	DW	EMIT-7
MTBUF	DW	DOCOL
	DW	FIRST
	DW	LIMIT
	DW	OVER
	DW	SUBB
	DW	ZERO
	DW	AFILL
	DW	NOBUF
	DW	ZERO
	DW	ADO
MTBUF1	DW	LIT
	DW	7FFFH
	DW	LIT
	DW	404H
	DW	IDO
	DW	STAR
	DW	FIRST
	DW	PLUS
	DW	STORE
	DW	ALOOP
	DW	OFFSET MTBUF1-$
	DW	EXIT
;
	DB	87H		;  ENCLOSE
	DB	'ENCLOS'
	DB	'E'+80H
	DW	MTBUF-10H
ENCL	DW	$+2
	POP	AX
	POP	BX
	PUSH	BX
	MOV	DX,0FFFFH
	DEC	BX
ENCL1:	INC	BX
	INC	DX
	CMP	AL,[BX]
	JZ	ENCL1
	PUSH	DX
	INC	BYTE PTR [BX]
	DEC	BYTE PTR [BX]
	JNZ	ENCL2
	INC	DX
	PUSH	DX
	DEC	DX
	PUSH	DX
	JMP	NEXT
ENCL2:	INC	BX
	INC	DX
	CMP	AL,[BX]
	JZ	ENCL3
	INC	BYTE PTR [BX]
	DEC	BYTE PTR [BX]
	JNZ	ENCL2
	PUSH	DX
	PUSH	DX
	JMP	NEXT
ENCL3:	PUSH	DX
	INC	DX
	PUSH	DX
	JMP	NEXT
;
	DB	86H		;  EPRINT
	DB	'EPRIN'
	DB	'T'+80H
	DW	ENCL-0AH
EPRINT	DW	DOVAR
	DW	0
;
	DB	87H		;  EXECUTE
	DB	'EXECUT'
	DB	'E'+80H
	DW	EPRINT-9
EXEC	DW	$+2
	POP	BX
	JMP	NEXT1
;
	DB	84H		;  EXIT
	DB	'EXI'
	DB	'T'+80H
	DW	EXEC-0AH
EXIT	DW	$+2
	MOV	SI,[BP]
	INC	BP
	INC	BP
	JMP	NEXT
;
	DB	86H		;  EXPECT
	DB	'EXPEC'
	DB	'T'+80H
	DW	EXIT-7
EXPEC	DW	DOCOL
	DW	TEXPECT
	DW	ATT
	DW	EXEC
	DW	EXIT
;
	DB	85H		;  FENCE
	DB	'FENC'
	DB	'E'+80H
	DW	EXPEC-9
FENCE	DW	DOUSE
	DW	10H
;
	DB	84H		;  FILL
	DB	'FIL'
	DB	'L'+80H
	DW	FENCE-8
FILL	DW	DOCOL
	DW	OVER
	DW	ZGREAT
	DW	ZBRAN
	DW	FILL1-$
	DW	AFILL
	DW	BRAN
	DW	FILL2-$
FILL1	DW	DDROP
	DW	DROP
FILL2	DW	EXIT
;
	DB	84H		;  FIND
	DB	'FIN'
	DB	'D'+80H
	DW	FILL-7
FIND	DW	DOCOL
	DW	DFIND
	DW	ZBRAN
	DW	FIND1-$
	DW	DROP
	DW	CFA
	DW	BRAN
	DW	FIND2-$
FIND1	DW	ZERO
FIND2	DW	EXIT
;
	DB	85H		;  FIRST
	DB	'FIRS'
	DB	'T'+80H
	DW	FIND-7
FIRST	DW	DOCON
	DW	BUF1
;
	DB	83H		;  FLD
	DB	'FL'
	DB	'D'+80H
	DW	FIRST-8
FLD	DW	DOUSE
	DW	44H
;
	DB	86H		;  FORGET
	DB	'FORGE'
	DB	'T'+80H
	DW	FLD-6
FORG	DW	DOCOL
	DW	BLL
	DW	WORDD
	DW	CURR
	DW	ATT
	DW	ATT
	DW	AFIND
	DW	ZEQU
	DW	AABORTQ
	DB	19H
	DB	'NOT IN CURRENT VOCABULARY'
	DW	DROP
	DW	NFA
	DW	DUPP
	DW	FENCE
	DW	ATT
	DW	ULESS
	DW	AABORTQ
	DB	17H
	DB	'IN PROTECTED DICTIONARY'
	DW	TOR
	DW	RAT
	DW	CONT
	DW	ATT
	DW	ULESS
	DW	ZBRAN
	DW	FORG1-$
	DW	FORTH
FORG1	DW	RAT
	DW	CURR
	DW	ATT
	DW	ULESS
	DW	ZBRAN
	DW	FORG2-$
	DW	FORTH
	DW	DEFIN
FORG2	DW	VOCL
	DW	ATT
FORG3	DW	RAT
	DW	OVER
	DW	ULESS
	DW	ZBRAN
	DW	FORG4-$
	DW	ATT
	DW	BRAN
	DW	FORG3-$
FORG4	DW	DUPP
	DW	VOCL
	DW	STORE
FORG5	DW	DUPP
	DW	LIT
	DW	4
	DW	SUBB
FORG6	DW	PFA
	DW	LFA
	DW	ATT
	DW	DUPP
	DW	RAT	
	DW	ULESS
	DW	ZBRAN
	DW	FORG6-$
	DW	OVER
	DW	TWOM
	DW	STORE
	DW	ATT
	DW	QDUP
	DW	ZEQU
	DW	ZBRAN
	DW	FORG5-$
	DW	FROMR
	DW	DP
	DW	STORE
	DW	EXIT
;
	DB	0C5H		;  FORTH
	DB	'FORT'
	DB	'H'+80H
	DW	FORG-9
FORTH	DW	DOVOC
	DW	0A081H
	DW	RBRAC-4
	DW	00
;
	DB	86H		;  FREEZE
	DB	'FREEZ'
	DB	'E'+80H
	DW	FORTH-8
FREEZE	DW	DOCOL
	DW	LIT
	DW	UP
	DW	ATT
	DW	LIT
	DW	6
	DW	PLUS
	DW	LIT
	DW	INITUSER
	DW	LIT
	DW	30H
	DW	CMOVE
	DW	LIT
	DW	FORTH+2
	DW	TWOP
	DW	ATT
	DW	LIT
	DW	INITFORTH
	DW	STORE
	DW	EXIT
;
	DB	84H		;  HERE
	DB	'HER'
	DB	'E'+80H
	DW	FREEZE-9
HERE	DW	DOCOL
	DW	DP
	DW	ATT
	DW	EXIT
;
	DB	83H		;  HEX
	DB	'HE'
	DB	'X'+80H
	DW	HERE-7
HEX	DW	DOCOL
	DW	LIT
	DW	10H
	DW	BASE
	DW	STORE
	DW	EXIT
;
	DB	83H		;  HLD
	DB	'HL'
	DB	'D'+80H
	DW	HEX-6
HLD	DW	DOUSE
	DW	46H
;
	DB	84H		;  HOLD
	DB	'HOL'
	DB	'D'+80H
	DW	HLD-6
HOLD	DW	DOCOL
	DW	LIT
	DW	0FFFFH
	DW	HLD
	DW	PSTOR
	DW	HLD
	DW	ATT
	DW	CSTOR
	DW	EXIT
;
	DB	81H		;  I
	DB	'I'+80H
	DW	HOLD-7
IDO	DW	$+2
	MOV	AX,[BP]
	JMP	APUSH
;
	DB	82H		;  I'
	DB	'I'
	DB	0A7H
	DW	IDO-4
IPDO	DW	$+2
	MOV	AX,[BP+2]
	JMP	APUSH
;
	DB	0C2H		;  IF
	DB	'I'
	DB	'F'+80H
	DW	IPDO-5
IFF	DW	DOCOL
	DW	COMP
	DW	ZBRAN
	DW	HERE
	DW	ZERO
	DW	COMMA
	DW	TWO
	DW	EXIT
;
	DB	89H		;  IMMEDIATE
	DB	'IMMEDIAT'
	DB	'E'+80H
	DW	IFF-5
IMMED	DW	DOCOL
	DW	LATES
	DW	LIT
	DW	40H
	DW	TOGGL
	DW	EXIT
;
	DB	8AH		;  INIT-FORTH
	DB	'INIT-FORT'
	DB	'H'+80H
	DW	IMMED-0CH
IFORTH	DW	DOCON
	DW	INITFORTH
;
	DB	89H		;  INIT-USER
	DB	'INIT-USE'
	DB	'R'+80H
	DW	IFORTH-0DH
IUSER	DW	DOCON
	DW	INITUSER
;
	DB	87H		;  INTCALL
	DB	'INTCAL'
	DB	'L'+80H
	DW	IUSER-0CH
INTCAL	DW	DOCOL
	DW	LIT
	DW	INTCA2+1
	DW	CSTOR
	DW	LIT
	DW	INTCA1
	DW	EXEC
	DW	EXIT
;
INTCA1	DW	$+2
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	PUSH	SI
	PUSH	BP
INTCA2: INT	0
	POP	BP
	POP	SI
	JMP	APUSH
;
	DB	89H		;  INTERPRET
	DB	'INTERPRE'
	DB	'T'+80H
	DW	INTCAL-0AH
INTER	DW	DOCOL
	DW	TINTER
	DW	ATT
	DW	EXEC
	DW	EXIT
;
;
	DB	81H		;  J
	DB	'J'+80H
	DW	INTER-0CH
JDO	DW	$+2
	MOV	AX,[BP+4]
	JMP	APUSH
;
	DB	83H		;  KEY
	DB	'KE'
	DB	'Y'+80H
	DW	JDO-4
KEY	DW	DOCOL
	DW	TKEY
	DW	ATT
	DW	EXEC
	DW	EXIT
;
	DB	86H		;  LATEST
	DB	'LATES'
	DB	'T'+80H
	DW	KEY-6
LATES	DW	DOCOL
	DW	CURR
	DW	ATT
	DW	ATT
	DW	EXIT
;
	DB	85H		;  LEAVE
	DB	'LEAV'
	DB	'E'+80H
	DW	LATES-9
LEAVE	DW	$+2
	MOV	AX,[BP]
	MOV	2[BP],AX
	JMP	NEXT
;
	DB	83H		;  LFA
	DB	'LF'
	DB	'A'+80H
	DW	LEAVE-8
LFA	DW	DOCOL
	DW	LIT
	DW	4
	DW	SUBB
	DW	EXIT
;
	DB	85H		;  LIMIT
	DB	'LIMI'
	DB	'T'+80H
	DW	LFA-6
LIMIT	DW	DOCON
	DW	EM
;
	DB	84H		;  LIST
	DB	'LIS'
	DB	'T'+80H
	DW	LIMIT-8
LIST	DW	DOCOL
	DW	CR
	DW	DUPP
	DW	SCR
	DW	STORE
	DW	ADOTQ
	DB	5
	DB	'SCR #'
	DW	UDOT
	DW	LIT
	DW	10H
	DW	ZERO
	DW	ADO
LIST1	DW	CR
	DW	RAT
	DW	LIT
	DW	3
	DW	DOTR
	DW	SPACE
	DW	RAT
	DW	SCR
	DW	ATT
	DW	DLINE
	DW	QTERM
	DW	ZBRAN
	DW	OFFSET LIST2-$
	DW	LEAVE
LIST2	DW	ALOOP
	DW	OFFSET LIST1-$
	DW	CR
	DW	EXIT
;
	DB	83H		;  LIT
	DB	'LI'
	DB	'T'+80H
	DW	LIST-7
LIT	DW	$+2
	MOV	AX,[SI]
	INC	SI
	INC	SI
	JMP	APUSH
;
	DB	0C7H		;  LITERAL
	DB	'LITERA'
	DB	'L'+80H
	DW	LIT-6
LITER	DW	DOCOL
	DW	STATE
	DW	ATT
	DW	ZBRAN
	DW	OFFSET LITER1-$
	DW	COMP
	DW	LIT
	DW	COMMA
LITER1	DW	EXIT
;
	DB	84H		;  LOAD
	DB	'LOA'
	DB	'D'+80H
	DW	LITER-0AH
LOAD	DW	DOCOL
	DW	TLOAD
	DW	ATT
	DW	EXEC
	DW	EXIT
;
	DB	0C4H		;  LOOP
	DB	'LOO'
	DB	'P'+80H
	DW	LOAD-7
LOOP	DW	DOCOL
	DW	LIT
	DW	3
	DW	QPAIR
	DW	COMP
	DW	ALOOP
	DW	HERE
	DW	SUBB
	DW	COMMA
	DW	EXIT
;
	DB	82H		;  M*
	DB	'M'
	DB	'*'+80H
	DW	LOOP-7
MSTAR	DW	DOCOL
	DW	DDUP
	DW	XORR
	DW	TOR
	DW	ABSS
	DW	SWAP
	DW	ABSS
	DW	USTAR
	DW	FROMR
	DW	DPM
	DW	EXIT
;
	DB	83H		;  M*/
	DB	'M*'
	DB	'/'+80H
	DW	MSTAR-5
MSTARSL DW	DOCOL
	DW	DDUP
	DW	XORR
	DW	SWAP
	DW	ABSS
	DW	TOR
	DW	SWAP
	DW	ABSS
	DW	TOR
	DW	OVER
	DW	XORR
	DW	ROT
	DW	ROT
	DW	DABS
	DW	SWAP
	DW	RAT
	DW	USTAR
	DW	ROT
	DW	FROMR
	DW	USTAR
	DW	ROT	
	DW	ZERO
	DW	DPLUS
	DW	RAT
	DW	USLM
	DW	ROT
	DW	ROT
	DW	FROMR
	DW	USLM
	DW	SWAP
	DW	DROP
	DW	SWAP
	DW	ROT
	DW	DPM
	DW	EXIT
;
	DB	82H		;  M+
	DB	'M'
	DB	'+'+80H
	DW	MSTARSL-6
MPLUS	DW	DOCOL
	DW	STOD
	DW	DPLUS
	DW	EXIT
;
	DB	82H		;  M/
	DB	'M'
	DB	'/'+80H
	DW	MPLUS-5
MSLAS	DW	DOCOL
	DW	OVER
	DW	TOR
	DW	TOR
	DW	DUPP
	DW	DPM
	DW	RAT
	DW	ABSS
	DW	USLM
	DW	FROMR
	DW	RAT
	DW	XORR
	DW	PM
	DW	SWAP
	DW	FROMR
	DW	PM
	DW	SWAP
	DW	EXIT
;
	DB	85H		;  M/MOD
	DB	'M/MO'
	DB	'D'+80H
	DW	MSLAS-5
MSMOD	DW	DOCOL
	DW	TOR
	DW	ZERO
	DW	RAT
	DW	USLM
	DW	FROMR
	DW	SWAP
	DW	TOR
	DW	USLM
	DW	FROMR
	DW	EXIT
;
	DB	83H		;  MAX
	DB	'MA'
	DB	'X'+80H
	DW	MSMOD-8
MAX	DW	DOCOL
	DW	DDUP
	DW	LESS
	DW	ZBRAN
	DW	OFFSET MAX1-$
	DW	SWAP
MAX1	DW	DROP
	DW	EXIT
;
	DB	87H		;  MAX-DRV
	DB	'MAX-DR'
	DB	'V'+80H
	DW	MAX-6
MAXDRV	DW	DOCON
	DW	2
; 
	DB	83H		;  MIN
	DB	'MI'
	DB	'N'+80H
	DW	MAXDRV-0AH
MIN	DW	DOCOL
	DW	DDUP
	DW	GREAT
	DW	ZBRAN
	DW	OFFSET MIN1-$
	DW	SWAP
MIN1	DW	DROP
	DW	EXIT
;
	DB	83H		;  MOD
	DB	'MO'
	DB	'D'+80H
	DW	MIN-6
MODD	DW	DOCOL
	DW	SLMOD
	DW	DROP
	DW	EXIT
;
	DB	84H		;  MOVE
	DB	'MOV'
	DB	'E'+80H
	DW	MODD-6
MOVE	DW	DOCOL
	DW	ZERO
	DW	MAX
	DW	TWOST
	DW	ACMOVE
	DW	EXIT
;
	DB	86H		;  NEGATE
	DB	'NEGAT'
	DB	'E'+80H
	DW	MOVE-7
NEG	DW	$+2
	POP	AX
	NEG	AX
	JMP	APUSH
;
	DB	84H		;  NEXT
	DB	'NEX'
	DB	'T'+80H
	DW	NEG-9
CNEXT	DW	DOCON
	DW	NEXT
;
	DB	85H		;  NEXT1
	DB	'NEXT'
	DB	'1'+80H
	DW	CNEXT-7
CNEXT1	DW	DOCON
	DW	NEXT1
;
	DB	83H		;  NFA
	DB	'NF'
	DB	'A'+80H
	DW	CNEXT1-8
NFA	DW	DOCOL
	DW	LIT
	DW	5
	DW	SUBB
	DW	LIT
	DW	0FFFFH
	DW	TRAV
	DW	EXIT
;
	DB	83H		;  NOT
	DB	'NO'
	DB	'T'+80H
	DW	NFA-6
NOTT	DW	$+2
	POP	AX
	OR	AX,AX
	MOV	AX,1H
	JZ	NOT1
	DEC	AX
NOT1:	JMP	APUSH
;
	DB	86H		;  NUMBER
	DB	'NUMBE'
	DB	'R'+80H
	DW	NOTT-6
NUM	DW	DOCOL
	DW	TNUM
	DW	ATT
	DW	EXEC
	DW	EXIT
;
	DB	86H		;  OFFSET
	DB	'OFFSE'
	DB	'T'+80H
	DW	NUM-9
OFSET	DW	DOUSE
	DW	48H
;
	DB	82H		;  OR
	DB	'O'
	DB	'R'+80H
	DW	OFSET-9
ORR	DW	$+2
	POP	AX
	POP	BX
	OR	AX,BX
	JMP	APUSH
;
	DB	83H		;  OUT
	DB	'OU'
	DB	'T'+80H
	DW	ORR-5
OUTT	DW	DOUSE
	DW	4AH
;
	DB	84H		;  OVER
	DB	'OVE'
	DB	'R'+80H
	DW	OUTT-6
OVER	DW	$+2
	POP	DX
	POP	AX
	PUSH	AX
	JMP	DPUSH
;
	DB	82H		;  PSTORE
	DB	'P'
	DB	'!'+80H
	DW	OVER-7
PTSTOR	DW	$+2
	POP	DX
	POP	AX
	OUT	DX,AL
	JMP	NEXT 
;
	DB	82H		;  P@
	DB	'P'
	DB	'@'+80H
	DW	PTSTOR-5
PTAT	DW	$+2
	POP	DX
	IN	AL,DX
	SUB	AH,AH
	JMP	APUSH
;
	DB	83H		;  PAD
	DB	'PA'
	DB	'D'+80H
	DW	PTAT-5
PAD	DW	DOCOL
	DW	HERE
	DW	LIT
	DW	44H
	DW	PLUS
	DW	EXIT
;
	DB	84H		;  PAGE
	DB	'PAG'
	DB	'E'+80H
	DW	PAD-6
PAGEE	DW	DOCOL
	DW	TPAGE
	DW	ATT
	DW	EXEC
	DW	EXIT
;
	DB	83H		;  PFA
	DB	'PF'
	DB	'A'+80H
	DW	PAGEE-7
PFA	DW	DOCOL
	DW	ONE
	DW	TRAV
	DW	LIT
	DW	5
	DW	PLUS
	DW	EXIT
;
	DB	84H		;  PICK
	DB	'PIC'
	DB	'K'+80H
	DW	PFA-6
PICK	DW	DOCOL
	DW	DUPP
	DW	ONE
	DW	LESS
	DW	AABORTQ
	DB	11H
	DB	'PICK ARGUMENT < 1'
	DW	TWOST
	DW	SPAT
	DW	PLUS
	DW	ATT
	DW	EXIT
;
	DB	82H		;  PP
	DB	'P'
	DB	'P'+80H
	DW	PICK-7
PP	DW	DOCOL
	DW	DUPP
	DW	LIT
	DW	0FFF0H
	DW	ANDD
	DW	AABORTQ
	DB	0AH
	DB	'OFF SCREEN'
	DW	ONE
	DW	TEXT
	DW	PAD
	DW	ONEP
	DW	SWAP
	DW	SCR
	DW	ATT
	DW	ALINE
	DW	CMOVE
	DW	UPDAT
	DW	EXIT
;
	DB	84H		;  PREV
	DB	'PRE'
	DB	'V'+80H
	DW	PP-5
PREV	DW	DOVAR
	DW	BUF1
;
	DB	83H		; PWSTORE
	DB	'PW'
	DB	'!'+80H
	DW	PREV-7
PWSTOR	DW	$+2
	POP	DX
	POP	AX
	OUT	DX,AX
	JMP	NEXT
;
	DB	83H		; PW@ 
	DB	'PW'
	DB	'@'+80H
	DW	PWSTOR-6
PWAT	DW	$+2
	POP	DX
	IN	AX,DX
	JMP	APUSH
;
	DB	85H		;  QUERY
	DB	'QUER'
	DB	'Y'+80H
	DW	PWAT-6
QUERY	DW	DOCOL
	DW	TIB
	DW	ATT
	DW	LIT
	DW	50H
	DW	EXPEC
	DW	ZERO
	DW	TOIN
	DW	STORE
	DW	EXIT
;
	DB	84H		;  QUIT
	DB	'QUI'
	DB	'T'+80H
	DW	QUERY-8
QUIT	DW	DOCOL
	DW	ZERO
	DW	BLK
	DW	STORE
	DW	LBRAC
QUIT1	DW	CR
	DW	RPSTO
	DW	QUERY
	DW	INTER
	DW	STATE
	DW	ATT
	DW	NOTT
	DW	ZBRAN
	DW	OFFSET QUIT2-$
	DW	ADOTQ
	DB	2
	DB	'OK'
QUIT2	DW	BRAN
	DW	QUIT1-$
	DW	EXIT
;
	DB	82H		;  R#
	DB	'R'
	DB	'#'+80H
	DW	QUIT-7
RSHARP	DW	DOUSE
	DW	4CH
;
	DB	83H		;  R/W
	DB	'R/'
	DB	'W'+80H
	DW	RSHARP-5
RSLW	DW	DOCOL
	DW	TRSLW
	DW	ATT
	DW	EXEC
	DW	EXIT
;
	DB	82H		;  R0
	DB	'R'
	DB	'0'+80H
	DW	RSLW-6
RZERO	DW	DOUSE
	DW	08
;
	DB	82H		;  R>
	DB	'R'
	DB	'>'+80H
	DW	RZERO-5
FROMR	DW	$+2
	MOV	AX,[BP]
	INC	BP
	INC	BP
	JMP	APUSH
;
	DB	82H		;  R@
	DB	'R'
	DB	'@'+80H
	DW	FROMR-5
RAT	DW	$+2
	MOV	AX,[BP]
	JMP	APUSH
;
	DB	0C6H		;  REPEAT
	DB	'REPEA'
	DB	'T'+80H
	DW	RAT-5
REPEA	DW	DOCOL
	DW	TOR
	DW	TOR
	DW	AGAIN
	DW	FROMR
	DW	FROMR
	DW	TWOM
	DW	THENN
	DW	EXIT
;
	DB	84H		;  ROLL
	DB	'ROL'
	DB	'L'+80H
	DW	REPEA-9
ROLL	DW	DOCOL
	DW	DUPP
	DW	ONE
	DW	LESS
	DW	AABORTQ
	DB	11H
	DB	'ROLL ARGUMENT < 1'
	DW	ONEP
	DW	DUPP
	DW	PICK
	DW	SWAP
	DW	TWOST
	DW	SPAT
	DW	PLUS
ROLL1	DW	DUPP
	DW	TWOM
	DW	ATT
	DW	OVER
	DW	STORE
	DW	TWOM
	DW	SPAT
	DW	OVER
	DW	ULESS
	DW	NOTT
	DW	ZBRAN
	DW	ROLL1-$
	DW	DDROP
	DW	EXIT
;
	DB	83H		;  ROT
	DB	'RO'
	DB	'T'+80H
	DW	ROLL-7
ROT	DW	$+2
	POP	DX
	POP	BX
	POP	AX
	PUSH	BX
	JMP	DPUSH
;
	DB	83H		;  RPSTORE
	DB	'RP'
	DB	'!'+80H
	DW	ROT-6
RPSTO	DW	$+2
	MOV	BX,UP
	MOV	BP,8[BX]
	JMP	NEXT
;
	DB	83H		;  RP@
	DB	'RP'
	DB	'@'+80H
	DW	RPSTO-6
RPAT	DW	$+2
	MOV	AX,BP
	JMP	APUSH
;
	DB	83H		;  RPP
	DB	'RP'
	DB	'P'+80H
	DW	RPAT-6
RPPP	DW	DOCON
	DW	RPP
;
	DB	84H		;  S->D
	DB	'S->'
	DB	'D'+80H
	DW	RPPP-6
STOD	DW	$+2
	POP	DX
	SUB	AX,AX
	OR	DX,DX
	JNS	STOD1
	DEC	AX
STOD1:	JMP	DPUSH
;
	DB	82H		;  S0
	DB	'S'
	DB	'0'+80H
	DW	STOD-7
SZERO	DW	DOCOL
	DW	SPZERO
	DW	ATT
	DW	EXIT
;
	DB	8CH		;  SAVE-BUFFERS
	DB	'SAVE-BUFFER'
	DB	'S'+80H
	DW	SZERO-5
SAVBUF	DW	DOCOL
	DW	NOBUF
	DW	ONEP
	DW	ZERO
	DW	ADO
SAVBUF1 DW	LIT
	DW	7FFFH
	DW	BUFFE
	DW	DROP
	DW	ALOOP
	DW	OFFSET SAVBUF1-$
	DW	EXIT
;
	DB	83H		;  SCR
	DB	'SC'
	DB	'R'+80H
	DW	SAVBUF-0FH
SCR	DW	DOUSE
	DW	4EH
;
	DB	83H		;  SEC	
	DB	'SE'
	DB	'C'+80H
	DW	SCR-6
SEC	DW	DOVAR
	DW	0
;
	DB	88H		;  SEC-READ
	DB	'SEC-REA'
	DB	'D'+80H
	DW	SEC-6
SECRD	DW	DOCOL
	DW	LIT
	DW	201H
	DW	LIT
	DW	SECRW
	DW	EXEC
	DW	EXIT
;
SECRW	DW	DOCOL
	DW	LIT
	DW	3
	DW	ZERO
	DW	ADO
SECRW1	DW	DUPP
	DW	USEE
	DW	ATT
	DW	TRACK
	DW	ATT
	DW	LIT
	DW	100H
	DW	STAR
	DW	SEC
	DW	ATT
	DW	PLUS
	DW	DRIVE
	DW	ATT
	DW	LIT
	DW	13H
	DW	INTCAL
	DW	DUPP
	DW	DSKERR
	DW	STORE
	DW	ZEQU
	DW	ZBRAN
	DW	OFFSET SECRW2-$
	DW	LEAVE
	DW	BRAN
	DW	OFFSET SECRW3-$
SECRW2	DW	ZERO
	DW	ZERO
	DW	ZERO
	DW	ZERO
	DW	LIT
	DW	13H
	DW	INTCAL
	DW	DROP
SECRW3	DW	ALOOP
	DW	OFFSET SECRW1-$
	DW	DROP
	DW	EXIT 
;
	DB	89H		;  SEC-WRITE
	DB	'SEC-WRIT'
	DB	'E'+80H
	DW	SECRD-0BH
SECWT	DW	DOCOL
	DW	LIT
	DW	301H
	DW	LIT
	DW	SECRW
	DW	EXEC
	DW	EXIT
;
	DB	87H		;  SEC/BLK
	DB	'SEC/BL'
	DB	'K'+80H
	DW	SECWT-0CH
SPBL	DW	DOVAR
	DW	2
	DW	2
	DW	8
	DW	8
	DW	8
	DW	8
	DW	8
;
	DB	86H		;  SEC/TR
	DB	'SEC/T'
	DB	'R'+80H
	DW	SPBL-0AH
SPTR	DW	DOVAR
	DW	8H
	DW	10H
	DW	1AH
	DW	34H
	DW	34H
	DW	40H
	DW	40H
;
	DB	87H		;  SET-DRX
	DB	'SET-DR'
	DB	'X'+80H
	DW	SPTR-9H
SETDRX	DW	DOCOL
	DW	DRDEN
	DW	DENSTY
	DW	STORE
	DW	BPDRV
	DW	OFSET
	DW	PSTOR
	DW	EXIT
;
	DB	84H		;  SIGN
	DB	'SIG'
	DB	'N'+80H
	DW	SETDRX-0AH
SIGN	DW	DOCOL
	DW	ZLESS
	DW	ZBRAN
	DW	OFFSET SIGN1-$
	DW	LIT
	DW	2DH
	DW	HOLD	
SIGN1	DW	EXIT
;
	DB	86H		;  SMUDGE
	DB	'SMUDG'
	DB	'E'+80H
	DW	SIGN-7
SMUDG	DW	DOCOL
	DW	LATES
	DW	LIT
	DW	20H
	DW	TOGGL
	DW	EXIT
;
	DB	83H		;  SPSTORE
	DB	'SP'
	DB	'!'+80H 
	DW	SMUDG-9
SPSTO	DW	$+2
	MOV	BX,UP
	MOV	SP,6[BX]
	JMP	NEXT
;
	DB	83H		;  SP0
	DB	'SP'
	DB	'0'+80H
	DW	SPSTO-6
SPZERO	DW	DOUSE
	DW	06
;
	DB	83H		;  SP@
	DB	'SP'
	DB	'@'+80H
	DW	SPZERO-6
SPAT	DW	$+2
	MOV	AX,SP
	JMP	APUSH
;
	DB	85H		;  SPACE
	DB	'SPAC'
	DB	'E'+80H
	DW	SPAT-6
SPACE	DW	DOCOL
	DW	BLL
	DW	EMIT
	DW	EXIT
;
	DB	86H		;  SPACES
	DB	'SPACE'
	DB	'S'+80H
	DW	SPACE-8
SPACS	DW	DOCOL
	DW	ZERO
	DW	MAX
	DW	QDUP
	DW	ZBRAN
	DW	OFFSET SPACS2-$
	DW	ZERO
	DW	ADO
SPACS1	DW	SPACE
	DW	ALOOP
	DW	OFFSET SPACS1-$
SPACS2	DW	EXIT
;
	DB	85H		;  SPBLK
	DB	'SPBL'
	DB	'K'+80H
	DW	SPACS-9
SPBLK	DW	DOCOL
	DW	DENSTY
	DW	ATT
	DW	LIT
	DW	6
	DW	MIN
	DW	TWOST
	DW	SPBL
	DW	PLUS
	DW	ATT
	DW	EXIT
;
	DB	85H		;  SPDRV
	DB	'SPDR'
	DB	'V'+80H
	DW	SPBLK-8
SPDRV	DW	DOCOL
	DW	BPDRV
	DW	SPBLK
	DW	STAR
	DW	EXIT
;
	DB	83H		;  SPT
	DB	'SP'
	DB	'T'+80H
	DW	SPDRV-8
SPT	DW	DOCOL
	DW	DENSTY
	DW	ATT
	DW	LIT
	DW	6
	DW	MIN
	DW	TWOST
	DW	SPTR
	DW	PLUS
	DW	ATT
	DW	EXIT
;
	DB	85H		;  STATE
	DB	'STAT'
	DB	'E'+80H
	DW	SPT-6
STATE	DW	DOUSE
	DW	50H
;
	DB	84H		;  SWAP
	DB	'SWA'
	DB	'P'+80H
	DW	STATE-8
SWAP	DW	$+2
	POP	DX
	POP	AX
	JMP	DPUSH
;
	DB	87H		;  SYSCALL
	DB	'SYSCAL'
	DB	'L'+80H
	DW	SWAP-7
SYSCALL DW	DOCOL
	DW	SWAP
	DW	LIT
	DW	100H
	DW	STAR
	DW	SWAP
	DW	ZERO
	DW	ZERO
	DW	ROT
	DW	LIT
	DW	21H
	DW	INTCAL
	DW	EXIT
;
	DB	87H		;  T&SCALC
	DB	'T&SCAL'
	DB	'C'+80H
	DW	SYSCALL-0AH
TSCALC	DW	DOCOL
	DW	TTSCALC
	DW	ATT
	DW	EXEC
	DW	EXIT
;
	DB	84H		;  TEXT
	DB	'TEX'
	DB	'T'+80H
	DW	TSCALC-0AH
TEXT	DW	DOCOL
	DW	HERE
	DW	CSLL
	DW	ONEP
	DW	BLANK
	DW	WORDD
	DW	BLL	 
	DW	OVER
	DW	DUPP
	DW	CAT
	DW	PLUS
	DW	ONEP
	DW	CSTOR
	DW	PAD
	DW	CSLL
	DW	ONEP
	DW	CMOVE
	DW	EXIT
;
	DB	0C4H		;  THEN
	DB	'THE'
	DB	'N'+80H
	DW	TEXT-7
THENN	DW	DOCOL
	DW	QCOMP
	DW	TWO
	DW	QPAIR
	DW	HERE
	DW	OVER
	DW	SUBB
	DW	SWAP
	DW	STORE
	DW	EXIT
;
	DB	83H		;  TIB
	DB	'TI'	
	DB	'B'+80H
	DW	THENN-7
TIB	DW	DOUSE
	DW	0AH
;
	DB	86H		;  TOGGLE
	DB	'TOGGL'
	DB	'E'+80H
	DW	TIB-6
TOGGL	DW	$+2
	POP	AX
	POP	BX
	XOR	[BX],AL
	JMP	NEXT
;
	DB	85H		;  TRACK
	DB	'TRAC'
	DB	'K'+80H
	DW	TOGGL-9
TRACK	DW	DOVAR
	DW	0
;
	DB	88H		;  TRAVERSE
	DB	'TRAVERS'
	DB	'E'+80H
	DW	TRACK-8
TRAV	DW	DOCOL
	DW	SWAP
TRAV1	DW	OVER
	DW	PLUS
	DW	LIT
	DW	07FH
	DW	OVER
	DW	CAT
	DW	LESS
	DW	ZBRAN
	DW	OFFSET TRAV1-$
	DW	SWAP
	DW	DROP
	DW	EXIT
;
	DB	84H		;  TYPE
	DB	'TYP'
	DB	'E'+80H
	DW	TRAV-0BH
TYPEE	DW	DOCOL
	DW	DUPP
	DW	ZGREAT
	DW	ZBRAN
	DW	OFFSET TYPE2-$
	DW	OVER
	DW	PLUS
	DW	SWAP
	DW	ADO
TYPE1	DW	IDO
	DW	CAT
	DW	EMIT
	DW	ONE
	DW	AUPLOOP
	DW	OFFSET TYPE1-$
	DW	BRAN
	DW	OFFSET TYPE3-$
TYPE2	DW	DDROP
TYPE3	DW	EXIT
;
	DB	82H		;  U*
	DB	'U'
	DB	'*'+80H
	DW	TYPEE-7
USTAR	DW	$+2
	POP	AX
	POP	BX
	MUL	BX
	XCHG	AX,DX
	JMP	DPUSH
;
	DB	82H		;  U.
	DB	'U'
	DB	'.'+80H
	DW	USTAR-5
UDOT	DW	DOCOL
	DW	ZERO
	DW	DDOT
	DW	EXIT
;
	DB	85H		;  U/MOD
	DB	'U/MO'
	DB	'D'+80H
	DW	UDOT-5
USLM	DW	$+2
	POP	BX
	POP	DX
	POP	AX
	DIV	BX
	JMP	DPUSH
;
	DB	82H		;  U<
	DB	'U'
	DB	'<'+80H
	DW	USLM-8
ULESS	DW	DOCOL
	DW	ZERO
	DW	SWAP
	DW	ZERO
	DW	DLESS
	DW	EXIT
;
	DB	0C5H		;  UNTIL
	DB	'UNTI'
	DB	'L'+80H
	DW	ULESS-5
UNTIL	DW	DOCOL
	DW	ONE
	DW	QPAIR
	DW	COMP
	DW	ZBRAN
	DW	HERE
	DW	SUBB
	DW	COMMA
	DW	EXIT
;
	DB	82H		;  UP
	DB	'U'
	DB	'P'+80H
	DW	UNTIL-8
UPP	DW	DOCON
	DW	UP
;
	DB	86H		;  UPDATE
	DB	'UPDAT'
	DB	'E'+80H
	DW	UPP-5
UPDAT	DW	DOCOL
	DW	PREV
	DW	ATT
	DW	ATT
	DW	LIT
	DW	8000H
	DW	ORR
	DW	PREV
	DW	ATT
	DW	STORE
	DW	EXIT
;	
	DB	83H		;  USE
	DB	'US'
	DB	'E'+80H
	DW	UPDAT-9
USEE	DW	DOVAR
	DW	BUF1
;
	DB	84H		;  USER
	DB	'USE'
	DB	'R'+80H
	DW	USEE-6
USER	DW	DOCOL
	DW	CON
	DW	ASCODE
DOUSE:	INC	DX
	MOV	BX,DX
	MOV	BL,[BX]
	SUB	BH,BH
	MOV	DI,UP
	LEA	AX,[BX+DI]
	JMP	APUSH
;
	DB	88H		;  VARIABLE
	DB	'VARIABL'
	DB	'E'+80H
	DW	USER-7
VAR	DW	DOCOL	
	DW	CREATE
	DW	TWO
	DW	ALLOT
	DW	EXIT
;
	DB	88H		;  VOC-LINK
	DB	'VOC-LIN'
	DB	'K'+80H
	DW	VAR-0BH
VOCL	DW	DOUSE
	DW	14H
;
	DB	8AH		;  VOCABULARY
	DB	'VOCABULAR'
	DB	'Y'+80H
	DW	VOCL-0BH
VOC	DW	DOCOL
	DW	TVOCAB
	DW	ATT
	DW	EXEC
	DW	EXIT
;
	DB	87H		;  WARNING
	DB	'WARNIN'
	DB	'G'+80H
	DW	VOC-0DH
WARN	DW	DOUSE
	DW	0EH
;
	DB	85H		;  WHERE
	DB	'WHER'
	DB	'E'+80H
	DW	WARN-0AH
WHERE	DW	DOCOL
	DW	BLK
	DW	ATT
	DW	ZBRAN
	DW	WHERE1-$
	DW	BLK
	DW	ATT
	DW	DUPP
	DW	SCR
	DW	STORE
	DW	CR
	DW	CR
	DW	ADOTQ
	DB	5
	DB	'SCR# '
	DW	DUPP
	DW	DOT
	DW	TOIN
	DW	ATT
	DW	LIT
	DW	3FFH
	DW	MIN
	DW	CSLL
	DW	SLMOD
	DW	DUPP
	DW	ADOTQ
	DB	6
	DB	'LINE# '
	DW	DOT
	DW	CSLL
	DW	STAR
	DW	ROT
	DW	BLOCK
	DW	PLUS
	DW	CR
	DW	CR
	DW	CSLL
	DW	DTRAI
	DW	TYPEE
	DW	TOIN
	DW	ATT
	DW	LIT
	DW	3FFH
	DW	GREAT
	DW	PLUS
	DW	BRAN
	DW	WHERE2-$
WHERE1	DW	TOIN
	DW	ATT
WHERE2	DW	CR
	DW	HERE
	DW	CAT
	DW	DUPP
	DW	TOR
	DW	SUBB
	DW	HERE
	DW	RAT
	DW	PLUS
	DW	ONEP
	DW	CAT
	DW	LIT
	DW	20H
	DW	EQUAL
	DW	ZBRAN
	DW	WHERE3-$
	DW	ONEM
WHERE3	DW	SPACS
	DW	FROMR
	DW	ZERO
	DW	ADO
WHERE4	DW	LIT
	DW	5EH
	DW	EMIT
	DW	ALOOP
	DW	WHERE4-$
	DW	EXIT
;
	DB	0C5H		;  WHILE
	DB	'WHIL'
	DB	'E'+80H
	DW	WHERE-8
WHILE	DW	DOCOL
	DW	IFF
	DW	TWOP
	DW	EXIT
;
	DB	85H		;  WIDTH
	DB	'WIDT'
	DB	'H'+80H
	DW	WHILE-8
WIDTHH	DW	DOUSE
	DW	0CH
;
	DB	84H		;  WORD
	DB	'WOR'
	DB	'D'+80H
	DW	WIDTHH-8
WORDD	DW	DOCOL
	DW	TWORD
	DW	ATT
	DW	EXEC
	DW	EXIT
;
	DB	0C0H		;  X   (NULL)
	DB	80H
	DW	WORDD-7
NULL	DW	DOCOL
	DW	BLK
	DW	ATT
	DW	ZBRAN
	DW	OFFSET NULL1-$
	DW	STATE
	DW	ATT
	DW	QSTREAM
NULL1	DW	FROMR
	DW	DROP
	DW	EXIT
;
	DB	83H		;  XOR
	DB	'XO'
	DB	'R'+80H
	DW	NULL-4
XORR	DW	$+2
	POP	AX
	POP	BX
	XOR	AX,BX
	JMP	APUSH
;
	DB	0C1H		;  [
	DB	'['+80H
	DW	XORR-6
LBRAC	DW	DOCOL
	DW	ZERO
	DW	STATE
	DW	STORE
	DW	EXIT
;
	DB	0C9H		;  [COMPILE]
	DB	'[COMPILE'
	DB	']'+80H
	DW	LBRAC-4
BCOMP	DW	DOCOL
	DW	QCOMP
	DW	DFIND
	DW	NOTT
	DW	AABORTQ
	DB	9
	DB	'NOT FOUND'
	DW	DROP
	DW	CFA
	DW	COMMA
	DW	EXIT
;
	DB	81H		;  ]
	DB	']'+80H
	DW	BCOMP-0CH
RBRAC	DW	DOCOL
	DW	LIT
	DW	0C0H
	DW	STATE
	DW	STORE
	DW	EXIT
;
	FSEG	ENDS
;
	END	ORIG
;
