/* stdio.h - standard I/O header file
 * $Version: 1.16 $
 * Copyright 1988,89,90,91 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef _stdioh
#define _stdioh

#ifndef NULL
#define NULL ((void *)0)
#endif

#ifndef _fpos_t
typedef unsigned long fpos_t;
#define _FPOS_T_DEFINED
#define _fpos_t
#endif

#ifndef _size_t
typedef unsigned size_t;
#define _SIZE_T_DEFINED
#define _size_t
#endif

#ifndef _va_list
typedef char *va_list;
#define _VA_LIST_DEFINED
#define _va_list
#endif

#define BUFSIZ         4096
#define FOPEN_MAX        20
#define SYS_OPEN         20
#define _NFILE           20
#define TMP_MAX        4096
#define FILENAME_MAX    127
#define EOF             (-1)

#define L_tmpnam         13
#define P_tmpdir       "\\"

#define _IOREAD        0x01
#define _IOWRT         0x02

#define _IOFBF         0x00               /* Neither line nor char buffering */
#define _IOLBF         0x40
#define _IONBF         0x04

#define _IOMYBUF       0x08
#define _IOEOF         0x10
#define _IOERR         0x20
#define _IOSTRG        0x40
#define _IORW          0x80

#define _IODIRTY       0x200

#define STREAM_IO      0                                  /* Used by _doscan */
#define CONSOLE_IO     1

/* seek */
#ifndef SEEK_SET
#define SEEK_SET       0
#define SEEK_CUR       1
#define SEEK_END       2
#endif

#ifndef _reenth
#pragma align (_iobuf)
#endif

#ifndef _FILE_DEFINED
struct _iobuf {
    unsigned char *_ptr;
    int _cnt;
    unsigned char *_base;
    int _flag;
    int _fd;                              /* File descriptor number */
    int _size;                            /* File buffer size */
    char *_temp_name;                     /* Temporary file name */
    void *_sem;                           /* Semaphore */
    struct _iobuf *_next_stream;          /* Pointer to the next stream */
};
typedef struct _iobuf FILE;
#define _FILE_DEFINED
#endif

#include <reent.h>

#define stdin          ((FILE *)&(_stdio_str._stdin))
#define stdout         ((FILE *)&(_stdio_str._stdout))
#define stderr         ((FILE *)&(_stdio_str._stderr))
#define stdaux         ((FILE *)&(_stdio_str._stdaux))
#define stdprn         ((FILE *)&(_stdio_str._stdprn))

/*
 * Function prototypes:
 */
void     clearerr(FILE *);
int     _doprnt(const char *, char* *, FILE *, int (*)());
int     _doscan(const char *, char* *, FILE *, int (*)(), int);
int     _dtobcd(double, char *);
int     _dtos(double, char *);
int      fclose(FILE *);
int      fcloseall(void);
FILE    *fdopen(int, const char *);
int      feof(FILE *);
int      ferror(FILE *);
int      fflush(FILE *);
int      fgetc(FILE *);
int      fgetchar(void);
int      fgetpos(FILE *, fpos_t *);
char    *fgets(char *, int, FILE *);
int     _filbuf(FILE *);
int      fileno(FILE *);
int     _flsbuf(unsigned char, FILE *);
int      flushall(void);
FILE    *fopen(const char *, const char *);
int      fprintf(FILE *, const char *, ...);
int      fputc(int, FILE *);
int      fputchar(int);
int      fputs(const char *, FILE *);
size_t   fread(void *, size_t, size_t, FILE *);
FILE    *freopen(const char *, const char *, FILE *);
int      fscanf(FILE *, const char *, ...);
int      fseek(FILE *, long int, int);
int      fsetpos(FILE *, const fpos_t *);
long int ftell(FILE *);
size_t   fwrite(const void *, size_t, size_t, FILE *);
int      getc(FILE *);
int     _getch(FILE *);
int      getchar(void);
char    *gets(char *);
int      getw(FILE *);
double  _pow_10(int);
int      printf(const char *, ...);
int      putc(int, FILE *);
int     _putch(int, FILE *);
int      putchar(int);
int      puts(const char *);
int      putw(int, FILE *);
void     rewind(FILE *);
int      rmtmp(void);
int      scanf(const char *, ...);
void     setbuf(FILE *, char *);
int      setvbuf(FILE *, char *, int, size_t);
int      sprintf(char *, const char *, ...);
int      sscanf(const char *, const char *, ...);
char    *tempnam(char *, const char *);
FILE    *tmpfile(void);
char    *tmpnam(char *);
int      ungetc(int, FILE *);
int      vfprintf(FILE *, const char *, va_list);
int      vprintf( const char *, va_list);
int      vsprintf(char *, const char *, va_list);

/*
 * ANSI and POSIX functions also prototyped in io.h
 * for Microsoft(reg.) compatibility:
 */
#ifndef _io_stdio
#define _io_stdio
int      remove(const char *);
int      rename(const char *, const char *);
int      unlink(const char *);
#endif

/*
 * ANSI function also prototyped in stdlib.h
 * for Microsoft compatibility:
 */
#ifndef _stdlib_stdio
#define _stdlib_stdio
void     perror(const char *);
#endif

/*
 * Prototypes of functions not supported by C Code Builder(TM) Libraries
 */
FILE   *_fsopen(const char *, const char *, int);
int     _pclose(FILE *);
FILE   *_popen(const char *, const char *);

/*
 * Macro implementation of stdio functions:
 */
#define feof(f)    ((f)->_flag & _IOEOF)
#define ferror(f)  ((f)->_flag & _IOERR)
#define fgetchar() fgetc(stdin)
#define fileno(f)  ((f)->_fd)
#define getc(s)    ((((s)->_cnt--) > 0) ? \
                   ((unsigned char)(*(s)->_ptr++)) : _filbuf(s))
#define getchar()  getc(stdin)
#define putc(c,s)  (((--(s)->_cnt) >= 0) \
                   ? (*((s)->_ptr++)=(c)) : _flsbuf((c),(s)))
#define putchar(c) putc((c),stdout)
#define _ungetc_

#endif /* _stdioh */
