/* Intel 386(TM)/486(TM) C Code Builder(TM) Kit
 * Copyright 1991 Intel Corporation.  All Rights Reserved.
 * time.c - Timing and synchronization features for the demo.
 * $Version: 1.3 $
 */

#include <time.h>
#include <sys\timeb.h>

/*=============================================================================
 * GetMilli - Get time in milliseconds
 *---------------------------------------------------------------------------*/
long GetMilli ()
   {
   struct timeb time;

   ftime (&time);
   return ( time.time * 1000 + time.millitm );
   }

/*=============================================================================
 * WaitFor - Wait for a specified number of milliseconds
 *---------------------------------------------------------------------------*/
void WaitFor ( int wait_milli )
   {
   long end_time = GetMilli() + wait_milli;

   while ( GetMilli() < end_time );
   }

/*=============================================================================
 * WaitUntil - Wait until a specified time
 *---------------------------------------------------------------------------*/
void WaitUntil ( long start_time, int wait_milli )
   {
   long end_time = start_time + wait_milli;

   while ( GetMilli() < end_time );
   }

