/* Intel 386(TM)/486(TM) C Code Builder(TM) Kit
 * Copyright 1991 Intel Corporation.  All Rights Reserved.
 * startup.c - Startup the demo program.
 * $Version: 1.7 $
 */

#include <stdio.h>
#include <graph.h>
#include <stdlib.h>
#include <time.h>
#include "srnchr.h"
#include "const.h"
#include "debug.h"

/*
 *  Start up the demo program.  Begin by making sure that the proper hardware
 *  exists.
 *
 *  If the proper hardware exists, get it into color graphics mode.  Use high
 *  density graphics, even though it is restricted to 16 colors.  16 colors
 *  is plenty for a demo, but low density graphics is very noticeable.
 *
 *  Finally, put data on the screen that does not change from demo to demo.
 *  The screen comes out looking like:
 *
 *        +------------------------------------+
 *        |            Header text             |
 *        +------------------------------------+
 *        |                                    |
 *        |                                    |
 *        |                                    |
 *        |                                    |
 *        |             Demo area              |
 *        |                                    |
 *        |                                    |
 *        |                                    |
 *        |                                    |
 *        +------------------------------------+
 *
 *  The Header text is the intel logo for this demo.  It is the same for
 *  the entire demo, so gets written by this function.
 */
#ifdef _INTELC32_
   #pragma interrupt (ControlCHandler)
   void ControlCHandler ( void );

#else
   void _interrupt _far ControlCHandler ( void );
#endif

int previous_video_mode;

SCREEN_CHAR *StartUpDemo ()
   {
   struct videoconfig vc;                           /* Video characteristics */
   char  *text;                                            /* A line of text */
   SCREEN_CHAR *scrn;                              /* Screen characteristics */
   short num_fonts;                            /* Number of fonts registered */
   struct _fontinfo the_font;         /* Information about the selected font */
   int y, x;                                 /* The font text row and column */

   _getvideoconfig (&vc);                   /* Check for valid video adaptor */

   #ifndef _INTELC32_
   if ( (vc.adapter != _VGA) && (vc.adapter != _OVGA) )
   #else
   if (vc.adapter != _VGA)
   #endif
      {
      printf ("This demo requires a VGA adapter.  Existing adapter is ");
      switch (vc.adapter)
         {
         case _EGA:  printf ("EGA\n");  break;

         #ifndef _INTELC32_
            case _CGA:  printf ("CGA\n");  break;
            case _HGC:  printf ("HGC\n");  break;
            case _MCGA: printf ("MCGA\n"); break;
            case _MDPA: printf ("MDPA\n"); break;
            case _OCGA: printf ("OCGA\n"); break;
            case _OEGA: printf ("OEGA\n"); break;
         #endif

         default:    printf ("unknown (Type %d)\n", vc.adapter);
         }
      exit (1);
      }

                                 /* Allocate space for video characteristics */
   scrn = (SCREEN_CHAR *) malloc (sizeof (SCREEN_CHAR));

   if ( scrn == NULL )
      {
      printf ( "Internal error (%s: %d)\n", __FILE__, __LINE__ );
      exit (1);
      }

    _dos_setvect ( 0x23, ControlCHandler );            /* Install ^C handler */

    previous_video_mode = vc.mode;

    _setvideomode (_MAXRESMODE);                  /* Switch to graphics mode */
    _getvideoconfig (&vc);        /* Get the video configuration information */

    _setbkcolor (_BLACK);                   /* Set background color to black */
    _clearscreen (_GCLEARSCREEN);                            /* Clear screen */

   #ifndef NOFONTS
      num_fonts = _registerfonts ( (const unsigned char *)FONT_PATH );

      if ( num_fonts <= 0 )
         {
         ShutDownDemo ( scrn );
         switch ( num_fonts )
            {
            case 0:  printf ( "No fonts registered\n" );                break;
            case -1: printf ( "Font files not found\n" );               break;
            case -2: printf ( "One or more font files are invalid\n" ); break;
            case -3: printf ( "One or more font files are damaged\n" ); break;
            default: printf ( "Unknown error with font files\n" );      break;
            }
         exit (1);
         }

      /*
       *  Display the first message.  Get a font, the color, the text.  Center
       *  the text and display it in the first row.
       */
      if ( !_setfont ((const unsigned char *)"t'tms rmn'h26b") )
         {
         ShutDownDemo ( scrn );
         printf ( "Error setting (%s: %d)\n", __FILE__, __LINE__);
         exit (1);
         };

      _getfontinfo (&the_font);
      _setcolor (T1_TEXT);
      y = 0;
      x = 10 * _getgtextextent((const unsigned char *)" ");
      _moveto  (x, y);
      _outgtext ((const unsigned char *)"Intel 386");
      _setfont ((const unsigned char *)"t'tms rmn'h12b");
      _outgtext ((const unsigned char *)"TM");
      _setfont ((const unsigned char *)"t'tms rmn'h26b");
      _outgtext ((const unsigned char *)"/486");
      _setfont ((const unsigned char *)"t'tms rmn'h12b");
      _outgtext ((const unsigned char *)"TM");
      _setfont ((const unsigned char *)"t'tms rmn'h26b");
      _outgtext ((const unsigned char *)" C Code Builder");
      _setfont ((const unsigned char *)"t'tms rmn'h12b");
      _outgtext ((const unsigned char *)"TM");
      _setfont ((const unsigned char *)"t'tms rmn'h26b");
      _outgtext ((const unsigned char *)" Kit");
      y += the_font.pixheight;
   #else
      y = 26;
   #endif

   #ifndef NOFONTS
      /*
       *  Display the second message.  Get the font, color and text.  Center
       *  the text and display it in the current row.
       */
      _setfont ((const unsigned char *)"t'tms rmn'h20b");
      _getfontinfo (&the_font);
      _setcolor (T2_TEXT);
      _moveto  (x, y);
      _outgtext ((const unsigned char *)
         "Development Tools for the 32-bit Environment.");

      y += the_font.pixheight;              /* Find next row number for text */
   #else
      y += 20;
   #endif

   /*
    * Compute the size of the graphics area.  Give the graphics area all
    * of the screen except the rows that have been written.
    */
   scrn->first_row = y;
   scrn->last_row  = vc.numypixels;
   scrn->left_col  = 1;
   scrn->right_col = vc.numxpixels;
   scrn->width     = scrn->right_col - scrn->left_col;
   scrn->height    = scrn->last_row  - scrn->first_row;
   scrn->width_over_height = 1.0;

   srand ((unsigned) time (NULL));       /* Seed the random number generator */

   return (scrn);                   /* Return the new screen characteristics */
   }
