/* Intel 386(TM)/486(TM) C Code Builder(TM) Kit
 * Copyright 1991 Intel Corporation.  All Rights Reserved.
 * shutdown.c - Exit the demo program.
 * $Version: 1.5 $
 */

#include <stdio.h>
#include <graph.h>
#include <stdlib.h>
#include "srnchr.h"


extern int previous_video_mode;

/*
 *  This function shuts down the demo program.  It will probably not be called,
 *  but for testing it is nice.  Turn the screen back to text mode and get rid
 *  of data allocated in the StartUpDemo function.
 */

SCREEN_CHAR *ShutDownDemo ( SCREEN_CHAR *scrn )
   {
   if (scrn != NULL)
      free (scrn);           /* Deallocate the screen characteristics memory */

   _setvideomode (previous_video_mode);                /* Restore video mode */

   #ifndef NOFONTS
      (void) _unregisterfonts ();                /* Free space used by fonts */
   #endif

   return (NULL);
   }


ExitDemo ( char *file_name, int line_number )
   {
   ShutDownDemo (NULL);
   printf ("Aborting:  file = %s, line = %d\n", file_name, line_number);
   exit (0);
   }

#ifdef _INTELC32_
void ControlCHandler ( void )
#else
void _interrupt _far ControlCHandler ( void )
#endif
   {
   _setvideomode (previous_video_mode);       /* Restore screen to text mode */
   exit(0);
   }
