/* Intel 386(TM)/486(TM) C Code Builder(TM) Kit
 * Copyright 1991 Intel Corporation.  All Rights Reserved.
 * poly.c - Functions for manipulating the polygon object.
 * $Version: 1.3 $
 */

#include <stdio.h>
#include <graph.h>
#include "debug.h"

/*
 *  This object is a polygon.  It can be initialized (cleared), have points
 *  added, displayed, and deleteded.
 *
 *  The structure includes the verticies and a vertex count.  All verticies
 *  are in world coordinates.
 */

#define MAX_VERTEX 40         /* Maxmum number of verticies in a polygon */
#define POLY_INVALID -1       /* An invalid vertex count */

typedef struct poly_struct POLY;

struct poly_struct {
    int count;                 /* The number of verticies.  0 => empty */
    double vertex[MAX_VERTEX]; /* The list of verticies */
};

static POLY poly;              /* The global polygon */



/*
 *  Create a new polygon.  Normally this function would allocate some
 *  memory for the new structure and return a pointer.  However, because
 *  one of the demo's attempts to allocate all of available memory,
 *  this function requires the caller to allocate the memory (either
 *  on the stack or via a call to malloc, and pass a pointer to the
 *  memory.  This function initializes the polygon to an empty state.
 */

void NewPoly ()
{
    poly.count = 0;
}


/*
 *  Add a new vertex to the polygon.  Make sure that the number of
 *  verticies has not exceeded the maximum.  Project the 3-D point
 *  to the 2-D world coordinates, and store the new point at the
 *  end of the vertex list.
 */

void  Add3DVertex (x, y, z)
    double x, y, z;                /* The 3-D point to add */
{
    double *vertex;                /* A vertex of the polygon */

    if (poly.count >= MAX_VERTEX-1) {
        FatalError ("Vertex maximum exceeded in AddVertex");
    } else if (poly.count == POLY_INVALID) {
        FatalError ("Invalid polygon in AddVertex");
    };

    vertex = &(poly.vertex[poly.count]);
    Project (x, y, z, vertex, vertex+1);
    poly.count += 2;
}



/*
 *  Display a polygon.  This assumes that the color has already been
 *  set up.
 */

void  DisplayPoly (cntl)
    short cntl;                /* Boarder control */
{
    if (poly.count == POLY_INVALID) {
        FatalError ("Invalid polygon in DisplayPoly");
    };

    _polygon_w (cntl, poly.vertex, poly.count >> 1);
}


/*
 *  Distroy a polygon.  This would normally free all memory associated
 *  with the polygon, but since the Create function does not allocate
 *  any, all this does is reset the polygon to an invalid polygon.
 *  The Create function must be used to make it valid again.
 */

void  DistroyPoly ()
{
    if (poly.count == POLY_INVALID) {
        FatalError ("Invalid polygon in DistroyPoly");
    };
    poly.count = POLY_INVALID;  /* Make the polygon invalid */
}
