/* Intel 386(TM)/486(TM) C Code Builder(TM) Kit
 * Copyright 1991 Intel Corporation.  All Rights Reserved.
 * main.h - Main routine for the demo program.
 * $Version: 1.3 $
 */

/*
 *  Main routine for the set of demo programs.  There are two graphics demos.
 *  Each needs part of the screen to display its results.  This main routine
 *  gets the screen set up and then calls each of the demo's, in order, over
 *  and over.  This main routine only controls calls to sub-functions and
 *  does the demo loop.
 *
 *  There is a function that initializes some data structures for the demo
 *  programs.  It sets up the screen with the data that does not change from
 *  demo to demo, sizes the screen and allocates the main portion to the demo
 *  graphics, and does other things that only need doing once when this is
 *  initialized.
 *
 *  It is up to each demo program to return when it is done (a timeout period
 *  has expired or a key has been pressed on the keyboard or whatever).  They
 *  are free to do anything to the screen they wish, as long as they only
 *  affect the part of the screen they are given.  The demo's should not
 *  erase the screen when done, but rather leave it alone.
 *
 *  Between each demo a function is called that switches the screen to a new
 *  background color.  It does this switch by changing random squares to the
 *  new color.  Actually, it switches the screen twice, and in between
 *  displays some bullets.
 *
 *  One debug statement opens a "debug" file for dumping information if
 *  something goes wrong.
 */

#include <stdio.h>
#include <limits.h>
#include "srnchr.h"
#include "const.h"
#define MAIN
#include "debug.h"

extern SCREEN_CHAR *StartUpDemo ();
extern SCREEN_CHAR *ShutDownDemo ();

main ( int argc, char *argv[] )
   {
   int i;                                                 /* Demo loop count */
   SCREEN_CHAR *scrn;                              /* Screen characteristics */
   int counter = 1;                                          /* Loop counter */

   if ( argc > 1 ) {                               /* Parse the command line */
      sscanf ( argv[1], "%d", &counter );
      if ( counter < 0 )
         counter = INT_MAX;
      }

   #ifdef DEBUG
      fd = fopen ("debug", "w+");                     /* Open the debug file */
   #endif

   scrn = StartUpDemo ();                           /* Initialize the screen */
   MainBullets ( scrn, MEMSIZEBK );      /* Display Code Builder information */

   while ( counter-- ) {               /* Loop through each of the sub-demos */
      MemorySize ( scrn );                      /* Display memory size graph */
      MainBullets ( scrn, FNCGRPHBK );           /* Code Builder information */

      FunctionGraph ( scrn );                             /* Rotating sphere */
      MainBullets ( scrn, MEMSIZEBK );          /* Code Builder information */
      }

   scrn = ShutDownDemo (scrn);       /* Return display to text mode and exit */
   }
