#
# File name: lib.mak
#
# (C) Copyright 1991 Intel Corporation.
#
#      This file is intended for your benefit in developing applications
#      using the Intel 386(TM) / 486(TM) C Code Builder (TM) Kit.  Intel
#      hereby grants you permission to modify and incorporate it as needed.
#
# To build a library, include this file in your makefile after defining
# the following two macros.
#	
# LIB_FILE  -  name of the library file you want to build.
# LIB_OBJS  -  list of the object files to add to the library.
#
# For example,
#        LIB_FILE=myprog.lib
#        LIB_OBJS=mod1.obj mod2.obj mod3.obj
#
# Include this file 'lib.mak' after the above two macros are defined.
#
# The following is an example of what you might have in your makefile
# to build a library automatically.
#
# LIB_FILE = abc.lib
# LIB_OBJS = x.obj y.obj
#
# !include lib.mak
#
	
CB_LIB_RESP=$(LIB_FILE,B,S/.*/&.RSP/)
	    
$(LIB_FILE) : $(LIB_OBJS)
	echo > $(CB_LIB_RESP)
	!foreach x $(.NEWER)
		# The following 'modname' will generate a replace command
		modname /r $x >> $(CB_LIB_RESP)
		#
		# If you can guarantee that modname==basename, use the
		# following echo line instead of previous modname line.
		# The echo line runs faster.
		#
		# echo replace $(x,B) by $x >> $(CB_LIB_RESP)
	!end 
	echo compress  >> $(CB_LIB_RESP)
	echo update    >> $(CB_LIB_RESP)
	echo quit exit >> $(CB_LIB_RESP)
	lib32 $(LIB_FILE) batch < $(CB_LIB_RESP)

