SUBROUTINE VIEWVIDMODE(CHECKED)
!***************************************************************************
!*                                                                         *
!*  THIS SUBROUTINE CREATES A DIALOG BOX THAT ALLOWS THE USER TO VIEW THE  *
!*  CURRENT VIDEO SETTINGS OF THE NUMBER OF X PIXELS, NUMBER OF Y PIXELS,  *
!*  AND THE NUMBER OF COLORS                                               *
!*                                                                         *
!***************************************************************************

  USE MSFLIB
  USE DIALOGM

  INCLUDE 'RESOURCE.FD'

  TYPE(DIALOG)DLG
  TYPE(WINDOWCONFIG)CURRENT

  INTEGER(KIND=4)IRET
  LOGICAL(KIND=4)RET, RETLOG
  CHARACTER(LEN=55)CTEMP
  LOGICAL(KIND=4)CHECKED

  CALL UNUSEDQQ(CHECKED)

!* GET THE CURRENT VIDEO CONFIGURATION
  IRET = GETWINDOWCONFIG(CURRENT)
!* INITIALIZE THE DIALOG BOX PARAMETERS
  RET = DLGINIT(IDD_VIEWVIDMODE, DLG)
!* LOAD THE CURRENT VIDEO PARAMETERS INTO THE APPROPRIEATE EDIT BOXES
  WRITE(CTEMP,*)CURRENT%NUMXPIXELS
  RETLOG = DLGSET(DLG, IDC_EDIT_VIEWVIDMODE_XPIX, CTEMP)
  WRITE(CTEMP,*)CURRENT%NUMYPIXELS
  RETLOG = DLGSET(DLG, IDC_EDIT_VIEWVIDMODE_YPIX, CTEMP)
  WRITE(CTEMP,*)CURRENT%NUMCOLORS
  RETLOG = DLGSET(DLG, IDC_EDIT_VIEWVIDMODE_NUMCOL, CTEMP)
!* CREATE THE DIALOG BOX
  IRET = DLGMODAL(DLG)
!* DESTROY THE DIALOG BOX WHEN OK BUTTON IS PUSHED
  CALL DLGUNINIT(DLG)

  RETURN
END
