SUBROUTINE SET_VID_PARAMS(CHECKED)
!***************************************************************************
!*                                                                         *
!*  THIS SUBROUTINE CREATES A DIALOG BOX THAT ALLOWS THE USER TO SET THE   *
!*  DESIRED NUMBER OF X AND Y PIXELS AND THE NUMBER OF COLORS TO BE USED.  *
!*  IT ALSO SETS UP THE CALLBACK ROUTINE USED FOR THE HELP AND OK BUTTONS  *
!*                                                                         *
!***************************************************************************

  USE MSFLIB
  USE DIALOGM
  USE CHAOSCOM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'

  TYPE(DIALOG)DLG
  TYPE(WINDOWCONFIG)CURRENT

  LOGICAL(KIND=4)RET, RETLOG
  INTEGER(KIND=4)IRET, IERR
  CHARACTER(LEN=55)CTEMP, MSG0, MSG1
  EXTERNAL SET_VID_PARAMS_HELP, SET_VID_PARAMS_OK
  LOGICAL(KIND=4)CHECKED

  CALL UNUSEDQQ(CHECKED)

  IERR = 0
  MSG0 = ''C
  MSG1 = ''C
!* INITILIZE THE DIALOG BOX PARAMETERS
  RET = DLGINIT(IDD_VIDEO_MODE, DLG)
!* SET UP THE CALLBACK ROUTINES FOR THE HELP AND OK BUTTONS
  RET = DLGSETSUB(DLG, IDHELP_VIDEO, SET_VID_PARAMS_HELP) 
  RET = DLGSETSUB(DLG, IDOK, SET_VID_PARAMS_OK) 


!* PLACE CURRENT VIDEO INFORMATION IN THE EDIT FIELDS
  WRITE(CTEMP,*)NUMXPIXELS
  RETLOG = DLGSET(DLG, IDC_NUMXPIX, CTEMP)
  WRITE(CTEMP,*)NUMYPIXELS
  RETLOG = DLGSET(DLG, IDC_NUMYPIX, CTEMP)
  WRITE(CTEMP,*)NUMCOLORS
  RETLOG = DLGSET(DLG, IDC_NUMCOLORS, CTEMP)

!* BRING UP DIALOG BOX
  IRET = DLGMODAL(DLG)

!* GET THE CURRENT VIDEOPARAMETERS
  IRET = GETWINDOWCONFIG(CURRENT)
!* DESTROY THE DIALOG BOX AND RELEASE THE RESOURCES
  CALL DLGUNINIT(DLG)

  RETURN
END SUBROUTINE SET_VID_PARAMS
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE SET_VID_PARAMS_HELP(DLGPARENT, ID, CALLBACKTYPE)
!***************************************************************************
!*                                                                         *
!*  THIS SUBROUTINE CREATES A DIALOG BOX THAT CONTAINS HELP INFORMATION    *
!*  FOR THE SET VIDEO PARAMETERS DIALOG BOX                                *
!*                                                                         *
!***************************************************************************
  USE MSFLIB
  USE DIALOGM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'

  TYPE(DIALOG)DLG2
  TYPE(DIALOG)DLGPARENT

  LOGICAL(KIND=4)RET
  INTEGER(KIND=4)IRET, ID, CALLBACKTYPE
!* TO PREVENT COMPILER WARNINGS OF UNUSED VARIABLES
  CALL UNUSEDQQ(DLGPARENT, ID, CALLBACKTYPE)

!* INITIALIZE THE DIALOG BOX
  RET = DLGINIT(IDD_VIDEO_MODE_HELP, DLG2)
!* CREATE DIALOG BOX
  IRET = DLGMODAL(DLG2)
!* DESTROY DIALOG BOX AND RELEASE RESOURCES
  CALL DLGUNINIT(DLG2)

  RETURN
END SUBROUTINE SET_VID_PARAMS_HELP
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE SET_VID_PARAMS_OK(DLG, ID, CALLBACKTYPE)
!***************************************************************************
!*                                                                         *
!*  THIS SUBROUTINE IS A CALLBACK ROUTINE FOR THE OK BUTTON IN THE SET     *
!*  VIDEO PARAMETERS DIALOG BOX.  IT IS CALLED WHEN THE OK BUTTON IS       *
!*  PUSHED.  IT CONTAINS ERROR SENSING CODE TO DETECT AN INVALID ENTRY IN  *
!*  THE VARIOUS EDIT BOXES.  WHEN A ERROR IS DETECTED IT PRINTS OUT AN     *
!*  ERROR MESSAGE AND RELOADS THE CURRENT VALLUE IN THE EDIT BOX.  UPON    *
!*  COMPLETION IT SETS THE RETUEN CODE TO THE OK BUTTON ID AND EXITS THE   *
!*  DIALOG.                                                                *
!*                                                                         *
!***************************************************************************
  USE MSFLIB
  USE DIALOGM
  USE CHAOSCOM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'
  TYPE(DIALOG)DLG
  TYPE(WINDOWCONFIG)CURRENT

  LOGICAL(KIND=4)RET, LERR
  INTEGER(KIND=4)IRET, ID, CALLBACKTYPE, IERR
  CHARACTER(LEN=55) CTEMP, MSG0, MSG1
!* TO PREVENT UNSED VARIABLES COMPILER WARNINGS
  CALL UNUSEDQQ(ID, CALLBACKTYPE)
  LERR = .FALSE.

!* GET THE NEW INFORMATION
  RET = DLGGET(DLG, IDC_NUMXPIX, CTEMP)
  READ(CTEMP,*,IOSTAT = IERR)NUMXPIXELS
  IF(IERR /= 0)THEN
!*ERROR CONDITION, PRINT MESSAGE, RELOAD CURRENT VALUE, SET ERROR FLAG
    MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD NUMBER OF X PIXELS'C
    MSG1 = 'ERROR READING INFORMATION'C
    IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
    WRITE(CTEMP,*)NUMXPIXELS
    RET = DLGSET(DLG, IDC_NUMXPIX, CTEMP)
	LERR = .TRUE.
  ENDIF
  RET = DLGGET(DLG, IDC_NUMYPIX, CTEMP)
  READ(CTEMP,*,IOSTAT = IERR)NUMYPIXELS
  IF(IERR /= 0)THEN
!*ERROR CONDITION, PRINT MESSAGE, RELOAD CURRENT VALUE, SET ERROR FLAG
    MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD NUMBER OF Y PIXELS'C
    MSG1 = 'ERROR READING INFORMATION'C
    IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
    WRITE(CTEMP,*)NUMYPIXELS
    RET = DLGSET(DLG, IDC_NUMYPIX, CTEMP)
	LERR = .TRUE.
  ENDIF
  RET = DLGGET(DLG, IDC_NUMCOLORS, CTEMP)
  READ(CTEMP,*,IOSTAT = IERR)NUMCOLORS
  IF(IERR /= 0)THEN
!*ERROR CONDITION, PRINT MESSAGE, RELOAD CURRENT VALUE, SET ERROR FLAG
    MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD NUMBER OF COLORS'C
    MSG1 = 'ERROR READING INFORMATION'C
    IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
    WRITE(CTEMP,*)NUMCOLORS
    RET = DLGSET(DLG, IDC_NUMCOLORS, CTEMP)
	LERR = .TRUE.
  ENDIF
  
  IF(.NOT. LERR)THEN
!* IF NO ERROR SET RETURN CODE TO OK BUTTON ID AND EXIT DIALOG BOX
    CALL DLGEXIT(DLG)
    CALL SET_VIDEO
  ENDIF

  IRET = GETWINDOWCONFIG(CURRENT)

  RETURN
END SUBROUTINE SET_VID_PARAMS_OK
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

