SUBROUTINE SHOW_PALLET(CHECKED)
!***************************************************************************
!*                                                                         *
!*  THIS SUBROUTINE IS EXECUTED WHEN THE MENU ITEM VIEW.PALETTE IS SELECTED*
!*  IT DISPLAYS A SCREEN THAT AT THE TOP SHOW A BAND OF COLORS THAT IS THE *
!*  PALETTE THAT THE USER HAS DEFINED.  EACH COLOR IS SEPERATED BY A BLACK *
!*  LINE.  THE LOWER PART OF THE SCREEN SHOWS THE MAGNITUDE OF THE RED,    *
!*  GREEN, AND BLUE  COMPONENTS THAT MAKE UP A PARTICULAR COLOR.  WHEN THE *
!*  PALETTE IS DISPLAYED, THE SECOND, THIRD, AND FOURTH COLORS FROM THE END*
!*  HAVE BEEN SET TO RED, GREEN AND BLUE RESPRCTIVLE TO ALLOW THESE COLORS *
!*  TO DRAW THE LINE CHART.  tHESE ARE NOT THE TRUE COLORS OF THE PALETTE  *
!*  AND ARE RESET TO THE CORRECT COLORS AFTER THE PLOT IS DISPLAYED.       *
!*                                                                         *
!***************************************************************************
  USE MSFLIB, SETPIXEL0 => SETPIXEL
  USE PALET
  USE PLOTVAL
  USE VIDCONF
  IMPLICIT NONE

  INTEGER(KIND=4)ICOL, II1, JJ1, II1P, I1, I2, ICNT, ITMP, ITMP2, ITEMP1, ITEMP2, ITEMP3, RGB
  INTEGER(KIND=2)XPR, YPR, XPG, YPG, XPB, YPB 

  LOGICAL(KIND=4)STATUSMODE
  LOGICAL(KIND=4)CHECKED

  CALL UNUSEDQQ(CHECKED)

!* GET THE CURRENT VIDEO MODE
  STATUSMODE = GETWINDOWCONFIG( WC )
!* CLEAR THE SCREEN
  CALL CLEARSCREEN($GCLEARSCREEN)
!* SET THE MIN AND MAX VALUES FOR THE LINE PLOTS
  XMIN = 0.00
  XMAX = REAL(WC%NUMXPIXELS)
  YMIN = 0.00
  IF((RMAX == 0.00E+00) .AND. (BMAX == 0.00E+00) .AND. (GMAX == 0.00E+00))THEN 
!* SET MAXIMUM COLOR INTENSITIES ACCORDING TO NUMBER OF BITS PER PIXELS
    RMAX = 2**WC%BITSPERPIXEL
    BMAX = 2**WC%BITSPERPIXEL
    GMAX = 2**WC%BITSPERPIXEL
  ENDIF
!* SCALE THE YMAX TO PREVENT LINE GRAPH FROM GOING INTO THE COLOR SWATCH
  YMAX = MAX(RMAX, BMAX, GMAX)*1.20E+00
!* OTHER GRAPHING PARAMETERS
  TICINTV = 20.00
  XTICSTR = 0.00
  YTICSTR = 0.00
  ITIC = 10
  XPR = 0
  YPR = 0
  XPG = 0
  YPG = 0
  XPB = 0
  YPB = 0
!* SET THE 2ND, 3RD, NAD 4TH COLORS FROM THE END TO RED GREEN AND BLUE, SAVE CURRENT VALUES
  ITEMP1 = PAL(WC%NUMCOLORS-1)
  ITEMP2 = PAL(WC%NUMCOLORS-2)
  ITEMP3 = PAL(WC%NUMCOLORS-3)
  PAL(WC%NUMCOLORS-1) = RGB(255,0,0)
  PAL(WC%NUMCOLORS-2) = RGB(0,255,0)
  PAL(WC%NUMCOLORS-3) = RGB(0,0,255)
!* CALCULATE PLOTTING PARAMETERS TO ALLOW ABSOLUTE PIXEL ADDRESSING
  CALL PLOTPIX
!* DRAW X AND Y AXIS
  CALL AXIS
!* PLACE TICK MARKS ON THE AXIS
  CALL PLOTTIC

  
!* SHOW_ONLY; CREATE PALETTE
  CALL CREATE_PALLET
  STATUSMODE = GETWINDOWCONFIG( WC )

  ICOL = 0
  ICNT = 0
!* CALCULATE HOW WISE EACH COLOR CAN BE IN THE COLOR SWATCH 
  ITMP = INT4(WC%NUMXPIXELS/WC%NUMCOLORS)
!* ALLOW FOR A 1 PIXEL WIDE BLACK LINE BETWEEN EACH COLOR
  ITMP2 = ITMP -1
!* DO THE PLOTTING.  THE COLOR SWATCH IS 1/10TH THE FILL SCREEN HEIGHT
  DO II1 = 0, WC%NUMXPIXELS-1
    DO JJ1 = 0, (WC%NUMYPIXELS-1)/10
!* DECIDE WHEN TO SWITCH COLORS
      IF((MOD(II1,INT4((WC%NUMXPIXELS/WC%NUMCOLORS))).EQ.0).AND.(II1.NE.II1p))then
        ICOL=ICOL+1
        II1P=II1
		ICNT = 0
!* TERMINATE THE DRAWING WHEN OUT OF COLORS BUT NOT OUT OF SCREEN
		IF(ICOL > (WC%NUMCOLORS-1))GO TO 1000
      endif
	  IF(ICNT .LT. ITMP2)THEN
!* SET PIXEL COLOR TO DESIRED COLOR
        I1 = SETCOLOR(INT2(ICOL))
	  ELSE
!* SET PIXEL COLOR TO BLACK FOR LINE BETWEEN COLORS
	    I1 = SETCOLOR(INT2(0))
	  ENDIF
!* PLOT PIXEL
      I2 = SETPIXEL(INT2(II1), INT2(JJ1))
    ENDDO
!* PLOT RED, GREEN AND BLUE LINES
    CALL PLOT(REAL(II1), REAL(IRED(ICOL+1)), WC%NUMCOLORS-2, XPR, YPR)
	CALL PLOT(REAL(II1), REAL(IGREEN(ICOL+1)), WC%NUMCOLORS-3, XPG, YPG)
	CALL PLOT(REAL(II1), REAL(IBLUE(ICOL+1)), WC%NUMCOLORS-4, XPB, YPB)
	ICNT = ICNT+1

  ENDDO
1000 CONTINUE

!* EMPTY PLOT BUFFER AND RESET COLORS TO ORIGINAL
  CALL SETPIXELFLUSH
  PAL(WC%NUMCOLORS-1) = ITEMP1
  PAL(WC%NUMCOLORS-2) = ITEMP2
  PAL(WC%NUMCOLORS-3) = ITEMP3


  RETURN
END