SUBROUTINE SET_VIDEO  
!***************************************************************************
!*                                                                         *
!*  THIS SUBROUTINE SETS THE VIDEO MODE TO THAT WHICH WAS DECIDED UPON BY  *
!*  THE USER IN THE DIALOG BOX.  THE COMPONENTS THAT THE USER ISN'T ALLOWED*
!*  TO SET ARE SET TO THE DEFAULT FOR THE ADAPTER BEING USED.  IF AN ERROR *
!*  OCCURS, THE PARAMETERS AER SET TO THE DEFAULT AND AN ERROR MESSAGE IS  *
!*  PRODUCED
!*                                                                         *
!***************************************************************************
  USE MSFLIB
  USE CHAOSCOM

  IMPLICIT NONE

  TYPE(WINDOWCONFIG)CURRENT

  LOGICAL(KIND=4)STATUSMODE
  CHARACTER(LEN=60)MSG0, MSG1
  INTEGER(KIND=4)IRET

  MSG0 = ''C
  MSG1 = ''C
!* LOAD DEFINED TYOE WITH USER INPUT
  CURRENT%NUMXPIXELS = NUMXPIXELS
  CURRENT%NUMYPIXELS = NUMYPIXELS
  CURRENT%NUMTEXTCOLS = -1
  CURRENT%NUMTEXTROWS = -1
  CURRENT%NUMCOLORS = NUMCOLORS
  CURRENT%FONTSIZE = -1
  CURRENT%BITSPERPIXEL = -1
!* SET THE VIDEO MODE
  STATUSMODE = SETWINDOWCONFIG(CURRENT)
!* IF ERROR OCCURS. PRINT MESSAGE AND RESET TO DEFAULTS
  IF(.NOT. STATUSMODE)THEN
    IF(.NOT. LDEMO)THEN
      MSG0 = ' ERROR IN SETTING VIDEO; RESETTING TO DEFAULTS'C
      MSG1 = ' ERROR SETTING VIDEO MODE'C
      IRET = MESSAGEBOXQQ(' ERROR IN SETTING VIDEO; RESETTING TO DEFAULTS'C, &
           ' ERROR SETTING VIDEO MODE'C,MB$ICONEXCLAMATION .OR. MB$OK)
	ENDIF
    CURRENT%NUMXPIXELS = -1
    CURRENT%NUMYPIXELS = -1
    CURRENT%NUMTEXTCOLS = -1
    CURRENT%NUMTEXTROWS = -1
    CURRENT%NUMCOLORS = -1
    CURRENT%FONTSIZE = -1
    CURRENT%BITSPERPIXEL = -1
    STATUSMODE = SETWINDOWCONFIG(CURRENT)
  ENDIF
!* STORE INFORMATION IN USER VARIABLES
  IRET = GETWINDOWCONFIG(CURRENT)
  NUMXPIXELS = CURRENT%NUMXPIXELS
  NUMYPIXELS = CURRENT%NUMYPIXELS
  NUMCOLORS = CURRENT%NUMCOLORS
  RETURN
END