SUBROUTINE SET_CHAOS_COEFF(CHECKED)
!***************************************************************************
!*                                                                         *
!*  THIS SUBROUTINE CREATES A DIALOG BOX THAT ALLOWS THE USER TO SPECIFY   *
!*  THE DESIRED COEFFICIENTS FOR THE SELECTED CHAOS EQUATION.  IT ALSO SETS*
!*  THE CALL BACK ROUTINES FOR THE HELP AND OK BUTTONS.                    *
!*                                                                         *
!***************************************************************************

  USE MSFLIB
  USE DIALOGM
  USE CHAOSCOM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'

  TYPE(DIALOG)DLG

  LOGICAL(KIND=4)RET, RETLOG
  INTEGER(KIND=4)IRET, IERR
  CHARACTER(LEN=55) CTEMP, MSG0, MSG1
  EXTERNAL SET_CHAOS_COEFF_HELP, SET_CHAOS_COEFF_OK
  LOGICAL(KIND=4)CHECKED

  CALL UNUSEDQQ(CHECKED)

  IERR = 0
  MSG0 = ''C
  MSG1 = ''C

!* INITIALIZE THE DIALOG BOX
  RET = DLGINIT(IDD_CHAOS_COEFF, DLG)
!* SET THE CALLBACK ROUTINES FOR THE OK AND HELP BUTTONS
  RET = DLGSETSUB(DLG, IDCHELP_CHAOS_COEFF, SET_CHAOS_COEFF_HELP)
  RET = DLGSETSUB(DLG, IDOK, SET_CHAOS_COEFF_OK)

!* GET THE CURRENT VALUES OF THE NUMBER OF POINTS AND PUT IT IN THE 
!* EDIT FIELD
  WRITE(CTEMP,*)A
  RETLOG = DLGSET(DLG, IDC_EDIT_COEF_A, CTEMP)
  WRITE(CTEMP,*)B
  RETLOG = DLGSET(DLG, IDC_EDIT_COEF_B, CTEMP)
  WRITE(CTEMP,*)C
  RETLOG = DLGSET(DLG, IDC_EDIT_COEF_C, CTEMP)
  WRITE(CTEMP,*)D
  RETLOG = DLGSET(DLG, IDC_EDIT_COEF_D, CTEMP)

!* BRING UP THE DIALOG BOX
  IRET = DLGMODAL(DLG)

!* DESTROY AND RELEASE THE DIALOG RESOURCES
  CALL DLGUNINIT(DLG)

  RETURN
END SUBROUTINE SET_CHAOS_COEFF
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE SET_CHAOS_COEFF_HELP(DLGPARENT, ID, CALLBACKTYPE)
!***************************************************************************
!*                                                                         *
!*  THIS SUBROUTINE CREATS A DIALOG BOX CONTAINING HELP FOR THE SET CHAOS  *
!*  COEFFICIENTS DIALOG BOX.  IT IS A CALLBACK ROUITINE FOR THE HELP BUTTON*
!*                                                                         *
!***************************************************************************
  USE MSFLIB
  USE DIALOGM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'

  TYPE(DIALOG)DLG2
  TYPE(DIALOG)DLGPARENT

  LOGICAL(KIND=4)RET
  INTEGER(KIND=4)IRET, ID, CALLBACKTYPE

  CALL UNUSEDQQ(DLGPARENT, ID, CALLBACKTYPE)
!* INITIALIZE THE DIALOG BOX
  RET = DLGINIT(IDD_CHAOS_COEFF_HELP, DLG2)
!* CREATE DIALOG
  IRET = DLGMODAL(DLG2)
!* DESTROY DIALOG AND RELEASE RESOURCES
  CALL DLGUNINIT(DLG2)
  RETURN
END SUBROUTINE SET_CHAOS_COEFF_HELP
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE SET_CHAOS_COEFF_OK(DLG, ID, CALLBACKTYPE)
!***************************************************************************
!*                                                                         *
!*  THIS SUBROUTINE IS THE CALLBACK ROUTINE FOR WHEN THE OK BUTTON IS      *
!*  PUSHED IN THE SET CHAOS COEFFICIENTS DIALOG BOX.  IT CONTAINS CODE TO  *
!*  SENSE IF AN INVALID ENTRY IN THE EDIT BOX HAS BEEN MADE.  IF AN ERROR  *
!*  OCCURS, AN ERROR MESSAGE IS PRINTED AND THE EDIT BOX IS RESET BACK TO  *
!*  ITS ORIGINAL VALUE.  IF NO ERROR OCCURS, THE DIALOG RETURN VALUE IS    *
!*  SET TO THE ID NUMBER FOR THE OK BUTTEN AND THE DIALOG IS EXITED        *
!*                                                                         *
!***************************************************************************
  USE MSFLIB
  USE DIALOGM
  USE CHAOSCOM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'

  TYPE(DIALOG)DLG
  TYPE(DIALOG)DLGPARENT

  LOGICAL(KIND=4)RET, LERR
  INTEGER(KIND=4)IRET, ID, CALLBACKTYPE, IERR1, IERR2, IERR3, IERR4
  CHARACTER(LEN=55) CTEMP, MSG0, MSG1

  CALL UNUSEDQQ(DLGPARENT, ID, CALLBACKTYPE)
  LERR = .FALSE.

!* GET THE NEW INFORMATION
  RET = DLGGET(DLG, IDC_EDIT_COEF_A, CTEMP)
  READ(CTEMP,*,IOSTAT = IERR1)A
  IF(IERR1 /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, AND RELOAD EDIT FIELD
    MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD A COEFFICIENT'C
    MSG1 = 'ERROR READING INFORMATION'C
    IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
    WRITE(CTEMP,*)A
    RET = DLGSET(DLG, IDC_EDIT_COEF_A, CTEMP)
	LERR = .TRUE.
  ENDIF
  RET = DLGGET(DLG, IDC_EDIT_COEF_B, CTEMP)
  READ(CTEMP,*,IOSTAT = IERR2)B
  IF(IERR2 /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, AND RELOAD EDIT FIELD
    MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD B COEFFICIENT'C
	MSG1 = 'ERROR READING INFORMATION'C
    IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
    WRITE(CTEMP,*)B
    RET = DLGSET(DLG, IDC_EDIT_COEF_B, CTEMP)
	LERR = .TRUE.
  ENDIF
  RET = DLGGET(DLG, IDC_EDIT_COEF_C, CTEMP)
  READ(CTEMP,*,IOSTAT = IERR3)C
  IF(IERR3 /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, AND RELOAD EDIT FIELD
    MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD C COEFFICIENT'C
    MSG1 = 'ERROR READING INFORMATION'C
    IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
    WRITE(CTEMP,*)C
    RET = DLGSET(DLG, IDC_EDIT_COEF_C, CTEMP)
	LERR = .TRUE.
  ENDIF
  RET = DLGGET(DLG, IDC_EDIT_COEF_D, CTEMP)
  READ(CTEMP,*,IOSTAT = IERR4)D
  IF(IERR4 /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, AND RELOAD EDIT FIELD
    MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD D COEFFICIENT'C
    MSG1 = 'ERROR READING INFORMATION'C
    IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
    WRITE(CTEMP,*)D
    RET = DLGSET(DLG, IDC_EDIT_COEF_D, CTEMP)
	LERR = .TRUE.
  ENDIF
  IF(.NOT. LERR)THEN
!* IF THERE IS NO ERROR SET RETURN VALUE TO OK BUTTON ID AND EXIT DIALOG BOX
	CALL DLGSETRETURN(DLG, IDOK)
    CALL DLGEXIT(DLG)
  ENDIF
  RETURN
END SUBROUTINE SET_CHAOS_COEFF_OK
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
